/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megafon.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigDecimal;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.modules.megafon.client.MegafonEditorDialog;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonOption;
import ru.bitel.bgbilling.modules.megafon.common.bean.MegafonOptionType;
import ru.bitel.bgbilling.modules.megafon.common.service.MegafonService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.table.BGTableModel;

public class MegafonOptionPanel
extends BGUPanel {
    private MegafonService megafonService;
    private BGUTable table;
    private MegafonOptionTableModel tableModel;

    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.tableModel = new MegafonOptionTableModel();
        this.table = new BGUTable((TableModel)((Object)this.tableModel));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        BGSwingUtilites.handleEdit((JTable)this.table, (AbstractBGUPanel)this);
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> new OptionEditorDialog(null).open());
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            MegafonOption selected = (MegafonOption)this.tableModel.getSelectedRow();
            if (selected != null) {
                new OptionEditorDialog(selected).open();
            } else {
                BGToolTip.showErrorMessage((JComponent)this.table, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u043f\u0446\u0438\u044e \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f!");
            }
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            MegafonOption selected = (MegafonOption)this.tableModel.getSelectedRow();
            if (selected != null && BGSwingUtilites.confirmDelete((String)selected.getTitle(), (Object)true)) {
                this.getMegafonService().deleteOption(selected.getId());
                this.performAction("refresh");
            } else {
                BGToolTip.showErrorMessage((JComponent)this.table, (String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043e\u043f\u0446\u0438\u044e \u0434\u043b\u044f \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u044f!");
            }
        });
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> this.tableModel.setData(this.getMegafonService().getOptionList()));
    }

    private MegafonService getMegafonService() {
        if (this.megafonService == null) {
            this.megafonService = (MegafonService)((ClientContext)this.getContext()).getPort(MegafonService.class, ((ClientContext)this.getContext()).getModuleId());
        }
        return this.megafonService;
    }

    private final class MegafonOptionTableModel
    extends BGTableModel<MegafonOption> {
        public MegafonOptionTableModel() {
            super("megafonOptionTable");
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", -1, -1, -1, "title", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0422\u0438\u043f", -1, -1, -1, "optionType", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
        }
    }

    private final class OptionEditorDialog
    extends MegafonEditorDialog<MegafonOption> {
        private final JTextField price;
        private final BGUComboBox<MegafonOptionType> optionType;

        public OptionEditorDialog(MegafonOption data) {
            super("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0434\u043e\u043f.\u0443\u0441\u043b\u0443\u0433", data);
            this.price = new JTextField(40);
            this.optionType = new BGUComboBox();
        }

        @Override
        public void doDialogPanel() {
            super.doDialogPanel();
            this.optionType.setData(List.of(MegafonOptionType.values()));
            this.addFieldV("\u0421\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c:", this.price);
            this.addFieldV("\u0422\u0438\u043f:", (JComponent)this.optionType);
            if (this.data != null) {
                this.title.setText(((MegafonOption)this.data).getTitle());
                this.productOfferingId.setText(((MegafonOption)this.data).getProductOfferingId());
                this.optionType.setSelectedItem((Object)((MegafonOption)this.data).getOptionType());
                this.npayServiceId.setText(String.valueOf(((MegafonOption)this.data).getNpayServiceId()));
                this.price.setText(((MegafonOption)this.data).getPrice() != null ? ((MegafonOption)this.data).getPrice().toString() : "");
            }
        }

        public boolean doApply() throws Exception {
            if (this.data == null) {
                this.data = new MegafonOption();
            }
            int serviceId = Utils.parseInt((String)this.npayServiceId.getText(), (int)0);
            if (Utils.isBlankString((String)this.title.getText()) || Utils.isBlankString((String)this.productOfferingId.getText()) || serviceId <= 0) {
                ClientUtils.showErrorMessageDialog((String)"\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u044b \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b!");
                return false;
            }
            BigDecimal priceValue = Utils.parseBigDecimal((String)this.price.getText(), (BigDecimal)BigDecimal.ZERO);
            if (priceValue.compareTo(BigDecimal.ZERO) <= 0) {
                BGToolTip.showErrorMessage((JComponent)this.price, (String)"\u0417\u0430\u0434\u0430\u0439\u0442\u0435 \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c!");
                return false;
            }
            ((MegafonOption)this.data).setTitle(this.title.getText());
            ((MegafonOption)this.data).setProductOfferingId(this.productOfferingId.getText());
            ((MegafonOption)this.data).setOptionType((MegafonOptionType)this.optionType.getSelectedItem());
            ((MegafonOption)this.data).setNpayServiceId(serviceId);
            ((MegafonOption)this.data).setPrice(priceValue);
            MegafonOptionPanel.this.getMegafonService().updateOption((MegafonOption)this.data);
            MegafonOptionPanel.this.performAction("refresh");
            return true;
        }
    }
}

