/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megogo.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractSubRequestLog;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;

public class MegogoContractSubRequestLogDao
extends AbstractIdDao<MegogoContractSubRequestLog> {
    public MegogoContractSubRequestLogDao(Connection con, int moduleId) {
        super(con, "megogo_contract_sub_request_log", moduleId);
    }

    public void setContractSubscriptionId(int id, int contractSubscriptionId) throws SQLException {
        if (id > 0 && contractSubscriptionId > 0) {
            String query = "UPDATE " + this.tableName + " SET contractSubId=? WHERE id=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                int index = 1;
                ps.setInt(index++, contractSubscriptionId);
                ps.setInt(index++, id);
                ps.executeUpdate();
            }
        }
    }

    public List<MegogoContractSubRequestLog> getContractLogList(int contractId) throws SQLException {
        return this.list("contractId=?", "time", new Object[]{contractId});
    }

    protected MegogoContractSubRequestLog getFromRS(ResultSet rs) throws SQLException {
        return new MegogoContractSubRequestLog().setId(rs.getInt("id")).setContractSubId(rs.getInt("contractSubId")).setServiceId(rs.getInt("sid")).setContractId(rs.getInt("contractId")).setType(rs.getInt("type")).setAnswerResult(rs.getInt("answerResult")).setDate(TimeUtils.convertTimestampToDate((Timestamp)rs.getTimestamp("time"))).setErrorMessage(rs.getString("errorMessage")).setUserId(rs.getInt("userId"));
    }

    protected void updateImpl(MegogoContractSubRequestLog log) throws SQLException {
        Objects.requireNonNull(log);
        if (log.getId() < 1) {
            String query = "INSERT INTO " + this.tableName + " SET contractSubId=?, contractId=?, sid=?, type=?, answerResult=?, time=?, errorMessage=?, userId=?";
            try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
                int index = 0;
                ps.setInt(++index, log.getContractSubId());
                ps.setInt(++index, log.getContractId());
                ps.setInt(++index, log.getServiceId());
                ps.setInt(++index, log.getType());
                ps.setInt(++index, log.getAnswerResult());
                ps.setTimestamp(++index, TimeUtils.convertDateToTimestamp((Date)log.getDate()));
                ps.setString(++index, log.getErrorMessage());
                ps.setInt(++index, log.getUserId());
                ps.executeUpdate();
                log.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }
}

