/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.megogo.client;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.module.common.bean.Service;
import ru.bitel.bgbilling.modules.megogo.client.MegogoContractPanel;
import ru.bitel.bgbilling.modules.megogo.common.bean.MegogoContractSubRequestLog;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.table.BGTableModel;

public class MegogoContractRequestLogPanel
extends MegogoContractPanel {
    private MegogoContractSubRequestLogTableModel model;
    private BGUTable table;

    public MegogoContractRequestLogPanel() {
        this.table = new BGUTable((TableModel)((Object)this.model));
    }

    @Override
    protected void jbInit() throws Exception {
        this.model = new MegogoContractSubRequestLogTableModel(MegogoContractSubRequestLogTableModel.class.getName());
        this.table.setModel((TableModel)((Object)this.model));
        this.setLayout(new GridBagLayout());
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            if (e.getActionCommand() == "refresh") {
                this.resetServiceDirectory();
                this.resetUserDirectory();
            }
            this.model.setData(this.getMegogoService().getContractRequestLog(((ClientContext)this.getContext()).getContractId()));
        });
    }

    class MegogoContractSubRequestLogTableModel
    extends BGTableModel<MegogoContractSubRequestLog> {
        public MegogoContractSubRequestLogTableModel(String name) {
            super(name);
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("ID \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438", 100, 100, 100, "contractSubId", true, (TableCellRenderer)DecimalTableCellRenderer.INTEGER());
            this.addColumn("\u0423\u0441\u043b\u0443\u0433\u0430", -1, 250, 600, "title", true);
            this.addColumn("\u0422\u0438\u043f", 200, 200, 300, "type", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0414\u0430\u0442\u0430", 100, 100, 100, "date", true);
            this.addColumn("\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442", 150, 150, 200, "answerResult", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c", 150, 200, 250, "userId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0448\u0438\u0431\u043a\u0438", -1, -1, -1, "errorMessage", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValueAt(MegogoContractSubRequestLog val, int column) throws Exception {
            switch (column) {
                case 2: {
                    if (val.getType() == MegogoContractSubRequestLog.MEGOGO_REQUEST_TYPE_CREATE_USER.intValue() || val.getType() == MegogoContractSubRequestLog.MEGOGO_REQUEST_TYPE_CHANGE_CREDENTIALS.intValue()) {
                        return "";
                    }
                    return MegogoContractRequestLogPanel.this.getServiceDirectory().get(val.getServiceId()) == null ? "<\u0422\u0438\u043f \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>" : ((Service)MegogoContractRequestLogPanel.this.getServiceDirectory().get(val.getServiceId())).getTitle();
                }
                case 3: {
                    return val.getTypeText();
                }
                case 5: {
                    return val.getAnswerResultText();
                }
                case 6: {
                    return MegogoContractRequestLogPanel.this.getUserDirectory().get(val.getUserId()) == null ? "<\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d>" : ((UserInfo)MegogoContractRequestLogPanel.this.getUserDirectory().get(val.getUserId())).getName();
                }
            }
            return super.getValue((Object)val, column);
        }
    }
}

