/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mobile.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.mobile.common.bean.MobileContractData;
import ru.bitel.bgbilling.modules.mobile.common.bean.PushStatusType;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractDao;

public class MobileContractDataDao
extends AbstractDao<MobileContractData> {
    public MobileContractDataDao(Connection con, int moduleId) {
        super(con, "mobile_contract_data", moduleId);
    }

    public MobileContractData getContractData(int contractId) throws BGException {
        return (MobileContractData)this.get("contractId=?", new Object[]{contractId});
    }

    protected MobileContractData getFromRS(ResultSet rs) throws SQLException, BGException {
        return new MobileContractData().setId(rs.getInt("id")).setContractId(rs.getInt("contractId")).setStatus(PushStatusType.getByCode((int)rs.getInt("status"))).setLastConfirmDate((Date)rs.getTimestamp("lastConfirmDate")).setCountNotification(rs.getInt("countNotification")).setLastSendDate((Date)rs.getTimestamp("lastSendDate"));
    }

    protected void updateImpl(MobileContractData data) throws BGException, SQLException {
        if (data.getId() > 0) {
            String query = "UPDATE " + this.tableName + " SET status=?, lastConfirmDate=?, countNotification=?, lastSendDate=? WHERE id=?";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                ps.setInt(1, data.getStatus().getCode());
                ps.setTimestamp(2, TimeUtils.convertDateToTimestamp((Date)data.getLastConfirmDate()));
                ps.setInt(3, data.getCountNotification());
                ps.setTimestamp(4, TimeUtils.convertDateToTimestamp((Date)data.getLastSendDate()));
                ps.setInt(5, data.getId());
                ps.executeUpdate();
            }
        }
        String query = "INSERT INTO " + this.tableName + " SET contractId=?, status=?, lastConfirmDate=?, countNotification=?, lastSendDate=?";
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            ps.setInt(1, data.getContractId());
            ps.setInt(2, data.getStatus().getCode());
            ps.setTimestamp(3, TimeUtils.convertDateToTimestamp((Date)data.getLastConfirmDate()));
            ps.setInt(4, data.getCountNotification());
            ps.setTimestamp(5, TimeUtils.convertDateToTimestamp((Date)data.getLastSendDate()));
            ps.executeUpdate();
            data.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
        }
    }
}

