/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mobimoney.server.action.web;

import bitel.billing.server.ActionResultContentType;
import bitel.billing.server.contract.bean.Contract;
import jakarta.servlet.http.HttpSession;
import jakarta.xml.ws.Holder;
import java.math.BigDecimal;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.XMLGregorianCalendar;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.bean.AbstractTransactionStatus;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebAction;
import ru.bitel.bgbilling.kernel.admin.web.server.bean.WebOperation;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractPaymentAction;
import ru.bitel.bgbilling.modules.gazprombank.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.mobimoney.common.bean.MobiServiceCode;
import ru.bitel.bgbilling.modules.mobimoney.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mobimoney.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.mobimoney.server.service.shopservice.demo.ShopService;
import ru.bitel.bgbilling.modules.mobimoney.server.service.shopservice.demo.ShopServiceSoap;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.model.SearchResult;

@WebAction(title="MobiMoney")
public class ActionDoTransaction
extends AbstractPaymentAction {
    public ActionDoTransaction() {
        super("mobimoney");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436\u043d\u0430\u044f \u0444\u043e\u0440\u043c\u0430")
    public void form() throws BGException {
        this.requestDispatcher(this.moduleName, "form");
    }

    @WebOperation(title="\u0418\u0441\u0442\u043e\u0440\u0438\u044f \u043e\u043f\u043b\u0430\u0442")
    public void transactions() throws Exception {
        SearchResult searchResult = new SearchResult(this.getPage(), new String[]{"createDate:1", "transactionDate:1"});
        new TransactionManager(this.con, this.moduleId).searchTransaction((SearchResult<Transaction>)searchResult, this.contractId, null, this.getStatus((AbstractTransactionStatus)TransactionStatus.ALL));
        this.setResultParam("transactions", searchResult.getList());
        this.requestDispatcher("include", "payment_transactions");
    }

    @WebOperation(title="\u041f\u043b\u0430\u0442\u0435\u0436")
    public void pay() throws Exception {
        super.pay();
        super.payCheckSum();
        MobiServiceCode mobiServiceCode = this.getServiceCode(this.req.getInt("serviceCode", 0));
        BigDecimal summa = this.req.getBigDecimal("summa", BigDecimal.ZERO);
        String phone = this.req.get("phone", null);
        if (summa.compareTo(BigDecimal.ZERO) <= 0 || Utils.isBlankString((String)phone) || mobiServiceCode == null || mobiServiceCode.getCode() < 1) {
            this.execute();
            throw new BGMessageException("\u041e\u0434\u043d\u043e \u0438\u043b\u0438 \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u043f\u043e\u043b\u0435\u0439 \u043d\u0435 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u043e!");
        }
        Pattern pattern = Pattern.compile("\\d{10}");
        Matcher matcher = pattern.matcher(phone);
        if (!matcher.find()) {
            this.execute();
            throw new BGMessageException("\u041f\u043e\u043b\u0435 \u0442\u0435\u043b\u0435\u0444\u043e\u043d \u0434\u043e\u043b\u0436\u043d\u043e \u0441\u043e\u0441\u0442\u043e\u044f\u0442\u044c \u0438\u0437 10 \u0446\u0438\u0444\u0440!");
        }
        this.setResultParam("contentType", ActionResultContentType.jsp);
        HttpSession session = this.context.getRequest().getSession();
        Contract contract = (Contract)session.getAttribute("contract_current");
        String smsCommand = this.moduleSetup.get("mobimoney.merchant.url", "") + " " + contract.getTitle() + " " + String.valueOf(Utils.roundBigDecimalSumm((BigDecimal)summa));
        Holder paymentID = new Holder();
        Holder paymentTime = new Holder();
        int serviceNumber = mobiServiceCode.getCode();
        Holder initResultCode = new Holder();
        Holder resultTitle = new Holder();
        try {
            ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
            if ("work".equals(moduleSetup.get("mobimoney.mode", "demo"))) {
                ru.bitel.bgbilling.modules.mobimoney.server.service.shopservice.work.ShopServiceSoap shopService = new ru.bitel.bgbilling.modules.mobimoney.server.service.shopservice.work.ShopService().getShopServiceSoap(moduleSetup);
                shopService.initPayment(phone, smsCommand, String.valueOf(serviceNumber), (Holder<String>)paymentID, (Holder<XMLGregorianCalendar>)paymentTime, (Holder<Integer>)initResultCode, (Holder<String>)resultTitle);
            } else {
                ShopServiceSoap shopService = new ShopService().getShopServiceSoap(moduleSetup);
                shopService.initPayment(phone, smsCommand, String.valueOf(serviceNumber), (Holder<String>)paymentID, (Holder<XMLGregorianCalendar>)paymentTime, (Holder<Integer>)initResultCode, (Holder<String>)resultTitle);
            }
            if ((Integer)initResultCode.value != 1) {
                this.execute();
                this.getLogger().error("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0435 \u0441\u043e\u0432\u0435\u0440\u0448\u0435\u043d\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 ID=" + this.contractId + "( \u043a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438 " + String.valueOf(initResultCode.value) + " - " + (String)resultTitle.value + " )");
                throw new BGMessageException("\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430: " + (String)resultTitle.value);
            }
            this.execute();
            this.getLogger().info("\u0418\u043d\u0438\u0446\u0438\u0430\u0446\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u043f\u0440\u043e\u0448\u043b\u0430 \u0443\u0441\u043f\u0435\u0448\u043d\u043e: ID \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 = " + this.contractId + ", [initResultCode=" + String.valueOf(initResultCode.value) + "; paymentID=" + (String)paymentID.value + "; paymentTime=" + String.valueOf(paymentTime.value) + "]");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }

    private MobiServiceCode getServiceCode(int serviceCode) throws Exception {
        MobiServiceCode result = null;
        TransactionManager transactionManager = new TransactionManager(this.con, this.moduleId);
        for (MobiServiceCode mobiServiceCode : transactionManager.getServiceCodeList()) {
            if (mobiServiceCode.getCode() != serviceCode) continue;
            result = mobiServiceCode;
            break;
        }
        return result;
    }
}

