/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.bean.protocol;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.modules.mps.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mps.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.mps.server.bean.Conf;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSException;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSRequest;
import ru.bitel.bgbilling.modules.mps.server.bean.MPSResponse;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.MPSTransactionManager;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class RapidaTransactionManager
extends MPSTransactionManager {
    public static final String PARAM_COMMAND = "command";
    public static final String PARAM_TXN_ID = "txn_id";
    public static final String PARAM_TXN_DATE = "txn_date";
    public static final String PARAM_ACCOUNT = "account";
    public static final String PARAM_SUM = "sum";
    protected static final Pattern TRANSACTION_PATTERN = Pattern.compile("^(\\d+)\t(.+)\t(.+)\t(.+)$", 8);

    @Override
    protected byte[] processRequest(Connection con, int moduleId, String mpsId, Conf conf, Conf.MPSSystem system, HttpServletRequest request, HttpServletResponse response) {
        MPSResponse mpsResponse = new MPSResponse(moduleId, mpsId, response);
        mpsResponse.setResult(0);
        try {
            if (system == null || !system.mode) {
                throw new MPSException(9, "\u0421\u0435\u0440\u0432\u0438\u0441 \u0432\u0440\u0435\u043c\u0435\u043d\u043d\u043e \u043d\u0435 \u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442");
            }
            MPSRequest mpsRequest = this.parseRequest(con, moduleId, mpsId, system, request);
            this.checkValid(system, mpsRequest, con);
            mpsResponse.setAction(mpsRequest.getAction());
            mpsResponse.setTransId(mpsRequest.getTransId());
            Transaction transaction = this.getTransactionByTransId(con, moduleId, mpsId, mpsRequest.getTransId(), mpsRequest.getTime());
            switch (mpsRequest.getAction()) {
                case 1: {
                    if (mpsRequest.getSum().compareTo(system.minSumm) < 0 || mpsRequest.getSum().compareTo(system.maxSumm) > 0) {
                        throw new MPSException(8, "\u0412\u0432\u0435\u0434\u0435\u043d\u0430 \u043d\u0435\u0432\u0435\u0440\u043d\u0430\u044f \u0441\u0443\u043c\u043c\u0430 \u043f\u043b\u0430\u0442\u0435\u0436\u0430. \u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 \u043f\u043b\u0430\u0442\u0435\u0436 \u0441\u043e\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442 " + String.valueOf(system.minSumm) + " " + Setup.getSetup().get("client.gui.currency.title.medium", "\u0440\u0443\u0431.;") + " \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u044b\u0439 - " + String.valueOf(system.maxSumm) + " " + Setup.getSetup().get("client.gui.currency.title.medium", "\u0440\u0443\u0431."));
                    }
                    if (transaction != null) {
                        throw new MPSException(4, "\u041f\u043b\u0430\u0442\u0435\u0436 \u0441 \u0434\u0430\u043d\u043d\u044b\u043c \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c \u0443\u0436\u0435 \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d");
                    }
                    mpsResponse.setMessage(this.getComment(system, conf, con, this.actionCheck(mpsRequest)));
                    break;
                }
                case 2: {
                    if (transaction != null && !transaction.getStatus().equals(TransactionStatus.PAYMENT_PAYED.getCode())) {
                        mpsResponse.setResult(300);
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u0435\u0441\u0442\u044c \u0432 \u0431\u0430\u0437\u0435, \u043d\u043e \u0431\u044b\u043b \u043e\u0442\u043c\u0435\u043d\u0435\u043d");
                        break;
                    }
                    if (transaction == null) {
                        Contract contract = this.actionCheck(mpsRequest);
                        this.checkTime(mpsRequest);
                        transaction = this.addTransaction(con, moduleId, mpsId, system, contract.getId(), mpsRequest.getTime(), mpsRequest.getSum(), mpsRequest.getTransId(), mpsRequest.getRawNumber(), mpsRequest.getType(), system.title);
                        mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u043f\u0440\u0438\u043d\u044f\u0442 \u043d\u0430: " + this.getComment(system, conf, con, contract));
                    } else {
                        Contract contract = this.getContractById(con, transaction.getContractId());
                        if (contract != null) {
                            mpsResponse.setMessage("\u041f\u043b\u0430\u0442\u0435\u0436 \u043f\u0440\u0438\u043d\u044f\u0442 \u043d\u0430: " + this.getComment(system, conf, con, contract));
                        }
                    }
                    mpsResponse.setId(transaction.getId());
                    mpsResponse.setSum(transaction.getSum());
                    mpsResponse.setLocalTime(transaction.getLocalTime());
                }
            }
        }
        catch (MPSException ex) {
            this.processError(ex, mpsResponse);
        }
        catch (Exception e) {
            this.processError(new MPSException(-1), mpsResponse);
            e.printStackTrace();
        }
        return this.getResponse(con, system, mpsResponse);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected MPSRequest parseRequest(Connection con, int moduleId, String mpsId, Conf.MPSSystem system, HttpServletRequest request) throws MPSException {
        mpsRequest = new MPSRequest(con, moduleId, mpsId, request, system);
        actionString = request.getParameter("command");
        if ("check".equals(actionString)) {
            mpsRequest.setAction(1);
        } else if ("pay".equals(actionString)) {
            mpsRequest.setAction(2);
        }
        mpsRequest.setTransId(request.getParameter("txn_id"));
        type = 0;
        number = request.getParameter("account");
        if (!system.osmpPrefix || number == null || number.length() <= 1 || number.charAt(1) != '_') ** GOTO lbl-1000
        v0 = number.charAt(0);
        type = v0;
        if (Character.isDigit((int)v0)) {
            type = Character.getNumericValue(type);
            mpsRequest.setNumber(number.substring(2));
        } else lbl-1000:
        // 2 sources

        {
            mpsRequest.setNumber(number);
        }
        mpsRequest.setType(type);
        mpsRequest.setRawNumber(number);
        time = TimeUtils.parseDate((String)request.getParameter("txn_date"), (String)"yyyyMMddHHmmss");
        mpsRequest.setTime(time != null ? time : new Date());
        mpsRequest.setSum(Utils.parseBigDecimal((String)request.getParameter("sum"), (BigDecimal)BigDecimal.ZERO));
        mpsRequest.parameters.put("command", actionString);
        mpsRequest.parameters.put("txn_id", request.getParameter("txn_id"));
        mpsRequest.parameters.put("account", request.getParameter("account"));
        mpsRequest.parameters.put("sum", request.getParameter("sum"));
        return mpsRequest;
    }

    @Override
    protected void processError(MPSException ex, MPSResponse response) {
        switch (ex.error) {
            case 2: {
                response.setResult(300);
                response.setMessage("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
                break;
            }
            case 3: {
                response.setResult(5);
                response.setMessage("\u0418\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440 \u0430\u0431\u043e\u043d\u0435\u043d\u0442\u0430 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d (\u041e\u0448\u0438\u0431\u043b\u0438\u0441\u044c \u043d\u043e\u043c\u0435\u0440\u043e\u043c)");
                break;
            }
            case 6: {
                response.setResult(300);
                response.setMessage(ex.message);
                break;
            }
            case 22: {
                response.setResult(241);
                response.setMessage("\u0421\u0443\u043c\u043c\u0430 \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u043c\u0430\u043b\u0430");
                break;
            }
            case 23: {
                response.setResult(242);
                response.setMessage("\u0421\u0443\u043c\u043c\u0430 \u0441\u043b\u0438\u0448\u043a\u043e\u043c \u0432\u0435\u043b\u0438\u043a\u0430");
                break;
            }
            case -1: {
                response.setResult(300);
                response.setMessage("\u0412\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u044f\u044f \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430");
                break;
            }
            case 9: {
                response.setResult(8);
                response.setMessage("\u041f\u0440\u0438\u0435\u043c \u043f\u043b\u0430\u0442\u0435\u0436\u0430 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d \u043f\u043e \u0442\u0435\u0445\u043d\u0438\u0447\u0435\u0441\u043a\u0438\u043c \u043f\u0440\u0438\u0447\u0438\u043d\u0430\u043c");
                break;
            }
            case 4: {
                response.setResult(300);
                response.setMessage(ex.message);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected List<Transaction> getTransactionListFromFile(Conf.MPSSystem system, String file) {
        result = new ArrayList<Transaction>();
        match = RapidaTransactionManager.TRANSACTION_PATTERN.matcher(file);
        while (match.find()) {
            number = match.group(3);
            transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setTransId(Utils.parseLong((String)match.group(1), (long)0L)).setTime(TimeUtils.parseDate((String)match.group(2), (String)"dd.MM.yyyy HH:mm:ss")).setRawNumber(number).setSum(Utils.parseBigDecimal((String)match.group(4), (BigDecimal)BigDecimal.ZERO))).setStatus(TransactionStatus.PAYMENT_PAYED.getCode())).build();
            type = 0;
            if (!system.osmpPrefix || number == null || number.length() <= 1 || number.charAt(1) != '_') ** GOTO lbl-1000
            v0 = number.charAt(0);
            type = v0;
            if (Character.isDigit((int)v0)) {
                transaction.setType(Character.getNumericValue(type));
                transaction.setNumber(number.substring(2));
            } else lbl-1000:
            // 2 sources

            {
                transaction.setType(type);
                transaction.setNumber(number);
            }
            result.add(transaction);
        }
        return result;
    }

    @Override
    protected byte[] getResponse(Connection con, Conf.MPSSystem system, MPSResponse response) {
        Document doc = this.documentBuilder.newDocument();
        Element rootNode = doc.createElement("response");
        doc.appendChild(rootNode);
        XMLUtils.createElement((Element)rootNode, (String)"rapida_txn_id").setTextContent(String.valueOf(response.getTransId()));
        if (response.getId() > 0L) {
            XMLUtils.createElement((Element)rootNode, (String)"prv_txn").setTextContent(String.valueOf(response.getId()));
        }
        if (response.getSum() != null) {
            XMLUtils.createElement((Element)rootNode, (String)PARAM_SUM).setTextContent(new DecimalFormat("0.00").format(response.getSum()));
        }
        XMLUtils.createElement((Element)rootNode, (String)"result").setTextContent(String.valueOf(response.getResult()));
        if (response.comment != null || response.getMessage() != null) {
            XMLUtils.createElement((Element)rootNode, (String)"comment").setTextContent(response.getMessage());
        }
        return this.xmlSerialize(doc);
    }

    public static void main(String[] args) {
    }

    private class AnswerCode {
        private static final int OK = 0;
        private static final int ERROR_1 = 1;
        private static final int ERROR_4 = 4;
        private static final int ERROR_5 = 5;
        private static final int ERROR_7 = 7;
        private static final int ERROR_8 = 8;
        private static final int ERROR_79 = 79;
        private static final int ERROR_241 = 241;
        private static final int ERROR_242 = 242;
        private static final int ERROR_243 = 243;
        private static final int ERROR_300 = 300;
        private static final int ERROR_500 = 500;

        private AnswerCode(RapidaTransactionManager rapidaTransactionManager) {
        }
    }
}

