/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.mps.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.config.common.bean.ConfigData;
import ru.bitel.bgbilling.kernel.config.server.bean.ConfigDAO;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ModuleConfigModifiedEvent;
import ru.bitel.bgbilling.modules.mps.common.bean.Transaction;
import ru.bitel.bgbilling.modules.mps.common.service.MPSService;
import ru.bitel.bgbilling.modules.mps.server.bean.protocol.MPSTransactionManager;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.mps.common.service.MPSService")
public class MPSServiceImpl
extends AbstractService
implements MPSService {
    @PostConstruct
    protected void init() {
    }

    public SearchResult<Transaction> searchTransactions(int contractId, String systemId, String status, PeriodWithTime period, Page page) throws BGException {
        SearchResult searchResult = new SearchResult(period, page);
        MPSTransactionManager.getInstance(systemId, Setup.getSetup(), this.moduleId).searchTransactionList((SearchResult<Transaction>)searchResult, systemId, contractId, status, this.getConnection(), this.moduleId);
        return searchResult;
    }

    public Transaction getTransaction(String mobiPaymentId) throws BGException {
        return null;
    }

    public void updateTransaction(Transaction transaction) throws BGException {
    }

    public void checkStatus(Transaction transaction) throws BGException {
    }

    public int checkContract(String contract) throws BGException {
        return 0;
    }

    public boolean checkTransaction(int contractId, String transactionId) throws BGException {
        return false;
    }

    public List<KeyValue> getMPSSystemList() throws BGException {
        ArrayList<KeyValue> data = new ArrayList<KeyValue>();
        ModuleSetup moduleSetup = this.getModuleSetup();
        List mpsKeys = Utils.toList((String)moduleSetup.get("mps.ids", "1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20"));
        for (String key : mpsKeys) {
            String title = moduleSetup.get("mps." + key + ".title", null);
            if (title == null) continue;
            data.add(new KeyValue(key, title));
        }
        return data;
    }

    public String getMPSSystemConfig(String key) throws BGException {
        ParameterMap moduleSetup = this.getModuleSetup().filter("mps." + key + ".");
        return moduleSetup.toString();
    }

    public void updateMPSSystemConfig(String key, String text) throws BGException {
        this.tryCall(() -> {
            ConfigDAO configDAO = new ConfigDAO(this.getConnection());
            ConfigData configData = configDAO.getActiveConfig(this.moduleId);
            if (configData != null) {
                String prefix = "mps." + key + ".";
                String config = configData.getConfig();
                ArrayList<String> newConfig = new ArrayList<String>();
                for (String line : config.split("\n")) {
                    if (line.startsWith(prefix)) continue;
                    newConfig.add(line);
                }
                Stream.of(text.split("\n")).forEach(a -> newConfig.add((String)a));
                configData.setConfig(Utils.toString(newConfig, (String)"\n"));
                configDAO.update((Object)configData);
                EventProcessor.getInstance().publishAfterCommit((Event)new ModuleConfigModifiedEvent(this.moduleId, this.userId));
            }
        });
    }

    public void deleteMPSSystemConfig(String key) throws BGException {
        this.tryCall(() -> {
            ConfigDAO configDAO = new ConfigDAO(this.getConnection());
            ConfigData configData = configDAO.getActiveConfig(this.moduleId);
            if (configData != null) {
                String prefix = "mps." + key + ".";
                String config = configData.getConfig();
                ArrayList<Object> newConfig = new ArrayList<Object>();
                for (String line : config.split("\n")) {
                    if (line.startsWith("mps.ids=")) {
                        List<String> keys = Utils.toList((String)line.substring(8));
                        keys = keys.stream().filter(a -> !a.equals(key)).toList();
                        newConfig.add("mps.ids=" + Utils.toString(keys));
                        continue;
                    }
                    if (line.startsWith(prefix)) continue;
                    newConfig.add(line);
                }
                configData.setConfig(Utils.toString(newConfig, (String)"\n"));
                configDAO.update((Object)configData);
                EventProcessor.getInstance().publishAfterCommit((Event)new ModuleConfigModifiedEvent(this.moduleId, this.userId));
            }
        });
    }
}

