/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.paylinks.server.action.web;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.modules.paylinks.common.bean.RedirectLogEntry;
import ru.bitel.bgbilling.modules.paylinks.server.bean.Method;
import ru.bitel.bgbilling.modules.paylinks.server.bean.MethodManager;
import ru.bitel.bgbilling.modules.paylinks.server.bean.PaylinksRedirectLogDao;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.util.Templater;

public class ActionPaylinks
extends AbstractAction {
    public ActionPaylinks() {
        super("paylinks");
    }

    public void execute() throws Exception {
        MethodManager methodsManager = new MethodManager((ParameterMap)this.moduleSetup);
        List<IdTitle> methods = methodsManager.getMethods();
        this.setResultParam("methods", methods);
        super.execute();
    }

    public void pay() throws BGException {
        Integer methodId = this.req.getInt("methodId", 0);
        MethodManager methodsManager = new MethodManager((ParameterMap)this.moduleSetup);
        Method method = methodsManager.getMethod(methodId);
        method.description = new Templater(method.description).replaceFields("contract.", (Object)this.getContract(this.contractId)).getString();
        method.confirm = null;
        method.url = null;
        method.results = null;
        this.setResultParam("method", method);
    }

    public void confirm() throws BGException {
        Integer methodId = this.req.getInt("methodId", 0);
        String sum = this.req.get("sum", null);
        if (Utils.isBlankString((String)sum)) {
            throw new BGMessageException("\u0432\u0432\u0435\u0434\u0438\u0442\u0435 \u0441\u0443\u043c\u043c\u0443");
        }
        MethodManager methodsManager = new MethodManager((ParameterMap)this.moduleSetup);
        Method method = methodsManager.getMethod(methodId);
        method.description = new Templater(method.description).replaceFields("contract.", (Object)this.getContract(this.contractId)).getString();
        method.confirm = new Templater(method.confirm).replaceFields("contract.", (Object)this.getContract(this.contractId)).replaceString("sum", sum).getString();
        method.url = null;
        method.results = null;
        this.setResultParam("method", method);
        this.setResultParam("sum", sum);
    }

    public void redirect() throws BGException {
        Integer methodId = this.req.getInt("methodId", 0);
        String sum = this.req.get("sum", null);
        MethodManager methodsManager = new MethodManager((ParameterMap)this.moduleSetup);
        Method method = methodsManager.getMethod(methodId);
        method.url = new Templater(method.url).replaceFields("contract.", (Object)this.getContract(this.contractId)).replaceString("sum", sum).replaceString("action", "Paylinks").replaceString("mid", String.valueOf(this.moduleId)).replaceString("module", "paylinks").getString();
        try {
            this.context.getResponse().sendRedirect(method.url);
            RedirectLogEntry entry = new RedirectLogEntry();
            entry.setMethodId(methodId.intValue());
            entry.setCid(this.contractId);
            entry.setDate(new Date());
            entry.setSum(Utils.parseBigDecimal((String)sum, (BigDecimal)BigDecimal.ZERO));
            entry.setRawUrl(method.url);
            new PaylinksRedirectLogDao(this.con, this.moduleId, (ParameterMap)this.moduleSetup).addLogEntry(entry);
        }
        catch (IOException ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void result() throws BGException {
        Integer methodId = this.req.getInt("methodId", 0);
        String sum = this.req.get("sum", null);
        String result = this.req.get("result", null);
        MethodManager methodsManager = new MethodManager((ParameterMap)this.moduleSetup);
        Method method = methodsManager.getMethod(methodId);
        String resultmessage = "\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430";
        if (method.results != null && method.results.containsKey(result)) {
            resultmessage = method.results.get(result);
            resultmessage = new Templater(resultmessage).replaceFields("contract.", (Object)this.getContract(this.contractId)).replaceString("sum", sum).getString();
        }
        this.setResultParam("resultmessage", resultmessage);
    }
}

