/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.rcmts.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.rcmts.server.bean.RCCdrItem;
import ru.bitel.common.TimeUtils;

public class RCCdrItemDao
extends AbstractIdDao<RCCdrItem> {
    public RCCdrItemDao(Connection con, int moduleId) {
        super(con, "rcmts_cdr", moduleId);
    }

    protected RCCdrItem getFromRS(ResultSet rs) throws SQLException {
        return (RCCdrItem)((Object)this.ormFromResultSet(rs, RCCdrItem.class));
    }

    protected void updateImpl(RCCdrItem rcCdrItem) throws SQLException {
        if (rcCdrItem.getId() > 0) {
            this.update(Collections.singletonList(rcCdrItem));
        } else {
            this.insert(Collections.singletonList(rcCdrItem));
        }
    }

    public void insert(List<RCCdrItem> rcCdrItems) throws SQLException {
        this.update0(rcCdrItems, false);
    }

    public void update(List<RCCdrItem> cdrItems) throws SQLException {
        this.update0(cdrItems, true);
    }

    private void update0(List<RCCdrItem> cdrItems, boolean isUpdate) throws SQLException {
        String query = (isUpdate ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET transaction_id=?, transaction_date=?, amount=?, tariff_plan_id=?, tariff_plan_name=?, service_name=?, gaap_code=?, agreement_id=?, agreement_number=?, account_id=?, account_number=?, service_obj_id=?, yy=?, mm=?, bg_entity_id=?, is_service=? " + (isUpdate ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            for (RCCdrItem cdrItem : cdrItems) {
                Calendar transactionDate = cdrItem.getTransactionDate();
                int index = 1;
                ps.setInt(index++, cdrItem.getTransactionId());
                ps.setDate(index++, TimeUtils.convertCalendarToSqlDate((Calendar)transactionDate));
                ps.setBigDecimal(index++, cdrItem.getAmount());
                ps.setInt(index++, cdrItem.getTariffPlanIn());
                ps.setString(index++, cdrItem.getTariffPlanName());
                ps.setString(index++, cdrItem.getServiceName());
                ps.setString(index++, cdrItem.getGaapCode());
                ps.setInt(index++, cdrItem.getAgreementId());
                ps.setString(index++, cdrItem.getAgreementNumber());
                ps.setInt(index++, cdrItem.getAccountId());
                ps.setString(index++, cdrItem.getAccountNumber());
                ps.setInt(index++, cdrItem.getServiceObjectId());
                ps.setInt(index++, transactionDate.get(1));
                ps.setInt(index++, transactionDate.get(2) + 1);
                ps.setInt(index++, cdrItem.getBgEntityId());
                ps.setInt(index++, cdrItem.isService() ? 1 : 0);
                if (isUpdate) {
                    ps.setInt(index, cdrItem.getId());
                }
                ps.addBatch();
            }
            ps.executeBatch();
        }
    }

    public void removeOldCdrItems(List<RCCdrItem> oldItems) throws SQLException {
        String query = "DELETE FROM " + this.tableName + " WHERE yy=? AND mm=? AND account_id=? AND bg_entity_id=? AND is_service=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            for (RCCdrItem oldItem : oldItems) {
                int index = 1;
                ps.setInt(index++, oldItem.getTransactionDate().get(1));
                ps.setInt(index++, oldItem.getTransactionDate().get(2) + 1);
                ps.setInt(index++, oldItem.getAccountId());
                ps.setInt(index++, oldItem.getBgEntityId());
                ps.setInt(index, oldItem.isService() ? 1 : 0);
                ps.addBatch();
            }
            ps.executeBatch();
        }
    }
}

