/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.client;

import au.com.bytecode.opencsv.CSVReader;
import au.com.bytecode.opencsv.CSVWriter;
import bitel.billing.module.common.BGFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.print.PrinterException;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.DialogTypeSelection;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PrinterResolution;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGFileChooser;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.reports.client.BGReportsPanel;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.io.NoClosableOutputStream;

public class ViewReportPanel
extends BGPanel {
    private ColumnData[] headers = null;
    protected ReportTableModel reportTableModel = new ReportTableModel(this.headers);
    protected BGUTable table = new BGUTable((TableModel)((Object)this.reportTableModel));
    private BGControlPanelPages pagePanel = null;
    private List<String[]> values = null;
    private boolean dataInJson = false;

    public ViewReportPanel(BGReportsPanel parent) {
        ActionListener buttonLis = e -> this.controlPanel_actionPerformed(e);
        BGButton saveButton = new BGButton("", "save", buttonLis);
        saveButton.setToolTipText("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043e\u0442\u0447\u0435\u0442 \u0432 \u0444\u0430\u0439\u043b");
        saveButton.setIcon((Icon)ClientUtils.getIcon((String)"save.png"));
        saveButton.setActionCommand("save");
        saveButton.setText("");
        BGButton printBtn = new BGButton("", "print", buttonLis);
        printBtn.setToolTipText("\u041f\u0435\u0447\u0430\u0442\u044c \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u044b");
        printBtn.setIcon((Icon)ClientUtils.getIcon((String)"print.png"));
        BGButton mailBtn = new BGButton("", "mail", e -> parent.sendEmailReport());
        mailBtn.setToolTipText("\u041e\u0442\u043f\u0440\u0430\u0432\u043a\u0430 \u043e\u0442\u0447\u0451\u0442\u0430 \u043d\u0430 email");
        mailBtn.setIcon((Icon)ClientUtils.getIcon((String)"mail.png"));
        this.pagePanel = new BGControlPanelPages();
        this.pagePanel.init();
        this.pagePanel.setKey(((Object)((Object)this)).getClass().getName());
        this.pagePanel.addPropertyChangeListener(e -> {
            String propertyName = e.getPropertyName();
            if (propertyName != null && propertyName.startsWith("to")) {
                this.showData();
            }
        });
        JPanel viewPanel = new JPanel(new BorderLayout());
        viewPanel.add((Component)new JScrollPane((Component)this.table), "Center");
        this.setLayout(new GridBagLayout());
        this.add((Component)saveButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)printBtn, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)mailBtn, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.pagePanel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(viewPanel, new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.trySetData();
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && ViewReportPanel.this.table.getSelectedRow() > -1) {
                    int contractIdColumnIndex = -1;
                    int len = ViewReportPanel.this.headers.length;
                    for (int index = 0; index < len; ++index) {
                        String title = ViewReportPanel.this.headers[index].title;
                        if (!"cid".equals(title) && !"#cid".equals(title) && !"contractId".equals(title)) continue;
                        contractIdColumnIndex = index;
                        break;
                    }
                    if (contractIdColumnIndex > -1) {
                        ClientUtils.openContract((int)Utils.parseInt((String)((String[])ViewReportPanel.this.reportTableModel.getSelectedRow())[contractIdColumnIndex], (int)0));
                    }
                }
            }
        });
    }

    private void saveCsv(String path, List<String[]> saveValues, Charset charset, boolean addBom) throws IOException {
        if (!Utils.endsWithIgnoreCase((String)path, (String)".csv")) {
            path = (String)path + ".csv";
        }
        try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream((String)path), charset);){
            if (addBom) {
                osw.write(Utils.insertBOM());
            }
            try (CSVWriter writer = new CSVWriter((Writer)osw, ';');){
                writer.writeAll(saveValues);
            }
        }
    }

    private void saveCsvZip(String path, List<String[]> saveValues, Charset charset) throws IOException {
        if (!Utils.endsWithIgnoreCase((String)path, (String)".zip")) {
            path = (String)path + ".zip";
        }
        Path p = Paths.get((String)path, new String[0]);
        String csvFileName = p.getFileName().toString();
        csvFileName = csvFileName.replace(".zip", ".csv").replace(".ZIP", ".csv");
        try (ZipOutputStream z = new ZipOutputStream(new FileOutputStream((String)path));){
            z.putNextEntry(new ZipEntry(csvFileName));
            try (CSVWriter writer = new CSVWriter((Writer)new OutputStreamWriter((OutputStream)new NoClosableOutputStream((OutputStream)z), charset), ';');){
                writer.writeAll(saveValues);
            }
            z.closeEntry();
        }
    }

    private void controlPanel_actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if ("save".equals(actionCommand)) {
            BGFileChooser fc = new BGFileChooser((Component)((Object)this));
            FileFilter[] ff = fc.getChoosableFileFilters();
            if (ff != null) {
                for (int i2 = 0; i2 < ff.length; ++i2) {
                    fc.removeChoosableFileFilter(ff[i2]);
                }
            }
            BGFileFilter csvUtf8Filter = new BGFileFilter("csv", "CSV (utf-8)");
            BGFileFilter csvUtf8BomFilter = new BGFileFilter("csv", "CSV (excel, utf-8)");
            BGFileFilter csvCp1251Filter = new BGFileFilter("csv", "CSV (cp1251)");
            BGFileFilter csvZipUtf8Filter = new BGFileFilter("zip", "ZIP-CSV (utf-8)");
            BGFileFilter csvZipCp1251Filter = new BGFileFilter("zip", "ZIP-CSV (cp1251)");
            fc.addChoosableFileFilter((FileFilter)csvUtf8Filter);
            fc.addChoosableFileFilter((FileFilter)csvUtf8BomFilter);
            fc.addChoosableFileFilter((FileFilter)csvCp1251Filter);
            fc.addChoosableFileFilter((FileFilter)csvZipUtf8Filter);
            fc.addChoosableFileFilter((FileFilter)csvZipCp1251Filter);
            if (fc.showSaveDialog((Component)JOptionPane.getRootFrame()) == 0) {
                try {
                    String[] header;
                    ArrayList<Object> saveValues;
                    String[] h = this.values.stream().findFirst().orElse(new String[0]);
                    Set skipColumns = IntStream.range(0, h.length).filter(i -> h[i].startsWith("#")).boxed().collect(Collectors.toSet());
                    if (!skipColumns.isEmpty()) {
                        saveValues = new ArrayList();
                        for (String[] row : this.values) {
                            saveValues.add((String[])IntStream.range(0, row.length).filter(i -> !skipColumns.contains(i)).mapToObj(j -> row[j]).toArray(String[]::new));
                        }
                    } else {
                        saveValues = new ArrayList<String[]>(this.values);
                    }
                    if ((header = (String[])saveValues.stream().findFirst().orElse(null)) != null) {
                        header = (String[])Arrays.stream(header).map(title -> {
                            int idx = -1;
                            idx = title.indexOf("##");
                            if (idx > -1) {
                                return title.substring(0, idx);
                            }
                            return title;
                        }).toArray(String[]::new);
                        saveValues.set(0, header);
                    }
                    String path = fc.getSelectedFile().getAbsolutePath();
                    if (csvUtf8Filter.equals(fc.getFileFilter())) {
                        this.saveCsv(path, saveValues, StandardCharsets.UTF_8, false);
                    } else if (csvUtf8BomFilter.equals(fc.getFileFilter())) {
                        this.saveCsv(path, saveValues, StandardCharsets.UTF_8, true);
                    } else if (csvZipUtf8Filter.equals(fc.getFileFilter())) {
                        this.saveCsvZip(path, saveValues, StandardCharsets.UTF_8);
                    } else if (csvCp1251Filter.equals(fc.getFileFilter())) {
                        this.saveCsv(path, saveValues, Charset.forName("cp1251"), false);
                    } else if (csvZipCp1251Filter.equals(fc.getFileFilter())) {
                        this.saveCsvZip(path, saveValues, Charset.forName("cp1251"));
                    }
                    JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "\u0424\u0430\u0439\u043b \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d");
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
        } else if ("print".equals(actionCommand)) {
            try {
                HashPrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
                aset.add(MediaSizeName.ISO_A4);
                aset.add(new PrinterResolution(300, 300, 100));
                aset.add(DialogTypeSelection.NATIVE);
                aset.add(OrientationRequested.LANDSCAPE);
                this.table.print(JTable.PrintMode.FIT_WIDTH, null, null, true, (PrintRequestAttributeSet)aset, true);
            }
            catch (PrinterException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        } else if ("do".equals(actionCommand)) {
            JOptionPane.showMessageDialog(JOptionPane.getRootFrame(), "do");
        }
    }

    public void showReport(InputStream input) throws IOException {
        if (this.dataInJson) {
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(input, "UTF-8"));){
                StringBuilder builder = new StringBuilder();
                char[] buf = new char[0x100000];
                int i = bufferedReader.read(buf);
                while (i > -1) {
                    builder.append(new String(buf, 0, i));
                    i = bufferedReader.read(buf);
                }
                JSONObject jsonObject = new JSONObject(builder.toString());
                this.values = new ArrayList<String[]>();
                JSONArray rows = jsonObject.optJSONArray("rows");
                int len = rows.length();
                for (int index = 0; index < len; ++index) {
                    JSONArray row = rows.getJSONArray(index);
                    String[] data = new String[row.length()];
                    int fLen = row.length();
                    for (int fIndex = 0; fIndex < fLen; ++fIndex) {
                        data[fIndex] = row.optString(fIndex);
                    }
                    this.values.add(data);
                }
                JSONArray header = jsonObject.optJSONArray("headers");
                this.headers = new ColumnData[header.length()];
                int len2 = this.headers.length;
                for (int index = 0; index < len2; ++index) {
                    JSONObject headerJson = header.optJSONObject(index);
                    ColumnData columnData = new ColumnData(this);
                    columnData.title = headerJson.getString("title");
                    columnData.width = new int[]{Utils.parseInt((String)headerJson.getString("wmin"), (int)-1), Utils.parseInt((String)headerJson.getString("wpref"), (int)-1), Utils.parseInt((String)headerJson.getString("wmax"), (int)-1)};
                    columnData.align = Utils.parseInt((String)headerJson.getString("align"), (int)-1);
                    columnData.type = headerJson.optString("type", "string");
                    this.headers[index] = columnData;
                }
            }
        }
        try (InputStreamReader inputStreamReader = new InputStreamReader(input, "UTF-8");
             CSVReader csvReader = new CSVReader((Reader)inputStreamReader, ';', '\"', '\\');){
            this.values = csvReader.readAll();
        }
        if (this.values.size() == 0) {
            this.headers = null;
            return;
        }
        this.headers = new ColumnData[this.values.get(0).length];
        int len = this.values.get(0).length;
        for (int index = 0; index < len; ++index) {
            String title = this.values.get(0)[index];
            ColumnData columnData = new ColumnData(this);
            int pos = title.indexOf("##");
            if (pos > -1) {
                int w = Utils.parseInt((String)title.substring(pos + 2));
                title = title.substring(0, pos);
                columnData.width = new int[]{-1, w, w};
            }
            if (title.startsWith("#")) {
                title = title.substring(1);
                columnData.width = new int[]{0, 0, 0};
            }
            columnData.title = title;
            this.headers[index] = columnData;
        }
        this.pagePanel.setPageIndex(1);
        this.pagePanel.setPageCount((this.values.size() - 1) / (this.pagePanel.getPageSize() + 1));
        this.showData();
    }

    private void showData() {
        int pageCount = (this.values.size() - 1) / this.pagePanel.getPageSize() + 1;
        if ((this.values.size() - 1) % this.pagePanel.getPageSize() == 0) {
            --pageCount;
        }
        this.pagePanel.setPageCount(pageCount);
        this.reportTableModel = new ReportTableModel(this.headers);
        this.table.setModel((TableModel)((Object)this.reportTableModel));
        String[][] page = this.getCurrentPage();
        ArrayList<String[]> rows = new ArrayList<String[]>();
        for (int i = 0; i < page.length; ++i) {
            String[] line = page[i];
            rows.add(line);
        }
        this.reportTableModel.setData(rows);
    }

    private String[][] getCurrentPage() {
        int pageIndex = this.pagePanel.getPageIndex();
        int pageSize = this.pagePanel.getPageSize();
        int start = (pageIndex - 1) * pageSize + (this.dataInJson ? 0 : 1);
        int end = start + pageSize >= this.values.size() ? this.values.size() : start + pageSize;
        String[][] result = new String[end - start][this.headers.length];
        int i = start;
        int j = 0;
        while (i < end) {
            result[j] = this.values.get(i);
            ++i;
            ++j;
        }
        return result;
    }

    public void setDataInJson(boolean value) {
        this.dataInJson = value;
    }

    class ColumnData {
        public String title = "";
        public int[] width = new int[]{-1, -1, -1};
        public int align = -1;
        public String type = "string";

        ColumnData(ViewReportPanel this$0) {
        }
    }

    class ReportTableModel
    extends BGTableModel<String[]> {
        public ReportTableModel(ColumnData[] headers) {
            super(ReportTableModel.class.getName());
            if (headers != null) {
                for (ColumnData columnData : headers) {
                    HorizontalAlignmentTableCellRenderer cellRenderer = HorizontalAlignmentTableCellRenderer.LEFT();
                    if (columnData.align == 0) {
                        cellRenderer = HorizontalAlignmentTableCellRenderer.CENTER();
                    } else if (columnData.align == 1) {
                        cellRenderer = HorizontalAlignmentTableCellRenderer.RIGHT();
                    }
                    cellRenderer = switch (columnData.type) {
                        case "decimal" -> DecimalTableCellRenderer.DEFAULT();
                        case "integer" -> DecimalTableCellRenderer.INTEGER();
                        case "date" -> DatetimeTableCellRenderer.DEFAULT_DDMMYYYY();
                        default -> cellRenderer;
                    };
                    this.addColumn(columnData.title, columnData.width[0], columnData.width[1], columnData.width[2], columnData.title, true, (TableCellRenderer)cellRenderer);
                }
            }
        }

        protected void initColumns() {
        }

        public Object getValueAt(String[] val, int column) throws BGException {
            ColumnData columnData = ViewReportPanel.this.headers[column];
            return switch (columnData.type) {
                case "decimal" -> new BigDecimal(val[column].length() > 0 ? val[column] : "0.00");
                case "integer" -> Utils.parseInt((String)val[column]);
                case "date" -> TimeUtils.parseDate((String)val[column], (String)"dd.MM.yyyy");
                default -> val[column];
            };
        }
    }
}

