/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.reports.client.constructor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ru.bitel.bgbilling.modules.reports.client.constructor.ParameterField;
import ru.bitel.bgbilling.modules.reports.client.constructor.ReportFieldsTabelPanel;
import ru.bitel.bgbilling.modules.reports.client.include.FillableFilter;
import ru.bitel.bgbilling.modules.reports.client.include.ModuleFilter;
import ru.bitel.bgbilling.modules.reports.client.include.ReportFilter;
import ru.bitel.bgbilling.modules.reports.client.include.ReportFilterParameterName;

public class FilterPanel
extends JPanel {
    private static final GridBagConstraints CONSTRAINTS = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 3, 0, 3), 0, 0);
    private final List<ParameterField> parameterFields = new LinkedList<ParameterField>();
    private final JTextField titleField = new JTextField();
    private ParameterField moduleIdField;
    private ParameterField sqlRequestField;
    private final ReportFilter reportFilter;
    private ReportFieldsTabelPanel reportFieldsTabelPanel;

    protected FilterPanel(ReportFilter reportFilter) {
        Field midField;
        this.reportFilter = reportFilter;
        this.setLayout(new GridBagLayout());
        if (reportFilter instanceof JPanel) {
            JPanel panel = (JPanel)((Object)reportFilter);
            this.add((Component)panel, CONSTRAINTS);
            this.disableComponents(panel);
        }
        this.titleField.setText(reportFilter.getGuiTitle());
        this.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0444\u0438\u043b\u044c\u0442\u0440\u0430 \u0434\u043b\u044f \u043e\u0442\u0447\u0435\u0442\u0430:"), CONSTRAINTS);
        this.add((Component)this.titleField, CONSTRAINTS);
        this.addParameterFields();
        if (reportFilter instanceof ModuleFilter && (midField = this.findFieldByName("mid", "moduleId", "pluginId")) != null) {
            this.moduleIdField = new ParameterField(midField);
            this.addModuleIdField();
        }
        if (reportFilter instanceof FillableFilter) {
            this.addFillableParametersPanel();
        }
    }

    private void disableComponents(JComponent component) {
        component.setEnabled(false);
        if (component.getComponents() != null && component.getComponents().length > 0) {
            for (Component child : component.getComponents()) {
                if (!(child instanceof JComponent)) continue;
                this.disableComponents((JComponent)child);
            }
        }
    }

    private void addParameterFields() {
        int counter = 1;
        for (Field field : this.reportFilter.getClass().getDeclaredFields()) {
            ReportFilterParameterName reportFilterParameterName = field.getAnnotation(ReportFilterParameterName.class);
            if (reportFilterParameterName == null) continue;
            ParameterField parameterField = new ParameterField(field);
            this.parameterFields.add(parameterField);
            this.add((Component)new JLabel("\u0418\u043c\u044f \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 \u2116" + counter + ": "), CONSTRAINTS);
            this.add((Component)parameterField, CONSTRAINTS);
            ++counter;
        }
    }

    private void addModuleIdField() {
        this.add((Component)new JLabel("ID \u043c\u043e\u0434\u0443\u043b\u044f(\u043f\u043b\u0430\u0433\u0438\u043d\u0430): "), CONSTRAINTS);
        this.add((Component)this.moduleIdField, CONSTRAINTS);
    }

    private void addFillableParametersPanel() {
        Field sqlField = this.findFieldByName("sql");
        if (sqlField != null) {
            this.sqlRequestField = new ParameterField(sqlField);
            this.add((Component)new JLabel("SQL \u0437\u0430\u043f\u0440\u043e\u0441 \u0434\u043b\u044f \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0441\u043f\u0438\u0441\u043a\u0430 (\u043d\u0435\u043e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u043e): "), CONSTRAINTS);
            this.add((Component)this.sqlRequestField, CONSTRAINTS);
        }
        this.reportFieldsTabelPanel = new ReportFieldsTabelPanel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b");
        this.add((Component)new JLabel("\u0417\u0430\u043f\u043e\u043b\u043d\u0438\u0442\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0434\u043b\u044f \u0444\u0438\u043b\u044c\u0442\u0440\u0430"), CONSTRAINTS);
        FilterPanel.CONSTRAINTS.weighty = 1.0;
        FilterPanel.CONSTRAINTS.fill = 1;
        this.add((Component)this.reportFieldsTabelPanel, CONSTRAINTS);
        FilterPanel.CONSTRAINTS.weighty = 0.0;
        FilterPanel.CONSTRAINTS.fill = 2;
    }

    private Field findFieldByName(String ... fieldNames) {
        List<String> names = Arrays.asList(fieldNames);
        for (Field field : this.reportFilter.getClass().getDeclaredFields()) {
            if (!names.contains(field.getName())) continue;
            return field;
        }
        return null;
    }

    public ReportFilter getReportFilter() {
        return this.reportFilter;
    }

    public List<ParameterField> getParameterFields() {
        return this.parameterFields;
    }

    public ParameterField getModuleIdField() {
        return this.moduleIdField;
    }

    public ParameterField getSqlRequestField() {
        return this.sqlRequestField;
    }

    public Map<String, String> getFillableParameters() {
        return this.reportFieldsTabelPanel.getFields();
    }

    public void addFillableParameter(String key, String value) {
        this.reportFieldsTabelPanel.addField(key, value);
    }

    public JTextField getTitleField() {
        return this.titleField;
    }
}

