/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.shop.client.directory.warehouse;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.BGToolTip;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.plugins.shop.client.WarehouseUtils;
import ru.bitel.bgbilling.plugins.shop.client.directory.AddStockItemDialog;
import ru.bitel.bgbilling.plugins.shop.client.directory.ShowStockItemPanel;
import ru.bitel.bgbilling.plugins.shop.client.directory.TransferStockItemToContractDialog;
import ru.bitel.bgbilling.plugins.shop.client.directory.warehouse.WarehouseEditorSearchPanel;
import ru.bitel.bgbilling.plugins.shop.client.directory.warehouse.WarehouseListPanel;
import ru.bitel.bgbilling.plugins.shop.client.directory.warehouse.WarehousePanel;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItem;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemAttributeValue;
import ru.bitel.bgbilling.plugins.shop.common.bean.StockItemType;
import ru.bitel.bgbilling.plugins.shop.common.bean.Warehouse;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.BGButtonPanelOkCancel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.action.BGUAction;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.SearchResult;

public class WarehouseEditorPanel
extends JPanel {
    private final WarehousePanel parentPanel;
    private final JPanel editorPanel = new JPanel(new GridBagLayout());
    private final JTextField warehouseTitle = new JTextField();
    private final JTextArea warehouseComment = new JTextArea();
    private BGDialogToolBar stockItemTypeToolbar;
    private BGDialogToolBar stockItemToolbar;
    private JTree warehouseStock;
    private WarehouseEditorSearchPanel searchPanel;
    private final JLabel recordCountLabel = new JLabel();
    private final BGControlPanelPages page = new BGControlPanelPages();
    private final BGUTable stockItemsTable;
    protected final StockItemTableModel stockItemTableModel;
    protected Warehouse currentEntry;

    public WarehouseEditorPanel(final WarehousePanel parentPanel) {
        this.parentPanel = parentPanel;
        this.setLayout(new GridBagLayout());
        this.page.setKey(this.getClass().getName());
        this.initWarehouseStockTree();
        this.stockItemTableModel = new StockItemTableModel();
        this.stockItemsTable = new BGUTable((TableModel)((Object)this.stockItemTableModel));
        this.stockItemsTable.setDefaultRenderer(Object.class, (TableCellRenderer)new StockItemTableRenderer());
        this.stockItemsTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
                    StockItem selectedStockItem = (StockItem)WarehouseEditorPanel.this.stockItemTableModel.getSelectedRow();
                    if (selectedStockItem != null) {
                        new ShowStockItemPanel(selectedStockItem, (ClientContext)parentPanel.getContext()).open();
                    }
                } else if (e.getClickCount() == 1 && SwingUtilities.isRightMouseButton(e)) {
                    new StockItemTablePopupMenu(e);
                }
            }
        });
        this.initToolbars();
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        okCancel.getButton(BGButtonPanel.CANCEL).addActionListener(e -> {
            this.clearEditor();
            this.editorPanel.setVisible(false);
        });
        okCancel.getButtonOk().addActionListener(e -> {
            Warehouse warehouse = this.getEditorData();
            if (Utils.isBlankString((String)warehouse.getTitle())) {
                BGToolTip.showErrorMessage((JComponent)this.warehouseTitle, (String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u0441\u043a\u043b\u0430\u0434\u0430!");
                return;
            }
            try {
                parentPanel.getWarehouseService().updateWarehouse(warehouse);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            parentPanel.performAction("refresh");
            this.clearEditor();
            this.editorPanel.setVisible(false);
        });
        this.searchPanel = new WarehouseEditorSearchPanel(this);
        JScrollPane commentScrollPane = new JScrollPane(this.warehouseComment);
        commentScrollPane.setPreferredSize(new Dimension(-1, 50));
        BGSwingUtilites.wrapBorder((JPanel)this.editorPanel, (String)"\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u043a\u043b\u0430\u0434\u043e\u043c");
        this.editorPanel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.editorPanel.add((Component)this.warehouseTitle, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.editorPanel.add((Component)this.stockItemTypeToolbar, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.editorPanel.add((Component)new JScrollPane(this.warehouseStock), new GridBagConstraints(0, 3, 3, 1, 0.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        JPanel stockItemsTablePanel = new JPanel(new GridBagLayout());
        stockItemsTablePanel.add((Component)new JScrollPane((Component)this.stockItemsTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.editorPanel.add((Component)this.searchPanel, new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 0, 3), 0, 0));
        this.editorPanel.add((Component)this.stockItemToolbar, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.editorPanel.add((Component)this.getFilterPanel(), new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.editorPanel.add((Component)stockItemsTablePanel, new GridBagConstraints(0, 6, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.editorPanel.add((Component)okCancel, new GridBagConstraints(0, 7, 3, 1, 0.0, 0.0, 13, 0, new Insets(3, 0, 0, 0), 0, 0));
        this.add((Component)this.editorPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private JPanel getFilterPanel() {
        this.page.init();
        this.page.addToHandler(a -> {
            try {
                StockItemType selectedType = this.getSelectedTypeOnTree();
                if (selectedType != null) {
                    SearchResult searchResult = this.parentPanel.getWarehouseService().getWarehouseItemsByType(this.currentEntry.getId(), selectedType.getId(), this.page.getPage());
                    this.stockItemTableModel.setData(searchResult.getList());
                    this.page.setPage(searchResult.getPage());
                    this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + searchResult.getList().size());
                }
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        });
        GridBagConstraints constraints = new GridBagConstraints(-1, 0, 1, 0, 0.0, 1.0, 13, 0, new Insets(0, 3, 0, 0), 0, 0);
        JPanel filterPanel = new JPanel(new GridBagLayout());
        filterPanel.add((Component)this.recordCountLabel, constraints);
        filterPanel.add((Component)this.page, constraints);
        return filterPanel;
    }

    private void initWarehouseStockTree() {
        this.warehouseStock = new JTree();
        this.warehouseStock.setCellRenderer(new WarehouseStockTreeRenderer());
        this.warehouseStock.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    WarehouseEditorPanel.this.stockItemsTableSetData();
                }
            }
        });
    }

    private void stockItemsTableSetData() {
        StockItemType selectedType = this.getSelectedTypeOnTree();
        if (selectedType != null) {
            try {
                this.page.getPage().setPageIndex(0);
                SearchResult searchResult = this.parentPanel.getWarehouseService().getWarehouseItemsByType(this.currentEntry.getId(), selectedType.getId(), this.page.getPage());
                this.stockItemTableModel.setData(searchResult.getList());
                if (searchResult.getPage() != null) {
                    this.page.setPage(searchResult.getPage());
                }
                this.recordCountLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + searchResult.getList().size());
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    }

    private StockItemType getSelectedTypeOnTree() {
        Object selected;
        Object object = selected = this.warehouseStock.getSelectionPath() != null ? this.warehouseStock.getSelectionPath().getLastPathComponent() : null;
        if (selected instanceof CustomTreeNode) {
            CustomTreeNode selectedTreeNode = (CustomTreeNode)selected;
            return selectedTreeNode.stockItemType;
        }
        return null;
    }

    private void initToolbars() {
        this.stockItemTypeToolbar = new BGDialogToolBar();
        this.stockItemTypeToolbar.setDefaultButtons(e -> {
            if ("newItem".equals(e.getActionCommand())) {
                this.addStockItem();
            }
        });
        this.stockItemTypeToolbar.setFloatable(false);
        this.stockItemTypeToolbar.setOrientation(0);
        this.stockItemTypeToolbar.setToolBar(new String[]{"newItem"});
        this.stockItemToolbar = new BGDialogToolBar();
        this.stockItemToolbar.setDefaultButtons(e -> {
            if ("deleteItem".equals(e.getActionCommand())) {
                this.removeStockItem();
            }
        });
        this.stockItemToolbar.setFloatable(false);
        this.stockItemToolbar.setOrientation(0);
        this.stockItemToolbar.setToolBar(new String[]{"deleteItem"});
    }

    void openEditor(Warehouse warehouse) {
        block8: {
            this.currentEntry = warehouse;
            if (this.currentEntry != null) {
                TreePath selectedPath = this.warehouseStock.getSelectionPath();
                this.warehouseTitle.setText(warehouse.getTitle());
                this.warehouseComment.setText(warehouse.getComment());
                try {
                    List stockItemTypes = this.parentPanel.getWarehouseService().getStockItemTypesByWarehouse(warehouse.getId());
                    if (!Utils.notEmptyCollection((Collection)stockItemTypes)) break block8;
                    this.searchPanel.init(stockItemTypes, (ClientContext)this.parentPanel.getContext());
                    CustomTreeNode changedNode = this.findNode(selectedPath);
                    DefaultMutableTreeNode changeNodeAfterUpdate = null;
                    DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("\u0412\u0441\u0435");
                    for (StockItemType type : stockItemTypes) {
                        CustomTreeNode newNode = new CustomTreeNode(type);
                        if (changedNode != null && changedNode.stockItemType.getId() == type.getId()) {
                            changeNodeAfterUpdate = newNode;
                        }
                        rootNode.add(newNode);
                    }
                    this.warehouseStock.setModel(new DefaultTreeModel(rootNode));
                    if (changeNodeAfterUpdate != null) {
                        this.warehouseStock.setSelectionPath(new TreePath(changeNodeAfterUpdate.getPath()));
                    }
                    if (changedNode != null) {
                        this.stockItemTableModel.setData(this.parentPanel.getWarehouseService().getWarehouseItemsByType(this.currentEntry.getId(), changedNode.stockItemType.getId(), this.page.getPage()).getList());
                    }
                }
                catch (Exception e) {
                    ClientUtils.showErrorMessageDialog((Throwable)e);
                }
            } else {
                this.clearEditor();
                this.warehouseStock.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("\u0412\u0441\u0435")));
                this.stockItemTableModel.setData(Collections.emptyList());
            }
        }
        this.editorPanel.revalidate();
        this.editorPanel.repaint();
        this.editorPanel.setVisible(true);
    }

    private CustomTreeNode findNode(TreePath path) {
        if (path == null || path.getLastPathComponent() == null) {
            return null;
        }
        CustomTreeNode oldNode = (CustomTreeNode)path.getLastPathComponent();
        DefaultMutableTreeNode node = this.findNodeByName((DefaultMutableTreeNode)this.warehouseStock.getModel().getRoot(), oldNode.stockItemType.getTitle());
        return node != null ? (CustomTreeNode)node : null;
    }

    private DefaultMutableTreeNode findNodeByName(DefaultMutableTreeNode currentNode, String name) {
        if (currentNode.getUserObject().toString().equals(name)) {
            return currentNode;
        }
        for (int i = 0; i < currentNode.getChildCount(); ++i) {
            DefaultMutableTreeNode foundNode = this.findNodeByName((DefaultMutableTreeNode)currentNode.getChildAt(i), name);
            if (foundNode == null) continue;
            return foundNode;
        }
        return null;
    }

    Warehouse getEditorData() {
        if (this.currentEntry == null) {
            this.currentEntry = new Warehouse();
        }
        this.currentEntry.setTitle(this.warehouseTitle.getText());
        this.currentEntry.setComment(this.warehouseComment.getText());
        return this.currentEntry;
    }

    void clearEditor() {
        this.warehouseTitle.setText("");
        this.warehouseComment.setText("");
    }

    void addStockItem() {
        Object selected = this.warehouseStock.getSelectionPath() != null ? this.warehouseStock.getSelectionPath().getLastPathComponent() : null;
        StockItemType selectedStockItemType = null;
        if (selected instanceof CustomTreeNode) {
            CustomTreeNode selectedTreeNode = (CustomTreeNode)selected;
            selectedStockItemType = selectedTreeNode.stockItemType;
        }
        new AddStockItemDialog(this.currentEntry, selectedStockItemType, (ClientContext)this.parentPanel.getContext()).open();
        this.reopenEditor();
    }

    void removeStockItem() {
        StockItem selectedItem = (StockItem)this.stockItemTableModel.getSelectedRow();
        if (selectedItem != null && ClientUtils.confirm((String)"\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0438\u0437 \u0441\u043a\u043b\u0430\u0434\u0430 \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442?", (String)"\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435")) {
            try {
                this.parentPanel.getWarehouseService().deleteStockItem(selectedItem.getId());
            }
            catch (Exception e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
            this.reopenEditor();
        }
    }

    void reopenEditor() {
        WarehouseListPanel warehouseListPanel = this.parentPanel.getWarehouseListPanel();
        warehouseListPanel.reloadList();
        for (int i = 0; i < warehouseListPanel.warehouseList.getModel().getSize(); ++i) {
            if (((Warehouse)warehouseListPanel.warehouseList.getModel().getElementAt(i)).getId() != this.currentEntry.getId()) continue;
            warehouseListPanel.warehouseList.setSelectedIndex(i);
            this.openEditor((Warehouse)warehouseListPanel.warehouseList.getModel().getElementAt(i));
        }
    }

    public JPanel getEditorPanel() {
        return this.editorPanel;
    }

    public final class StockItemTableModel
    extends BGTableModel<StockItem> {
        public StockItemTableModel() {
            super("StockItemTableModel");
        }

        protected void initColumns() {
            this.addColumn("\u0410\u0442\u0442\u0440\u0438\u0431\u0443\u0442 #1", String.class, false);
            this.addColumn("\u0410\u0442\u0442\u0440\u0438\u0431\u0443\u0442 #2", String.class, false);
            this.addColumn("\u0410\u0442\u0442\u0440\u0438\u0431\u0443\u0442 #3", String.class, false);
            this.addColumn("\u0410\u0442\u0442\u0440\u0438\u0431\u0443\u0442 #4", String.class, false);
            this.addColumn("ID \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", String.class, false);
        }

        public Object getValueAt(StockItem val, int column) throws Exception {
            if (column == 4) {
                return val.getContractId();
            }
            if (Utils.isEmptyCollection((Collection)val.getAttributeValues()) || column > 3 || column > val.getAttributeValues().size() - 1) {
                return "";
            }
            return WarehouseUtils.getStockItemAttributeValue((ClientContext)WarehouseEditorPanel.this.parentPanel.getContext(), (StockItemAttributeValue)val.getAttributeValues().get(column));
        }
    }

    private final class StockItemTableRenderer
    extends DefaultTableCellRenderer {
        private StockItemTableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            StockItem stockItem = (StockItem)((StockItemTableModel)((Object)table.getModel())).getRows().get(table.convertRowIndexToModel(row));
            this.setBackground(stockItem.getContractId() > 0 ? Color.LIGHT_GRAY : Color.white);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setForeground(Color.BLACK);
            }
            return this;
        }
    }

    private static final class WarehouseStockTreeRenderer
    extends DefaultTreeCellRenderer {
        private final Icon rootIcon = ClientUtils.getIcon((String)"fugue/tree");
        private final Icon folderIcon = ClientUtils.getIcon((String)"fugue/category");

        private WarehouseStockTreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object userObj;
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (value instanceof CustomTreeNode) {
                this.setIcon(this.folderIcon);
            } else if (value instanceof DefaultMutableTreeNode && (userObj = ((DefaultMutableTreeNode)value).getUserObject()) != null && "\u0412\u0441\u0435".equals(userObj.toString())) {
                this.setIcon(this.rootIcon);
            }
            return this;
        }
    }

    private static final class CustomTreeNode
    extends DefaultMutableTreeNode {
        private final StockItemType stockItemType;

        public CustomTreeNode(StockItemType stockItemType) {
            super(stockItemType);
            this.stockItemType = stockItemType;
        }
    }

    private final class StockItemTablePopupMenu
    extends JPopupMenu {
        public StockItemTablePopupMenu(MouseEvent event) {
            BGUAction addToContract = new BGUAction("addToContract", "\u0414\u043e\u0431\u0430\u0432\u0438\u0442\u044c \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440", ClientUtils.getIcon((String)"arrow_right")){

                public void actionPerformed(ActionEvent e) {
                    new TransferStockItemToContractDialog(WarehouseEditorPanel.this.parentPanel.getWarehouseOperationService(), (StockItem)WarehouseEditorPanel.this.stockItemTableModel.getSelectedRow()).showDialog();
                    WarehouseEditorPanel.this.stockItemsTableSetData();
                }
            };
            BGUAction removeFromContract = new BGUAction("removeFromContract", "\u0423\u0431\u0440\u0430\u0442\u044c \u0441 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430", ClientUtils.getIcon((String)"arrow_left")){

                public void actionPerformed(ActionEvent e) {
                    if (WarehouseEditorPanel.this.stockItemTableModel.getSelectedRow() != null && ClientUtils.confirm((String)"\u0423\u0431\u0440\u0430\u0442\u044c \u0442\u043e\u0432\u0430\u0440 \u0441 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0438 \u0432\u0435\u0440\u043d\u0443\u0442\u044c \u043d\u0430 \u0441\u043a\u043b\u0430\u0434?", (String)"")) {
                        try {
                            WarehouseEditorPanel.this.parentPanel.getWarehouseOperationService().returnStockItemToWarehouse(((StockItem)WarehouseEditorPanel.this.stockItemTableModel.getSelectedRow()).getId());
                        }
                        catch (Exception ex) {
                            ClientUtils.showErrorMessageDialog((Throwable)ex);
                        }
                        WarehouseEditorPanel.this.stockItemsTableSetData();
                    }
                }
            };
            StockItem selectedStockItem = (StockItem)WarehouseEditorPanel.this.stockItemTableModel.getSelectedRow();
            if (selectedStockItem.getContractId() > 0) {
                this.add((Action)removeFromContract);
            } else {
                this.add((Action)addToContract);
            }
            this.show((Component)WarehouseEditorPanel.this.stockItemsTable, event.getX(), event.getY());
        }
    }
}

