/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.api.dvor24;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.dvor24.Dvor24UserClient;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.dvor24.Dvor24UserSupport;
import ru.bitel.bgbilling.modules.smarthouse.server.api.SmarthouseManager;
import ru.bitel.bgbilling.modules.smarthouse.server.api.dvor24.ResponseCamera;
import ru.bitel.bgbilling.modules.smarthouse.server.api.dvor24.ResponseCameras;
import ru.bitel.bgbilling.modules.smarthouse.server.api.dvor24.ResponseGroupAdd;
import ru.bitel.bgbilling.modules.smarthouse.server.api.dvor24.ResponseGroups;
import ru.bitel.bgbilling.modules.smarthouse.server.api.dvor24.ResponseLogin;
import ru.bitel.bgbilling.modules.smarthouse.server.api.dvor24.ResponseObjects;
import ru.bitel.bgbilling.modules.smarthouse.server.api.dvor24.ResponseUserAdd;
import ru.bitel.bgbilling.modules.smarthouse.server.api.dvor24.ResponseUsers;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;

public class Dvor24Manager
extends SmarthouseManager {
    private static final String PARAM_API_KEY = "x-vsaas-api-key";
    private static final String PARAM_SESSION = "x-vsaas-session";
    private static final String PARAM_SERVICE_API_KEY = "x-vsaas-service-api-key";
    private static String apiKey = null;
    private static String authToken = null;
    private String serverUrl = null;
    private String apiLogin = null;
    private String apiPassword = null;
    private String serviceApiKey = null;
    private int connectTimeout;
    private int readTimeout;
    private Map<String, String> requestProperties = null;

    public Dvor24Manager(int moduleId) {
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
        this.serverUrl = moduleSetup.get("dvor24.server.url");
        this.apiLogin = moduleSetup.get("dvor24.api.login");
        this.apiPassword = moduleSetup.get("dvor24.api.password");
        this.serviceApiKey = moduleSetup.get("dvor24.service.api.key");
        this.readTimeout = moduleSetup.getInt("dvor24.request.timeout.read", 10000);
        this.connectTimeout = moduleSetup.getInt("dvor24.request.timeout.connect", 10000);
        if (this.serviceApiKey == null) {
            try {
                if (this.apiLogin == null && this.apiPassword == null) {
                    throw new BGMessageException("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \"dvor24.service.api.key=\" \u0438\u043b\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \"dvor24.api.login=\" \u0438 \"dvor24.api.password=\"");
                }
                ResponseLogin responseLogin = this.authLogin(Arrays.asList(new KeyValue("login", this.apiLogin), new KeyValue("password", this.apiPassword)));
                apiKey = responseLogin.getResult().getApiKey();
                authToken = responseLogin.getResult().getAuthToken();
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        }
    }

    public ResponseLogin authLogin(List<KeyValue> params) throws Exception {
        return this.doRequest(HTTP.POST, "/api/v2/auth/login", params, ResponseLogin.class);
    }

    public ResponseCameras cameras(List<KeyValue> params) throws Exception {
        return this.doRequest(HTTP.GET, "/api/v2/cameras", params, ResponseCameras.class);
    }

    public ResponseCamera cameraByName(String name) throws Exception {
        Objects.requireNonNull(name);
        return this.doRequest(HTTP.GET, "/api/v2/cameras/" + name, new ArrayList<KeyValue>(), ResponseCamera.class);
    }

    public ResponseCamera cameraByNumber(String number) throws Exception {
        Objects.requireNonNull(number);
        return this.doRequest(HTTP.GET, "/api/v2/cameras/info/" + number, new ArrayList<KeyValue>(), ResponseCamera.class);
    }

    public ResponseUsers users(List<KeyValue> params) throws Exception {
        return this.doRequest(HTTP.GET, "/api/v2/users", params, ResponseUsers.class);
    }

    public ResponseUserAdd userAdd(Dvor24UserClient userClient) throws Exception {
        return this.doRequest(HTTP.POST, "/api/v2/users/add", userClient.toParams(), ResponseUserAdd.class);
    }

    public ResponseUserAdd userAdd(Dvor24UserSupport userSupport) throws Exception {
        return this.doRequest(HTTP.POST, "/api/v2/users/add", userSupport.toParams(), ResponseUserAdd.class);
    }

    public ResponseGroups groups(List<KeyValue> params) throws Exception {
        return this.doRequest(HTTP.GET, "/api/v2/groups", params, ResponseGroups.class);
    }

    public ResponseGroupAdd groupEntranceAdd(int objectId, int entrance, String name, String description) throws Exception {
        List<KeyValue> params = Arrays.asList(new KeyValue("groupType", "entrance"), new KeyValue("entrance", String.valueOf(entrance)), new KeyValue("name", name), new KeyValue("description", description));
        return this.doRequest(HTTP.POST, "/api/v2/objects/" + objectId + "/manage/groups/add", params, ResponseGroupAdd.class);
    }

    public ResponseGroupAdd groupAnyAdd(int objectId, String name, String description) throws Exception {
        List<KeyValue> params = Arrays.asList(new KeyValue("groupType", "any"), new KeyValue("name", name), new KeyValue("description", description));
        return this.doRequest(HTTP.POST, "/api/v2/objects/" + objectId + "/manage/groups/add", params, ResponseGroupAdd.class);
    }

    public ResponseObjects objects(List<KeyValue> params) throws Exception {
        return this.doRequest(HTTP.GET, "/api/v2/objects", params, ResponseObjects.class);
    }

    protected <T> T doRequest(HTTP httpMethod, String uri, List<KeyValue> params, Class<T> clazz) throws Exception {
        if (this.serverUrl == null) {
            throw new BGMessageException("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 \"dvor24.server.url=\"");
        }
        String query = null;
        if (httpMethod == HTTP.GET) {
            query = params.stream().map(a -> a.getKey() + "=" + this.encodeString(a.getValue())).collect(Collectors.joining("&"));
        }
        String spec = this.serverUrl + uri + (String)(query == null ? "" : "?" + query);
        StringBuilder debug = new StringBuilder();
        if (this.getLogger().isDebugEnabled()) {
            debug.append("\n\tDvor24: URL \u0437\u0430\u043f\u0440\u043e\u0441\u0430: " + spec + "\n");
        }
        HttpURLConnection connection = (HttpURLConnection)URI.create(spec).toURL().openConnection();
        connection.setConnectTimeout(this.connectTimeout);
        connection.setReadTimeout(this.readTimeout);
        connection.setRequestMethod(httpMethod.name());
        if (this.requestProperties != null && !this.requestProperties.isEmpty()) {
            for (Map.Entry<String, String> entry : this.requestProperties.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        Optional.ofNullable(this.serviceApiKey).ifPresent(a -> connection.setRequestProperty(PARAM_SERVICE_API_KEY, (String)a));
        Optional.ofNullable(apiKey).ifPresent(a -> connection.setRequestProperty(PARAM_API_KEY, (String)a));
        Optional.ofNullable(authToken).ifPresent(a -> connection.setRequestProperty(PARAM_SESSION, (String)a));
        connection.setDoOutput(httpMethod == HTTP.POST);
        connection.setDoInput(true);
        if (httpMethod == HTTP.POST) {
            try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(connection.getOutputStream()));){
                bw.write(params.stream().map(a -> a.getKey() + "=" + this.encodeString(a.getValue())).collect(Collectors.joining("&")).toCharArray());
            }
        }
        if (this.getLogger().isDebugEnabled()) {
            String text = params.stream().map(a -> a.getKey() + "=" + (a.getKey().toLowerCase().contains("password") ? "*".repeat(a.getValue().length()) : this.encodeString(a.getValue()))).collect(Collectors.joining("&"));
            debug.append("\tDvor24: \u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0437\u0430\u043f\u0440\u043e\u0441\u0430: " + text + "\n");
        }
        connection.connect();
        StringBuilder result = new StringBuilder();
        int responseCode = connection.getResponseCode();
        try {
            InputStream inputStream = null;
            if (responseCode == 200) {
                inputStream = connection.getInputStream();
            } else if (responseCode == 401) {
                inputStream = connection.getErrorStream();
            } else if (responseCode == 403) {
                inputStream = connection.getErrorStream();
            }
            if (inputStream != null) {
                result.append(new String(Utils.readByBlock((InputStream)inputStream), "UTF-8"));
            } else {
                this.getLogger().error("connection.getResponseCode()={}", (Object)connection.getResponseCode());
                this.getLogger().error("inputStream={}", (Object)inputStream);
            }
        }
        catch (Exception ex) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug(debug.toString());
            }
            this.logError(ex);
        }
        connection.disconnect();
        if (this.getLogger().isDebugEnabled()) {
            debug.append("\tDvor24: \u041e\u0442\u0432\u0435\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430: " + String.valueOf(result));
            this.getLogger().debug(debug.toString());
        }
        ObjectMapper mapper = ((JsonMapper.Builder)JsonMapper.builder().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false)).build();
        mapper.registerModule((Module)new JavaTimeModule());
        String resulrStr = result.toString();
        if (resulrStr.startsWith("{")) {
            boolean success = false;
            JSONObject jsonObject = new JSONObject(resulrStr);
            success = jsonObject.optBoolean("success");
            if (!success) {
                this.getLogger().error("\u041e\u0442\u0432\u0435\u0442 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 Dvor24: " + resulrStr);
            }
            return (T)mapper.readValue(resulrStr, clazz);
        }
        return null;
    }

    static enum HTTP {
        GET,
        POST;

    }
}

