/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.smarthouse.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.smarthouse.common.bean.SmartHousePackageContract;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Idable;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.PeriodWithTime;
import ru.bitel.common.model.SearchResult;

public class SmartHousePackageContractDao
extends AbstractIdDao<SmartHousePackageContract> {
    public SmartHousePackageContractDao(Connection con, int moduleId) {
        super(con, "smarthouse_package_contract", moduleId);
        this.fields = new HashMap();
        this.fields.put("dateFrom", "date_from");
    }

    public void searchContractPackages(SearchResult<SmartHousePackageContract> searchResult, int contractId) throws SQLException {
        List list = searchResult.getList();
        Page page = searchResult.getPage();
        String query = "SELECT SQL_CALC_FOUND_ROWS * FROM " + this.tableName + " WHERE contract_id=? " + this.getSQLOrder(searchResult.getSort(), this.fields) + Page.toSqlLimit((Page)page);
        try (PreparedStatement psSelect = this.con.prepareStatement(query);){
            int index = 1;
            psSelect.setInt(index++, contractId);
            try (ResultSet resultSet = psSelect.executeQuery();){
                while (resultSet.next()) {
                    list.add(this.getFromRS(resultSet));
                }
            }
            Page.setRecordCount((Page)page, (int)ServerUtils.foundRows((Connection)this.con));
        }
    }

    protected SmartHousePackageContract getFromRS(ResultSet rs) throws SQLException {
        String data = rs.getString("data");
        return new SmartHousePackageContract().setId(rs.getInt("id")).setContractId(rs.getInt("contract_id")).setObjectId(rs.getInt("object_id")).setPackageId(rs.getInt("package_id")).setPeriod(new Period((Date)rs.getDate("date_from"), (Date)rs.getDate("date_to"))).setCalcPeriod(new PeriodWithTime((Date)rs.getTimestamp("calc_date_from"), (Date)rs.getTimestamp("calc_date_to"))).setPackageCost(rs.getBigDecimal("package_cost")).setPackageCostDate(TimeUtils.convertDateToLocalDate((Date)rs.getDate("package_cost_date"))).setReserveId(rs.getInt("reserve_id")).setData(data.isEmpty() ? "{}" : data);
    }

    public void update(SmartHousePackageContract contractPackage) throws SQLException {
        super.update((Object)contractPackage);
    }

    public int[] getNavigationIds(int contractId, int packageContractId) throws SQLException {
        int[] result;
        block17: {
            ArrayList<LocalDateTime[]> dates;
            ArrayList<Integer> ids;
            block19: {
                block18: {
                    ids = new ArrayList<Integer>();
                    dates = new ArrayList<LocalDateTime[]>();
                    String query = "SELECT `id`, `date_from`, `date_to` FROM " + this.tableName + " WHERE `contract_id`=? ORDER BY `date_from`";
                    try (PreparedStatement psSelect = this.con.prepareStatement(query);){
                        psSelect.setInt(1, contractId);
                        try (ResultSet rs = psSelect.executeQuery();){
                            while (rs.next()) {
                                ids.add(rs.getInt(1));
                                dates.add(new LocalDateTime[]{TimeUtils.convertTimestampToLocalDateTime((Timestamp)rs.getTimestamp(2)), TimeUtils.convertTimestampToLocalDateTime((Timestamp)rs.getTimestamp(3))});
                            }
                        }
                    }
                    result = new int[3];
                    if (packageContractId <= 0) break block18;
                    result[1] = packageContractId;
                    int len = ids.size();
                    for (int index = 0; index < len; ++index) {
                        if ((Integer)ids.get(index) != packageContractId) continue;
                        this.setIDResult(index, len, result, ids);
                        break block17;
                    }
                    break block17;
                }
                if (ids.size() != 1) break block19;
                result[1] = (Integer)ids.get(0);
                break block17;
            }
            if (ids.size() <= 1) break block17;
            int len = dates.size();
            LocalDateTime now = LocalDateTime.now();
            for (int index = 0; index < len; ++index) {
                this.setIDResult(index, len, result, ids);
                LocalDateTime[] dateTimes = (LocalDateTime[])dates.get(index);
                if (dateTimes[1] != null && dateTimes[1].compareTo(now) < 0) {
                    continue;
                }
                break;
            }
        }
        return result;
    }

    private void setIDResult(int index, int len, int[] result, List<Integer> ids) {
        result[1] = ids.get(index);
        if (index > 0) {
            result[0] = ids.get(index - 1);
            result[2] = 0;
        }
        if (index < len - 1) {
            result[2] = ids.get(index + 1);
        }
    }

    protected void updateImpl(SmartHousePackageContract contractPackage) throws SQLException {
        String querySet = "package_id=?, data=?, contract_id=?, date_from=?, date_to=?";
        try (PreparedStatement ps = this.prepareStatement((Idable)contractPackage, querySet);){
            Period period = contractPackage.getPeriod();
            int index = 1;
            ps.setInt(index++, contractPackage.getPackageId());
            ps.setString(index++, contractPackage.getData());
            ps.setInt(index++, contractPackage.getContractId());
            ps.setDate(index++, period == null ? null : TimeUtils.convertDateToSqlDate((Date)period.getDateFrom()));
            ps.setDate(index++, period == null ? null : TimeUtils.convertDateToSqlDate((Date)period.getDateTo()));
            this.executeUpdate((Id)contractPackage, index, ps);
        }
    }
}

