/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.client.contract;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import ru.bitel.bgbilling.client.common.BGCalendarButton;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.oss.systems.inventory.product.common.bean.Product;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductOffering;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductOfferingActivationMode;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpecActivationMode;

public abstract class ProductFormBase
extends BGUPanel {
    protected BGUComboBox<ProductOffering> productSpec = new BGUComboBox();
    protected BGUComboBox<ProductOfferingActivationMode> activationMode = new BGUComboBox();
    protected BGCalendarButton dateFrom = new BGCalendarButton();
    protected BGTextField timeFrom = new BGTextField(8);
    protected BGCalendarButton dateTo = new BGCalendarButton();
    protected BGTextField timeTo = new BGTextField(8);
    protected JTextArea comment = new JTextArea();
    protected BGTextField description = new BGTextField();
    protected String mode = null;
    protected Product current;

    public ProductFormBase(ClientContext context) {
        super(context);
    }

    protected void jbInit() {
        this.setLayout(new GridBagLayout());
        this.setBorder((Border)new BGTitleBorder("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440"));
        this.add(BGSwingUtilites.wrapBorder(this.productSpec, (String)"\u041f\u0440\u043e\u0434\u0443\u043a\u0442"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(BGSwingUtilites.wrapBorder(this.activationMode, (String)"\u0420\u0435\u0436\u0438\u043c \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel panel = new JPanel(new GridBagLayout());
        this.timeFrom.setHorizontalAlignment(0);
        this.timeTo.setHorizontalAlignment(0);
        panel.add((Component)new JLabel("\u0441"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 3, 5, 5), 0, 0));
        panel.add((Component)this.dateFrom, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 3), 0, 0));
        panel.add((Component)this.timeFrom, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u043f\u043e"), new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        panel.add((Component)this.dateTo, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 3), 0, 0));
        panel.add((Component)this.timeTo, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 3), 0, 0));
        this.add(panel, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(BGSwingUtilites.wrapBorder((JComponent)this.description, (String)"\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, 3, 1, 1, 0.0, 1.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(BGSwingUtilites.wrapBorder((JComponent)new JScrollPane(this.comment), (String)"\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439"), new GridBagConstraints(2, 0, 1, 4, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        panel.setBorder((Border)new BGTitleBorder("\u041f\u0435\u0440\u0438\u043e\u0434"));
        this.productSpec.addActionListener(e -> {
            ProductOffering selected = (ProductOffering)this.productSpec.getSelectedItem();
            if (selected != null) {
                ProductOfferingActivationMode currentMode;
                List list = selected.getActivationModeList();
                this.activationMode.setData(list);
                if (this.current != null && this.current.getActivationModeId() > 0 && (currentMode = (ProductOfferingActivationMode)Utils.maskNull((List)list).stream().filter(a -> a.getProductSpecActivationMode().getId() == this.current.getActivationModeId()).findFirst().orElse(null)) != null) {
                    this.activationMode.setSelectedItem((Object)currentMode);
                }
            }
        });
    }

    protected List<ProductOfferingActivationMode> toProductOfferingActovationModeList(List<ProductSpecActivationMode> productSpecActivationModeList) {
        ArrayList<ProductOfferingActivationMode> result = new ArrayList<ProductOfferingActivationMode>(productSpecActivationModeList.size());
        for (ProductSpecActivationMode productSpecActivationMode : productSpecActivationModeList) {
            ProductOfferingActivationMode productOfferingActivationMode = new ProductOfferingActivationMode();
            productOfferingActivationMode.setProductSpecActivationMode(productSpecActivationMode);
            result.add(productOfferingActivationMode);
        }
        return result;
    }

    protected List<ProductOffering> toProductOfferingList(List<ProductSpec> productSpecList) {
        ArrayList<ProductOffering> result = new ArrayList<ProductOffering>(productSpecList.size());
        for (ProductSpec productSpec : productSpecList) {
            if (productSpec.getActivationModeList().size() == 0) {
                // empty if block
            }
            result.add(ProductOffering.builder().setProductSpec(productSpec).setActivationModeList(this.toProductOfferingActovationModeList(productSpec.getActivationModeList())).build());
        }
        return result;
    }

    public Calendar getTimeToCalendar() throws BGMessageException {
        Calendar timeToCalendar = this.dateTo.getCalendar();
        if (timeToCalendar != null) {
            TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)timeToCalendar);
            Calendar timeToCalendar2 = TimeUtils.parseCalendar((String)this.timeTo.getText(), (String)"HH:mm:ss");
            if (timeToCalendar2 != null) {
                timeToCalendar.set(11, timeToCalendar2.get(11));
                timeToCalendar.set(12, timeToCalendar2.get(12));
                timeToCalendar.set(13, timeToCalendar2.get(13));
            } else {
                timeToCalendar2 = TimeUtils.parseCalendar((String)this.timeTo.getText(), (String)"HH:mm");
                if (timeToCalendar2 != null) {
                    timeToCalendar.set(11, timeToCalendar2.get(11));
                    timeToCalendar.set(12, timeToCalendar2.get(12));
                    timeToCalendar.set(13, 0);
                } else {
                    if (Utils.notBlankString((String)this.timeTo.getText())) {
                        throw new BGMessageException("\u0412\u0440\u0435\u043c\u044f \u0432 \u043f\u043e\u043b\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \"\u043f\u043e\" \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u043d\u0435\u0432\u0435\u0440\u043d\u043e");
                    }
                    timeToCalendar.set(11, 23);
                    timeToCalendar.set(12, 59);
                    timeToCalendar.set(13, 59);
                }
            }
        }
        return timeToCalendar;
    }

    public Calendar getTimeFromCalendar() throws BGMessageException {
        Calendar timeFromCalendar = this.dateFrom.getCalendar();
        if (timeFromCalendar != null) {
            TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)timeFromCalendar);
            Calendar timeFromCalendar2 = TimeUtils.parseCalendar((String)this.timeFrom.getText(), (String)"HH:mm:ss");
            if (timeFromCalendar2 != null) {
                timeFromCalendar.set(11, timeFromCalendar2.get(11));
                timeFromCalendar.set(12, timeFromCalendar2.get(12));
                timeFromCalendar.set(13, timeFromCalendar2.get(13));
            } else {
                timeFromCalendar2 = TimeUtils.parseCalendar((String)this.timeFrom.getText(), (String)"HH:mm");
                if (timeFromCalendar2 != null) {
                    timeFromCalendar.set(11, timeFromCalendar2.get(11));
                    timeFromCalendar.set(12, timeFromCalendar2.get(12));
                    timeFromCalendar.set(13, 0);
                } else {
                    if (Utils.notBlankString((String)this.timeFrom.getText())) {
                        throw new BGMessageException("\u0412\u0440\u0435\u043c\u044f \u0432 \u043f\u043e\u043b\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u0430 \"\u0441\" \u0443\u043a\u0430\u0437\u0430\u043d\u043e \u043d\u0435\u0432\u0435\u0440\u043d\u043e");
                    }
                    timeFromCalendar.set(13, 0);
                    timeFromCalendar.set(12, 0);
                    timeFromCalendar.set(11, 0);
                }
            }
        }
        return timeFromCalendar;
    }
}

