/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.client.master;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.common.model.IdTitle;

public class TvMasterBasePanel
extends BGUPanel {
    protected final int width = 500;
    protected final int height = 300;
    protected KeyValue masterMode;
    protected Map<String, String> masterData;
    protected JButton prevButton = new JButton("\u043d\u0430\u0437\u0430\u0434");
    protected JButton nextButton = new JButton("\u0434\u0430\u043b\u0435\u0435");

    public TvMasterBasePanel(KeyValue masterMode, Map<String, String> masterData) {
        this.masterMode = masterMode;
        this.masterData = masterData;
    }

    protected void jbInit() throws Exception {
    }

    protected void showPanel(JPanel panel) {
        SwingUtilities.invokeLater(() -> {
            this.removeAll();
            this.add(panel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.revalidate();
            this.repaint();
        });
    }

    protected JPanel getNavigationButtonPanel(ActionListener prevActionListener, ActionListener nextActionListener) {
        Arrays.asList(this.prevButton.getActionListeners()).forEach(l -> this.prevButton.removeActionListener((ActionListener)l));
        Arrays.asList(this.nextButton.getActionListeners()).forEach(l -> this.nextButton.removeActionListener((ActionListener)l));
        this.prevButton.addActionListener(prevActionListener);
        this.nextButton.addActionListener(nextActionListener);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.prevButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 10, 0), 0, 0));
        panel.add(Box.createGlue(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(10, 0, 10, 0), 0, 0));
        panel.add((Component)this.nextButton, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 10, 0), 0, 0));
        return panel;
    }

    protected void selectButton(String key, String defaulValue, AbstractButton ... buttons) {
        String value = this.masterData.getOrDefault(key, defaulValue);
        Arrays.asList(buttons).forEach(b -> b.setSelected(b.getActionCommand().equals(value)));
    }

    protected class ListCellRenderer
    extends DefaultListCellRenderer {
        protected ListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            label.setFont(label.getFont().deriveFont(label.getFont().getSize2D() * 1.25f));
            if (value instanceof IdTitle) {
                label.setText(((IdTitle)value).getGuiTitle());
            }
            return label;
        }
    }

    protected class LabelM
    extends JLabel {
        public LabelM(String title) {
            super(title);
            this.setFont(this.getFont().deriveFont(this.getFont().getSize2D() * 1.4f));
        }
    }
}

