/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.tv.server.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.modules.tv.server.TvUtils;
import ru.bitel.common.RangeUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.util.AbstractPeriodItemSet;
import ru.bitel.oss.systems.inventory.product.common.bean.Product;

public class ProductRuntimeList
extends AbstractPeriodItemSet<ProductItem> {
    private static final Logger logger = LogManager.getLogger();

    ProductRuntimeList(List<ProductItem> entryList) {
        super(ProductItem.class, entryList);
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(160);
            sb.append("Create: \n");
            for (ProductItem item : (ProductItem[])this.entries) {
                item.toString(sb.append("\tProductItem: ")).append("\n");
            }
            sb.setLength(sb.length() - 1);
            logger.debug(sb.toString());
        }
    }

    ProductRuntimeList(ProductItem[] entries) {
        super(ProductItem.class, (AbstractPeriodItemSet.PeriodItem[])entries);
        if (logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder(160);
            sb.append("Create: \n");
            for (ProductItem item : entries) {
                item.toString(sb.append("\tPeriodItem: ")).append("\n");
            }
            sb.setLength(sb.length() - 1);
            logger.debug(sb.toString());
        }
    }

    public List<ProductItem> listEndingAt(long millis) {
        millis = millis / 1000L * 1000L + 999L;
        ArrayList<ProductItem> result = new ArrayList<ProductItem>();
        int size = ((ProductItem[])this.entries).length;
        for (int i = 0; i < size; ++i) {
            ProductItem item = ((ProductItem[])this.entries)[i];
            if (item.timeTo != millis) continue;
            result.add(item);
        }
        return result;
    }

    protected boolean containsMillis(ProductItem item, long millis) {
        return item.timeFrom <= millis && (item.timeTo == 0L || millis <= item.timeTo);
    }

    protected boolean isCoincide(ProductItem item, ProductItem other) {
        return other.productId == item.productId && other.id == item.id;
    }

    public long getTimeFrom(int productId) {
        int size = ((ProductItem[])this.entries).length;
        for (int i = 0; i < size; ++i) {
            ProductItem item = ((ProductItem[])this.entries)[i];
            if (productId != item.productId) continue;
            return item.timeFrom;
        }
        return 0L;
    }

    public Map<Integer, Integer> optionMap(long date1, long date2) {
        if (((ProductItem[])this.entries).length == 0) {
            return Collections.emptyMap();
        }
        HashMap<Integer, Integer> options = new HashMap<Integer, Integer>(4);
        long[] intersection = new long[2];
        int size = ((ProductItem[])this.entries).length;
        for (int i = 0; i < size; ++i) {
            ProductItem item = ((ProductItem[])this.entries)[i];
            long[] period = RangeUtils.intersectionAnd((long[])intersection, (long)item.timeFrom, (long)item.timeTo, (long)date1, (long)date2);
            if (period == null) continue;
            options.put(item.id, item.productId);
        }
        if (options.size() > 0) {
            return options;
        }
        return Collections.emptyMap();
    }

    public ProductRuntimeList add(int productSpecId, int productId, int activationModeId, Date timeFrom, Date timeTo, short state) {
        return new ProductRuntimeList((ProductItem[])super.add((AbstractPeriodItemSet.PeriodItem)new ProductItem(productSpecId, productId, activationModeId, timeFrom, timeTo, state)));
    }

    public ProductRuntimeList update(int productSpecId, int productId, int activationModeId, Date timeFrom, Date timeTo, short state) {
        return new ProductRuntimeList(this.update(new ProductItem(productSpecId, productId, activationModeId, timeFrom, timeTo, state)));
    }

    protected ProductItem[] update(ProductItem newItem) {
        int size = ((ProductItem[])this.entries).length;
        for (int i = 0; i < size; ++i) {
            ProductItem item = ((ProductItem[])this.entries)[i];
            if (!this.isCoincide(item, newItem)) continue;
            newItem.deviceState = item.deviceState;
            ProductItem[] newEntries = new ProductItem[((ProductItem[])this.entries).length];
            System.arraycopy(this.entries, 0, newEntries, 0, ((ProductItem[])this.entries).length);
            newEntries[i] = newItem;
            return newEntries;
        }
        return (ProductItem[])this.add(newItem);
    }

    public ProductRuntimeList remove(int productSpecId, int productId, int activationModeId, Date timeFrom, Date timeTo) {
        return new ProductRuntimeList((ProductItem[])super.remove((AbstractPeriodItemSet.PeriodItem)new ProductItem(productSpecId, productId, activationModeId, timeFrom, timeTo, -1000)));
    }

    public ProductItem itemByProductId(int productId) {
        for (int i = ((ProductItem[])this.entries).length - 1; i >= 0; --i) {
            ProductItem item = ((ProductItem[])this.entries)[i];
            if (item.productId != productId) continue;
            return item;
        }
        return null;
    }

    public static ProductRuntimeList newInstance(List<Product> productList) {
        ArrayList<ProductItem> result = new ArrayList<ProductItem>();
        for (Product product : productList) {
            result.add(new ProductItem(product.getProductSpecId(), product.getId(), product.getActivationModeId(), product.getTimeFrom(), product.getTimeTo(), product.getDeviceState()));
        }
        return new ProductRuntimeList(result);
    }

    public ProductItem[] items() {
        return (ProductItem[])this.entries;
    }

    public void updateState(int productId, short deviceState) {
        for (int i = ((ProductItem[])this.entries).length - 1; i >= 0; --i) {
            ProductItem item = ((ProductItem[])this.entries)[i];
            if (item.productId != productId) continue;
            item.deviceState = deviceState;
        }
    }

    public Map<Integer, ProductItem> mapByProductId(long date1, long date2) {
        if (((ProductItem[])this.entries).length == 0) {
            return Collections.emptyMap();
        }
        HashMap<Integer, ProductItem> options = new HashMap<Integer, ProductItem>(4);
        long[] intersection = new long[2];
        int size = ((ProductItem[])this.entries).length;
        for (int i = 0; i < size; ++i) {
            ProductItem item = ((ProductItem[])this.entries)[i];
            long[] period = RangeUtils.intersectionAnd((long[])intersection, (long)item.timeFrom, (long)item.timeTo, (long)date1, (long)date2);
            if (period == null) continue;
            options.put(item.id, item);
        }
        if (options.size() > 0) {
            return options;
        }
        return Collections.emptyMap();
    }

    public static final class ProductItem
    extends AbstractPeriodItemSet.PeriodItem
    implements Delayed {
        public final int productId;
        public final int activationModeId;
        public volatile short deviceState;
        public volatile int version;

        public ProductItem(int productSpecId, int productId, int activationModeId, Date timeFrom, Date timeTo, short deviceState) {
            this(productSpecId, productId, activationModeId, timeFrom != null ? timeFrom.getTime() : 0L, timeTo != null ? timeTo.getTime() : 0L, deviceState);
        }

        public ProductItem(int productSpecId, int productId, int activationModeId, long timeFrom, long timeTo, short deviceState) {
            super(productSpecId, timeFrom / 1000L * 1000L, timeTo != 0L ? timeTo / 1000L * 1000L + 999L : 0L);
            this.productId = productId;
            this.activationModeId = activationModeId;
            this.deviceState = deviceState;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            assert (this.timeTo != 0L);
            return unit.convert(this.timeTo - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            ProductItem x = (ProductItem)other;
            long diff = this.timeTo - x.timeTo;
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            return 0;
        }

        public Product toProduct(int contractId, int accountId) {
            return new Product().setId(this.productId).setContractId(contractId).setAccountId(accountId).setProductSpecId(this.id).setTimeFrom(TvUtils.toDate(this.timeFrom)).setTimeTo(TvUtils.toDate(this.timeTo)).setActivationModeId(this.activationModeId).setDeviceState(this.deviceState);
        }

        public StringBuilder toString(StringBuilder sb) {
            return sb.append(this.id).append('-').append(this.productId).append("[").append(this.deviceState).append("]").append(": ").append(this.timeFrom == 0L ? "null" : TimeUtils.format((Date)new Date(this.timeFrom), (String)"dd.MM.yyyy HH:mm:ss.S")).append(" - ").append(this.timeTo == 0L ? "null" : TimeUtils.format((Date)new Date(this.timeTo), (String)"dd.MM.yyyy HH:mm:ss.S"));
        }
    }
}

