/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.uniteller.server.bean;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractUtils;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.modules.uniteller.common.bean.Transaction;
import ru.bitel.bgbilling.modules.uniteller.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.uniteller.server.event.UnitellerAutopaymentSumEvent;
import ru.bitel.bgbilling.server.bean.AbstractTransactionManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;

public class TransactionManager
extends AbstractTransactionManager<Transaction> {
    private static final String ASCII = "ASCII";

    public TransactionManager(Connection con, int moduleId) {
        super(con, "uniteller_transaction", moduleId);
        this.fields = new HashMap();
        this.fields.put("id", "id");
        this.fields.put("createDate", "create_date");
        this.fields.put("transactionDate", "transaction_date");
        this.fields.put("sum", "sum");
    }

    protected void queryStatus(StringBuilder query, String status) {
        if (Utils.notBlankString((String)status) && !TransactionStatus.ALL.getCode().equals(status)) {
            query.append(" AND pt.result=?");
        }
    }

    protected int psStatus(PreparedStatement ps, String status, int index) throws SQLException {
        if (Utils.notBlankString((String)status) && !TransactionStatus.ALL.getCode().equals(status)) {
            ps.setString(index++, status);
        }
        return index;
    }

    public Transaction getTransactionByTransactionId(String transactionId) throws SQLException {
        Transaction transaction = null;
        String query = "SELECT " + this.tableName + ".*, c.title AS contract_title" + " FROM " + this.tableName + " LEFT JOIN contract c ON c.id=" + this.tableName + ".contract_id" + " WHERE " + "transaction_id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setString(1, transactionId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    transaction = this.getFromRS(rs);
                }
            }
        }
        return transaction;
    }

    public void doCheckRequest(int contractId) {
        String gateUrl = this.moduleSetup.get("uniteller.url.gate", "https://wpay.uniteller.ru/") + "results";
        String shopID = this.moduleSetup.get("uniteller.point.id", "");
        String login = this.moduleSetup.get("uniteller.login", "");
        String password = this.moduleSetup.get("uniteller.password", "");
        try {
            StringBuilder query = new StringBuilder().append("Shop_ID").append("=").append(URLEncoder.encode(shopID, "UTF-8")).append("&").append("Login").append("=").append(URLEncoder.encode(login, "UTF-8")).append("&").append("Password").append("=").append(URLEncoder.encode(password, "UTF-8")).append("&").append("Format").append("=").append(1).append("&").append("Header1").append("=").append(1).append("&");
            HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(10L)).build();
            HttpRequest httpRequest = HttpRequest.newBuilder().uri(new URI(gateUrl + "?" + query.toString())).GET().build();
            String result = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofString()).body();
            if (result != null) {
                System.out.println("result = " + result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Transaction doRecurrentRequest(int contractId, BigDecimal sum, String parentOrderIDP) throws Exception {
        boolean fiscalization;
        UnitellerAutopaymentSumEvent event = new UnitellerAutopaymentSumEvent(this.moduleId, contractId, sum);
        BigDecimal newSum = ((UnitellerAutopaymentSumEvent)EventProcessor.getInstance().request((QueueEvent)event)).getSum();
        if (newSum != null) {
            sum = newSum;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("sum = " + String.valueOf(sum));
        }
        Transaction transaction = (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setSum(sum)).setContractId(contractId)).setCreateDate(new Date())).setAutopayment(true)).setTransactionId(String.valueOf(System.currentTimeMillis() + (long)(100.0 * Math.random())))).build();
        this.update(transaction);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("transaction = " + transaction.toString());
        }
        String shopIDP = this.moduleSetup.get("uniteller.point.id", "");
        String orderIDP = String.valueOf(transaction.getTransactionId());
        String subtotalP = this.getFormatSum(sum);
        String signature = new StringBuffer().append(Utils.getDigest((String)shopIDP, (String)ASCII).toLowerCase()).append("&").append(Utils.getDigest((String)orderIDP, (String)ASCII).toLowerCase()).append("&").append(Utils.getDigest((String)subtotalP, (String)ASCII).toLowerCase()).append("&").append(Utils.getDigest((String)parentOrderIDP, (String)ASCII).toLowerCase()).append("&").append(Utils.getDigest((String)this.moduleSetup.get("uniteller.password", ""), (String)ASCII).toLowerCase()).toString();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("signature = " + signature);
        }
        String url = (fiscalization = this.moduleSetup.getBoolean("uniteller.fiscalization.enable", false)) ? this.moduleSetup.get("uniteller.autopayment.fiscalization.url.gate", "https://fpay.uniteller.ru/v2/") : this.moduleSetup.get("uniteller.autopayment.url.gate", "https://wpay.uniteller.ru/");
        StringBuilder spec = new StringBuilder(url).append("recurrent?").append("Shop_IDP").append("=").append(shopIDP).append("&").append("Order_IDP").append("=").append(orderIDP).append("&").append("Subtotal_P").append("=").append(subtotalP).append("&").append("Parent_Order_IDP").append("=").append(parentOrderIDP).append("&");
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("fiscalization = " + fiscalization);
            this.getLogger().debug("url = " + url);
        }
        if (fiscalization) {
            Contract contract = null;
            try (ContractDao contractDao = new ContractDao(this.con, 0);){
                contract = (Contract)contractDao.get(contractId);
            }
            try {
                String customerAddress = ContractUtils.getCustomerAddress((Connection)this.con, (int)this.moduleId, (int)contractId);
                String receipt = this.getReceipt(sum, customerAddress, contract != null ? contract.getTitle() : "");
                receipt = Base64.getEncoder().encodeToString(receipt.getBytes("UTF-8"));
                String receiptSignature = this.getReceiptSignature(shopIDP, orderIDP, subtotalP, receipt);
                receipt = URLEncoder.encode(receipt, "UTF-8");
                spec.append("Receipt").append("=").append(receipt).append("&");
                spec.append("ReceiptSignature").append("=").append(receiptSignature).append("&");
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("contract = " + String.valueOf(contract));
                    this.getLogger().debug("customerAddress = " + customerAddress);
                    this.getLogger().debug("receipt => " + receipt);
                    this.getLogger().debug("receiptSignature => " + (String)receiptSignature);
                }
            }
            catch (UnsupportedEncodingException ex) {
                this.logError(ex);
            }
        }
        spec.append("Signature").append("=").append(Utils.getDigest((String)signature, (String)ASCII));
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("\u0417\u0430\u043f\u0440\u043e\u0441: " + spec.toString());
        }
        ArrayList<String> resultCSV = new ArrayList<String>();
        try {
            StringBuilder sb = this.doConnection(spec.toString(), "GET", true, null, null);
            StringTokenizer stringTokenizer = new StringTokenizer(sb.toString(), "\n", false);
            while (stringTokenizer.hasMoreTokens()) {
                resultCSV.add(stringTokenizer.nextToken());
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("\u041e\u0442\u0432\u0435\u0442: ");
                for (String str : resultCSV) {
                    this.getLogger().debug("\t" + str);
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().error(ex.getMessage());
        }
        HashMap<String, String> dataMap = new HashMap<String, String>();
        if (resultCSV.size() > 0) {
            ArrayList<Object> names = new ArrayList<Object>();
            for (String name : ((String)resultCSV.get(0)).split(";")) {
                names.add(name);
            }
            if (resultCSV.size() > 1) {
                for (int index = 1; index < resultCSV.size(); ++index) {
                    String[] values = ((String)resultCSV.get(index)).split(";");
                    for (int indexV = 0; indexV < Math.min(names.size(), values.length); ++indexV) {
                        dataMap.put((String)names.get(indexV), values[indexV]);
                    }
                }
            }
        }
        Payment payment = null;
        if (dataMap.containsKey("ErrorCode")) {
            transaction.setStatus(TransactionStatus.ERROR.getCode());
        } else {
            String status = (String)dataMap.get("Status");
            if (status != null && this.moduleSetup.get("uniteller.payment.status.ok", "paid").equals(status.toLowerCase())) {
                transaction.setStatus(TransactionStatus.OK.getCode());
                Date paymentDate = transaction.getTransactionDate();
                if (paymentDate == null) {
                    paymentDate = new Date();
                    transaction.setTransactionDate(paymentDate);
                }
                payment = Payment.builder().setDate(paymentDate).setTypeId(this.moduleSetup.getInt("uniteller.payment.type.id", 0)).setContractId(transaction.getContractId()).setSum(transaction.getSum()).setUserId(0).setModuleId(Integer.valueOf(this.moduleId)).setTransactionId(String.valueOf(transaction.getId())).setComment(this.moduleSetup.get("uniteller.payment.comment", "\u041e\u043f\u043b\u0430\u0442\u0430 \u0447\u0435\u0440\u0435\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u043d\u044b\u0439 \u0441\u0435\u0440\u0432\u0438\u0441 Uniteller [\u0442\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044f #{TRANSACTION_ID}]").replace("{TRANSACTION_ID}", orderIDP)).build();
                new PaymentDao(this.con).update((Object)payment);
                transaction.setPaymentId(payment.getId());
            }
        }
        transaction.setParameters(transaction.getParameters() + "\n" + Utils.toString(dataMap, (String)"\n"));
        this.update(transaction);
        if (payment != null) {
            ServerUtils.commitConnection((Connection)this.con);
            BalanceUtils balanceUtils = new BalanceUtils(this.con);
            balanceUtils.updateBalance(transaction.getTransactionDate(), transaction.getContractId());
            balanceUtils.close();
            ServerUtils.commitConnection((Connection)this.con);
            EventProcessor.getInstance().publish((Event)new PaymentEvent(0, payment));
            EventProcessor.getInstance().publish((Event)new ContractBalanceChangedEvent(transaction.getContractId(), 3, payment.getSum()));
        }
        return transaction;
    }

    public String getFormatSum(BigDecimal sum) {
        DecimalFormat decimalFormat = new DecimalFormat("###########0.00");
        return decimalFormat.format(sum).replace(",", ".");
    }

    public String getReceipt(BigDecimal sum, String customerAddress, String contractTitle) {
        JSONObject customerJSON = new JSONObject();
        customerJSON.put("id", (Object)contractTitle);
        if (!Utils.isBlankString((String)customerAddress)) {
            if (customerAddress.contains("@")) {
                customerJSON.put("email", (Object)customerAddress);
            } else {
                customerJSON.put("phone", (Object)customerAddress);
            }
        }
        JSONObject lineJSON = new JSONObject();
        lineJSON.put("name", (Object)this.moduleSetup.get("uniteller.fiscalization.receipt.name", "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 \u2116{CONTRACT_TITLE}").replace("{CONTRACT_TITLE}", contractTitle));
        lineJSON.put("price", (Object)sum);
        lineJSON.put("qty", this.moduleSetup.getInt("uniteller.fiscalization.receipt.qty", 1));
        lineJSON.put("sum", (Object)sum);
        lineJSON.put("vat", this.moduleSetup.getInt("uniteller.fiscalization.receipt.vat", 0));
        lineJSON.put("payattr", this.moduleSetup.getInt("uniteller.fiscalization.receipt.payattr", 1));
        lineJSON.put("lineattr", this.moduleSetup.getInt("uniteller.fiscalization.receipt.lineattr", 4));
        JSONArray linesJSON = new JSONArray();
        linesJSON.put((Object)lineJSON);
        JSONObject paymentJSON = new JSONObject();
        paymentJSON.put("kind", this.moduleSetup.getInt("uniteller.fiscalization.receipt.payments.kind", 1));
        paymentJSON.put("type", this.moduleSetup.getInt("uniteller.fiscalization.receipt.payments.type", 0));
        paymentJSON.put("amount", (Object)sum);
        JSONArray paymentsJSON = new JSONArray();
        paymentsJSON.put((Object)paymentJSON);
        JSONObject receiptJSON = new JSONObject();
        receiptJSON.put("customer", (Object)customerJSON);
        receiptJSON.put("taxmode", this.moduleSetup.getInt("uniteller.fiscalization.receipt.taxmode", 0));
        receiptJSON.put("lines", (Object)linesJSON);
        receiptJSON.put("payments", (Object)paymentsJSON);
        receiptJSON.put("total", (Object)sum);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("receipt = " + receiptJSON.toString());
        }
        return receiptJSON.toString();
    }

    public String getReceiptSignature(Object shopIdp, Object orderIdp, Object subTotalP, Object receipt) {
        String receiptSignature = new StringBuffer().append(Utils.getDigest((String)String.valueOf(shopIdp), (String)ASCII, (String)"SHA-256").toLowerCase()).append("&").append(Utils.getDigest((String)String.valueOf(orderIdp), (String)ASCII, (String)"SHA-256").toLowerCase()).append("&").append(Utils.getDigest((String)String.valueOf(subTotalP), (String)ASCII, (String)"SHA-256").toLowerCase()).append("&").append(Utils.getDigest((String)String.valueOf(receipt), (String)ASCII, (String)"SHA-256").toLowerCase()).append("&").append(Utils.getDigest((String)this.moduleSetup.get("uniteller.password", ""), (String)ASCII, (String)"SHA-256").toLowerCase()).toString();
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("shopIdp = " + String.valueOf(shopIdp));
            this.getLogger().debug("orderIdp = " + String.valueOf(orderIdp));
            this.getLogger().debug("subTotalP = " + String.valueOf(subTotalP));
            this.getLogger().debug("receipt = " + String.valueOf(receipt));
            this.getLogger().debug("receiptSignature = " + receiptSignature);
        }
        return Utils.getDigest((String)receiptSignature, (String)ASCII, (String)"SHA-256");
    }

    protected Transaction getFromRS(ResultSet rs) throws SQLException {
        return (Transaction)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)((Transaction.Builder)Transaction.builder().setId(rs.getInt("id"))).setContractId(rs.getInt("contract_id"))).setContractTitle(rs.getString("contract_title"))).setPaymentId(rs.getInt("payment_id"))).setCreateDate((Date)rs.getTimestamp("create_date"))).setTransactionDate((Date)rs.getTimestamp("transaction_date"))).setTransactionId(rs.getString("transaction_id"))).setStatus(rs.getString("result"))).setParameters(rs.getString("params"))).setSum(rs.getBigDecimal("sum"))).setAutopayment(rs.getBoolean("autopayment"))).build();
    }

    protected void updateImpl(Transaction transaction) throws SQLException {
        String querySet = "contract_id=?, payment_id=?, create_date=?, transaction_date=?, transaction_id=?, result=?, params=?, sum=?, autopayment=?";
        try (PreparedStatement ps = this.prepareStatement((Id)transaction, querySet);){
            int index = 1;
            ps.setInt(index++, transaction.getContractId());
            ps.setInt(index++, transaction.getPaymentId());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getCreateDate()));
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)transaction.getTransactionDate()));
            ps.setString(index++, transaction.getTransactionId());
            ps.setString(index++, transaction.getStatus());
            ps.setString(index++, transaction.getParameters());
            ps.setBigDecimal(index++, transaction.getSum());
            ps.setBoolean(index++, transaction.isAutopayment());
            this.executeUpdate((Id)transaction, index, ps);
        }
    }

    protected void setConnectionTimeout(HttpsURLConnection connection) {
        connection.setConnectTimeout(this.moduleSetup.getInt("uniteller.request.timeout", 10000));
        connection.setReadTimeout(this.moduleSetup.getInt("uniteller.request.read.timeout", 5000));
    }
}

