/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.client.contract;

import bitel.billing.module.admin.DialogContractAndDateSelect;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.BGClient;
import ru.bitel.bgbilling.client.common.BGControlPanelDateNoB;
import ru.bitel.bgbilling.client.common.BGEditor;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextArea;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientSetup;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractService;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObject;
import ru.bitel.bgbilling.kernel.contract.object.common.service.ContractObjectService;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.modules.voice.client.contract.VoiceAccountEditor;
import ru.bitel.bgbilling.modules.voice.client.contract.VoiceAccountNumberForm;
import ru.bitel.bgbilling.modules.voice.client.device.VoiceDevicePanel;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccount;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccountType;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceDevice;
import ru.bitel.bgbilling.modules.voice.common.bean.enums.VoiceAccountState;
import ru.bitel.bgbilling.modules.voice.common.bean.enums.VoiceAccountStatus;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceAccountService;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceDeviceService;
import ru.bitel.bgbilling.modules.voice.common.utils.VoiceCommonUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGDialog;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.client.DialogContractSelect;
import ru.bitel.common.client.DialogEditPeriod;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.oss.systems.inventory.resource.common.DeviceManagerMethodType;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceManagerMethod;
import ru.bitel.oss.systems.inventory.resource.common.bean.PhoneCategory;
import ru.bitel.oss.systems.inventory.resource.common.service.PhoneResourceService;

public class VoiceAccountPanel
extends BGUPanel {
    public static final KeyValue COLUMN_TITLE = new KeyValue("title", "\u0410\u043a\u043a\u0430\u0443\u043d\u0442");
    public static final KeyValue COLUMN_NUMBER = new KeyValue("number", "\u041d\u043e\u043c\u0435\u0440");
    private PopupMenuListener popupMenuListener;
    private VoiceDeviceService deviceService = null;
    private VoiceAccount selectedVoiceAccount = null;
    private BGUTable accountTable = null;
    private BGTextField filterValue = null;
    private BGControlPanelDateNoB filterDate = null;
    private BGUComboBox<KeyValue> filterColumn = null;
    private BGUComboBox<IdTitle> filterStatus = new BGUComboBox();
    private BGUComboBox<IdTitle> filterDeviceState = new BGUComboBox();
    private List<VoiceAccount> voiceAccounts = null;
    private VoiceAccountTableModel accountTableModel = null;
    Map<Integer, ContractObject> objectMap = new HashMap<Integer, ContractObject>();
    private int oldMenuDeviceId = Integer.MIN_VALUE;
    private int oldMenuDeviceTypeId = Integer.MIN_VALUE;
    private List<JMenuItem> oldMenuItemList = new ArrayList<JMenuItem>();
    private JSeparator menuSeparator = new JSeparator();

    protected void jbInit() throws Exception {
        try {
            Contract contract = ((ContractService)((ClientContext)this.getContext()).getPort(ContractService.class, 0)).contractGet(((ClientContext)this.getContext()).getContractId());
            if (contract.isIndependSub() && VoiceCommonUtils.agetModeOn((Preferences)ClientSetup.getInstance())) {
                JLabel label = new JLabel("\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430 \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u043d\u044b, \u044d\u0442\u043e \u0441\u0443\u0431\u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0441 \u043d\u0435\u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u043c \u0431\u0430\u043b\u0430\u043d\u0441\u043e\u043c", 0);
                this.removeAll();
                this.add(label, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
                return;
            }
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        BGEditor editor = new BGEditor("table");
        editor.addForm((JComponent)this.getTablePanel(), (Object)"table");
        editor.addForm((JComponent)((Object)new VoiceAccountEditor(this, (VoiceAccountService)((ClientContext)this.getContext()).getWebService(VoiceAccountService.class))));
        this.setLayout(new BorderLayout());
        this.add((Component)editor, "Center");
        BGSwingUtilites.handleEdit((JTable)this.accountTable, (AbstractBGUPanel)editor);
    }

    private JPanel getTablePanel() {
        this.accountTableModel = new VoiceAccountTableModel();
        this.accountTable = new BGUTable((TableModel)((Object)this.accountTableModel));
        this.accountTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (SwingUtilities.isRightMouseButton(event) && ((VoiceAccount)VoiceAccountPanel.this.accountTableModel.getSelectedRow()).getChildren() == null) {
                    VoiceAccountPanel.this.getPopupMenu().show((Component)VoiceAccountPanel.this.accountTable, event.getX(), event.getY());
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getFilterPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        panel.add((Component)new JScrollPane((Component)this.accountTable), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 3, 3, 3), 0, 0));
        return panel;
    }

    private JPanel getFilterPanel() {
        this.filterColumn = new BGUComboBox();
        this.filterColumn.setData(Arrays.asList(COLUMN_TITLE, COLUMN_NUMBER));
        this.filterValue = new BGTextField(10);
        this.filterValue.setHorizontalAlignment(0);
        this.filterValue.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                VoiceAccountPanel.this.doFilterTable();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                VoiceAccountPanel.this.doFilterTable();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                VoiceAccountPanel.this.doFilterTable();
            }
        });
        ItemListener listener = e -> this.comboBoxSelect(a -> this.doFilterTable());
        ArrayList<IdTitle> statusItems = new ArrayList<IdTitle>();
        statusItems.add(new IdTitle(-1, "\u043b\u044e\u0431\u043e\u0439"));
        statusItems.addAll(Arrays.asList(VoiceAccountStatus.STATUS_ON.toIdTitle(), VoiceAccountStatus.STATUS_OFF.toIdTitle()));
        this.filterStatus.setData(statusItems);
        this.filterStatus.addItemListener(listener);
        ArrayList<IdTitle> statesItems = new ArrayList<IdTitle>();
        statesItems.add(new IdTitle(-2, "\u043b\u044e\u0431\u043e\u0435"));
        statesItems.addAll(Stream.of(VoiceAccountState.values()).map(VoiceAccountState::toIdTitle).toList());
        this.filterDeviceState.setData(statesItems);
        this.filterDeviceState.addItemListener(listener);
        this.filterDate = new BGControlPanelDateNoB();
        this.filterDate.setLocalDate(LocalDate.now());
        this.filterDate.setButtonNow(true);
        this.filterDate.addPropertyChangeListener("date", e -> this.doFilterTable());
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.filterColumn, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.filterValue, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u0421\u0442\u0430\u0442\u0443\u0441:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.filterStatus, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.filterDeviceState, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add((Component)new JLabel("\u041d\u0430 \u0434\u0430\u0442\u0443:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 0), 0, 0));
        panel.add((Component)this.filterDate, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        panel.add(Box.createHorizontalGlue(), new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
        return panel;
    }

    private void doFilterTable() {
        if (this.voiceAccounts != null && this.accountTableModel != null) {
            KeyValue keyValue = (KeyValue)this.filterColumn.getSelectedItem();
            String value = this.filterValue.getText();
            int status = ((IdTitle)this.filterStatus.getSelectedItem()).getId();
            int state = ((IdTitle)this.filterDeviceState.getSelectedItem()).getId();
            LocalDate date = this.filterDate.getLocalDate();
            ArrayList<VoiceAccount> list = new ArrayList<VoiceAccount>();
            for (VoiceAccount voiceAccount : this.voiceAccounts) {
                boolean add = true;
                if (!value.isEmpty()) {
                    switch (keyValue.getKey()) {
                        case "title": {
                            add = voiceAccount.getTitle().contains(value);
                            break;
                        }
                        case "number": {
                            add = String.valueOf(voiceAccount.getNumber()).contains(value);
                            break;
                        }
                    }
                }
                if (add && status > -1) {
                    boolean bl = add = voiceAccount.getStatus().getCode() == status;
                }
                if (add && state > -2) {
                    boolean bl = add = voiceAccount.getDeviceState().getCode() == state;
                }
                if (add && date != null) {
                    add = TimeUtils.dateInRange((Date)TimeUtils.convertLocalDateToDate((LocalDate)date), (Date)voiceAccount.getDateFrom(), (Date)voiceAccount.getDateTo());
                }
                if (!add) continue;
                list.add(voiceAccount);
            }
            this.accountTableModel.setData(list);
        }
    }

    private VoiceDeviceService getVoiceDeviceService() {
        if (this.deviceService == null) {
            this.deviceService = (VoiceDeviceService)((ClientContext)this.getContext()).getPort(VoiceDeviceService.class);
        }
        return this.deviceService;
    }

    private void moveToContract(ActionEvent e) {
        List<VoiceAccount> selectedAccounts = this.checkSelect();
        if (selectedAccounts != null) {
            DialogContractSelect dialogContractSelect = new DialogContractSelect(true, true, ((ClientContext)this.getContext()).getContractId());
            if (dialogContractSelect.showDialog() == "ok") {
                String selectedContractId = dialogContractSelect.getSingleId();
                if (selectedContractId == null) {
                    ClientUtils.showMessageDialog((Object)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440");
                } else {
                    int toContractId = Utils.parseInt((String)selectedContractId);
                    for (VoiceAccount voiceAccount : selectedAccounts) {
                        try {
                            ((VoiceAccountService)((ClientContext)this.getContext()).getWebService(VoiceAccountService.class)).voiceAccountRelocate(voiceAccount.getId(), toContractId);
                        }
                        catch (Exception ex) {
                            ClientUtils.showErrorMessageDialog((Throwable)ex);
                        }
                    }
                    this.performAction("refresh");
                }
            }
            dialogContractSelect.dispose();
        }
    }

    private void copyToContractWithDate(ActionEvent e) {
        List<VoiceAccount> selectedAccounts = this.checkSelect();
        if (selectedAccounts != null) {
            DialogContractAndDateSelect contractAndDateSelect = new DialogContractAndDateSelect(((ClientContext)this.getContext()).getContractId());
            if (contractAndDateSelect.showDialog() == "ok") {
                String selectedContractId = contractAndDateSelect.getSingleId();
                Date toDate = contractAndDateSelect.getDate();
                if (selectedContractId == null) {
                    ClientUtils.showMessageDialog((Object)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440");
                } else if (toDate == null) {
                    ClientUtils.showMessageDialog((Object)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0434\u0430\u0442\u0443");
                } else {
                    int toContractId = Utils.parseInt((String)selectedContractId);
                    Date endDate = TimeUtils.getPrevDay((Date)toDate);
                    for (VoiceAccount voiceAccount : selectedAccounts) {
                        try {
                            voiceAccount.setDateTo(endDate);
                            ((VoiceAccountService)((ClientContext)this.getContext()).getWebService(VoiceAccountService.class)).voiceAccountUpdate(voiceAccount);
                            voiceAccount.setId(0);
                            voiceAccount.setContractId(toContractId);
                            voiceAccount.setDateFrom(toDate);
                            voiceAccount.setDateTo(null);
                            ((VoiceAccountService)((ClientContext)this.getContext()).getWebService(VoiceAccountService.class)).voiceAccountUpdate(voiceAccount);
                        }
                        catch (Exception ex) {
                            ClientUtils.showErrorMessageDialog((Throwable)ex);
                        }
                    }
                    this.performAction("refresh");
                }
            }
            contractAndDateSelect.dispose();
        }
    }

    protected JPopupMenu getPopupMenu() {
        if (this.accountTable.getComponentPopupMenu() == null) {
            JPopupMenu popupMenu = new JPopupMenu();
            popupMenu = new JPopupMenu();
            popupMenu.add("\u041f\u0440\u043e\u0434\u0443\u0431\u043b\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0434\u043b\u044f \u043d\u043e\u043c\u0435\u0440\u043e\u0432 (\u0438\u0437 \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432)").addActionListener(e -> {
                if (this.accountTableModel.getSelectedRow() == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
                    return;
                }
                this.selectedVoiceAccount = (VoiceAccount)this.accountTableModel.getSelectedRow();
                this.dublicateEditorWindow((ActionListener)((Object)this));
            });
            popupMenu.add("\u041f\u0440\u043e\u0434\u0443\u0431\u043b\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0434\u043b\u044f \u043d\u043e\u043c\u0435\u0440\u043e\u0432 (\u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430)").addActionListener(e -> {
                if (this.accountTableModel.getSelectedRow() == null) {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443 \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
                    return;
                }
                this.selectedVoiceAccount = (VoiceAccount)this.accountTableModel.getSelectedRow();
                new DuplicateListDialog("\u0414\u0443\u0431\u043b\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u043e\u0432 \u043f\u043e \u0441\u043f\u0438\u0441\u043a\u0443 \u043d\u043e\u043c\u0435\u0440\u043e\u0432", this.selectedVoiceAccount).open();
            });
            popupMenu.add("\u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u0435\u0440\u0438\u043e\u0434").addActionListener(e -> {
                List<VoiceAccount> selectedAccounts = this.checkSelect();
                if (selectedAccounts != null) {
                    this.changeDateSelectedAccounts(selectedAccounts);
                }
            });
            popupMenu.add("\u041f\u0435\u0440\u0435\u043d\u0435\u0441\u0442\u0438 \u043d\u0430 \u0434\u0440\u0443\u0433\u043e\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440").addActionListener(e -> this.moveToContract(e));
            popupMenu.add("\u0421\u043a\u043e\u043f\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043d\u0430 \u0434\u0440\u0443\u0433\u043e\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440 (\u0441 \u0434\u0430\u0442\u044b)").addActionListener(e -> this.copyToContractWithDate(e));
            popupMenu.add("\u0423\u0434\u0430\u043b\u0438\u0442\u044c").addActionListener(e -> this.performAction("delete"));
            this.accountTable.setComponentPopupMenu(popupMenu);
        }
        return this.accountTable.getComponentPopupMenu();
    }

    protected void shownNotify() {
        if (this.accountTable == null) {
            return;
        }
        final JPopupMenu popupMenu = this.accountTable.getComponentPopupMenu();
        if (popupMenu != null && this.popupMenuListener == null) {
            this.popupMenuListener = new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    VoiceAccountPanel.this.updateDeviceManagerMethodList(popupMenu);
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            };
            popupMenu.addPopupMenuListener(this.popupMenuListener);
        }
    }

    private void updateDeviceManagerMethodList(JPopupMenu popupMenu) {
        VoiceAccount voiceAccount;
        final VoiceAccount menuVoiceAccount = voiceAccount = (VoiceAccount)this.accountTableModel.getSelectedRow();
        if (voiceAccount != null && voiceAccount.getDeviceId() == this.oldMenuDeviceId) {
            return;
        }
        try {
            VoiceDevice menuDevice;
            VoiceDevice voiceDevice = menuDevice = voiceAccount != null ? (VoiceDevice)this.getVoiceDeviceService().deviceGet(voiceAccount.getDeviceId()) : null;
            if (menuDevice != null && menuDevice.getDeviceTypeId() == this.oldMenuDeviceTypeId) {
                return;
            }
            for (JMenuItem m : this.oldMenuItemList) {
                popupMenu.remove(m);
            }
            popupMenu.remove(this.menuSeparator);
            this.oldMenuItemList.clear();
            if (menuDevice == null) {
                this.oldMenuDeviceId = Integer.MIN_VALUE;
                this.oldMenuDeviceTypeId = Integer.MIN_VALUE;
                return;
            }
            this.oldMenuDeviceId = voiceAccount.getDeviceId();
            this.oldMenuDeviceTypeId = menuDevice.getDeviceTypeId();
            List methodList = this.getVoiceDeviceService().deviceManagerMethodList(menuDevice.getDeviceTypeId());
            if (methodList.size() > 0) {
                popupMenu.add(this.menuSeparator);
            }
            for (final DeviceManagerMethod deviceManagerMethod : methodList) {
                if (!deviceManagerMethod.getTypes().contains(DeviceManagerMethodType.ACCOUNT)) continue;
                AbstractBGUPanel.DefaultAction action = new AbstractBGUPanel.DefaultAction("command." + deviceManagerMethod.getMethod(), deviceManagerMethod.getTitle(), ClientUtils.getIcon((String)"fugue/terminal-network")){

                    public void actionPerformedImpl(ActionEvent e) throws Exception {
                        try {
                            VoiceDevicePanel.executeCommand((ClientContext)VoiceAccountPanel.this.getContext(), menuDevice.getId(), deviceManagerMethod.getMethod(), menuVoiceAccount.getId(), 0);
                        }
                        catch (BGException ex) {
                            ClientUtils.showErrorMessageDialog((Throwable)ex);
                        }
                    }
                };
                JMenuItem menu = new JMenuItem((Action)action);
                popupMenu.add(menu);
                this.oldMenuItemList.add(menu);
            }
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    private List<VoiceAccount> checkSelect() {
        List selectedAccounts = this.accountTableModel.getSelectedRows();
        if (Utils.isEmptyCollection((Collection)selectedAccounts)) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443(\u0438)");
            return null;
        }
        return selectedAccounts;
    }

    private void dublicateEditorWindow(ActionListener listener) {
        VoiceAccountNumberForm numberForm = new VoiceAccountNumberForm((ClientContext)this.getContext(), listener);
        PhoneCategory rootCat = null;
        try {
            rootCat = ((PhoneResourceService)((ClientContext)this.getContext()).getPort(PhoneResourceService.class)).phoneCategoryRoot();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
        numberForm.treeModel.setData(rootCat);
        numberForm.treeModel.setSelectedRow(0);
        numberForm.maxField.setValue((long)ClientSetup.getInstance().getUserConfig().getInt("voice.resource.ip.free.max", 100));
        numberForm.setVoiceAccountPanel(this);
        new DialogDuplicate(numberForm);
    }

    protected void createNewCopyVoiceAccount(List<Long> selectedNumbers) {
        ArrayList<VoiceAccount> createAccounts = new ArrayList<VoiceAccount>();
        String comment = "\u0421\u043e\u0437\u0434\u0430\u043d \u043f\u0430\u043a\u0435\u0442\u043d\u043e";
        for (Long number : selectedNumbers) {
            VoiceAccount account = new VoiceAccount();
            try {
                account = (VoiceAccount)this.selectedVoiceAccount.clone();
                account.setId(-1);
                account.setNumber(number.longValue());
                account.setComment(comment);
            }
            catch (CloneNotSupportedException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            createAccounts.add(account);
        }
        try {
            for (VoiceAccount account : createAccounts) {
                ((VoiceAccountService)((ClientContext)this.getContext()).getWebService(VoiceAccountService.class)).voiceAccountUpdate(account);
            }
            this.performAction("refresh");
        }
        catch (Exception e) {
            ClientUtils.showErrorMessageDialog((Throwable)e);
        }
    }

    BGTableModel<VoiceAccount> getAccountTableModel() {
        return this.accountTableModel;
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            int contractId = ((ClientContext)this.getContext()).getContractId();
            int contractObjectId = ((ClientContext)this.getContext()).getObjectId();
            List contractObjectList = ((ContractObjectService)((ClientContext)this.getContext()).getPort(ContractObjectService.class, 0)).contractObjectList(contractId);
            this.objectMap.putAll(contractObjectList.stream().filter(o -> contractObjectId > 0 && o.getId() == contractObjectId || contractObjectId == 0).collect(Collectors.toMap(v -> v.getId(), v -> v)));
            if (this.accountTableModel != null && this.accountTable != null) {
                this.voiceAccounts = ((VoiceAccountService)((ClientContext)this.getContext()).getWebService(VoiceAccountService.class)).voiceAccountList(contractId, contractObjectId, null);
                this.doFilterTable();
            }
        });
        new AbstractBGUPanel.BGActionDelete((AbstractBGUPanel)this, e -> {
            List selectedAccounts = this.accountTableModel.getSelectedRows();
            if (Utils.isEmptyCollection((Collection)selectedAccounts)) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442 \u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0435!");
                return;
            }
            if (JOptionPane.showConfirmDialog((Component)BGClient.getFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0430\u043a\u043a\u0430\u0443\u043d\u0442 \u0441 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0434\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u0430", 0) == 0) {
                if (selectedAccounts.size() > 1) {
                    ((VoiceAccountService)((ClientContext)this.getContext()).getWebService(VoiceAccountService.class)).voiceAccountListDelete(selectedAccounts.stream().mapToInt(Id::getId).boxed().toList());
                } else {
                    ((VoiceAccountService)((ClientContext)this.getContext()).getWebService(VoiceAccountService.class)).voiceAccountDelete(((VoiceAccount)selectedAccounts.get(0)).getId());
                }
                this.performAction("refresh");
            }
        });
    }

    private void changeDateSelectedAccounts(List<VoiceAccount> selectedAccounts) {
        DialogEditPeriod dialogEditDate = new DialogEditPeriod();
        dialogEditDate.btnOk.addActionListener(e -> {
            Date dateFrom = dialogEditDate.fromDate.getDate();
            Date dateTo = dialogEditDate.toDate.getDate();
            if (dateFrom != null && dateTo != null && dateFrom.after(dateTo)) {
                ClientUtils.showErrorMessageDialog((String)"\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0440\u0430\u043d\u044c\u0448\u0435 \u0434\u0430\u0442\u044b \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f");
                return;
            }
            VoiceAccountService voiceAccountService = (VoiceAccountService)((ClientContext)this.getContext()).getWebService(VoiceAccountService.class);
            for (VoiceAccount account : selectedAccounts) {
                try {
                    voiceAccountService.voiceAccountPeriodUpdate(account.getId(), dateFrom, dateTo);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
            }
            dialogEditDate.dispose();
            this.performAction("refresh");
        });
    }

    class VoiceAccountTableModel
    extends BGTableModel<VoiceAccount> {
        private Map<Integer, String> deviceTitles;
        private Map<Integer, String> typeTypes;
        private Directory<VoiceAccountType> directory;

        public VoiceAccountTableModel() {
            super(VoiceAccountTableModel.class.getName());
            this.deviceTitles = new HashMap<Integer, String>();
            this.typeTypes = new HashMap<Integer, String>();
            this.directory = null;
            try {
                this.directory = ((ClientContext)VoiceAccountPanel.this.getContext()).getDirectory(VoiceAccountType.class);
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn(COLUMN_TITLE.getValue(), -1, -1, -1, COLUMN_TITLE.getKey(), true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e", 150, 200, -1, "deviceTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0422\u0438\u043f", 100, 150, 200, "typeTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn(COLUMN_NUMBER.getValue(), 120, 120, 120, COLUMN_NUMBER.getKey(), true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041f\u0435\u0440\u0438\u043e\u0434", 180, 180, 180, "period", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u0442\u0430\u0442\u0443\u0441", 120, 120, 120, "status", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u0421\u043e\u0441\u0442\u043e\u044f\u043d\u0438\u0435", 100, 100, 100, "deviceState", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.CENTER());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 80, 160, -1, "comment", false, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041e\u0431\u044a\u0435\u043a\u0442", null, 80, 160, -1, "object", true, false, false, null);
        }

        public Object getValue(VoiceAccount val, int column) throws Exception {
            String identifier;
            switch (identifier = this.getIdentifier(column)) {
                case "title": {
                    return Utils.maskNull((String)val.getTitle());
                }
                case "deviceTitle": {
                    Integer deviceId = val.getDeviceId();
                    if (!this.deviceTitles.containsKey(deviceId)) {
                        this.deviceTitles.put(deviceId, ((VoiceDevice)VoiceAccountPanel.this.getVoiceDeviceService().deviceGet(deviceId.intValue())).getTitle());
                    }
                    return this.deviceTitles.get(deviceId);
                }
                case "typeTitle": {
                    Integer typeId = val.getTypeId();
                    if (!this.typeTypes.containsKey(typeId)) {
                        this.typeTypes.put(typeId, ((VoiceAccountType)this.directory.get(typeId.intValue())).getTitle());
                    }
                    return this.typeTypes.get(typeId);
                }
                case "period": {
                    return TimeUtils.formatPeriod((Date)val.getDateFrom(), (Date)val.getDateTo());
                }
                case "status": {
                    return Optional.ofNullable(val.getStatus()).map(a -> a.getTitle()).orElse("---");
                }
                case "deviceState": {
                    return switch (val.getDeviceState()) {
                        case VoiceAccountState.STATE_DELETED -> "\u0443\u0434\u0430\u043b\u0435\u043d";
                        case VoiceAccountState.STATE_ENABLE -> "\u0432\u043a\u043b\u044e\u0447\u0435\u043d";
                        case VoiceAccountState.STATE_DISABLE -> "\u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d";
                        default -> "---";
                    };
                }
                case "object": {
                    ContractObject obj = VoiceAccountPanel.this.objectMap.get(val.getContractObjectId());
                    return obj != null ? obj.getTitle() : "";
                }
            }
            return super.getValue((Object)val, column);
        }
    }

    class DialogDuplicate
    extends BGDialog {
        public DialogDuplicate(VoiceAccountNumberForm panel) {
            this.jbInit(panel);
        }

        public void jbInit(VoiceAccountNumberForm panel) {
            this.setTitle("\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043d\u043e\u0432\u044b\u0445 \u0430\u043a\u043a\u0430\u0443\u043d\u0442\u043e\u0432");
            this.setSize(800, 600);
            this.setResizable(true);
            this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            panel.setSize(800, 600);
            this.add((Component)((Object)panel));
            this.setLocationRelativeTo((Component)BGClient.getFrame());
            this.setVisible(true);
        }
    }

    class DuplicateListDialog
    extends BGEditorDialog<VoiceAccount> {
        private BGTextArea numberList;

        public DuplicateListDialog(String title, VoiceAccount voiceAccount) {
            super(title, (Object)voiceAccount);
            this.numberList = new BGTextArea(30, 50);
        }

        public void doDialogPanel() {
            this.panel.add((Component)new JLabel("\u0421\u043f\u0438\u0441\u043e\u043a \u043d\u043e\u043c\u0435\u0440\u043e\u0432 \u0432 \u0444\u043e\u0440\u043c\u0430\u0442\u0435 E.164 (\u043f\u043e \u043e\u0434\u043d\u043e\u043c\u0443 \u043d\u0430 \u0441\u0442\u0440\u043e\u043a\u0443)"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.panel.add((Component)new JScrollPane((Component)this.numberList), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 0, 0, 0), 0, 0));
        }

        public boolean doApply() throws Exception {
            if (Utils.isBlankString((String)this.numberList.getText())) {
                ClientUtils.showErrorMessageDialog((String)"\u041f\u0443\u0441\u0442\u043e\u0439 \u0441\u043f\u0438\u0441\u043e\u043a");
                return false;
            }
            ArrayList<Long> numbers = new ArrayList<Long>();
            for (String line : this.numberList.getText().split("\n")) {
                if (!line.matches("^\\d{11}$")) {
                    ClientUtils.showErrorMessageDialog((String)("\u0421\u0442\u0440\u043e\u043a\u0430 \"" + line + "\" \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0448\u0430\u0431\u043b\u043e\u043d\u0443 (11 \u0446\u0438\u0444\u0440)"));
                    return false;
                }
                numbers.add(Long.valueOf(line));
            }
            if (numbers.isEmpty()) {
                ClientUtils.showErrorMessageDialog((String)"\u041f\u0443\u0441\u0442\u043e\u0439 \u0441\u043f\u0438\u0441\u043e\u043a");
                return false;
            }
            VoiceAccountPanel.this.createNewCopyVoiceAccount(numbers);
            return true;
        }
    }
}

