/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean.code;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceCostMapItem;
import ru.bitel.bgbilling.modules.voice.common.utils.VoiceCommonUtils;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.Id;

public class VoiceCostMapItemDao
extends AbstractIdDao<VoiceCostMapItem> {
    static final String VOICE_COST_MAP_ITEM_TABLENAME = "voice_cost_map_item";

    public VoiceCostMapItemDao(Connection con, int moduleId) {
        super(con, VOICE_COST_MAP_ITEM_TABLENAME, moduleId);
    }

    protected VoiceCostMapItem getFromRS(ResultSet rs) throws SQLException {
        return this.getFromRS(rs, "");
    }

    private VoiceCostMapItem getFromRS(ResultSet rs, String prefix) throws SQLException {
        return VoiceCostMapItem.builder().setId(rs.getInt(prefix + "id")).setCostMapId(rs.getInt(prefix + "costMapId")).setItemCost(rs.getBigDecimal(prefix + "cost")).setCodeId(rs.getInt(prefix + "codeId")).setDateFrom((Date)rs.getDate(prefix + "dateFrom")).setDateTo((Date)rs.getDate(prefix + "dateTo")).build();
    }

    protected void updateImpl(VoiceCostMapItem item) throws SQLException {
        String querySet = "costMapId=?, cost=?, codeId=?, dateFrom=?, dateTo=?";
        try (PreparedStatement ps = this.prepareStatement((Id)item, querySet);){
            int index = 1;
            ps.setInt(index++, item.getCostMapId());
            ps.setBigDecimal(index++, item.getItemCost());
            ps.setInt(index++, item.getCodeId());
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)item.getDateFrom()));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)item.getDateTo()));
            this.executeUpdate((Id)item, index, ps);
        }
    }

    public List<VoiceCostMapItem> list(int costMapId, Date date) throws SQLException {
        ArrayList<VoiceCostMapItem> result = new ArrayList<VoiceCostMapItem>();
        String geoCodeTableName = ServerUtils.getModuleTableName((String)"voice_geographic_code", (int)this.moduleId);
        String destTableName = ServerUtils.getModuleTableName((String)"voice_destination", (int)this.moduleId);
        String codeDestTableName = ServerUtils.getModuleTableName((String)"voice_code_destination", (int)this.moduleId);
        String query = "SELECT vcm.*,vgc.code, vd.title FROM " + this.tableName + " vcm LEFT JOIN " + geoCodeTableName + " vgc ON vgc.id=vcm.codeId LEFT JOIN " + codeDestTableName + " vcd ON vgc.id=vcd.codeId AND (vcd.dateFrom IS NULL OR vcd.dateFrom <= ?) AND (vcd.dateTo IS NULL OR vcd.dateTo >= ?) LEFT JOIN " + destTableName + " vd ON vcd.destinationId=vd.id WHERE costMapId=? AND (vcm.dateFrom IS NULL OR vcm.dateFrom <= ?) AND (vcm.dateTo IS NULL OR vcm.dateTo >= ? ) ORDER BY vgc.code";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)date));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)date));
            ps.setInt(index++, costMapId);
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)date));
            ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)date));
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    VoiceCostMapItem item = this.getFromRS(rs, "vcm.");
                    item.setCode(rs.getString("vgc.code"));
                    item.setDestinationTitle(rs.getString("vd.title"));
                    result.add(item);
                }
            }
        }
        return result;
    }

    public List<VoiceCostMapItem> list(int codeId, int costMapId) throws SQLException {
        ArrayList<VoiceCostMapItem> result = new ArrayList<VoiceCostMapItem>();
        String geoCodeTableName = ServerUtils.getModuleTableName((String)"voice_geographic_code", (int)this.moduleId);
        String query = "SELECT vcm.*,vgc.code FROM " + this.tableName + " vcm LEFT JOIN " + geoCodeTableName + " vgc ON vgc.id=vcm.codeId WHERE vcm.costMapId = ? " + (codeId > 0 ? " AND vcm.codeId=? " : "") + " ORDER BY vgc.code";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            int index = 1;
            ps.setInt(index++, costMapId);
            if (codeId > 0) {
                ps.setInt(index++, codeId);
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    VoiceCostMapItem item = this.getFromRS(rs, "vcm.");
                    item.setCode(rs.getString("vgc.code"));
                    result.add(item);
                }
            }
        }
        return result;
    }

    public void deleteByMapId(int id) throws SQLException {
        super.delete("costMapId=?", new Object[]{id});
    }

    public Map<Integer, List<VoiceCostMapItem>> codeMap(int codeId, int costMapId) throws SQLException {
        HashMap<Integer, List<VoiceCostMapItem>> result = new HashMap<Integer, List<VoiceCostMapItem>>();
        for (VoiceCostMapItem item : this.list(codeId, costMapId)) {
            int key = item.getCodeId();
            ArrayList<VoiceCostMapItem> list = (ArrayList<VoiceCostMapItem>)result.get(key);
            if (list == null) {
                list = new ArrayList<VoiceCostMapItem>();
                result.put(key, list);
            }
            list.add(item);
        }
        for (Integer key : result.keySet()) {
            List list = (List)result.get(key);
            list = VoiceCommonUtils.getDateSortedNormalizeList((List)list);
            result.put(key, list);
        }
        return result;
    }

    public void updateHistory(List<VoiceCostMapItem> itemHistory) throws SQLException {
        if (itemHistory != null && !itemHistory.isEmpty()) {
            VoiceCostMapItem first = itemHistory.get(0);
            String query = "DELETE FROM " + this.tableName + " WHERE codeId=" + first.getCodeId() + " AND costMapId=" + first.getCostMapId();
            try (Statement st = this.con.createStatement();){
                st.execute(query);
            }
            query = "INSERT INTO " + this.tableName + "  SET id=? , costMapId=?, cost=?, codeId=?, dateFrom=?, dateTo=?  ";
            try (PreparedStatement ps = this.con.prepareStatement(query);){
                for (VoiceCostMapItem item : itemHistory) {
                    int index = 1;
                    ps.setInt(index++, item.getId());
                    ps.setInt(index++, item.getCostMapId());
                    ps.setBigDecimal(index++, item.getItemCost());
                    ps.setInt(index++, item.getCodeId());
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)item.getDateFrom()));
                    ps.setDate(index++, TimeUtils.convertDateToSqlDate((Date)item.getDateTo()));
                    ps.executeUpdate();
                }
            }
        }
    }
}

