/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.radius;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeInfo;
import ru.bitel.bgbilling.kernel.network.radius.RadiusDictionary;
import ru.bitel.bgbilling.modules.voice.server.radius.VoiceSearchModeEq;
import ru.bitel.bgbilling.modules.voice.server.radius.VoiceSearchModePattern;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class RadiusSearchPattrernManager
extends BGLogger {
    private List<VoiceSearchModePattern> patterns = new ArrayList<VoiceSearchModePattern>();
    private List<VoiceSearchModePattern> operpatterns = new ArrayList<VoiceSearchModePattern>();
    private Map<Integer, VoiceSearchModePattern> patternMap = new HashMap<Integer, VoiceSearchModePattern>();
    private Map<Integer, VoiceSearchModePattern> operPatternMap = new HashMap<Integer, VoiceSearchModePattern>();
    private Preferences setup;

    public RadiusSearchPattrernManager(Preferences setup) {
        this.setup = setup;
        this.load("radius.search.mode.pattern.", this.patterns, this.patternMap);
        this.load("radius.oper.search.mode.pattern.", this.operpatterns, this.operPatternMap);
    }

    private void load(String prefix, List<VoiceSearchModePattern> patterns, Map<Integer, VoiceSearchModePattern> patternMap) {
        this.getLogger().trace("load( {} )", (Object)prefix);
        for (Map.Entry me : this.setup.subIndexed(prefix).entrySet()) {
            int id = (Integer)me.getKey();
            ParameterMap params = (ParameterMap)me.getValue();
            String value = params.get("rule");
            this.getLogger().trace("rule => id = {}; value = {}", (Object)id, (Object)value);
            if (Utils.isEmptyString((String)value)) {
                this.getLogger().error("Error findmode string (Utils.isEmptyString( value )): {} = {}", me.getKey(), me.getValue());
                continue;
            }
            String[] parts = value.split("=");
            if (parts.length != 2) {
                this.getLogger().error("Error findmode string (parts.length != 2): {} = {}", me.getKey(), me.getValue());
                continue;
            }
            String attribute = parts[0];
            this.getLogger().trace("attribute = {}", (Object)attribute);
            RadiusAttributeInfo attributeInfo = RadiusDictionary.findAttributeInfo((String)attribute);
            if (attributeInfo == null) {
                this.getLogger().error("Can't find " + attribute);
                continue;
            }
            String eqString = parts[1];
            this.getLogger().trace("eqString = {}", (Object)eqString);
            VoiceSearchModeEq eq = null;
            if (eqString.equalsIgnoreCase("PHONE")) {
                eq = VoiceSearchModeEq.PHONE;
            } else if (eqString.equalsIgnoreCase("LOGIN")) {
                eq = VoiceSearchModeEq.LOGIN;
            } else {
                this.getLogger().error("Error findmode string: " + String.valueOf(me.getKey()) + "=" + String.valueOf(me.getValue()));
                continue;
            }
            VoiceSearchModePattern mode = new VoiceSearchModePattern().setAttributeInfo(attributeInfo).setEq(eq);
            patterns.add(mode);
            patternMap.put(id, mode);
        }
    }

    public List<VoiceSearchModePattern> getPatterns() {
        return this.patterns;
    }

    public Map<Integer, VoiceSearchModePattern> getPatternMap() {
        return this.patternMap;
    }

    public Map<Integer, VoiceSearchModePattern> getOperPatternMap() {
        return this.operPatternMap;
    }
}

