/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.common.bean.AbtractVoiceAccount;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccount;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceAccountSearchParam;
import ru.bitel.bgbilling.modules.voice.common.bean.enums.VoiceAccountState;
import ru.bitel.bgbilling.modules.voice.common.bean.enums.VoiceAccountStatus;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceAccountPortDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceCommonAccountDao;
import ru.bitel.bgbilling.server.util.XMLDatabaseSerializer;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Result;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDaoSupport;
import ru.bitel.oss.kernel.entity.server.bean.VoiceAccountEntityAttrDaoSupport;

public class VoiceAccountDao
extends AbstractEntityDao<VoiceAccount> {
    public static final String TABLE_VOICE_ACCOUNT = "voice_account";
    private final String accountBaseTable;
    private final String accountTypeTable;
    private VoiceCommonAccountDao commonDao;
    private PreparedStatement updateCurrentStatePS;
    private boolean contractLoad = false;

    public VoiceAccountDao(Connection con, int moduleId) {
        super(con, TABLE_VOICE_ACCOUNT, TABLE_VOICE_ACCOUNT, (EntityAttrDaoSupport)new VoiceAccountEntityAttrDaoSupport(), moduleId, 0);
        this.commonDao = new VoiceCommonAccountDao(con, moduleId);
        this.accountBaseTable = "voice_account_base_" + moduleId;
        this.accountTypeTable = "voice_account_type_" + moduleId;
    }

    protected VoiceAccount getFromRS(ResultSet rs) throws SQLException, BGException {
        VoiceAccount account = new VoiceAccount();
        this.commonDao.fillFromRS(rs, (AbtractVoiceAccount)account, this.contractLoad);
        VoiceAccount.builder((VoiceAccount)account).setNumber(rs.getLong("number")).setLineCount(rs.getInt("lineCount")).setComment(rs.getString("comment")).setStatus(VoiceAccountStatus.getVoiceAccountStatus((int)rs.getInt("status"))).setDeviceState(VoiceAccountState.getVoiceAccountState((int)rs.getShort("deviceState"))).setAccessCode(rs.getInt("accessCode")).setPassword(rs.getString("password")).setLogin(rs.getString("login")).setSessionCountLimit(rs.getByte("sessionCountLimit")).setContractObjectId(rs.getInt("contractObjectId"));
        ResultSetMetaData resultSetMetaData = rs.getMetaData();
        for (int index = 1; index <= resultSetMetaData.getColumnCount(); ++index) {
            if (!resultSetMetaData.getColumnName(index).equals("entitySpecId")) continue;
            account.setEntitySpecId(rs.getInt("entitySpecId"));
            break;
        }
        account.setPortList(new VoiceAccountPortDao(this.con, this.moduleId).list(account.getId()));
        return account;
    }

    protected void updateImpl(VoiceAccount account) throws BGException, SQLException {
        boolean isNew = account.getId() <= 0;
        this.commonDao.update((AbtractVoiceAccount)account);
        String fieldPart = " SET number=?, lineCount=?, comment=?, status=?, deviceState=?, accessCode=?, password=?, login=?, sessionCountLimit=?, contractObjectId=?";
        String query = (isNew ? "INSERT INTO " : "UPDATE ") + this.tableName + fieldPart + (isNew ? ", id = ?" : " WHERE id = ?");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setLong(index++, account.getNumber());
            ps.setInt(index++, account.getLineCount());
            ps.setString(index++, account.getComment());
            ps.setInt(index++, account.getStatus().getCode());
            ps.setShort(index++, isNew ? VoiceAccountState.STATE_DELETED.getCode() : account.getDeviceState().getCode());
            ps.setInt(index++, account.getAccessCode());
            ps.setString(index++, account.getPassword());
            ps.setString(index++, account.getLogin());
            ps.setByte(index++, account.getSessionCountLimit());
            if (account.getContractObjectId() > 0) {
                ps.setInt(index++, account.getContractObjectId());
            } else {
                ps.setNull(index++, 4);
            }
            ps.setInt(index++, account.getId());
            ps.executeUpdate();
        }
    }

    public List<VoiceAccount> list(int contractId) throws BGException {
        return this.list(contractId, -1, null);
    }

    public List<VoiceAccount> list(int contractId, int deviceId, Period period) throws BGException {
        Object filter = "1 = 1 ";
        try {
            if (contractId > 0) {
                filter = (String)filter + " AND ancestor.contractId=" + contractId;
            }
            if (deviceId > 0) {
                filter = (String)filter + " AND deviceId=" + deviceId;
            }
            if (period != null) {
                filter = (String)filter + " AND (dateFrom IS NULL OR ? IS NULL OR dateFrom<=?) AND(dateTo IS NULL OR ? IS NULL OR dateTo>=?)";
            }
            ArrayList<Date> params = new ArrayList<Date>();
            if (period != null) {
                params.addAll(Arrays.asList(period.getDateTo(), period.getDateTo(), period.getDateFrom(), period.getDateFrom()));
            }
            return this.listImpl(new Page(), this.getWhat() + ", t.entitySpecId as entitySpecId", this.getJoins() + " LEFT JOIN contract c ON c.id=ancestor.contractId LEFT JOIN `" + this.accountTypeTable + "` AS t ON t.id=ancestor.typeId", (String)filter, "", params.toArray());
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    private String getWhat() {
        return "ancestor.*, " + this.tableName + ".*";
    }

    private String getJoins() {
        return " INNER JOIN " + this.getTableName("voice_account_base", this.moduleId, null) + " as ancestor  ON ancestor.id = " + this.tableName + ".id ";
    }

    public List<VoiceAccount> list() throws BGException {
        return this.list(-1, -1, null);
    }

    public List<VoiceAccount> list(String login, Date dateFrom, Date dateTo) throws BGException {
        try {
            return this.listImpl(new Page(), this.getWhat(), this.getJoins(), " login = ? AND (dateFrom is NULL OR dateFrom <= ? OR ? IS NULL) AND (dateTo is NULL OR dateTo >= ? OR ? IS NULL )", this.tableName + ".id", new Object[]{login, dateTo, dateTo, dateFrom, dateFrom});
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public void updateDeviceState(int accountId, VoiceAccountState state, int accessCode) throws BGException {
        try {
            PreparedStatement ps = this.updateCurrentStatePS;
            if (ps == null) {
                ps = this.updateCurrentStatePS = this.con.prepareStatement("UPDATE " + this.tableName + " SET deviceState=?, accessCode=? WHERE id=?");
            }
            ps.setShort(1, state.getCode());
            ps.setInt(2, accessCode);
            ps.setInt(3, accountId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<VoiceAccount> listToCreate(Date now) throws BGException {
        try {
            return this.listImpl(new Page(), this.getWhat(), this.getJoins(), "deviceState=? AND (dateFrom IS NULL OR dateFrom<=?) AND (dateTo IS NULL OR dateTo>=?) ", null, new Object[]{VoiceAccountState.STATE_DELETED.getCode(), TimeUtils.convertDateToSqlDate((Date)now), TimeUtils.convertDateToSqlDate((Date)now)});
        }
        catch (SQLException e) {
            throw new BGException((Throwable)e);
        }
    }

    public List<VoiceAccount> listToCancel(Date now) throws BGException {
        try {
            return this.listImpl(new Page(), this.getWhat(), this.getJoins(), "deviceState!=? AND (dateTo IS NOT NULL AND dateTo<?) ", null, new Object[]{VoiceAccountState.STATE_DELETED.getCode(), TimeUtils.convertDateToSqlDate((Date)now)});
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void close() throws BGException {
        super.close();
    }

    protected VoiceAccount getById(int id) throws BGException, SQLException {
        String query = "SELECT " + this.getWhat() + ", t.entitySpecId as entitySpecId FROM " + this.tableName + this.getJoins() + " LEFT JOIN `" + this.accountBaseTable + "` AS b ON b.id=" + this.tableName + ".id LEFT JOIN `" + this.accountTypeTable + "` AS t ON t.id=b.typeId WHERE " + this.tableName + ".id=?";
        PreparedStatement ps = this.getByIdPS;
        if (ps == null) {
            ps = this.getByIdPS = this.con.prepareStatement(query);
        }
        ps.setInt(1, id);
        VoiceAccount result = null;
        try (ResultSet rs = ps.executeQuery();){
            if (rs.next()) {
                result = this.getFromRS(rs);
            }
        }
        return result;
    }

    public int delete(int id) throws BGException, SQLException {
        return this.deleteImpl(id);
    }

    public void deleteList(List<Integer> ids) throws BGException, SQLException {
        for (int id : ids) {
            this.delete(id);
        }
    }

    protected int deleteImpl(int id) throws BGException, SQLException {
        this.commonDao.delete(id);
        return super.deleteImpl(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result<VoiceAccount> list(VoiceAccountSearchParam searchParam, Page page) throws Exception {
        boolean contractLoad = this.isContractLoad();
        try {
            this.setContractLoad(true);
            Object filter = " 1 = 1";
            ArrayList<Object> params = new ArrayList<Object>();
            if (!Utils.isEmptyString((String)searchParam.getLogin())) {
                filter = (String)filter + " AND login LIKE ? ";
                params.add("%" + searchParam.getLogin() + "%");
            }
            if (searchParam.getAccountId() > 0L) {
                filter = (String)filter + " AND ancestor.id=" + searchParam.getAccountId();
            }
            if (searchParam.getNumber() > 0L) {
                filter = (String)filter + " AND  CAST( number as CHAR) LIKE ? ";
                params.add("%" + searchParam.getNumber() + "%");
            }
            if (searchParam.getTypeId() > 0) {
                filter = (String)filter + " AND typeId= " + searchParam.getTypeId();
            }
            if (!Utils.isEmptyString((String)searchParam.getTitle())) {
                filter = (String)filter + " AND ancestor.title LIKE ? ";
                params.add("%" + searchParam.getTitle() + "%");
            }
            if (searchParam.getPeriod().getDateFrom() != null) {
                filter = (String)filter + " AND (dateFrom IS NULL OR dateFrom<=?) ";
                params.add(searchParam.getPeriod().getDateFrom());
            }
            if (searchParam.getPeriod().getDateTo() != null) {
                filter = (String)filter + " AND (dateTo is NULL OR dateTo >= ? )";
                params.add(searchParam.getPeriod().getDateTo());
            }
            List list = this.listImpl(page, "SQL_CALC_FOUND_ROWS " + this.getWhat() + ",contract.title AS contractTitle,  contract.comment as contractComment ", this.getJoins() + " LEFT JOIN contract on contract.id = contractId ", (String)filter, null, params.toArray());
            Result result = new Result(list, page);
            return result;
        }
        finally {
            this.setContractLoad(contractLoad);
        }
    }

    protected boolean isContractLoad() {
        return this.contractLoad;
    }

    protected void setContractLoad(boolean contractLoad) {
        this.contractLoad = contractLoad;
    }

    protected VoiceAccount getImpl(int id) throws BGException, SQLException {
        VoiceAccount voiceAccount = (VoiceAccount)super.getImpl(id);
        if (voiceAccount != null) {
            voiceAccount.setEntityAttributes(this.getEntityAttributes(voiceAccount.getEntitySpecId(), voiceAccount.getId(), false));
        }
        return voiceAccount;
    }

    protected VoiceAccount getFromRSImpl(ResultSet rs) throws SQLException, BGException {
        return null;
    }

    public void relocate(int accountId, int toContractId) throws SQLException {
        String query = "UPDATE " + this.accountBaseTable + " SET `contractId`=? WHERE `id`=?";
        try (PreparedStatement psUpdate = this.con.prepareStatement(query);){
            psUpdate.setInt(1, toContractId);
            psUpdate.setInt(2, accountId);
            psUpdate.executeUpdate();
        }
    }

    public List<Integer> voiceAccountBaseSerialize(int contractId, XMLStreamWriter xmlStreamWriter) throws SQLException, XMLStreamException {
        ResultSet rs;
        ArrayList<Integer> accountIds = new ArrayList<Integer>();
        String query = "SELECT id FROM " + this.accountBaseTable + " WHERE contractId=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            rs = ps.executeQuery();
            try {
                while (rs.next()) {
                    accountIds.add(rs.getInt("id"));
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        query = "SELECT id, contractId, dateFrom, dateTo, typeId, deviceId, title FROM " + this.accountBaseTable + " WHERE contractId=?";
        ps = this.con.prepareStatement(query, 1004, 1007);
        try {
            ps.setInt(1, contractId);
            rs = ps.executeQuery();
            try {
                new XMLDatabaseSerializer(xmlStreamWriter).addItemsFromRS(this.accountBaseTable, null, null, rs);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        return accountIds;
    }

    public void voiceAccountSerialize(List<Integer> accountIds, XMLStreamWriter xmlStreamWriter) throws SQLException, XMLStreamException {
        if (Utils.notEmptyCollection(accountIds)) {
            String query = "SELECT id, number, comment, status, login, password, contractObjectId  FROM " + this.tableName + " WHERE id IN (" + Utils.toString(accountIds) + ")";
            try (PreparedStatement ps = this.con.prepareStatement(query);
                 ResultSet rs = ps.executeQuery();){
                new XMLDatabaseSerializer(xmlStreamWriter).addItemsFromRS(this.tableName, null, null, rs);
            }
        }
    }
}

