/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.bean.code.importer;

import au.com.bytecode.opencsv.CSVReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceCostMapItem;
import ru.bitel.bgbilling.modules.voice.server.bean.code.CostMapItemReader;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class CostMapItemFullFileReader
implements CostMapItemReader {
    @Override
    public List<VoiceCostMapItem> getGeocodesFromString(String importString, String result, int costMapId, Period period) {
        ArrayList<VoiceCostMapItem> resultList = new ArrayList<VoiceCostMapItem>();
        try (CSVReader csvReader = new CSVReader((Reader)new InputStreamReader(new ByteArrayInputStream(importString.getBytes(StandardCharsets.UTF_8))), ',');){
            List inDataMg = csvReader.readAll();
            for (String[] row : inDataMg) {
                String[] cody;
                String dest = row[0].trim().replaceAll("\t", " ");
                String cost = row[2].trim().replaceAll("\t", " ").replaceAll(",", ".");
                String codyStr = row[1].trim().replaceAll("\t", " ");
                for (String cod : cody = codyStr.split(",")) {
                    VoiceCostMapItem item = new VoiceCostMapItem();
                    item.setCostMapId(costMapId);
                    item.setCode(cod.trim());
                    item.setDestinationTitle(dest);
                    item.setItemCost(Utils.parseBigDecimal((String)cost, (BigDecimal)BigDecimal.ZERO));
                    item.setDateFrom(period.getDateFrom());
                    item.setDateTo(period.getDateTo());
                    resultList.add(item);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return resultList;
    }

    @Override
    public String getTitle() {
        return "CSV-multi (<dest>,<codes>,<cost>)";
    }
}

