/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voice.server.service;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import jakarta.xml.ws.Holder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceZone;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceZoneCostMap;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceZoneMap;
import ru.bitel.bgbilling.modules.voice.common.bean.VoiceZoneMapItem;
import ru.bitel.bgbilling.modules.voice.common.service.VoiceZoneService;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceZoneCostMapDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceZoneDao;
import ru.bitel.bgbilling.modules.voice.server.bean.VoiceZoneMapDao;
import ru.bitel.bgbilling.modules.voice.server.bean.code.VoiceZoneMapItemDao;
import ru.bitel.bgbilling.modules.voice.server.bean.code.ZoneMapImportManager;
import ru.bitel.bgbilling.modules.voice.server.event.VoiceZoneMapUpdateEvent;
import ru.bitel.bgbilling.modules.voice.server.utils.VoiceUtils;
import ru.bitel.common.TreeUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Node;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.voice.common.service.VoiceZoneService")
public class VoiceZoneServiceImpl
extends AbstractService
implements VoiceZoneService {
    private VoiceZoneMapDao voiceZoneMapDao;
    private VoiceZoneCostMapDao voiceZoneCostMapDao;
    private VoiceZoneMapItemDao voiceZoneMapItemDao;

    @PostConstruct
    private void init() {
        this.voiceZoneMapDao = new VoiceZoneMapDao(this.getConnection(), this.moduleId);
        this.voiceZoneCostMapDao = new VoiceZoneCostMapDao(this.getConnection(), this.moduleId);
        this.voiceZoneMapItemDao = new VoiceZoneMapItemDao(this.getConnection(), this.moduleId);
    }

    public SearchResult<VoiceZone> searchVoiceZone(String[] sort, Page page) throws BGException {
        if (sort != null && sort.length == 0) {
            sort = new String[]{"title:0"};
        }
        SearchResult searchResult = new SearchResult(page, sort);
        return (SearchResult)this.tryReturn(() -> {
            try (VoiceZoneDao voiceZoneDao = new VoiceZoneDao(this.getConnection(), this.moduleId);){
                voiceZoneDao.searchVoiceZone((SearchResult<VoiceZone>)searchResult);
            }
            return searchResult;
        });
    }

    public List<VoiceZone> voiceZoneList() throws BGException {
        return (List)this.tryReturn(() -> {
            List list = this.context.getDirectory(VoiceZone.class, this.moduleId).list();
            Collections.sort(list, new Comparator<VoiceZone>(this){

                @Override
                public int compare(VoiceZone o1, VoiceZone o2) {
                    return o1.getTitle().compareTo(o2.getTitle());
                }
            });
            return list;
        });
    }

    public VoiceZone voiceZoneGet(int zoneId) throws BGException {
        return (VoiceZone)this.context.getDirectory(VoiceZone.class, this.moduleId).get(zoneId);
    }

    public int voiceZoneUpdate(VoiceZone zone) throws BGException {
        return (Integer)this.tryReturn(() -> {
            this.context.newDirectory(VoiceZone.class, this.moduleId).update((Id)zone);
            return zone.getId();
        });
    }

    public int voiceZoneDelete(int zoneId) throws BGException {
        return (Integer)this.tryReturn(() -> this.context.newDirectory(VoiceZone.class, this.moduleId).delete(zoneId));
    }

    public List<VoiceZoneCostMap> voiceZoneCostMapList() throws BGException {
        return (List)this.tryReturn(() -> this.voiceZoneCostMapDao.list());
    }

    public VoiceZoneCostMap voiceZoneCostMapGet(int id) throws BGException {
        return (VoiceZoneCostMap)this.tryReturn(() -> {
            VoiceZoneCostMap voiceZoneCostMap = (VoiceZoneCostMap)this.voiceZoneCostMapDao.get(id);
            voiceZoneCostMap.setCosts(this.voiceZoneCostMapDao.getCosts(id));
            return voiceZoneCostMap;
        });
    }

    public int voiceZoneCostMapUpdate(VoiceZoneCostMap voiceZoneCostMap) throws BGException {
        return (Integer)this.tryReturn(() -> {
            this.voiceZoneCostMapDao.update(voiceZoneCostMap);
            return voiceZoneCostMap.getId();
        });
    }

    public void voiceZoneCostMapDelete(int id) throws BGException {
        this.tryCall(() -> this.voiceZoneCostMapDao.delete(id));
    }

    public List<VoiceZoneMap> voiceZoneMapList() throws BGException {
        return (List)this.tryReturn(() -> this.voiceZoneMapDao.list());
    }

    public int voiceZoneMapUpdate(VoiceZoneMap zoneMap) throws BGException {
        return (Integer)this.tryReturn(() -> {
            this.voiceZoneMapDao.update(zoneMap);
            EventProcessor.getInstance().publishAfterCommit((Event)new VoiceZoneMapUpdateEvent(this.moduleId, this.userId, zoneMap.getId()));
            return zoneMap.getId();
        });
    }

    public int voiceZoneMapDelete(int zoneMapId) throws BGException {
        try {
            EventProcessor.getInstance().publishAfterCommit((Event)new VoiceZoneMapUpdateEvent(this.moduleId, this.userId, zoneMapId));
            this.voiceZoneMapItemDao.deleteByMapId(zoneMapId);
            return this.voiceZoneMapDao.delete(zoneMapId);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void voiceZoneMapItemTree(int zoneMapId, Holder<DataHandler> content) throws BGException {
        this.tryCall(() -> {
            List<VoiceZoneMapItem> zoneMapItemList = this.voiceZoneMapItemDao.list(zoneMapId);
            VoiceUtils.fillParents(zoneMapItemList);
            VoiceZoneMapItem root = new VoiceZoneMapItem();
            root.setTitle("\u0414\u0435\u0440\u0435\u0432\u043e \u043a\u043e\u0434\u043e\u0432");
            root = (VoiceZoneMapItem)TreeUtils.tree(zoneMapItemList, (Node)root);
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                 ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(root);
                oos.flush();
                final byte[] rootBytes = baos.toByteArray();
                content.value = new DataHandler(new DataSource(){

                    public OutputStream getOutputStream() throws IOException {
                        return null;
                    }

                    public String getName() {
                        return null;
                    }

                    public InputStream getInputStream() throws IOException {
                        return new ByteArrayInputStream(rootBytes);
                    }

                    public String getContentType() {
                        return null;
                    }
                });
                EventProcessor.getInstance().publishAfterCommit((Event)new VoiceZoneMapUpdateEvent(this.moduleId, this.userId, zoneMapId));
            }
        });
    }

    public VoiceZoneMapItem voiceZoneMapItemGet(int itemId) throws BGException {
        return (VoiceZoneMapItem)this.tryReturn(() -> (VoiceZoneMapItem)this.voiceZoneMapItemDao.get(itemId));
    }

    public int voiceZoneMapItemUpdate(VoiceZoneMapItem item) throws BGException {
        return (Integer)this.tryReturn(() -> {
            this.voiceZoneMapItemDao.update(item);
            EventProcessor.getInstance().publishAfterCommit((Event)new VoiceZoneMapUpdateEvent(this.moduleId, this.userId, item.getMapId()));
            return item.getId();
        });
    }

    public int voiceZoneMapItemDelete(List<Integer> itemIds) throws BGException {
        return (Integer)this.tryReturn(() -> {
            if (!itemIds.isEmpty()) {
                int itemId = (Integer)itemIds.get(0);
                VoiceZoneMapItem item = (VoiceZoneMapItem)this.voiceZoneMapItemDao.get(itemId);
                EventProcessor.getInstance().publishAfterCommit((Event)new VoiceZoneMapUpdateEvent(this.moduleId, this.userId, item.getMapId()));
            }
            for (Integer itemId : itemIds) {
                this.voiceZoneMapItemDao.delete(itemId);
            }
            return itemIds.size();
        });
    }

    public String importZoneMap(int zoneMapId, int mode, String importContent) throws BGException {
        return (String)this.tryReturn(() -> new ZoneMapImportManager(this.getConnection(), this.moduleId, this.userId).importZoneMap(zoneMapId, mode, importContent));
    }
}

