/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashSet;
import ru.bitel.bgbilling.apps.voice.accounting.mediation.proccess.VoiceTrafficRangeProcessManager;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffContext;
import ru.bitel.bgbilling.modules.voice.server.tariff.VoiceTariffWorkerContext;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.sql.ConnectionSet;

public class RangeProcessFlushingManager {
    private final Setup setup;
    private final VoiceTariffContext tariffContext;
    private final int moduleId;

    public RangeProcessFlushingManager(Setup setup, VoiceTariffContext tariffContext, int moduleId) {
        this.setup = setup;
        this.tariffContext = tariffContext;
        this.moduleId = moduleId;
    }

    public void flushMonthRangeFromDBDetail(Date month) throws SQLException, BGException {
        String tableName = ServerUtils.getModuleMonthTableName((String)"voice_tariff_traffic_range_detail", (Date)month, (int)this.moduleId);
        String query = "SELECT SUM(amount) as amount, contractId, treeNodeId, rangeKey  FROM " + tableName + " GROUP BY contractId, treeNodeId, rangeKey";
        Date nextMonth = TimeUtils.getNextMonth((Date)month);
        try (ConnectionSet connectionSet = ConnectionSet.newInstance((DefaultServerSetup)this.setup, (boolean)true);
             PreparedStatement ps = connectionSet.getConnection().prepareStatement(query);
             ResultSet rs = ps.executeQuery();
             VoiceTrafficRangeProcessManager rangeManager = new VoiceTrafficRangeProcessManager(connectionSet.getConnection(), month, nextMonth, this.moduleId, this.tariffContext.rangedTrafficManager);
             VoiceTariffWorkerContext workerContext = new VoiceTariffWorkerContext(this.setup, connectionSet, this.moduleId);){
            HashSet<Long> affectedKeys = new HashSet<Long>();
            HashSet<Long> affectedNodes = new HashSet<Long>();
            while (rs.next()) {
                long amount = rs.getLong("amount");
                int contractId = rs.getInt("contractId");
                long treeNodeId = rs.getLong("treeNodeId");
                long rangeKey = rs.getLong("rangeKey");
                rangeManager.updateRangeFromDetail(contractId, workerContext, affectedKeys, affectedNodes, amount, treeNodeId, rangeKey);
                rangeManager.deleteInvalidRangeTraffs(contractId, affectedKeys, affectedNodes);
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }
}

