/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.alfabank.server;

import bitel.billing.server.BGPaymentModule;
import bitel.billing.server.ModuleBase;
import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.contract.function.server.bean.PaymentMethod;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.modules.alfabank.common.bean.Transaction;
import ru.bitel.bgbilling.modules.alfabank.common.bean.TransactionStatus;
import ru.bitel.bgbilling.modules.alfabank.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.alfabank.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.alfabank.server.event.AlfabankAutopaymentEvent;
import ru.bitel.bgbilling.modules.alfabank.server.event.AlfabankCheckEvent;
import ru.bitel.bgbilling.modules.alfabank.server.event.worker.AlfabankAutopaymentEventWorker;
import ru.bitel.bgbilling.modules.alfabank.server.event.worker.AlfabankCheckEventWorker;
import ru.bitel.bgbilling.modules.alfabank.server.service.AlfabankServiceImpl;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.jmx.MBeanPaymentModule;

@BGPaymentModule
public class Module
extends ModuleBase
implements MBeanPaymentModule {
    private static final String[] PACKAGES = new String[]{"ru.bitel.bgbilling.modules.alfabank.server"};
    final String[] loggerName = new String[]{Module.class.getName(), TransactionManager.class.getName(), AlfabankServiceImpl.class.getName()};

    public String[] getServerPackages() {
        return PACKAGES;
    }

    public void start(Connection con, BGModule module) throws BGException {
        this.registerMBean(module);
        if (Setup.getSetup().getModuleSetup(Integer.valueOf(module.getId())).getBoolean("alfabank.event.worker", true)) {
            new AlfabankCheckEventWorker(Setup.getSetup(), module.getId());
            new AlfabankAutopaymentEventWorker(Setup.getSetup(), module.getId());
        } else {
            this.addListeners(module);
        }
    }

    private void addListeners(final BGModule module) throws BGException {
        EventProcessor.getInstance().addListener((EventListener)new EventListener<AlfabankCheckEvent>(){

            public void notify(AlfabankCheckEvent event, EventListenerContext ctx) throws Exception {
                int moduleId = module.getId();
                Connection con = ctx.getConnection();
                new TransactionManager(con, moduleId).doCheckRequest(event.getContractId(), event.isAutopaymentTransaction());
            }
        }, AlfabankCheckEvent.class);
        EventProcessor.getInstance().addListener((EventListener)new EventListener<AlfabankAutopaymentEvent>(){

            public void notify(AlfabankAutopaymentEvent event, EventListenerContext ctx) throws Exception {
                Contract contract;
                int moduleId = module.getId();
                int contractId = event.getContractId();
                Connection con = ctx.getConnection();
                AutopaymentManager autopaymentManager = new AutopaymentManager(con, moduleId);
                Autopayment autopayment = autopaymentManager.getCurrentAutopayment(contractId);
                BigDecimal sum = event.getSum();
                if (sum == null) {
                    sum = autopayment.getSum();
                }
                if (autopayment != null && autopayment.getMode().getCode() == event.getMode() && (contract = ContractDao.getContract((Connection)con, (int)contractId)) != null) {
                    HashMap<String, Object> dataMap = new HashMap<String, Object>();
                    TransactionManager transactionManager = new TransactionManager(con, moduleId);
                    Transaction transaction = transactionManager.registerOrder(contractId, contract.getTitle(), null, sum, dataMap, true, true, null);
                    String result = transactionManager.paymentOrderBinding(transaction, autopayment);
                    if (result != null) {
                        Map parameterMap = Utils.stringToPairsHash((String)result.replace("\n", ";"));
                        if ("0".equals(parameterMap.get("errorCode"))) {
                            transactionManager.doCheckRequest(contractId, true);
                        } else {
                            transaction.setStatus(TransactionStatus.ERROR.getCode());
                            transaction.setParameters((transaction.getParameters() == null ? "" : transaction.getParameters()) + result);
                            transactionManager.update(transaction);
                        }
                    }
                }
            }
        }, AlfabankAutopaymentEvent.class);
    }

    public void moduleAction(ServerContext serverContext, int moduleId, Event event) throws Exception {
        super.moduleAction(serverContext, moduleId, event);
        int contractId = event.getContractId();
        try {
            ContractDeleteEvent contractDeleteEvent;
            Connection con = serverContext.getConnection();
            if (event instanceof ContractCreateEvent) {
                ContractCreateEvent contractCreateEvent = (ContractCreateEvent)event;
                if (!contractCreateEvent.isCheck()) {
                    this.enableAutopayment(contractCreateEvent.getPattern().getData(), "alfabank", moduleId, contractId, con, serverContext.getUserId());
                }
            } else if (event instanceof ContractDeleteEvent && !(contractDeleteEvent = (ContractDeleteEvent)event).isCheck()) {
                this.removeAutopayment(moduleId, contractId, con);
            }
        }
        catch (Exception ex) {
            this.logError(ex);
        }
    }

    public List<PaymentMethod> getPaymentMethods(int moduleId) {
        ArrayList<PaymentMethod> methods = new ArrayList<PaymentMethod>();
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(moduleId));
        if (moduleSetup.getBoolean("alfabank.enable", true)) {
            if (moduleSetup.getBoolean("alfabank.sbp.enable", false)) {
                methods.add(PaymentMethod.SBP);
            }
            methods.add(PaymentMethod.CARD);
        }
        return methods;
    }

    public String[] getLoggerNames() {
        return this.loggerName;
    }
}

