/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.client.contract;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.common.BGButton;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.modules.bill.common.bean.DocTypes;
import ru.bitel.bgbilling.modules.bill.common.bean.enums.DocumentType;
import ru.bitel.bgbilling.modules.bill.common.service.BillService;

public class ContractDocTypeEditor
extends BGPanel {
    private JPanel editorPanel = new JPanel();
    private DocumentType type;
    private BGControlPanelListSelect selectList = new BGControlPanelListSelect();
    private BGControlPanelListSelect avaliableList = new BGControlPanelListSelect();

    public ContractDocTypeEditor(boolean invoice) {
        this.jbInit();
        this.editorPanel.setVisible(false);
        this.type = invoice ? DocumentType.INVOICE : DocumentType.BILL;
    }

    private void jbInit() {
        Dimension minDimension = new Dimension(400, 300);
        this.selectList.setBorder((Border)new TitledBorder("\u0412\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435"));
        this.selectList.setMinimumSize(minDimension);
        this.selectList.setPreferredSize(minDimension);
        this.avaliableList.setBorder((Border)new TitledBorder("\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u044b\u0435"));
        this.avaliableList.setMinimumSize(minDimension);
        this.avaliableList.setPreferredSize(minDimension);
        BGButton addButton = new BGButton("<");
        addButton.setColumns(5);
        addButton.addActionListener(e -> this.newItem());
        BGButton delButton = new BGButton(">");
        delButton.addActionListener(e -> this.deleteItem());
        JPanel controlPanel = new JPanel(new GridBagLayout());
        controlPanel.add(Box.createVerticalStrut(50), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        controlPanel.add((Component)addButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        controlPanel.add((Component)delButton, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        controlPanel.add(Box.createGlue(), new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.selectList, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(controlPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.avaliableList, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void setData() {
        try {
            DocTypes docTypes = ((BillService)this.getContext().getWebService(BillService.class, this.getModuleId())).documentTypes(this.getContractId(), this.type);
            this.selectList.getListModel().clear();
            docTypes.getSelectList().forEach(a -> this.selectList.getListModel().addElement(new BGUListItem(a)));
            this.avaliableList.getListModel().clear();
            docTypes.getAvaliableList().forEach(a -> this.avaliableList.getListModel().addElement(new BGUListItem(a)));
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog((Throwable)ex);
        }
    }

    public void deleteItem() {
        String selectedItems = this.selectList.getListValues();
        if (selectedItems != null && JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0423\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u044d\u043b\u0435\u043c\u0435\u043d\u0442\u044b?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
            Request request = new Request();
            request.setModule(this.module);
            request.setAction("ContractDocTypeDelete");
            request.setContractId(this.getContractId());
            request.setModuleId(this.getModuleId());
            request.setAttribute("selectedItems", selectedItems);
            if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
                this.setData();
            }
        }
    }

    public void newItem() {
        String selectedItems = this.avaliableList.getListValues();
        if (!selectedItems.isEmpty()) {
            Request request = new Request();
            request.setModuleId(this.getModuleId());
            request.setModule(this.module);
            request.setContractId(this.getContractId());
            request.setAction("ContractDocTypeAdd");
            request.setAttribute("selectedItems", selectedItems);
            if (ClientUtils.checkStatus((Document)this.getDocument(request))) {
                this.setData();
            }
        }
    }
}

