/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.action;

import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.modules.bill.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.bill.server.bean.BillDoc;
import ru.bitel.bgbilling.modules.bill.server.bean.InvoiceManager;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionInvoiceUpdatePositions
extends ActionBase {
    public void doAction() throws Exception {
        int id = this.getIntParameter("id", -1);
        String positions = this.getParameter("positions");
        int correction = this.getIntParameter("correction", -1);
        String paymentDocumentData = this.getParameter("payDoc", "");
        String identifierGovermentContract = this.getParameter("identifierGovermentContract", "");
        String shipmentDocument = this.getParameter("shipmentDocument", "");
        if (id <= 0 || this.mid <= 0) {
            throw new BGIllegalArgumentException();
        }
        try {
            BillDoc doc;
            InvoiceManager invoiceManager = new InvoiceManager(this.con, this.mid);
            Calendar closedDate = null;
            closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionInvoiceUpdatePositions", (int)this.mid, (int)this.userId);
            if (closedDate != null && (doc = invoiceManager.getBillDocInfo(id)) != null) {
                LocalDate month = LocalDate.of(doc.getYear(), doc.getMonth() + 1, 1);
                ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, (LocalDate)month, (LocalDate)month);
            }
            if ("updateNumber".equals(this.getParameter("mode"))) {
                int number = this.getIntParameter("number", -1);
                int numberInYear = this.getIntParameter("number_in_year", -1);
                int numberInMonth = this.getIntParameter("number_in_month", -1);
                int month = this.getIntParameter("mm", 0);
                int year = this.getIntParameter("yy", 0);
                Calendar date = TimeUtils.convertDateToCalendar((Date)this.getDateParameter("date", null));
                if (number <= 0 || numberInMonth <= 0 || numberInYear <= 0) {
                    throw new BGMessageException("\u041d\u043e\u043c\u0435\u0440\u0430 \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 \u043d\u0443\u043b\u044f.");
                }
                if (date == null) {
                    throw new BGMessageException("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0434\u0430\u0442\u0443 \u0432\u044b\u043f\u0438\u0441\u043a\u0438.");
                }
                invoiceManager.updateNumber(id, number, numberInYear, numberInMonth, date, month, year);
            } else {
                if (Utils.isEmptyString((String)positions)) {
                    throw new BGIllegalArgumentException();
                }
                if (correction < 0) {
                    invoiceManager.updatePositions(id, positions, identifierGovermentContract, shipmentDocument);
                } else {
                    invoiceManager.updatePositions(id, positions, correction, paymentDocumentData, identifierGovermentContract, shipmentDocument);
                }
            }
        }
        catch (Exception ex) {
            throw new BGMessageException(ex.getMessage());
        }
    }
}

