/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.client;

import bitel.billing.module.services.ServiceConfigTabbedPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.PaymentService;
import ru.bitel.bgbilling.kernel.contract.pattern.common.service.ContractPatternService;
import ru.bitel.bgbilling.kernel.module.common.service.ModuleService;
import ru.bitel.bgbilling.kernel.table.client.BGDataSourceTableModel;
import ru.bitel.bgbilling.kernel.table.common.bean.BGUTableParams;
import ru.bitel.bgbilling.modules.card.common.service.CardService;
import ru.bitel.bgbilling.modules.card.server.bean.CardSeries;
import ru.bitel.common.Utils;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.BGUComboBox;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;

public class ServiceConfigManagerSeries
extends ServiceConfigTabbedPanel {
    private BGDataSourceTableModel cardSeriesTableModel = new BGDataSourceTableModel("CardSeries");

    public ServiceConfigManagerSeries() {
        this.tryCall(() -> this.jbInit());
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.add(this.getTablePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private JPanel getTablePanel() {
        BGUTable table = new BGUTable((TableModel)this.cardSeriesTableModel);
        BGSwingUtilites.handleLDMouseClicked((Component)table, e -> this.editItem());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JScrollPane((Component)table), "Center");
        return panel;
    }

    public void setData() {
        BGUTableParams tableParams = new BGUTableParams();
        this.cardSeriesTableModel.loadData(this.getContext(), tableParams);
    }

    public void editItem() {
        this.cardSeriesTableModel.optSelectRow(Id.class).ifPresent(id -> this.startEdit(id.getId()));
    }

    public void deleteItem() {
        this.cardSeriesTableModel.optSelectRow(Id.class).ifPresent(id -> {
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u0441\u044e \u0441\u0435\u0440\u0438\u044e?", "\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435", 0) == 0) {
                this.tryCall(() -> {
                    ((CardService)this.getContext().getWebService(CardService.class)).cardSeriesDelete(id.getId());
                    this.setData();
                });
            }
        });
    }

    private void startEdit(int id) {
        new SeriesDialogEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 \u0441\u0435\u0440\u0438\u0438", new Id().setId(id)).open();
    }

    class SeriesDialogEditor
    extends BGEditorDialog<Id> {
        private BGTextField sum;
        private BGControlPanelPeriodNoB period;
        private BGUComboBox<IdTitle> paymentType;
        private BGUComboBox<IdTitle> serviceBalance;
        private BGUComboBox<IdTitle> serviceActivate;
        private BGUComboBox<IdTitle> contractPattern;

        public SeriesDialogEditor(String title, Id data) {
            super(title, (Object)data);
            this.sum = new BGTextField();
            this.period = new BGControlPanelPeriodNoB();
            this.paymentType = new BGUComboBox();
            this.serviceBalance = new BGUComboBox();
            this.serviceActivate = new BGUComboBox();
            this.contractPattern = new BGUComboBox();
        }

        public void doDialogPanel() {
            this.sum.setHorizontalAlignment(0);
            this.addFieldV("\u0421\u0443\u043c\u043c\u0430:", (JComponent)this.sum);
            this.addFieldV("\u041f\u0435\u0440\u0438\u043e\u0434:", (JComponent)this.period);
            this.addFieldV("\u0423\u0441\u043b\u0443\u0433\u0430 \u043f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0431\u0430\u043b\u0430\u043d\u0441\u0430:", (JComponent)this.serviceBalance);
            this.addFieldV("\u0422\u0438\u043f \u043f\u043b\u0430\u0442\u0435\u0436\u0430:", (JComponent)this.paymentType);
            this.addFieldV("\u0423\u0441\u043b\u0443\u0433\u0430 \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u043a\u0430\u0440\u0442\u044b:", (JComponent)this.serviceActivate);
            this.addFieldV("\u0428\u0430\u0431\u043b\u043e\u043d \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430:", (JComponent)this.contractPattern);
            this.tryCall(() -> {
                this.contractPattern.setData(((ContractPatternService)ServiceConfigManagerSeries.this.getKernelContext().getWebService(ContractPatternService.class)).contractPatterns(false));
                this.paymentType.setData(((PaymentService)ServiceConfigManagerSeries.this.getKernelContext().getWebService(PaymentService.class)).paymentTypeTitles());
                List<IdTitle> serviceItems = ((ModuleService)ServiceConfigManagerSeries.this.getKernelContext().getWebService(ModuleService.class)).serviceList(ServiceConfigManagerSeries.this.getModuleId()).stream().map(IdTitle::toIdTitle).toList();
                ArrayList<IdTitle> balanceItems = new ArrayList<IdTitle>();
                balanceItems.add(new IdTitle(-1, "\u041f\u043e\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e"));
                balanceItems.addAll(serviceItems);
                this.serviceBalance.setData(balanceItems);
                this.serviceBalance.setSelectedIndex(0);
                ArrayList<IdTitle> activateItems = new ArrayList<IdTitle>();
                activateItems.add(new IdTitle(-1, "\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430"));
                activateItems.addAll(serviceItems);
                this.serviceActivate.setData(activateItems);
                this.serviceActivate.setSelectedIndex(0);
                CardSeries cardSeries = ((CardService)ServiceConfigManagerSeries.this.getContext().getWebService(CardService.class)).cardSeriesGet(((Id)this.data).getId());
                this.sum.setText(String.valueOf(cardSeries.getCardSum()));
                this.period.setPeriod(cardSeries.getPeriod());
                ClientUtils.setComboBoxSelection(this.contractPattern, (int)cardSeries.getContractPatternId());
                ClientUtils.setComboBoxSelection(this.serviceBalance, (int)cardSeries.getServiceBalance());
                ClientUtils.setComboBoxSelection(this.serviceActivate, (int)cardSeries.getServiceActivate());
                ClientUtils.setComboBoxSelection(this.paymentType, (int)cardSeries.getPaymentTypeId());
            });
        }

        public boolean doApply() throws Exception {
            if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u0442\u0435\u043b\u044c\u043d\u043e \u0445\u043e\u0442\u0438\u0442\u0435 \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u043a\u0430\u0440\u0442\u044b \u044d\u0442\u043e\u0439 \u0441\u0435\u0440\u0438\u0438?", "\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435", 2) == 0) {
                if (Utils.isEmptyString((String)this.period.getDateString1())) {
                    ClientUtils.showErrorMessageDialog((String)"\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u043d\u0430\u0447\u0430\u043b\u043e \u043f\u0435\u0440\u0438\u043e\u0434\u0430!");
                    return false;
                }
                CardSeries cardSeries = new CardSeries().setId(((Id)this.data).getId()).setCardSum(new BigDecimal(this.sum.getText())).setPeriod(this.period.getPeriod()).setContractPatternId(((IdTitle)this.contractPattern.getSelectedItem()).getId()).setPaymentTypeId(((IdTitle)this.paymentType.getSelectedItem()).getId()).setServiceActivate(((IdTitle)this.serviceActivate.getSelectedItem()).getId()).setServiceBalance(((IdTitle)this.serviceBalance.getSelectedItem()).getId());
                ((CardService)ServiceConfigManagerSeries.this.getContext().getWebService(CardService.class)).cardSeriesUpdate(cardSeries);
                ServiceConfigManagerSeries.this.setData();
                return true;
            }
            return false;
        }
    }
}

