/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.card.server.action;

import java.util.Date;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.card.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.card.server.bean.Card;
import ru.bitel.bgbilling.modules.card.server.bean.CardDao;
import ru.bitel.bgbilling.modules.card.server.bean.CardSeriesManager;
import ru.bitel.common.Utils;

public class ActionCardLoad
extends ActionBase {
    public void doAction() throws Exception {
        int seriesId;
        CardDao cm = new CardDao(this.con, this.mid);
        int service_pay = this.getIntParameter("service_pay", -2);
        int service_activate = this.getIntParameter("service_activate", -2);
        int pid = this.getIntParameter("pid", -1);
        int pt = this.getIntParameter("pt", -1);
        int mid = this.getIntParameter("mid", -1);
        float summa = this.getFloatParameter("summa", -1.0f);
        Date date1 = this.getDateParameter("date1");
        Date date2 = this.getDateParameter("date2");
        String cards = this.getParameter("cards");
        String series = this.getParameter("series");
        if (mid > 0 && summa > 0.0f && cards != null && pid > 0 && pt > 0 && service_activate > -2 && service_pay > -2 && Utils.isBlankString((String)series)) {
            throw new BGIllegalArgumentException();
        }
        CardSeriesManager sm = new CardSeriesManager(this.con, mid);
        try {
            seriesId = sm.addSeries(series);
        }
        catch (BGException e) {
            throw new BGException(e.getMessage());
        }
        StringTokenizer st = new StringTokenizer(cards, "\n");
        StringBuffer report = new StringBuffer();
        StringBuffer errorData = new StringBuffer();
        int lines = 0;
        int errorsCount = 0;
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            StringTokenizer card_data = new StringTokenizer(line, "\t");
            if (card_data.countTokens() == 3) {
                long id = Utils.parseLong((String)card_data.nextToken(), (long)-1L);
                long card_code = Utils.parseLong((String)card_data.nextToken(), (long)-1L);
                String card_pin = card_data.nextToken();
                if (id > 0L && card_code > 0L && card_pin != null) {
                    Card card = new Card();
                    card.setId(id);
                    card.setSeriesId(seriesId);
                    card.setCardCode(card_code);
                    card.setCardPinCode(card_pin);
                    card.setStatus(0);
                    card.setDateBegin(date1);
                    card.setDateEnd(date2);
                    card.setSumma(summa);
                    card.setPatternId(pid);
                    card.setServicePayId(service_pay);
                    card.setServiceActivateId(service_activate);
                    card.setPaymentType(pt);
                    String error = null;
                    error = cm.checkCard(card);
                    if (error != null) {
                        errorData.append(error);
                        errorData.append("; \u0441\u0442\u0440\u043e\u043a\u0430: ");
                        errorData.append(line);
                        errorData.append("%");
                        ++errorsCount;
                    } else {
                        error = cm.addCard(this.con, card);
                        if (error != null) {
                            errorData.append(error);
                            errorData.append("; \u0441\u0442\u0440\u043e\u043a\u0430: ");
                            errorData.append(line);
                            errorData.append("%");
                            ++errorsCount;
                        }
                    }
                } else {
                    errorData.append("\u0421\u0435\u0440\u0438\u0439\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0438 \u043a\u043e\u0434 \u043a\u0430\u0440\u0442\u044b \u0434\u043e\u043b\u0436\u043d\u044b \u0431\u044b\u0442\u044c \u0446\u0435\u043b\u044b\u043c \u043f\u043e\u043b\u043e\u0436\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u043c \u0447\u0438\u0441\u043b\u043e\u043c: '" + line + "%");
                    ++errorsCount;
                }
            } else {
                errorData.append("\u0421\u0442\u0440\u043e\u043a\u0430 \"" + line + "\" \u0438\u043c\u0435\u0435\u0442 \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442!%");
                ++errorsCount;
            }
            ++lines;
        }
        sm.updateSeriesFree(seriesId);
        Element errorDataElement = this.createElement(this.rootNode, "errorData");
        errorDataElement.setAttribute("data", errorData.toString());
        report.append("\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430.%");
        report.append("\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043e \u0441\u0442\u0440\u043e\u043a => ");
        report.append(String.valueOf(lines) + "%");
        report.append("\u0417\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043e => " + String.valueOf(lines - errorsCount) + "%");
        report.append("\u041e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0445 \u0441\u0442\u0440\u043e\u043a => " + errorsCount);
        this.setMsg(report.toString());
    }
}

