/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.cashcheck.frk.utils;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;

public class BGCfg {
    private Map<String, Object> _values = new HashMap<String, Object>();
    private int charCount = 0;
    private int col = 0;
    private int row = 1;
    private int depth = 0;

    public BGCfg(Reader source) throws Exception {
        this.parse(source, this._values);
    }

    private int readChar(Reader source) throws IOException {
        int ch;
        do {
            ch = source.read();
            ++this.charCount;
            ++this.col;
        } while (ch == 13);
        if (ch == 10) {
            this.col = 0;
            ++this.row;
        }
        return ch;
    }

    private void readToLn(Reader source) throws IOException {
        int ch = -1;
        while ((ch = this.readChar(source)) != -1 && ch != 10) {
        }
    }

    private void parse(Reader source, Map<String, Object> localValues) throws Exception {
        StringBuilder bufferKey = new StringBuilder();
        StringBuilder bufferValue = new StringBuilder();
        States currState = States.WAIT_KEY;
        block7: while (true) {
            int ch = this.readChar(source);
            switch (currState.ordinal()) {
                case 0: {
                    if (ch == -1) {
                        if (this.depth != 0) {
                            throw new CfgParseException(ch, currState, bufferKey, bufferValue);
                        }
                        return;
                    }
                    if (ch == 125) {
                        --this.depth;
                        return;
                    }
                    if (ch == 35) {
                        this.readToLn(source);
                        break;
                    }
                    if (Character.isWhitespace(ch)) continue block7;
                    if (Character.isJavaIdentifierStart(ch)) {
                        bufferKey.setLength(0);
                        bufferKey.append((char)ch);
                        currState = States.KEY;
                        bufferValue.setLength(0);
                        break;
                    }
                    throw new CfgParseException(ch, currState, bufferKey, bufferValue);
                }
                case 1: {
                    if (ch == -1) {
                        throw new CfgParseException(ch, currState, bufferKey, bufferValue);
                    }
                    if (Character.isJavaIdentifierPart(ch) || ch == 46) {
                        bufferKey.append((char)ch);
                        break;
                    }
                    if (ch == 58) {
                        currState = States.WAIT_VALUE;
                        break;
                    }
                    currState = States.WAIT_COLON;
                    break;
                }
                case 2: {
                    if (ch == -1) {
                        throw new CfgParseException(ch, currState, bufferKey, bufferValue);
                    }
                    if (ch == 58) {
                        currState = States.WAIT_VALUE;
                        break;
                    }
                    if (ch == 10 || Character.isSpaceChar(ch)) continue block7;
                    if (ch == 35) {
                        this.readToLn(source);
                        break;
                    }
                    throw new CfgParseException(ch, currState, bufferKey, bufferValue);
                }
                case 3: {
                    if (ch == -1) {
                        throw new CfgParseException(ch, currState, bufferKey, bufferValue);
                    }
                    if (ch == 10 || Character.isSpaceChar(ch)) continue block7;
                    if (ch == 35) {
                        this.readToLn(source);
                        break;
                    }
                    if (ch == 123) {
                        currState = States.WAIT_KEY;
                        ++this.depth;
                        HashMap<String, Object> newValues = new HashMap<String, Object>();
                        this.parse(source, newValues);
                        localValues.put(bufferKey.toString(), newValues);
                        break;
                    }
                    currState = States.VALUE;
                    bufferValue.setLength(0);
                    bufferValue.append((char)ch);
                    break;
                }
                case 4: {
                    if (ch == -1 || ch == 10) {
                        localValues.put(bufferKey.toString(), bufferValue.toString());
                        currState = States.WAIT_KEY;
                        break;
                    }
                    bufferValue.append((char)ch);
                }
            }
        }
    }

    public Map<String, Object> getMap(String ... keyset) {
        Map ret = this._values;
        for (String key : keyset) {
            Object value = ret.get(key);
            if (value == null || !(value instanceof Map)) {
                return null;
            }
            ret = (Map)value;
        }
        return ret;
    }

    public String getString(String ... keyset) {
        String ret = null;
        if (keyset.length > 0) {
            Object value;
            String[] keyset1 = new String[keyset.length - 1];
            System.arraycopy(keyset, 0, keyset1, 0, keyset.length - 1);
            Map<String, Object> map = this.getMap(keyset1);
            if (map != null && (value = map.get(keyset[keyset.length - 1])) != null && value instanceof String) {
                ret = (String)value;
            }
        }
        return ret;
    }

    static enum States {
        WAIT_KEY,
        KEY,
        WAIT_COLON,
        WAIT_VALUE,
        VALUE;

    }

    class CfgParseException
    extends Exception {
        public CfgParseException(int ch, States currState, StringBuilder bufferKey, StringBuilder bufferValue) {
            super("error parse symbol '" + String.valueOf(ch != -1 ? Character.valueOf((char)ch) : "EOF") + "' (" + ch + "), position: " + BGCfg.this.charCount + " (row: " + BGCfg.this.row + ", col: " + BGCfg.this.col + "), state: " + currState.toString() + ", depth: " + BGCfg.this.depth + ", keyvalue: '" + bufferKey.toString() + "'->'" + bufferValue.toString() + "'");
        }
    }
}

