/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cashcheck.server;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.BGNotImplementedException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTask;
import ru.bitel.bgbilling.kernel.task.server.bean.RunTaskDataManager;
import ru.bitel.bgbilling.plugins.cashcheck.common.BGPrinterNotloggedMessageException;
import ru.bitel.bgbilling.plugins.cashcheck.common.CashcheckService;
import ru.bitel.bgbilling.plugins.cashcheck.common.Check;
import ru.bitel.bgbilling.plugins.cashcheck.common.Payment;
import ru.bitel.bgbilling.plugins.cashcheck.common.PrintCheckData;
import ru.bitel.bgbilling.plugins.cashcheck.common.Printer;
import ru.bitel.bgbilling.plugins.cashcheck.server.CashCheckUtils;
import ru.bitel.bgbilling.plugins.cashcheck.server.CheckMaker;
import ru.bitel.bgbilling.plugins.cashcheck.server.bean.Check;
import ru.bitel.bgbilling.plugins.cashcheck.server.bean.PaymentQueueManager;
import ru.bitel.bgbilling.plugins.cashcheck.server.bean.PrinterManager;
import ru.bitel.bgbilling.plugins.cashcheck.server.fisc.CheckPrintResult;
import ru.bitel.bgbilling.plugins.cashcheck.server.fisc.Fiscalizator;
import ru.bitel.bgbilling.plugins.cashcheck.server.task.AdvancePaymentsManual;
import ru.bitel.bgbilling.plugins.cashcheck.server.task.AutoprintAutoBatch;
import ru.bitel.bgbilling.plugins.cashcheck.server.task.AutoprintReprintAsIsBatch;
import ru.bitel.bgbilling.plugins.cashcheck.server.task.AutoprintReprintAutoBatch;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.Result;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.cashcheck.common.CashcheckService")
@XmlSeeAlso(value={Id.class, IdTitle.class, Payment.class, ArrayList.class, Printer.class})
public class CashcheckServiceImpl
extends AbstractService
implements CashcheckService {
    private BGPluginServer plugin = null;
    private PaymentQueueManager paymentQueueManager = null;

    @PostConstruct
    public void init() {
        this.plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.cashcheck");
        this.paymentQueueManager = new PaymentQueueManager(this.getConnection());
    }

    private static void doHelloPrinter(Printer printer, String password, boolean setErrorStatus) throws BGException {
        block2: {
            StringBuffer textString = new StringBuffer(1024);
            textString.append("\u0414\u043e\u0431\u0440\u043e \u043f\u043e\u0436\u0430\u043b\u043e\u0432\u0430\u0442\u044c!").append("\n");
            textString.append("\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440 #").append(printer.getId()).append("\n");
            textString.append("(").append(printer.getTitle()).append(")\n\n");
            textString.append("!CUT%)");
            try {
                printer.fiscalize().printtext(password, textString.toString());
            }
            catch (BGException e) {
                if (!setErrorStatus) break block2;
                throw e;
            }
        }
    }

    private String getRegistratorName() {
        int registratorId = PrinterManager.getCurrentRegistratorId();
        if (registratorId == 0) {
            return "~\u043d\u0435 \u0432\u044b\u0431\u0440\u0430\u043d~";
        }
        try {
            return PrinterManager.getPrinter(registratorId).getTitle();
        }
        catch (BGException e) {
            return "~" + e.getMessage() + "~";
        }
    }

    public void bindPrinter(int registratorId, String password) throws BGException {
        PrinterManager.setCurrentRegistrator(0, null);
        if (registratorId == 0) {
            return;
        }
        Printer printer = PrinterManager.getPrinter(registratorId);
        printer.fiscalize().status(password);
        PrinterManager.setCurrentRegistrator(registratorId, password);
        if (!this.plugin.getSetup().getBoolean("disable.login.hello", false)) {
            CashcheckServiceImpl.doHelloPrinter(printer, password, false);
        }
    }

    public void buzzer() throws BGException {
        Printer printer = PrinterManager.getPrinter();
        String oppass = PrinterManager.getCurrentRegistratorPassword();
        printer.fiscalize().buzzer(oppass);
    }

    public void cancelCheck() throws BGException {
        Printer printer = PrinterManager.getPrinter();
        String oppass = PrinterManager.getCurrentRegistratorPassword();
        printer.fiscalize().cancelcheck(oppass);
    }

    public void continuePrint() throws BGException {
        Printer printer = PrinterManager.getPrinter();
        String oppass = PrinterManager.getCurrentRegistratorPassword();
        printer.fiscalize().continueprint(oppass);
    }

    public void divReport() throws BGException {
        Printer printer = PrinterManager.getPrinter();
        String adminpass = PrinterManager.getCurrentRegistratorPassword();
        printer.fiscalize().divreport(adminpass);
    }

    public void openDay() throws BGException {
        Printer printer = PrinterManager.getPrinter();
        String adminpass = PrinterManager.getCurrentRegistratorPassword();
        printer.fiscalize().openday(adminpass);
    }

    public String getCurrentPrinter() throws BGException {
        return this.getRegistratorName();
    }

    private void formatPtCh(Printer printer, StringBuffer statusString, List<Integer> listPtCh, Map<Integer, PrinterManager.PaymentMapping> ptchMap) {
        if (listPtCh != null) {
            for (Integer ptch : listPtCh) {
                PrinterManager.PaymentMapping paymentMapping = ptchMap.get(ptch);
                statusString.append("#").append(ptch);
                if (paymentMapping.print != PrinterManager.PaymentPrintMode.manual) {
                    statusString.append("(").append((Object)paymentMapping.print).append(")");
                }
                StringBuffer otherReg = new StringBuffer(1024);
                for (Integer i : paymentMapping.fr) {
                    if (i.intValue() == printer.getId()) continue;
                    otherReg.append(" #").append(i);
                }
                if (otherReg.length() > 0) {
                    statusString.append(" (\u0415\u0449\u0451 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d \u043d\u0430 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u044b:").append(otherReg).append(")");
                }
                statusString.append("\n");
            }
        } else {
            statusString.append("\u043d\u0435 \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u044b\n");
        }
    }

    public String getRegistratorStatus() throws BGException {
        String resultstatus = null;
        Printer printer = PrinterManager.getPrinter();
        StringBuffer statusString = new StringBuffer(10240);
        statusString.append("\u0420\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440 #").append(printer.getId()).append("\n\n");
        String oppass = PrinterManager.getCurrentRegistratorPassword();
        Fiscalizator fiscalize = printer.fiscalize();
        statusString.append("\u0423\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u043e (\u0434\u0440\u0430\u0439\u0432\u0435\u0440/\u0444\u0438\u0441\u043a\u0430\u043b\u0438\u0437\u0430\u0442\u043e\u0440):\n");
        try {
            String name = fiscalize.name(oppass);
            statusString.append(name).append("\n\n");
        }
        catch (BGException e) {
            statusString.append("ERROR: ").append(e.getMessage()).append("\n\n");
        }
        statusString.append("\u0424\u0438\u0441\u043a\u0430\u043b\u0438\u0437\u0430\u0442\u043e\u0440:\n");
        statusString.append(printer.getFiscalizatorType()).append("\n\n");
        List<Integer> listPt = PrinterManager.getRegistratorPtMap().get(printer.getId());
        statusString.append("\u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u044b \u0442\u0438\u043f\u044b \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439:\n");
        this.formatPtCh(printer, statusString, listPt, PrinterManager.getPtMap());
        List<Integer> listCh = PrinterManager.getRegistratorChMap().get(printer.getId());
        statusString.append("\n\u041d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u044b \u0442\u0438\u043f\u044b \u0440\u0430\u0441\u0445\u043e\u0434\u043e\u0432:\n");
        this.formatPtCh(printer, statusString, listCh, PrinterManager.getChMap());
        if (printer.isHidden()) {
            statusString.append("\n").append("\u041f\u0440\u0438\u043d\u0442\u0435\u0440 \u0421\u041a\u0420\u042b\u0422\u042b\u0419").append("\n");
        }
        if (printer.isAutoclose()) {
            statusString.append("\n").append("\u041d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u043e \u0410\u0412\u0422\u041e\u0417\u0410\u041a\u0420\u042b\u0422\u0418\u0415 \u0414\u041d\u042f").append("\n");
        }
        statusString.append("\n");
        statusString.append("\u0421\u0442\u0430\u0442\u0443\u0441 (\u0434\u0440\u0430\u0439\u0432\u0435\u0440/\u0444\u0438\u0441\u043a\u0430\u043b\u0438\u0437\u0430\u0442\u043e\u0440):\n");
        try {
            String status = fiscalize.status(oppass);
            statusString.append(status).append("\n\n");
        }
        catch (BGException e) {
            statusString.append("ERROR: ").append(e.getMessage()).append("\n\n");
        }
        statusString.append("\u0421\u0442\u0430\u0442\u0443\u0441 \u0441\u0435\u0440\u0432\u0435\u0440\u0430/\u0444\u0438\u0441\u043a\u0430\u043b\u0438\u0437\u0430\u0442\u043e\u0440\u0430:\n");
        statusString.append(fiscalize.getFiscalizatorStatus());
        resultstatus = statusString.toString();
        return resultstatus;
    }

    public void helloPrinter(int registratorId, String password) throws BGException {
        Printer printer = PrinterManager.getPrinter(registratorId);
        if (Utils.isBlankString((String)password) && Utils.isBlankString((String)(password = PrinterManager.getCurrentRegistratorPassword()))) {
            throw new BGMessageException("\u041e\u0448\u0438\u0431\u043a\u0430! \u0414\u043b\u044f \u043f\u0440\u0438\u0432\u0435\u0442\u0430 \u043d\u0443\u0436\u043d\u043e \u0432\u0432\u0435\u0441\u0442\u0438 \u043f\u0430\u0440\u043e\u043b\u044c (\u043b\u0438\u0431\u043e \u0432\u043e\u0439\u0442\u0438 \u043f\u0435\u0440\u0435\u0434 \u044d\u0442\u0438\u043c \u043d\u0430 \u043f\u0440\u0438\u043d\u0442\u0435\u0440)");
        }
        printer.fiscalize().status(password);
        CashcheckServiceImpl.doHelloPrinter(printer, password, true);
    }

    public PrintCheckData printCheck(List<Integer> paymentIds, BigDecimal clientsumma) throws BGException {
        PrintCheckData rootNode = new PrintCheckData();
        Printer printer = PrinterManager.getPrinter();
        if (paymentIds == null || paymentIds.isEmpty()) {
            throw new BGIllegalArgumentException();
        }
        List<Payment> payments = this.paymentQueueManager.getPaymentNotLogList(paymentIds);
        if (paymentIds.size() != payments.size()) {
            throw new BGException("\u041e\u0434\u043d\u043e\u0433\u043e \u0438\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 ##" + Utils.toString(paymentIds) + " \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.\n\u0411\u044b\u043b \u0443\u0434\u0430\u043b\u0451\u043d? \u041f\u0440\u043e\u043f\u0430\u043b \u0438\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u044b contract_payment? \u0418\u043b\u0438 \u043f\u0440\u043e\u0441\u0442\u043e \u043e\u0448\u0438\u0431\u043a\u0430...");
        }
        int findCidFirst = -1;
        HashSet<Integer> findCids = new HashSet<Integer>();
        Map<Integer, PrinterManager.PaymentMapping> ptMap = PrinterManager.getPtMap();
        HashSet<String> findCheckbuilderAll = new HashSet<String>();
        for (Payment payment : payments) {
            if (payment.getLogDate() != null) {
                Object additionalInfo = "\u041f\u043e \u0432\u0441\u0435\u0439 \u0432\u0438\u0434\u0438\u043c\u043e\u0441\u0442\u0438, \u043e\u043d \u0443\u0436\u0435 \u0431\u044b\u043b \u043d\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u043d.";
                if (!"manual".equals(payment.getPosMapping())) {
                    additionalInfo = (String)additionalInfo + "\n\u0418 \u043c\u0430\u043f\u043f\u0438\u043d\u0433 \u043d\u0435 manual (" + payment.getPosMapping() + ").";
                }
                if (Utils.notBlankString((String)payment.getLastError())) {
                    additionalInfo = (String)additionalInfo + "\n\u0418 \u0447\u0435\u043a \u0431\u044b\u043b \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0439.";
                }
                throw new BGMessageException("\u041f\u043b\u0430\u0442\u0435\u0436 #" + payment.getPaymentId() + "(log-id #" + payment.getLogId() + ") \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442\u0441\u044f \u0432 \u043b\u043e\u0433\u0435, \u043f\u0435\u0447\u0430\u0442\u044c \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430.\n" + (String)additionalInfo);
            }
            int ptID = payment.getPaymentTypeId();
            this.checkManualMappingForType(printer, 0, ptID);
            if (ptMap.containsKey(ptID)) {
                PrinterManager.PaymentMapping paymentMapping = ptMap.get(ptID);
                findCheckbuilderAll.add(paymentMapping.checkbuilder);
            }
            findCids.add(payment.getContractId());
            if (findCidFirst == -1) {
                findCidFirst = payment.getContractId();
                continue;
            }
            if (findCidFirst == payment.getContractId()) continue;
            try (ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);){
                if (contractDao.isSubContract(findCidFirst, payment.getContractId())) continue;
                throw new BGMessageException("\u041c\u043e\u0436\u043d\u043e \u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0432 \u043e\u0434\u0438\u043d \u0447\u0435\u043a \u043f\u043b\u0430\u0442\u0435\u0436\u0438 \u043e\u0434\u043d\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0433\u043e\u0440\u0430, \u043b\u0438\u0431\u043e \u0437\u0430\u0432\u0438\u0441\u0438\u043c\u044b\u0445 \u0434\u0440\u0443\u0433 \u043e\u0442 \u0434\u0440\u0443\u0433\u0430.\n\u041d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, \u043f\u043b\u0430\u0442\u0451\u0436 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 '" + payment.getContractTitle() + "' \u043c\u043e\u0436\u043d\u043e \u0440\u0430\u0441\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0441\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u043c \u0447\u0435\u043a\u043e\u043c.");
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
        if (findCheckbuilderAll.size() != 1) {
            throw new BGMessageException("\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e, \u0447\u0442\u043e \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u044b \u0440\u0430\u0437\u043d\u044b\u0435 checkbuilder \u043d\u0430 \u0440\u0430\u0437\u043d\u044b\u0435 \u043f\u043b\u0430\u0442\u0435\u0436\u0438, \u043f\u043e\u043f\u0430\u0434\u0430\u044e\u0449\u0438\u0439 \u0432 \u043e\u0434\u0438\u043d \u0447\u0435\u043a");
        }
        String checkBuilderClass = (String)findCheckbuilderAll.iterator().next();
        if (checkBuilderClass == null && (checkBuilderClass = printer.getCheckbuilder()) == null && (checkBuilderClass = this.plugin.getSetup().get("checkbuilder")) == null) {
            throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0448\u0430\u0431\u043b\u043e\u043d \u0447\u0435\u043a\u0430");
        }
        CheckMaker dynCheckBuilder = null;
        try {
            dynCheckBuilder = (CheckMaker)DynamicClassManager.getInstance().newInstance(CheckMaker.class, checkBuilderClass);
            dynCheckBuilder.init(this.getSetup(), this.getConnection(), this.getSlaveConnection());
        }
        catch (Exception e) {
            throw new BGException("error checkbuilder class", (Throwable)e);
        }
        Check check = new Check(Check.Type.PAYMENT);
        for (Payment payment : payments) {
            dynCheckBuilder.addPayment(payment, check, printer);
        }
        dynCheckBuilder.endCreate(findCids, check, printer);
        if (clientsumma == null) {
            clientsumma = check.getPaymentsum();
        }
        String oppass = PrinterManager.getCurrentRegistratorPassword();
        CheckPrintResult result = printer.fiscalize().check(oppass, clientsumma, check);
        Object submit = result.change;
        String pendingId = null;
        if (printer.fiscalize().isAsynchronous()) {
            pendingId = result.checkId;
            submit = "\u0427\u0435\u043a \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d, \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043f\u0435\u0447\u0430\u0442\u0438 \u0431\u0443\u0434\u0435\u0442 \u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d \u043f\u043e\u0437\u0434\u043d\u0435\u0435, id: " + pendingId;
        }
        rootNode.submit = submit;
        rootNode.summa = check.getPaymentsum().toPlainString();
        for (Payment payment : payments) {
            this.paymentQueueManager.updatePaymentLog(payment.getPaymentId(), printer.getId(), check.getCheckData(), check.getCheckType(), PrinterManager.PaymentPrintMode.manual.name(), null, pendingId, payment.getContractId(), result.data, null);
        }
        return rootNode;
    }

    public void printText(String text) throws BGException {
        Printer printer = PrinterManager.getPrinter();
        String oppass = PrinterManager.getCurrentRegistratorPassword();
        printer.fiscalize().printtext(oppass, text);
    }

    public Result<Payment> queueTable(Period period, Page page, int printerId, int checkType) throws BGException {
        int registratorId = printerId > 0 ? printerId : PrinterManager.getCurrentRegistratorId();
        Result<Payment> paymentResult = null;
        if (checkType == Payment.IS_PAYMENT) {
            List paytypes = PrinterManager.getRegistratorPtMap().getOrDefault(registratorId, new ArrayList());
            paymentResult = this.paymentQueueManager.getPaymentQueue(period, paytypes, page);
        } else if (checkType == Payment.IS_CHARGE) {
            List chatypes = PrinterManager.getRegistratorChMap().getOrDefault(registratorId, new ArrayList());
            paymentResult = this.paymentQueueManager.getChargeQueue(period, chatypes, page);
        } else {
            throw new IllegalArgumentException();
        }
        paymentResult.setAttribute("registratorBindedName", (Object)this.getRegistratorName());
        paymentResult.setAttribute("registratorId", (Object)PrinterManager.getCurrentRegistratorId());
        paymentResult.setAttribute("fiscalStart", (Object)this.plugin.getSetup().getLocalDate("fiscal.start", null));
        return paymentResult;
    }

    public Result<IdTitle> registratorList() throws BGException {
        Result rootNode = new Result(PrinterManager.getPrinters().stream().filter(printer -> !printer.isHidden()).map(p -> new IdTitle(p.getId(), p.getTitle())).collect(Collectors.toList()), null);
        rootNode.setAttribute("registratorId", (Object)PrinterManager.getCurrentRegistratorId());
        return rootNode;
    }

    public void repeatCheck() throws BGException {
        Printer printer = PrinterManager.getPrinter();
        String oppass = PrinterManager.getCurrentRegistratorPassword();
        printer.fiscalize().repeatcheck(oppass);
    }

    public PrintCheckData returnCheckCharge(final int chargeId) throws BGPrinterNotloggedMessageException, BGMessageException, BGException {
        PrintCheckData rootNode = new PrintCheckData();
        Printer printer = PrinterManager.getPrinter();
        if (chargeId <= 0) {
            throw new BGIllegalArgumentException();
        }
        List<Payment> charges = this.paymentQueueManager.getChargesList((List<Integer>)new ArrayList<Integer>(){
            {
                this.add(chargeId);
            }
        });
        if (1 != charges.size()) {
            throw new BGException("\u0420\u0430\u0441\u0445\u043e\u0434\u0430/\u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 #" + chargeId + " \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.\n\u0411\u044b\u043b \u0443\u0434\u0430\u043b\u0451\u043d? \u041f\u0440\u043e\u043f\u0430\u043b \u0438\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u044b contract_charge? \u0418\u043b\u0438 \u043f\u0440\u043e\u0441\u0442\u043e \u043e\u0448\u0438\u0431\u043a\u0430...");
        }
        Map<Integer, PrinterManager.PaymentMapping> chMap = PrinterManager.getChMap();
        Payment charge0 = charges.get(0);
        if (charge0.getLogDate() != null) {
            Object additionalInfo = "\u041f\u043e \u0432\u0441\u0435\u0439 \u0432\u0438\u0434\u0438\u043c\u043e\u0441\u0442\u0438, \u043e\u043d \u0443\u0436\u0435 \u0431\u044b\u043b \u043d\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u043d.";
            if (!"manual".equals(charge0.getPosMapping())) {
                additionalInfo = (String)additionalInfo + "\n\u0418 \u043c\u0430\u043f\u043f\u0438\u043d\u0433 \u043d\u0435 manual (" + charge0.getPosMapping() + ").";
            }
            if (Utils.notBlankString((String)charge0.getLastError())) {
                additionalInfo = (String)additionalInfo + "\n\u0418 \u0447\u0435\u043a \u0431\u044b\u043b \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0439.";
            }
            throw new BGMessageException("\u0420\u0430\u0441\u0445\u043e\u0434/\u0432\u043e\u0437\u0432\u0440\u0430\u0442 #" + chargeId + "(log-id #" + charge0.getLogId() + ") \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442\u0441\u044f \u0432 \u043b\u043e\u0433\u0435, \u043f\u0435\u0447\u0430\u0442\u044c \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430.\n" + (String)additionalInfo);
        }
        int chID = charge0.getPaymentTypeId();
        this.checkManualMappingForType(printer, 1, chID);
        int findCidFirst = charge0.getContractId();
        String checkBuilderClass = chMap.get((Object)Integer.valueOf((int)chID)).checkbuilder;
        if (checkBuilderClass == null && (checkBuilderClass = printer.getCheckbuilder()) == null) {
            checkBuilderClass = this.plugin.getSetup().get("checkbuilder");
        }
        CheckMaker dynCheckBuilder = null;
        if (checkBuilderClass != null) {
            try {
                dynCheckBuilder = (CheckMaker)DynamicClassManager.getInstance().newInstance(CheckMaker.class, checkBuilderClass);
                dynCheckBuilder.init(this.getSetup(), this.getConnection(), this.getSlaveConnection());
            }
            catch (Exception e) {
                throw new BGException("error checkbuilder class", (Throwable)e);
            }
        } else {
            throw new BGMessageException("\u0414\u043b\u044f \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0430 \u043d\u0443\u0436\u0435\u043d \u0434\u0438\u043d.\u043a\u043e\u0434 (checkbuilder) \u0447\u0435\u0440\u0435\u0437 CheckMaker");
        }
        Check check = new Check(Check.Type.PAYMENTREFUND);
        dynCheckBuilder.addPaymentRefund(charge0, check, printer);
        dynCheckBuilder.endCreateRefund(findCidFirst, check, printer);
        BigDecimal clientsumma = BigDecimal.ZERO;
        String oppass = PrinterManager.getCurrentRegistratorPassword();
        CheckPrintResult result = printer.fiscalize().checkreturn(oppass, clientsumma, check);
        Object submit = result.change;
        String pendingId = null;
        if (printer.fiscalize().isAsynchronous()) {
            pendingId = result.checkId;
            submit = "\u0427\u0435\u043a \u043e\u0442\u043f\u0440\u0430\u0432\u043b\u0435\u043d, \u0440\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 \u043f\u0435\u0447\u0430\u0442\u0438 \u0431\u0443\u0434\u0435\u0442 \u0438\u0437\u0432\u0435\u0441\u0442\u0435\u043d \u043f\u043e\u0437\u0434\u043d\u0435\u0435, id: " + pendingId;
        }
        rootNode.submit = submit;
        rootNode.summa = check.getPaymentsum().toPlainString();
        this.paymentQueueManager.updateChargeLog(charge0.getPaymentId(), printer.getId(), check.getCheckData(), check.getCheckType(), PrinterManager.PaymentPrintMode.manual.name(), null, pendingId, charges.get(0).getContractId(), result.data, null);
        return rootNode;
    }

    public String sendPureCommand(String hexdump) throws BGException {
        String ret = null;
        Printer printer = PrinterManager.getPrinter();
        String pass = PrinterManager.getCurrentRegistratorPassword();
        ret = printer.fiscalize().purecommand(pass, hexdump);
        return ret;
    }

    public void XReport() throws BGException {
        Printer printer = PrinterManager.getPrinter();
        String adminpass = PrinterManager.getCurrentRegistratorPassword();
        printer.fiscalize().xreport(adminpass);
    }

    public void ZReport() throws BGException {
        Printer printer = PrinterManager.getPrinter();
        String adminpass = PrinterManager.getCurrentRegistratorPassword();
        printer.fiscalize().zreport(adminpass);
    }

    public Result<Payment> logTable(Set<Integer> cids, int printerId, int checkType, Boolean erroredType, String posMapping, Period period, Page page) throws BGException {
        if (checkType == Payment.IS_PAYMENT) {
            return this.paymentQueueManager.getPaymentLog(cids, printerId, erroredType, posMapping, period, page, null);
        }
        if (checkType == Payment.IS_CHARGE) {
            return this.paymentQueueManager.getChargeLog(cids, printerId, erroredType, posMapping, period, page, null);
        }
        throw new IllegalArgumentException();
    }

    public List<Integer> logTableOnlyId(Set<Integer> cids, int printerId, int checkType, Boolean erroredType, String posMapping, Period period) throws BGException {
        if (checkType == Payment.IS_PAYMENT) {
            Result<Payment> payments = this.paymentQueueManager.getPaymentLog(cids, printerId, erroredType, posMapping, period, null, null);
            return payments.getList().stream().map(p -> p.getLogId()).collect(Collectors.toList());
        }
        throw new IllegalArgumentException();
    }

    public String printCheckBatchAuto(List<Integer> paymentIds) throws BGMessageException, BGException {
        List<Payment> payments = this.paymentQueueManager.getPaymentNotLogList(paymentIds);
        if (paymentIds.size() != payments.size()) {
            throw new BGException("\u041e\u0434\u043d\u043e\u0433\u043e \u0438\u0437 \u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439 ##" + Utils.toString(paymentIds) + " \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.\n\u0411\u044b\u043b \u0443\u0434\u0430\u043b\u0451\u043d? \u041f\u0440\u043e\u043f\u0430\u043b \u0438\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u044b contract_payment? \u0418\u043b\u0438 \u043f\u0440\u043e\u0441\u0442\u043e \u043e\u0448\u0438\u0431\u043a\u0430...");
        }
        Map<Integer, PrinterManager.PaymentMapping> ptMap = PrinterManager.getPtMap();
        for (Payment payment : payments) {
            if (payment.getLogDate() != null) {
                throw new BGMessageException("\u041f\u043b\u0430\u0442\u0435\u0436 #" + payment.getPaymentId() + "(log-id #" + payment.getLogId() + ") \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442\u0441\u044f \u0432 \u043b\u043e\u0433\u0435, \u043f\u0435\u0447\u0430\u0442\u044c \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430.\n\u041f\u043e \u0432\u0441\u0435\u0439 \u0432\u0438\u0434\u0438\u043c\u043e\u0441\u0442\u0438, \u043e\u043d \u0443\u0436\u0435 \u0431\u044b\u043b \u043d\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u043d.");
            }
            int ptID = payment.getPaymentTypeId();
            if (ptMap.containsKey(ptID)) {
                PrinterManager.PaymentMapping paymentMapping = ptMap.get(ptID);
                if (paymentMapping.print == PrinterManager.PaymentPrintMode.auto) continue;
                throw new BGMessageException("\u041f\u043b\u0430\u0442\u0451\u0436 #" + payment.getPaymentId() + " (\u0442\u0438\u043f: " + ptID + ") \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d \u043d\u0430 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440 #" + Utils.toString(paymentMapping.fr) + ", \u043d\u043e \u043d\u0435 \u0432 auto-\u0440\u0435\u0436\u0438\u043c\u0435 (\u0440\u0435\u0436\u0438\u043c: " + String.valueOf((Object)paymentMapping.print) + ")");
            }
            throw new BGMessageException("\u041f\u043b\u0430\u0442\u0451\u0436 #" + payment.getPaymentId() + " (\u0442\u0438\u043f: " + ptID + ") \u043d\u0435\u043b\u044c\u0437\u044f \u043d\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0432\u043e\u043e\u0431\u0449\u0435 (\u043d\u0435\u0442 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a \u043c\u044d\u043f\u043f\u0438\u043d\u0433\u0430)");
        }
        new RunTaskDataManager(this.getConnection()).addTask((RunTask)new AutoprintAutoBatch(payments));
        return "\u0417\u0430\u0434\u0430\u0447\u0430 \u043f\u0435\u0447\u0430\u0442\u0438 \u043f\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0430 \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u044c";
    }

    public String printCheckErrorDyncode(List<Integer> logIds) throws BGMessageException, BGException {
        if (logIds == null || logIds.isEmpty()) {
            throw new BGException("\u041f\u0443\u0441\u0442\u043e\u0439 \u0441\u043f\u0438\u0441\u043e\u043a \u0437\u0430\u043f\u0438\u0441\u0435\u0439?");
        }
        List logPayments = this.paymentQueueManager.getPaymentLog(null, 0, null, null, null, null, logIds).getList();
        if (logIds.size() != logPayments.size()) {
            throw new BGException("\u041e\u0434\u043d\u043e\u0439 \u0438\u0437 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u043b\u043e\u0433\u0430 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.\n\u0411\u044b\u043b \u0443\u0434\u0430\u043b\u0451\u043d? \u041f\u0440\u043e\u043f\u0430\u043b \u0438\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u044b cashcheck_payment_log? \u0418\u043b\u0438 \u043f\u0440\u043e\u0441\u0442\u043e \u043e\u0448\u0438\u0431\u043a\u0430...");
        }
        Map<Integer, PrinterManager.PaymentMapping> ptMap = PrinterManager.getPtMap();
        for (Payment payment : logPayments) {
            if (payment.getLogDate() == null) {
                throw new BGMessageException("\u041f\u043b\u0430\u0442\u0435\u0436\u0430 #" + payment.getPaymentId() + "(log-id #" + payment.getLogId() + ") \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442\u0441\u044f \u0432 \u043b\u043e\u0433\u0435.\n\u041f\u043e \u0432\u0441\u0435\u0439 \u0432\u0438\u0434\u0438\u043c\u043e\u0441\u0442\u0438, \u043e\u043d \u043d\u0435 \u0431\u044b\u043b \u043d\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u043d/\u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d.");
            }
            if (payment.getCheckType() != Check.Type.PAYMENT) {
                throw new BGMessageException("\u041f\u043b\u0430\u0442\u0435\u0436 #" + payment.getPaymentId() + "(log-id #" + payment.getLogId() + ") \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442\u0441\u044f \u0432 \u043b\u043e\u0433\u0435, \u043d\u043e \u0442\u0438\u043f \u0447\u0435\u043a\u0430 \u0431\u044b\u043b \u043d\u0435 PAYMENT (" + String.valueOf(payment.getCheckType()) + ").\n\u041f\u043e \u0432\u0441\u0435\u0439 \u0432\u0438\u0434\u0438\u043c\u043e\u0441\u0442\u0438, \u044d\u0442\u043e \u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0438\u043b\u0438 \u0434\u0440\u0443\u0433\u043e\u0439 \u043a\u0430\u0441\u0442\u043e\u043c\u043d\u044b\u0439 \u0442\u0438\u043f \u0447\u0435\u043a\u0430.");
            }
            if (Utils.isBlankString((String)payment.getLastError())) {
                throw new BGMessageException("\u041f\u043b\u0430\u0442\u0435\u0436 #" + payment.getPaymentId() + "(log-id #" + payment.getLogId() + ") \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442\u0441\u044f \u0432 \u043b\u043e\u0433\u0435, \u043d\u043e \u043d\u0435 \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0439/\u043d\u043e\u0432\u044b\u0439.\n\u041f\u043e \u0432\u0441\u0435\u0439 \u0432\u0438\u0434\u0438\u043c\u043e\u0441\u0442\u0438, \u043e\u043d \u0431\u044b\u043b \u043d\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e.");
            }
            if (Payment.LAST_ERROR_NEW.equals(payment.getLastError())) {
                throw new BGMessageException("\u041f\u043b\u0430\u0442\u0435\u0436 #" + payment.getPaymentId() + "(log-id #" + payment.getLogId() + ") \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442\u0441\u044f \u0432 \u043b\u043e\u0433\u0435, \u043d\u043e \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \"\u043d\u043e\u0432\u044b\u043c\".\n\u0421\u043c\u044b\u0441\u043b \u0442\u0430\u043a\u0438\u0445 \u0447\u0435\u043a\u043e\u0432 \u0432 \u0441\u043e\u0445\u0440\u0430\u043d\u0451\u043d\u043d\u043e\u043c \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u043c\u043e\u043c, \u0438\u0445 \u043d\u0430\u0434\u043e \u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \"\u043a\u0430\u043a \u0435\u0441\u0442\u044c\".");
            }
            if (payment.getPaymentTypeId() <= 0) {
                throw new BGMessageException("\u041f\u043b\u0430\u0442\u0435\u0436 #" + payment.getPaymentId() + "(log-id #" + payment.getLogId() + ") \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442\u0441\u044f \u0432 \u043b\u043e\u0433\u0435, \u043d\u043e \u043a \u043d\u0435\u043c\u0443 \u043d\u0435 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d\u043e \u0440\u0435\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u0442\u0435\u0436\u0430.\n\u041f\u043e \u0432\u0441\u0435\u0439 \u0432\u0438\u0434\u0438\u043c\u043e\u0441\u0442\u0438, \u043e\u043d \u043d\u0435 \u0431\u044b\u043b \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d \u0438\u043b\u0438 \u043f\u043b\u0430\u0442\u0451\u0436 \u0431\u044b\u043b \u0443\u0434\u0430\u043b\u0451\u043d.");
            }
            if (!"auto".equals(payment.getPosMapping()) && !"delay".equals(payment.getPosMapping())) {
                throw new BGMessageException("\u041f\u043b\u0430\u0442\u0435\u0436 #" + payment.getPaymentId() + "(log-id #" + payment.getLogId() + ") \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442\u0441\u044f \u0432 \u043b\u043e\u0433\u0435, \u043d\u043e \u043c\u0430\u043f\u043f\u0438\u043d\u0433 \u0447\u0435\u043a\u0430 \u0431\u044b\u043b \u043d\u0435 auto/delay (" + payment.getPosMapping() + ").\n\u041f\u043e \u0432\u0441\u0435\u0439 \u0432\u0438\u0434\u0438\u043c\u043e\u0441\u0442\u0438, \u044d\u0442\u043e\u0442 \u0447\u0435\u043a \u043d\u0435 \u043f\u0435\u0447\u0430\u0442\u0430\u043b\u0441\u044f \u0448\u0442\u0430\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u043e\u0439 \u0430\u0432\u0442\u043e\u043f\u043b\u0430\u0442\u0435\u0436\u0435\u0439.");
            }
            int ptID = payment.getPaymentTypeId();
            if (ptMap.containsKey(ptID)) {
                PrinterManager.PaymentMapping paymentMapping = ptMap.get(ptID);
                if (paymentMapping.print == PrinterManager.PaymentPrintMode.auto || paymentMapping.print == PrinterManager.PaymentPrintMode.delay) continue;
                throw new BGMessageException("\u041f\u043b\u0430\u0442\u0451\u0436 #" + payment.getPaymentId() + "(log-id #" + payment.getLogId() + ")(\u0442\u0438\u043f: " + ptID + ") \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d \u043d\u0430 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440 #" + Utils.toString(paymentMapping.fr) + ", \u043d\u043e \u043d\u0435 \u0432 auto- \u0438\u043b\u0438 delay-\u0440\u0435\u0436\u0438\u043c\u0435 (\u0440\u0435\u0436\u0438\u043c: " + String.valueOf((Object)paymentMapping.print) + ")");
            }
            throw new BGMessageException("\u041f\u043b\u0430\u0442\u0451\u0436 #" + payment.getPaymentId() + "(log-id #" + payment.getLogId() + ")(\u0442\u0438\u043f: " + ptID + ") \u043d\u0435\u043b\u044c\u0437\u044f \u043d\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0432\u043e\u043e\u0431\u0449\u0435 (\u043d\u0435\u0442 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a \u043c\u044d\u043f\u043f\u0438\u043d\u0433\u0430)");
        }
        new RunTaskDataManager(this.getConnection()).addTask((RunTask)new AutoprintReprintAutoBatch(logPayments));
        return "\u0417\u0430\u0434\u0430\u0447\u0430 \u043f\u0435\u0447\u0430\u0442\u0438 \u043f\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0430 \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u044c (\u0447\u0435\u043a\u043e\u0432: " + logPayments.size() + ")";
    }

    public String printCheckErrorAsIs(List<Integer> logIds) throws BGMessageException, BGException {
        if (logIds == null || logIds.isEmpty()) {
            throw new BGException("\u041f\u0443\u0441\u0442\u043e\u0439 \u0441\u043f\u0438\u0441\u043e\u043a \u0437\u0430\u043f\u0438\u0441\u0435\u0439?");
        }
        List logPayments = this.paymentQueueManager.getPaymentLog(null, 0, null, null, null, null, logIds).getList();
        if (logIds.size() != logPayments.size()) {
            throw new BGException("\u041e\u0434\u043d\u043e\u0439 \u0438\u0437 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u043b\u043e\u0433\u0430 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.\n\u0411\u044b\u043b \u0443\u0434\u0430\u043b\u0451\u043d? \u041f\u0440\u043e\u043f\u0430\u043b \u0438\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u044b cashcheck_payment_log? \u0418\u043b\u0438 \u043f\u0440\u043e\u0441\u0442\u043e \u043e\u0448\u0438\u0431\u043a\u0430...");
        }
        for (Payment payment : logPayments) {
            if (payment.getLogDate() == null) {
                throw new BGMessageException("\u0417\u0430\u043f\u0438\u0441\u044c \u043e \u0447\u0435\u043a\u0435 \u043f\u043b\u0430\u0442\u0451\u0436 #" + payment.getPaymentId() + "(log-id #" + payment.getLogId() + ") \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442\u0441\u044f \u0432 \u043b\u043e\u0433\u0435.\n\u041f\u043e \u0432\u0441\u0435\u0439 \u0432\u0438\u0434\u0438\u043c\u043e\u0441\u0442\u0438, \u043e\u043d \u043d\u0435 \u0431\u044b\u043b \u043d\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u043d/\u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d.");
            }
            if (Utils.isBlankString((String)payment.getLastError())) {
                throw new BGMessageException("\u0417\u0430\u043f\u0438\u0441\u044c \u043e \u0447\u0435\u043a\u0435 \u043f\u043b\u0430\u0442\u0451\u0436 #" + payment.getPaymentId() + "(log-id #" + payment.getLogId() + ") \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442\u0441\u044f \u0432 \u043b\u043e\u0433\u0435, \u043d\u043e \u043d\u0435 \u043e\u0448\u0438\u0431\u043e\u0447\u043d\u044b\u0439/\u043d\u043e\u0432\u044b\u0439.\n\u041f\u043e \u0432\u0441\u0435\u0439 \u0432\u0438\u0434\u0438\u043c\u043e\u0441\u0442\u0438, \u043e\u043d \u0431\u044b\u043b \u043d\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u043d \u0443\u0441\u043f\u0435\u0448\u043d\u043e.");
            }
            try {
                ru.bitel.bgbilling.plugins.cashcheck.common.Check.fromCheckData((String)payment.getCheckData());
            }
            catch (Exception e) {
                throw new BGMessageException("\u0417\u0430\u043f\u0438\u0441\u044c \u043e \u0447\u0435\u043a\u0435 \u043f\u043b\u0430\u0442\u0451\u0436 #" + payment.getPaymentId() + "(log-id #" + payment.getLogId() + ") \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0435 \u0434\u0430\u043d\u043d\u044b\u0435 \u0447\u0435\u043a\u0430: " + e.getMessage());
            }
            try {
                PrinterManager.getPrinter(payment.getPosId());
            }
            catch (Exception e) {
                throw new BGMessageException("\u0417\u0430\u043f\u0438\u0441\u044c \u043e \u0447\u0435\u043a\u0435 \u043f\u043b\u0430\u0442\u0451\u0436 #" + payment.getPaymentId() + "(log-id #" + payment.getLogId() + ") \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0443\u043a\u0430\u0437\u0430\u043d\u0438\u0435 \u043d\u0430 \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u044b\u0439 \u041a\u041a\u0422#" + payment.getPosId() + ", \u043e\u0448\u0438\u0431\u043a\u0430: " + e.getMessage());
            }
        }
        new RunTaskDataManager(this.getConnection()).addTask((RunTask)new AutoprintReprintAsIsBatch(logPayments));
        return "\u0417\u0430\u0434\u0430\u0447\u0430 \u043f\u0435\u0447\u0430\u0442\u0438 \u043f\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0430 \u0432 \u043e\u0447\u0435\u0440\u0435\u0434\u044c (\u0447\u0435\u043a\u043e\u0432: " + logPayments.size() + ")";
    }

    public List<String> posMappingList() throws BGException {
        return new ArrayList<String>(this.paymentQueueManager.getExistingPosMapping());
    }

    public void runAdvancePayments(LocalDate month, List<Integer> contractsIds) throws BGMessageException, BGException {
        if (month == null) {
            throw new BGMessageException("\u041c\u0435\u0441\u044f\u0446 \u0434\u043b\u044f \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0438 \u043d\u0443\u0436\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u0442\u044c");
        }
        try {
            CheckMaker dynCheckBuilder = CashCheckUtils.getCheckMaker(this.getSetup(), this.getConnection(), this.getSlaveConnection(), null, null);
            dynCheckBuilder.makeCheckAdvancePayments(null, null, null);
        }
        catch (BGNotImplementedException e) {
            throw new BGMessageException("\u041d\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d\u043e \u0432 \u0434\u0438\u043d.\u043a\u043e\u0434\u0435?\n" + e.getMessage());
        }
        catch (Exception exception) {
            // empty catch block
        }
        new RunTaskDataManager(this.getConnection()).addTask((RunTask)new AdvancePaymentsManual(month, contractsIds));
    }

    public void checkManualPrint(int checkMode, int paymentType) throws BGPrinterNotloggedMessageException, BGMessageException, BGException {
        Printer printer = PrinterManager.getPrinter();
        this.checkManualMappingForType(printer, checkMode, paymentType);
    }

    private void checkManualMappingForType(Printer printer, int checkMode, int paymentType) throws BGMessageException, BGException {
        String modename;
        Map<Integer, PrinterManager.PaymentMapping> ptchMap;
        if (checkMode == Payment.IS_PAYMENT) {
            ptchMap = PrinterManager.getPtMap();
            modename = "\u041f\u043b\u0430\u0442\u0451\u0436";
        } else if (checkMode == Payment.IS_CHARGE) {
            ptchMap = PrinterManager.getChMap();
            modename = "\u0420\u0430\u0441\u0445\u043e\u0434/\u0432\u043e\u0437\u0432\u0440\u0430\u0442";
        } else {
            throw new BGIllegalArgumentException("checkMode");
        }
        if (ptchMap.containsKey(paymentType)) {
            PrinterManager.PaymentMapping paymentMapping = ptchMap.get(paymentType);
            if (!paymentMapping.checkFr(printer.getId())) {
                throw new BGMessageException(modename + " (\u0442\u0438\u043f: " + paymentType + ") \u043d\u0435\u043b\u044c\u0437\u044f \u043d\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u043d\u0430 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0435 #" + printer.getId() + ", \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d \u043d\u0430 \u0434\u0440\u0443\u0433\u043e\u0439");
            }
            if (paymentMapping.print != PrinterManager.PaymentPrintMode.manual) {
                throw new BGMessageException(modename + " (\u0442\u0438\u043f: " + paymentType + ") \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d \u043d\u0430 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440 #" + printer.getId() + ", \u043d\u043e \u0432 \u0430\u0432\u0442\u043e\u0440\u0435\u0436\u0438\u043c\u0435 (\u0440\u0435\u0436\u0438\u043c: " + String.valueOf((Object)paymentMapping.print) + ")");
            }
        } else {
            throw new BGMessageException(modename + " (\u0442\u0438\u043f: " + paymentType + ") \u043d\u0435\u043b\u044c\u0437\u044f \u043d\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u0442\u044c \u0432\u043e\u043e\u0431\u0449\u0435 (\u043d\u0435\u0442 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a \u043c\u044d\u043f\u043f\u0438\u043d\u0433\u0430)");
        }
    }

    public int deleteNewCheck(int checkMode, List<Integer> logIds) throws BGMessageException, BGException {
        if (logIds == null || logIds.isEmpty()) {
            throw new BGException("\u041f\u0443\u0441\u0442\u043e\u0439 \u0441\u043f\u0438\u0441\u043e\u043a \u0437\u0430\u043f\u0438\u0441\u0435\u0439?");
        }
        List logPayments = null;
        if (checkMode == Payment.IS_PAYMENT) {
            logPayments = this.paymentQueueManager.getPaymentLog(null, 0, null, null, null, null, logIds).getList();
        } else if (checkMode == Payment.IS_CHARGE) {
            logPayments = this.paymentQueueManager.getChargeLog(null, 0, null, null, null, null, logIds).getList();
        } else {
            throw new IllegalArgumentException();
        }
        if (logIds.size() != logPayments.size()) {
            throw new BGException("\u041e\u0434\u043d\u043e\u0439 \u0438\u0437 \u0437\u0430\u043f\u0438\u0441\u0435\u0439 \u043b\u043e\u0433\u0430 \u043d\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442.\n\u0411\u044b\u043b \u0443\u0434\u0430\u043b\u0451\u043d? \u041f\u0440\u043e\u043f\u0430\u043b \u0438\u0437 \u0442\u0430\u0431\u043b\u0438\u0446\u044b? \u0418\u043b\u0438 \u043f\u0440\u043e\u0441\u0442\u043e \u043e\u0448\u0438\u0431\u043a\u0430...");
        }
        for (Payment payment : logPayments) {
            if (payment.getLogDate() == null) {
                throw new BGMessageException("\u0417\u0430\u043f\u0438\u0441\u044c \u043e \u0447\u0435\u043a\u0435 \u043f\u043b\u0430\u0442\u0451\u0436/\u0440\u0430\u0441\u0445\u043e\u0434 #" + payment.getPaymentId() + "(log-id #" + payment.getLogId() + ") \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442\u0441\u044f \u0432 \u043b\u043e\u0433\u0435.\n\u041f\u043e \u0432\u0441\u0435\u0439 \u0432\u0438\u0434\u0438\u043c\u043e\u0441\u0442\u0438, \u043e\u043d \u043d\u0435 \u0431\u044b\u043b \u043d\u0430\u043f\u0435\u0447\u0430\u0442\u0430\u043d/\u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d.");
            }
            if (Payment.LAST_ERROR_NEW.equals(payment.getLastError())) continue;
            throw new BGMessageException("\u041f\u043b\u0430\u0442\u0435\u0436/\u0440\u0430\u0441\u0445\u043e\u0434 #" + payment.getPaymentId() + "(log-id #" + payment.getLogId() + ") \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442\u0441\u044f \u0432 \u043b\u043e\u0433\u0435, \u043d\u043e \u043e\u043d \u043d\u0435 \"\u043d\u043e\u0432\u044b\u0439\".");
        }
        if (checkMode == Payment.IS_PAYMENT) {
            return this.paymentQueueManager.deletePaymentLog(logIds);
        }
        return this.paymentQueueManager.deleteChargeLog(logIds);
    }
}

