/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.cashcheck.server.fisc.empty;

import java.math.BigDecimal;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.plugins.cashcheck.common.Check;
import ru.bitel.bgbilling.plugins.cashcheck.common.Printer;
import ru.bitel.bgbilling.plugins.cashcheck.server.fisc.CheckFiscalData;
import ru.bitel.bgbilling.plugins.cashcheck.server.fisc.CheckPrintResult;
import ru.bitel.bgbilling.plugins.cashcheck.server.fisc.Fiscalizator;

public class EmptyFiscalizator
extends Fiscalizator {
    public EmptyFiscalizator(Printer printer) throws BGException {
        super(printer);
    }

    @Override
    public void buzzer(String oppass) throws BGException {
    }

    @Override
    public void cancelcheck(String oppass) throws BGException {
    }

    @Override
    public void continueprint(String oppass) throws BGException {
    }

    @Override
    public void divreport(String adminpass) throws BGException {
    }

    @Override
    public void openday(String adminpass) throws BGException {
    }

    @Override
    public void printtext(String oppass, String text) throws BGException {
    }

    @Override
    public void repeatcheck(String oppass) throws BGException {
    }

    @Override
    public void xreport(String adminpass) throws BGException {
    }

    @Override
    public void zreport(String adminpass) throws BGException {
    }

    @Override
    public String purecommand(String pass, String hexdump) throws BGException {
        return ";)";
    }

    private CheckFiscalData _makeFiscData(BigDecimal summa, Check.Type type) {
        CheckFiscalData fisc_data = new CheckFiscalData();
        fisc_data.total = summa;
        fisc_data.type = type;
        fisc_data.timeNow();
        fisc_data.comment = "\u043f\u0443\u0441\u0442\u043e\u0439 \u0444\u0438\u0441\u043a\u0430\u043b\u0438\u0437\u0430\u0442\u043e\u0440";
        return fisc_data;
    }

    @Override
    public CheckPrintResult check(String oppass, BigDecimal clientsumma, Check check) throws BGException {
        BigDecimal summa = check.getPaymentsum();
        if (clientsumma.compareTo(summa) < 0) {
            throw new BGMessageException("\u0414\u0435\u043d\u0435\u0433 \u0432\u043d\u0435\u0441\u0435\u043d\u043e (" + clientsumma.toPlainString() + ") \u043c\u0435\u043d\u044c\u0448\u0435 \u0441\u0443\u043c\u043c\u044b \u0447\u0435\u043a\u0430 (" + summa.toPlainString() + ")");
        }
        return CheckPrintResult.sync(clientsumma.subtract(summa).toPlainString(), this._makeFiscData(summa, Check.Type.PAYMENT));
    }

    @Override
    public CheckPrintResult checkreturn(String oppass, BigDecimal clientsumma, Check check) throws BGException {
        BigDecimal summa = check.getPaymentsum();
        return CheckPrintResult.sync("0", this._makeFiscData(summa, Check.Type.PAYMENTREFUND));
    }

    @Override
    public String status(String pass) throws BGException {
        return "ok";
    }

    @Override
    public String name(String pass) throws BGException {
        return "\u043f\u0443\u0441\u0442\u043e\u0439 \u0444\u0438\u0441\u043a\u0430\u043b\u0438\u0437\u0430\u0442\u043e\u0440";
    }

    @Override
    public String getFiscalizatorStatus() throws BGException {
        return "ok";
    }

    @Override
    public boolean isAsynchronous() {
        return false;
    }
}

