/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30;

import java.io.IOException;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30.BitArrayOutputStream;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30.CDCAS30Connection;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30.Request;
import ru.bitel.bgbilling.modules.cerbercrypt.server.protocol.cdcas30.SendOSDResponse;

public class SendOSDRequest
extends Request<SendOSDRequest, SendOSDResponse> {
    private String text;
    private int style = 2;
    private int duration = 30;
    private String charset = "utf-8";

    public SendOSDRequest(CDCAS30Connection connection, int dB_ID) {
        super(connection, dB_ID);
    }

    public void setData(String text, int style, int duration, String osdCharset) throws IOException {
        if (text.length() > 180) {
            throw new IOException("text length > 180");
        }
        if (duration > 900) {
            throw new IOException("duration > 900");
        }
        this.text = text;
        this.style = style;
        this.duration = duration;
        this.charset = osdCharset;
    }

    @Override
    protected int getMessageId() {
        return 772;
    }

    @Override
    protected void writeDataCont(BitArrayOutputStream output) throws IOException {
        String exp = "card=" + new String(this.card_sn);
        output.writeBits(exp.length(), 8);
        output.write(exp.getBytes("ascii"));
        byte[] s = this.text.getBytes(this.charset);
        output.writeBits(s.length, 8);
        output.write(s);
        output.writeBits(this.style, 8);
        output.writeBits(this.duration, 32);
    }

    @Override
    public SendOSDResponse getResponse() {
        return new SendOSDResponse(this.connection, this.DB_ID);
    }
}

