/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.server.service;

import jakarta.jws.WebService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.container.web.action.XSLManager;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.object.common.bean.ContractObject;
import ru.bitel.bgbilling.kernel.contract.object.server.bean.ContractObjectDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterCall;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterCallDTO;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterCallItem;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterCategory;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterExecutor;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterGroup;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterObjectType;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterProblem;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterSubject;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterTask;
import ru.bitel.bgbilling.plugins.crm.common.service.CRMService;
import ru.bitel.bgbilling.plugins.crm.server.bean.CRMUtils;
import ru.bitel.bgbilling.plugins.crm.server.bean.event.CreateProblemFromCallEvent;
import ru.bitel.bgbilling.plugins.crm.server.bean.event.ProblemOrCallChangedEvent;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterCallManager;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterCategoryManager;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterExecutorManager;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterGroupManager;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterProblemManager;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterSubjectManager;
import ru.bitel.bgbilling.plugins.crm.server.dao.RegisterTaskManager;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.plugins.crm.common.service.CRMService")
public class CRMServiceImpl
extends AbstractService
implements CRMService {
    private BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.crm");

    public RegisterSubject registerSubjectGet(int id) throws Exception {
        return new RegisterSubjectManager(this.getConnection()).getRegisterSubjectById(id);
    }

    public List<IdTitle> registerSubjectList() throws Exception {
        return new RegisterSubjectManager(this.getConnection()).getRegisterSubjectList().stream().map(IdTitle::toIdTitle).toList();
    }

    public int registerSubjectUpdate(RegisterSubject registerSubject) throws Exception {
        return new RegisterSubjectManager(this.getConnection()).updateRegisterSubject(registerSubject);
    }

    public boolean registerSubjectDelete(int id) throws Exception {
        new RegisterSubjectManager(this.getConnection()).deleteRegisterSubject(id);
        return true;
    }

    public SearchResult<RegisterCallItem> registerCallItems(int contractId, int subjectId, Period period, Page page) throws Exception {
        RegisterCallManager callManager = new RegisterCallManager(this.getConnection());
        RegisterCategoryManager catManager = new RegisterCategoryManager(this.getConnection());
        RegisterProblemManager problemManager = new RegisterProblemManager(this.getConnection());
        Map<Integer, RegisterCategory> categoryMap = catManager.getCategoryMap();
        String statusList = this.plugin.getSetup().get("register.problem.status.list", "0:\u043e\u0442\u043a\u0440\u044b\u0442\u0430;1:\u043f\u0440\u0438\u043d\u044f\u0442\u0430;2:\u0437\u0430\u043a\u0440\u044b\u0442\u0430");
        Map<Integer, String> statusMap = RegisterProblemManager.getStatusMap(statusList);
        SearchResult searchResult = new SearchResult(period, page);
        searchResult.setAttribute("cid", String.valueOf(contractId));
        searchResult.setAttribute("subject", String.valueOf(subjectId));
        callManager.searchList((SearchResult<RegisterCall>)searchResult);
        SearchResult searchResultCallItems = new SearchResult(searchResult.getPeriod(), searchResult.getPage());
        searchResultCallItems.getList().addAll(searchResult.getList().stream().map(RegisterCall::toRegisterCallItem).toList());
        searchResultCallItems.getList().forEach(a -> {
            if (a.getProblemId() > 0) {
                try {
                    RegisterProblem ri = problemManager.getProblemByID(a.getProblemId());
                    if (ri != null) {
                        a.setProblemTitle(this.getDescription(ri, categoryMap, statusMap));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return searchResultCallItems;
    }

    protected String getDescription(RegisterProblem problem, Map<Integer, RegisterCategory> categoryMap, Map<Integer, String> statusMap) {
        StringBuffer sb = new StringBuffer();
        sb.append(problem.getId());
        sb.append(";");
        sb.append(statusMap.get(problem.getStatus()));
        if (problem.getCloseTime() != null) {
            sb.append(" (");
            RegisterCategory cat = categoryMap.get(problem.getCategoryId());
            if (cat != null) {
                sb.append(cat.getTitle());
            } else {
                sb.append("??? (" + problem.getCategoryId() + ") ");
            }
            sb.append(")");
        }
        sb.append(";");
        sb.append(problem.getComment());
        return sb.toString();
    }

    public RegisterCallDTO registerCallGet(int registerCallId) throws Exception {
        RegisterCallDTO registerCallDTO = null;
        if (registerCallId < 0) {
            throw new BGIllegalArgumentException();
        }
        registerCallDTO = new RegisterCallDTO();
        RegisterCall call = new RegisterCallManager(this.getConnection()).getCallById(registerCallId);
        if (call != null) {
            RegisterProblemManager registerManager;
            RegisterProblem problem;
            registerCallDTO.setRegisterCall(call);
            if (call.getProblemId() > 0 && (problem = (registerManager = new RegisterProblemManager(this.getConnection())).getProblemByID(call.getProblemId())) != null) {
                BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.crm");
                String statusList = plugin.getSetup().get("register.problem.status.list", "0:\u043e\u0442\u043a\u0440\u044b\u0442\u0430;1:\u043f\u0440\u0438\u043d\u044f\u0442\u0430;2:\u0437\u0430\u043a\u0440\u044b\u0442\u0430");
                Map<Integer, String> statusMap = RegisterProblemManager.getStatusMap(statusList);
                registerCallDTO.setRegisterProblem(problem);
                registerCallDTO.setProblemStatus(statusMap.get(problem.getStatus()));
            }
        }
        return registerCallDTO;
    }

    public int registerCallUpdate(RegisterCall registerCall, int problemId, String problemComment, boolean sendMail) throws Exception {
        int id = registerCall.getId();
        if (id == 0) {
            registerCall.setTime(new Date());
            registerCall.setUserId(this.userId);
        }
        RegisterCallManager registerCallManager = new RegisterCallManager(this.getConnection());
        registerCallManager.updateCall(registerCall);
        boolean needUpdate = false;
        if (problemId >= 0) {
            registerCall.setProblemId(problemId);
            needUpdate = true;
        } else if (problemComment != null && problemComment.length() > 0) {
            RegisterProblem problem = RegisterProblem.builder().setObjectId(registerCall.getObjectId()).setOpenTime(new Date()).setOpenUserId(this.userId).setStatusTime(new Date()).setStatusUserId(this.userId).setComment(problemComment).setGroupId(registerCall.getGroupId()).build();
            if (registerCall.getContractId() > 0) {
                try (ContractObjectDao contractObjectDao = new ContractObjectDao(this.getConnection(), this.userId);){
                    Contract contract = ContractDao.getContract((Connection)this.getConnection(), (int)registerCall.getContractId());
                    ContractObject object = null;
                    if (contract != null) {
                        if (registerCall.getObjectId() > 0) {
                            object = (ContractObject)contractObjectDao.get(registerCall.getObjectId());
                        }
                        CreateProblemFromCallEvent event = new CreateProblemFromCallEvent(this.plugin.getPluginUID(), contract, object, registerCall, problem);
                        event = (CreateProblemFromCallEvent)EventProcessor.getInstance().request((QueueEvent)event);
                        registerCall = event.getCall();
                        problem = event.getProblem();
                    }
                }
            }
            RegisterProblemManager problemManager = new RegisterProblemManager(this.getConnection());
            problemManager.updateProblem(problem, this.userId);
            problemManager.addGroup(problem.getId(), registerCall.getGroupId());
            registerCall.setProblemId(problem.getId());
            needUpdate = true;
            int eventContractId = this.plugin.getSetup().getInt("event.contract.id", 0);
            if (eventContractId > 0) {
                this.context.publishAfterCommit((Event)new ProblemOrCallChangedEvent(this.plugin.getPluginUID(), eventContractId, true, registerCall, problem));
            }
            problemId = problem.getId();
        } else {
            int eventContractId = this.plugin.getSetup().getInt("event.contract.id", 0);
            if (eventContractId > 0) {
                this.context.publishAfterCommit((Event)new ProblemOrCallChangedEvent(this.plugin.getPluginUID(), eventContractId, id == 0, registerCall, null));
            }
        }
        if (needUpdate) {
            registerCallManager.updateCall(registerCall);
        }
        if (registerCall != null && sendMail) {
            try {
                this.sendRegisterEmail(registerCall, problemId, this.plugin.getSetup().get("register.task.call.subject", Setup.getSetup().get("register.task.call.subject", "\u041e\u0442\u0447\u0435\u0442 \u043f\u043e \u0437\u0432\u043e\u043d\u043a\u0443")));
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
        return registerCall.getId();
    }

    protected void sendRegisterEmail(RegisterCall call, int problemId, String subject) throws Exception {
        RegisterProblem problem;
        Connection con = this.getConnection();
        RegisterGroup group = new RegisterGroupManager(con).getGroupById(call.getGroupId());
        if (group == null || group.getEmail() == null || group.getEmail().trim().isEmpty()) {
            throw new BGMessageException("\u0423 \u0433\u0440\u0443\u043f\u043f\u044b \u043d\u0435\u0442 \u043f\u043e\u0447\u0442\u043e\u0432\u043e\u0433\u043e \u0430\u0434\u0440\u0435\u0441\u0430!");
        }
        Document doc = XMLUtils.newDocument();
        Element rootNode = XMLUtils.createElement((Document)doc, (String)"data");
        Element header = XMLUtils.createElement((Element)rootNode, (String)"header");
        header.setAttribute("id", String.valueOf(call.getId()));
        CRMUtils.addUserData(call.getUserId(), call.getTime(), "dd.MM.yyyy HH:mm", header, "open");
        header.setAttribute("group", group.getTitle());
        header.setAttribute("contract", "-");
        header.setAttribute("object", "-");
        if (call.getContractId() > 0) {
            try (ContractObjectDao contractObjectDao = new ContractObjectDao(this.getConnection(), this.userId);){
                Contract contract = ContractDao.getContract((Connection)con, (int)call.getContractId());
                if (contract != null) {
                    header.setAttribute("contract", contract.getTitle());
                    ContractObject object = (ContractObject)contractObjectDao.get(call.getObjectId());
                    if (object != null) {
                        header.setAttribute("object", object.getTitle());
                    }
                }
            }
        }
        String query = "SELECT title FROM register_subject WHERE id=?";
        try (PreparedStatement ps = con.prepareStatement(query);){
            ps.setInt(1, call.getTypeId());
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    header.setAttribute("type", rs.getString(1));
                }
            }
        }
        catch (SQLException ex) {
            throw new BGException((Throwable)ex);
        }
        Element comment = XMLUtils.createElement((Element)rootNode, (String)"comment");
        XMLUtils.stringToLines((Element)comment, (String)call.getComment());
        RegisterProblemManager problemManager = new RegisterProblemManager(con);
        if (call.getProblemId() > 0 && (problem = problemManager.getProblemByID(call.getProblemId())) != null) {
            Element problemEl = XMLUtils.createElement((Element)rootNode, (String)"problem");
            comment = XMLUtils.createElement((Element)problemEl, (String)"comment");
            XMLUtils.stringToLines((Element)comment, (String)problem.getComment());
        }
        XSLManager.getInstance().transformAndSend("crm_register_call.xsl", (Source)new DOMSource(doc), null, "text/html", null, false, group.getEmail(), subject);
    }

    public List<RegisterExecutor> registerExecutorList(List<Integer> groupIds) throws Exception {
        return new RegisterExecutorManager(this.getConnection()).getRegisterExecutorList(groupIds, (List<Integer>)null);
    }

    public List<IdTitle> registerExecutorItems(List<Integer> groupIds) throws Exception {
        return this.registerExecutorList(groupIds).stream().map(IdTitle::toIdTitle).toList();
    }

    public void registerExecutorDelete(int id) throws Exception {
        String query = "DELETE FROM register_executor WHERE id=?";
        try (PreparedStatement ps = this.getConnection().prepareStatement(query);){
            ps.setInt(1, id);
            ps.executeUpdate();
        }
    }

    public List<RegisterGroup> registerGroupList(int id) throws Exception {
        return new RegisterGroupManager(this.getConnection()).getGroupList(id);
    }

    public List<IdTitle> registerGroupItems(int id) throws Exception {
        return this.registerGroupList(id).stream().map(IdTitle::toIdTitle).toList();
    }

    public List<IdTitle> registerCategoryItems() throws Exception {
        return new RegisterCategoryManager(this.getConnection()).list().stream().map(IdTitle::toIdTitle).toList();
    }

    public List<IdTitle> registerStatusItems(RegisterObjectType objectType) throws Exception {
        if (objectType == null) {
            return new ArrayList<IdTitle>();
        }
        BGPluginServer plugin = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.crm");
        String statusList = switch (objectType) {
            case RegisterObjectType.PROBLEM -> plugin.getSetup().get("register.problem.status.list", "0:\u043e\u0442\u043a\u0440\u044b\u0442\u0430;1:\u043f\u0440\u0438\u043d\u044f\u0442\u0430;2:\u0437\u0430\u043a\u0440\u044b\u0442\u0430");
            case RegisterObjectType.TASK -> plugin.getSetup().get("register.task.status.list", "0:\u043e\u0442\u043a\u0440\u044b\u0442\u0430;1:\u043f\u0440\u0438\u043d\u044f\u0442\u0430;2:\u0437\u0430\u043a\u0440\u044b\u0442\u0430");
            default -> "";
        };
        return Utils.toList((String)statusList, (String)";").stream().filter(a -> a.indexOf(58) > 0).map(a -> {
            int index = a.indexOf(58);
            return new IdTitle(Utils.parseInt((String)a.substring(0, index)), a.substring(index + 1));
        }).toList();
    }

    public List<IdTitle> registerProblemUsedGroups(int id) throws Exception {
        return new RegisterProblemManager(this.getConnection()).getProblemUsedGroups(id).stream().map(a -> new IdTitle(0, a)).toList();
    }

    public String registerProblemCalls(int id) throws Exception {
        StringBuffer calls = new StringBuffer();
        try (ContractObjectDao contractObjectDao = new ContractObjectDao(this.getConnection(), this.userId);){
            RegisterProblemManager registerProblemManager = new RegisterProblemManager(this.getConnection());
            List callList = registerProblemManager.getProblemByID(id).getCalls();
            if (callList != null) {
                for (RegisterCall call : callList) {
                    ContractObject object;
                    if (calls.length() != 0) {
                        calls.append("\n");
                    }
                    calls.append("[").append(call.getId()).append("] ").append(call.getContractTitle());
                    if (call.getObjectId() <= 0 || (object = (ContractObject)contractObjectDao.get(call.getObjectId())) == null) continue;
                    calls.append(" (");
                    calls.append(object.getTitle());
                    calls.append(")");
                }
            }
        }
        return calls.toString();
    }

    public List<KeyValue> registerProblemTasks(int id) throws Exception {
        ArrayList<KeyValue> tasks = new ArrayList<KeyValue>();
        RegisterProblemManager registerProblemManager = new RegisterProblemManager(this.getConnection());
        List tList = registerProblemManager.getProblemByID(id).getTasks();
        if (tList != null) {
            RegisterTaskManager registerTaskManager = new RegisterTaskManager(this.getConnection());
            RegisterCallManager registerCallManager = new RegisterCallManager(this.getConnection());
            List<RegisterCall> problemCallList = registerCallManager.getProblemCallList(id);
            try (ContractDao contractDao = new ContractDao(this.getConnection(), this.userId);){
                Contract contract = null;
                for (String t : tList) {
                    RegisterTask task = registerTaskManager.getTaskById(Integer.valueOf(t));
                    StringBuilder sb = new StringBuilder();
                    sb.append(String.valueOf(task.getContractId()));
                    if (Utils.notBlankString((String)task.getComment())) {
                        sb.append(" ( ").append(task.getComment()).append(" )");
                    }
                    sb.append(" [ ").append(String.valueOf(t)).append(" ]");
                    tasks.add(new KeyValue(t, sb.toString()));
                }
                for (RegisterCall registerCall : problemCallList) {
                    StringBuilder sb = new StringBuilder().append("\u0421\u043e\u0437\u0434\u0430\u0442\u044c \u0437\u0430\u0434\u0430\u0447\u0443 \u0434\u043b\u044f \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430: ").append(String.valueOf(registerCall.getContractId()));
                    contract = (Contract)contractDao.get(registerCall.getContractId());
                    if (contract == null) continue;
                    if (Utils.notBlankString((String)contract.getComment())) {
                        sb.append(" ( ").append(contract.getComment()).append(" )");
                    }
                    tasks.add(new KeyValue("new:" + contract.getId(), sb.toString()));
                }
            }
        }
        return tasks;
    }

    public List<RegisterProblem> registerProblemHistoryList(int id) throws Exception {
        return new RegisterProblemManager(this.getConnection()).getProblemHistory(id);
    }

    public void registerProblemHistoryClear(int id) throws Exception {
        new RegisterProblemManager(this.getConnection()).clearProblemHistory(id);
    }
}

