/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterCall;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

public class RegisterCallManager
extends BGLogger {
    private Connection con;

    public RegisterCallManager(Connection con) {
        this.con = con;
    }

    public List<RegisterCall> getProblemCallList(int problemID) throws Exception {
        ArrayList<RegisterCall> result = new ArrayList<RegisterCall>();
        String query = "SELECT * FROM register_call WHERE rpid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, problemID);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    RegisterCall call = new RegisterCall();
                    this.setRegisterCallData(call, rs, "", "", "", "");
                    result.add(call);
                }
            }
        }
        return result;
    }

    public RegisterCall getCallById(int id) throws Exception {
        RegisterCall result = null;
        String query = "SELECT rcall.*, contract.title, object.title FROM register_call AS rcall LEFT JOIN contract ON rcall.cid=contract.id LEFT JOIN object ON rcall.oid=object.id WHERE rcall.id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, id);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    result = new RegisterCall();
                    this.setRegisterCallData(result, rs, "rcall.", "", "contract.", "object.");
                }
            }
        }
        return result;
    }

    public void searchList(SearchResult<RegisterCall> searchResult) throws Exception {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            Period period = searchResult.getPeriod();
            List result = searchResult.getList();
            StringBuffer query = new StringBuffer(500);
            query.append("SELECT SQL_CALC_FOUND_ROWS rcall.*, subject.title, contract.title, object.title");
            query.append(" FROM register_call AS rcall ");
            query.append(" LEFT JOIN register_subject AS subject ON rcall.sid=subject.id ");
            query.append(" LEFT JOIN contract ON rcall.cid=contract.id ");
            query.append(" LEFT JOIN object ON rcall.oid=object.id ");
            this.addWhereString(Utils.parseInt((String)searchResult.getAttribute("cid")), period.getDateFrom(), period.getDateTo(), Utils.parseInt((String)searchResult.getAttribute("subject")), query);
            query.append(" ORDER BY rcall.time");
            query.append(Page.toSqlLimit((Page)page));
            try (PreparedStatement ps = this.con.prepareStatement(query.toString());){
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        RegisterCall call = new RegisterCall();
                        this.setRegisterCallData(call, rs, "rcall.", "subject.", "contract.", "object.");
                        result.add(call);
                    }
                }
                Page.setRecordCount((Page)page, (int)ServerUtils.foundRows((Connection)this.con));
            }
        }
    }

    public Map<Integer, List<RegisterCall>> getProblemCallList(List<Integer> problemIds) throws Exception {
        HashMap<Integer, List<RegisterCall>> result = new HashMap<Integer, List<RegisterCall>>();
        if (problemIds != null) {
            StringBuilder ids = new StringBuilder();
            for (Integer problemId : problemIds) {
                if (ids.length() > 0) {
                    ids.append(", ");
                }
                ids.append(problemId);
            }
            if (ids.length() > 0) {
                String query = "SELECT *, contract.title FROM register_call LEFT JOIN contract ON cid=contract.id WHERE rpid IN ( " + ids.toString() + " )";
                try (PreparedStatement ps = this.con.prepareStatement(query);
                     ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        RegisterCall call = new RegisterCall();
                        this.setRegisterCallData(call, rs, "", "", "contract.", "");
                        Integer problemId = rs.getInt("rpid");
                        ArrayList<RegisterCall> list = (ArrayList<RegisterCall>)result.get(problemId);
                        if (list == null) {
                            list = new ArrayList<RegisterCall>();
                            result.put(problemId, list);
                        }
                        list.add(call);
                    }
                }
            }
        }
        return result;
    }

    private void addWhereString(int contractId, Date date1, Date date2, int subject, StringBuffer query) {
        query.append(" WHERE ( ");
        query.append(contractId);
        query.append("<=0 OR rcall.cid=");
        query.append(contractId);
        query.append(" )");
        if (date1 != null) {
            query.append(" AND ");
            query.append("time>='");
            query.append(TimeUtils.format((Date)date1, (String)"yyyy-MM-dd"));
            query.append("'");
        }
        if (date2 != null) {
            query.append(" AND ");
            query.append("time<=DATE_ADD('");
            query.append(TimeUtils.format((Date)date2, (String)"yyyy-MM-dd"));
            query.append("', INTERVAL 1 DAY )");
        }
        if (subject > 0) {
            query.append(" AND sid=");
            query.append(subject);
        }
    }

    public void updateCall(RegisterCall call) throws Exception {
        boolean update = call.getId() > 0;
        String query = null;
        query = !update ? "INSERT INTO register_call (cid, oid, sid, gid, rpid, time, uid, comment ) VALUES ( ?, ?, ?, ?, ?, ?, ?, ? ) " : "UPDATE register_call SET cid=?, oid=?, sid=?, gid=?, rpid=?, time=?, uid=?, comment=? WHERE id=?";
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setInt(index++, call.getContractId());
            ps.setInt(index++, call.getObjectId());
            ps.setInt(index++, call.getTypeId());
            ps.setInt(index++, call.getGroupId());
            ps.setInt(index++, call.getProblemId());
            ps.setTimestamp(index++, TimeUtils.convertDateToTimestamp((Date)call.getTime()));
            ps.setInt(index++, call.getUserId());
            ps.setString(index++, call.getComment());
            if (update) {
                ps.setInt(index++, call.getId());
            }
            ps.executeUpdate();
            if (!update) {
                call.setId(ServerUtils.lastInsertId((PreparedStatement)ps));
            }
        }
    }

    public void deleteCallsByContractId(int contractId) throws Exception {
        String query = "DELETE FROM register_call WHERE cid=?";
        try (PreparedStatement ps = this.con.prepareStatement(query);){
            ps.setInt(1, contractId);
            ps.executeUpdate();
        }
    }

    private void setRegisterCallData(RegisterCall call, ResultSet rs, String tableCall, String tableSubject, String tableContract, String tableObject) throws SQLException {
        RegisterCall.builder((RegisterCall)call).setId(rs.getInt(tableCall + "id")).setContractId(rs.getInt(tableCall + "cid")).setObjectId(rs.getInt(tableCall + "oid")).setTypeId(rs.getInt(tableCall + "sid")).setGroupId(rs.getInt(tableCall + "gid")).setTime((Date)rs.getTimestamp(tableCall + "time")).setProblemId(rs.getInt(tableCall + "rpid")).setComment(rs.getString(tableCall + "comment")).setUserId(rs.getInt(tableCall + "uid"));
        if (Utils.notEmptyString((String)tableSubject)) {
            call.setTypeTitle(rs.getString(tableSubject + "title"));
        }
        if (Utils.notEmptyString((String)tableContract)) {
            call.setContractTitle(rs.getString(tableContract + "title"));
        }
        if (Utils.notEmptyString((String)tableObject)) {
            call.setObjectTitle(rs.getString(tableObject + "title"));
        }
    }
}

