/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.crm.client;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.client.BGClientBase;
import ru.bitel.bgbilling.client.common.BGControlPanelPages;
import ru.bitel.bgbilling.client.common.BGControlPanelPeriodNoB;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGServiceConfig;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.common.field.BGTextArea;
import ru.bitel.bgbilling.client.common.table.renderer.DatetimeTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.HorizontalAlignmentTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.plugins.crm.client.admin.ActionConfig;
import ru.bitel.bgbilling.plugins.crm.client.admin.ProblemManager;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterCall;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterCallDTO;
import ru.bitel.bgbilling.plugins.crm.common.model.RegisterCallItem;
import ru.bitel.bgbilling.plugins.crm.common.service.CRMService;
import ru.bitel.common.Utils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGSwingUtilites;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.SearchResult;

public class CallManager
extends BGUPanel {
    private boolean init = false;
    private int contractId = -1;
    private BGComboBox<ComboBoxItem> subjectCB = new BGComboBox();
    private BGControlPanelPeriodNoB periodPanel = new BGControlPanelPeriodNoB();
    private BGControlPanelPages pagePanel = new BGControlPanelPages();
    private JLabel countLabel = new JLabel("\u0412\u0441\u0435\u0433\u043e \u0437\u0432\u043e\u043d\u043a\u043e\u0432: 0");
    private JPanel filterPanel = new JPanel(new GridBagLayout());
    private Directory<UserInfo> userDir = null;
    private RegisterCallTableModel registerCallTableModel = new RegisterCallTableModel();

    public CallManager() {
        this(-1);
    }

    public CallManager(int contractId) {
        this.setContractId(contractId);
        this.periodPanel.setDateCalendar1((Calendar)new GregorianCalendar());
        this.periodPanel.setDateCalendar2((Calendar)new GregorianCalendar());
    }

    protected void jbInit() throws Exception {
        BGUTable table = new BGUTable((TableModel)((Object)this.registerCallTableModel));
        BGSwingUtilites.handleEdit((JTable)table, (AbstractBGUPanel)this);
        this.pagePanel.addToHandler(a -> this.setData());
        this.setLayout(new GridBagLayout());
        this.add(this.getTopPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        this.add(new JScrollPane((Component)table), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
    }

    private Directory<UserInfo> getUserDirectory() {
        if (this.userDir == null) {
            try {
                this.userDir = ((ClientContext)this.getContext()).getDirectory(UserInfo.class);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
        return this.userDir;
    }

    private JPanel getTopPanel() {
        JButton doFilter = new JButton("\u041f\u0440\u0438\u043c\u0435\u043d\u0438\u0442\u044c");
        this.countLabel.setFont(new Font("Arial", 1, 14));
        this.filterPanel.add((Component)new JLabel("\u0422\u0438\u043f \u0437\u0432\u043e\u043d\u043a\u0430: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.filterPanel.add((Component)this.subjectCB, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.filterPanel.add((Component)new JLabel("\u041f\u0435\u0440\u0438\u043e\u0434: "), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 25, 0, 0), 0, 0));
        this.filterPanel.add((Component)this.periodPanel, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.filterPanel.add((Component)doFilter, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 25, 0, 5), 0, 0));
        JPanel topPanel = new JPanel(new GridBagLayout());
        topPanel.add((Component)this.filterPanel, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        topPanel.add((Component)this.countLabel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 15, 0, 0), 0, 0));
        topPanel.add((Component)this.pagePanel, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 15, 0, 5), 0, 0));
        doFilter.addActionListener(e -> {
            this.pagePanel.init();
            this.setData();
        });
        this.subjectCB.setMaximumRowCount(20);
        return topPanel;
    }

    public void setContractId(int id) {
        this.contractId = id;
        this.periodPanel.setDateCalendar1(null);
        this.periodPanel.setDateCalendar2(null);
    }

    public void setData() {
        this.tryCall(() -> {
            ComboBoxItem subjectItem = (ComboBoxItem)this.subjectCB.getSelectedItem();
            int subjectId = subjectItem != null ? Utils.parseInt((String)((String)subjectItem.getObject())) : 0;
            SearchResult searchResult = ((CRMService)((ClientContext)this.getContext()).getWebService(CRMService.class)).registerCallItems(this.contractId, subjectId, this.periodPanel.getPeriod(), this.pagePanel.getPage());
            this.registerCallTableModel.setData(searchResult.getList());
            this.pagePanel.setPage(searchResult.getPage());
            this.countLabel.setText("\u0412\u0441\u0435\u0433\u043e \u0437\u0432\u043e\u043d\u043a\u043e\u0432: " + searchResult.getPage().getRecordCount());
        });
    }

    protected void initActions() {
        new AbstractBGUPanel.BGActionRefresh((AbstractBGUPanel)this, e -> {
            if (!this.init) {
                try {
                    DefaultComboBoxModel<ComboBoxItem> model = new DefaultComboBoxModel<ComboBoxItem>();
                    model.addElement(new ComboBoxItem((Object)"0", "------"));
                    ((CRMService)((ClientContext)this.getContext()).getWebService(CRMService.class)).registerSubjectList().forEach(a -> model.addElement(new ComboBoxItem(a.getId(), a.getGuiTitle())));
                    this.subjectCB.setModel(model);
                    this.subjectCB.setSelectedIndex(0);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                }
                this.init = true;
            }
            this.setData();
        });
        new AbstractBGUPanel.BGActionNew((AbstractBGUPanel)this, e -> new CallEditorDialog("\u041d\u043e\u0432\u044b\u0439 \u0437\u0432\u043e\u043d\u043e\u043a", new RegisterCall().setContractId(((ClientContext)this.getContext()).getContractId())).open());
        new AbstractBGUPanel.BGActionEdit((AbstractBGUPanel)this, e -> {
            RegisterCallItem item = (RegisterCallItem)this.registerCallTableModel.getSelectedRow();
            if (item != null) {
                RegisterCall registerCall = new RegisterCall().setId(item.getId());
                new CallEditorDialog("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0437\u0432\u043e\u043d\u043a\u0430", registerCall).open();
            }
        });
    }

    class RegisterCallTableModel
    extends BGTableModel<RegisterCallItem> {
        public RegisterCallTableModel() {
            super(RegisterCallTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440", 100, 150, 200, "contractTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0422\u0438\u043f", 120, 250, 300, "typeId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u0414\u0430\u0442\u0430", 150, 150, 150, "datetime", true, DatetimeTableCellRenderer.DEFAULT_DDMMYYYY_HHMMSS());
            this.addColumn("\u041f\u0440\u0438\u043d\u044f\u0442", 100, 200, 300, "userId", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439", 100, 200, -1, "comment", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
            this.addColumn("\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u0430", 100, 200, -1, "problemTitle", true, (TableCellRenderer)HorizontalAlignmentTableCellRenderer.LEFT());
        }

        public Object getValue(RegisterCallItem val, int column) throws BGException {
            try {
                String identifier = this.getIdentifier(column);
                if ("userId".equals(identifier)) {
                    return CallManager.this.getUserDirectory().opt(val.getUserId()).map(UserInfo::getName).orElse("??? [#" + val.getUserId() + "]");
                }
                if ("typeId".equals(identifier)) {
                    return val.getTypeTitle();
                }
                return super.getValue((Object)val, column);
            }
            catch (Exception ex) {
                throw new BGException((Throwable)ex);
            }
        }
    }

    class CallEditorDialog
    extends BGEditorDialog<RegisterCall> {
        private int callContractID;
        private String callContractTitle;
        private int problemId;
        private String problemComment;
        private JTabbedPane link;
        private JTabbedPane jTabbedPane1;
        private JPanel view;
        private JLabel problemRef_L;
        private JLabel contractLabel;
        private JButton contractOpenButton;
        private CardLayout cardLayout1;
        private BGTextArea problemComment_TA;
        private BGTextArea problemResolution_TA;
        private BGTextArea createProblemComment_TA;
        private BGTextArea comment_TA;
        private String module;
        private DefaultListModel<BGUListItem> groupModel;
        private JList<BGUListItem> groupList;
        private DefaultListModel<BGUListItem> subjectModel;
        private JList<BGUListItem> subjectList;
        private BGUList<BGUListItem> currentProblems_L;
        private JCheckBox sendEmail;

        public CallEditorDialog(String title, RegisterCall data) {
            super(title, (Object)data);
            this.callContractID = 0;
            this.problemId = -1;
            this.problemComment = null;
            this.link = new JTabbedPane();
            this.jTabbedPane1 = new JTabbedPane();
            this.view = new JPanel(new GridBagLayout());
            this.problemRef_L = new JLabel();
            this.contractLabel = new JLabel("\u0414\u043e\u0433\u043e\u0432\u043e\u0440: ");
            this.contractOpenButton = new JButton();
            this.cardLayout1 = new CardLayout();
            this.problemComment_TA = new BGTextArea();
            this.problemResolution_TA = new BGTextArea();
            this.createProblemComment_TA = new BGTextArea();
            this.comment_TA = new BGTextArea();
            this.module = "ru.bitel.bgbilling.plugins.crm";
            this.groupModel = new DefaultListModel();
            this.groupList = new JList<BGUListItem>(this.groupModel);
            this.subjectModel = new DefaultListModel();
            this.subjectList = new JList<BGUListItem>(this.subjectModel);
            this.currentProblems_L = new BGUList();
            this.sendEmail = new JCheckBox("\u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u043d\u0430 e-mail");
            this.contractOpenButton.addActionListener(e -> ClientUtils.openContract((int)this.callContractID));
        }

        public void doDialogPanel() {
            JPanel jPanel1 = new JPanel(new GridBagLayout());
            JPanel linkProblemPanel = new JPanel(new GridBagLayout());
            JPanel createProblemPanel = new JPanel(new GridBagLayout());
            this.link.addChangeListener(event -> {
                if (((JTabbedPane)event.getSource()).getSelectedIndex() == 1) {
                    this.loadCurrentProblemList();
                }
            });
            this.subjectList.setSelectionMode(0);
            this.subjectList.addListSelectionListener(e -> this.subjectList_valueChanged(e));
            this.problemRef_L.setText("\u041e\u0442\u043a\u0440\u044b\u0442\u0430");
            this.groupList.setSelectionMode(0);
            JButton openProblem_B = new JButton("\u041f\u0440\u043e\u0441\u043c\u043e\u0442\u0440");
            openProblem_B.addActionListener(actionEvent -> this.openProblem_B_actionPerformed(actionEvent));
            JButton unlinkProblem_B = new JButton("\u041e\u0442\u0432\u044f\u0437\u0430\u0442\u044c");
            unlinkProblem_B.addActionListener(actionEvent -> this.unlinkProblem_B_actionPerformed(actionEvent));
            this.problemComment_TA.setEnabled(false);
            this.problemComment_TA.setEditable(false);
            this.problemComment_TA.setLineWrap(true);
            this.problemComment_TA.setWrapStyleWord(true);
            this.problemResolution_TA.setEnabled(false);
            this.problemResolution_TA.setEditable(false);
            this.problemResolution_TA.setLineWrap(true);
            this.problemResolution_TA.setWrapStyleWord(true);
            this.contractOpenButton.setText(" ");
            JPanel jPanel2 = new JPanel(new GridBagLayout());
            jPanel2.add((Component)BGSwingUtilites.wrapScrollPane(this.subjectList, (int)800, (int)400), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            jPanel2.add((Component)new JLabel("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u0437\u0432\u043e\u043d\u043a\u0430"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
            jPanel2.add((Component)BGSwingUtilites.wrapScrollPane((JComponent)this.comment_TA, (int)800, (int)100), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 0, 0), 0, 0));
            JPanel jPanel5 = new JPanel(new GridBagLayout());
            jPanel5.add((Component)new JScrollPane(this.groupList), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.link.add((Component)createProblemPanel, "\u0421\u043e\u0437\u0434\u0430\u0442\u044c");
            this.link.add((Component)linkProblemPanel, "\u041f\u0440\u0438\u0432\u044f\u0437\u0430\u0442\u044c");
            linkProblemPanel.add((Component)new JScrollPane((Component)this.currentProblems_L), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            JScrollPane jScrollPane6 = new JScrollPane((Component)this.problemResolution_TA);
            jScrollPane6.setMinimumSize(new Dimension(18, 100));
            jScrollPane6.setPreferredSize(new Dimension(3, 100));
            JScrollPane jScrollPane1 = new JScrollPane((Component)this.problemComment_TA);
            jScrollPane1.setMinimumSize(new Dimension(18, 60));
            jScrollPane1.setPreferredSize(new Dimension(3, 60));
            createProblemPanel.add((Component)new JScrollPane((Component)this.createProblemComment_TA), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            this.view.add((Component)this.problemRef_L, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.view.add((Component)openProblem_B, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
            this.view.add((Component)unlinkProblem_B, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
            this.view.add((Component)jScrollPane6, new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.view.add((Component)jScrollPane1, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.4, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            JPanel problemPanel = new JPanel(this.cardLayout1);
            problemPanel.setBorder(null);
            problemPanel.add((Component)this.link, "problemCreate");
            problemPanel.add((Component)this.view, "problemView");
            this.jTabbedPane1.add((Component)jPanel2, "\u0422\u0438\u043f \u0437\u0432\u043e\u043d\u043a\u0430");
            this.jTabbedPane1.add((Component)jPanel5, "\u0413\u0440\u0443\u043f\u043f\u0430");
            this.jTabbedPane1.add((Component)problemPanel, "\u041f\u0440\u043e\u0431\u043b\u0435\u043c\u0430");
            jPanel1.add((Component)this.contractLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 20, 10, 0), 0, 0));
            jPanel1.add((Component)this.contractOpenButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 10, 0), 0, 0));
            jPanel1.add(Box.createHorizontalGlue(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
            jPanel1.add((Component)this.sendEmail, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 10, 10, 0), 0, 0));
            this.panel.setLayout(new GridBagLayout());
            this.panel.add((Component)this.jTabbedPane1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
            this.panel.add((Component)jPanel1, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 0, 0), 0, 0));
            this.init();
            this.setData();
        }

        public void setData() {
            if (((RegisterCall)this.data).getId() > 0) {
                this.tryCall(() -> {
                    RegisterCallDTO registerCallDTO = ((CRMService)((ClientContext)CallManager.this.getContext()).getWebService(CRMService.class)).registerCallGet(((RegisterCall)this.data).getId());
                    RegisterCall call = registerCallDTO.getRegisterCall();
                    if (call != null) {
                        this.data = call;
                        this.comment_TA.setText(call.getComment());
                        this.callContractTitle = call.getContractTitle();
                        this.callContractID = call.getContractId();
                        this.contractOpenButton.setText(Utils.notEmptyString((String)this.callContractTitle) ? this.callContractTitle : " ");
                        this.contractOpenButton.setVisible(this.callContractID > 0);
                        this.contractLabel.setVisible(this.callContractID > 0);
                    } else {
                        this.callContractID = ((RegisterCall)this.data).getContractId();
                    }
                    ClientUtils.setListSelection(this.subjectList, (String)("" + call.getTypeId()));
                    ClientUtils.setListSelection(this.groupList, (String)("" + call.getGroupId()));
                    boolean problemLinked = false;
                    if (Utils.notEmptyString((String)registerCallDTO.getProblemStatus())) {
                        String problemStatus = registerCallDTO.getProblemStatus();
                        if ("\u0437\u0430\u043a\u0440\u044b\u0442\u0430".equals(problemStatus)) {
                            this.jTabbedPane1.setSelectedIndex(2);
                        }
                        this.problemRef_L.setText(problemStatus);
                        this.problemId = call.getProblemId();
                        this.problemComment_TA.setText(registerCallDTO.getRegisterProblem().getComment());
                        this.problemResolution_TA.setText(registerCallDTO.getRegisterProblem().getResolution());
                        problemLinked = true;
                    }
                    this.showProblemPanel(problemLinked);
                });
            } else {
                this.callContractID = ((RegisterCall)this.data).getContractId();
                this.comment_TA.setText("");
                this.subjectList.clearSelection();
                this.groupList.clearSelection();
                this.problemComment_TA.setText("");
                this.showProblemPanel(false);
                this.contractOpenButton.setVisible(false);
                this.contractOpenButton.setText(" ");
                this.contractLabel.setVisible(false);
                this.link.setSelectedIndex(0);
                this.callContractID = ((RegisterCall)this.data).getContractId();
            }
            this.jTabbedPane1.setSelectedIndex(0);
        }

        private void init() {
            CallManager.this.init = true;
            Async registerSubjectList = Async.of(() -> {
                try {
                    return ((CRMService)((ClientContext)CallManager.this.getContext()).getWebService(CRMService.class)).registerSubjectList();
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                    return new ArrayList();
                }
            });
            Async registerGroupList = Async.of(() -> {
                try {
                    return ((CRMService)((ClientContext)CallManager.this.getContext()).getWebService(CRMService.class)).registerGroupList(0);
                }
                catch (Exception ex) {
                    ClientUtils.showErrorMessageDialog((Throwable)ex);
                    return new ArrayList();
                }
            });
            this.subjectModel.removeAllElements();
            ((List)registerSubjectList.get()).forEach(a -> this.subjectModel.addElement(new BGUListItem(a.getId(), a.getTitle())));
            this.groupModel.removeAllElements();
            ((List)registerGroupList.get()).forEach(a -> this.groupModel.addElement(new BGUListItem(a.getId(), a.getTitle())));
        }

        private void loadCurrentProblemList() {
            this.tryCall(() -> this.currentProblems_L.setData(ClientUtils.toBGUListItemList((List)((CRMService)((ClientContext)CallManager.this.getContext()).getWebService(CRMService.class)).registerProblemCurrentList(CallManager.this.contractId))));
        }

        public void subjectList_valueChanged(ListSelectionEvent e) {
            Request request;
            Document doc;
            BGUListItem subjectItem;
            if (e.getValueIsAdjusting() && (subjectItem = this.subjectList.getSelectedValue()) != null && ClientUtils.checkStatus((Document)(doc = TransferManager.getDocument((Request)(request = new Request().setModule(this.module).setAction("GetRegisterSubjectGroup").setAttribute("subject", subjectItem.getId())))))) {
                ClientUtils.setListSelection(this.groupList, (String)doc.getDocumentElement().getAttribute("gid"));
            }
        }

        public void save(boolean email) {
            BGUListItem subjectItem = this.subjectList.getSelectedValue();
            BGUListItem groupItem = this.groupList.getSelectedValue();
            ((RegisterCall)this.data).setTypeId(subjectItem.getId());
            ((RegisterCall)this.data).setGroupId(groupItem.getId());
            ((RegisterCall)this.data).setComment(this.comment_TA.getText());
            if (this.link.isVisible()) {
                int index = this.link.getSelectedIndex();
                if (index == 1) {
                    BGUListItem linkProblem = (BGUListItem)this.currentProblems_L.getSelectedValue();
                    if (linkProblem != null) {
                        this.problemId = linkProblem.getId();
                    }
                } else if (this.createProblemComment_TA.getText().trim().length() > 0) {
                    this.problemComment = this.createProblemComment_TA.getText();
                }
            }
            this.tryCall(() -> {
                ((CRMService)((ClientContext)CallManager.this.getContext()).getWebService(CRMService.class)).registerCallUpdate((RegisterCall)this.data, this.problemId, this.problemComment, email);
                this.setData();
            });
        }

        private void showProblemPanel(boolean problemExist) {
            this.view.setVisible(problemExist);
            this.link.setVisible(!problemExist);
        }

        public void openProblem_B_actionPerformed(ActionEvent actionEvent) {
            BGServiceConfig serviceConfig = (BGServiceConfig)BGClientBase.getFrame().getTabbedPane().addTab(ActionConfig.class.getName(), BGServiceConfig.class);
            if (serviceConfig.getTabTitle() == null) {
                ClientContext ctx = new ClientContext(null, -1, -1, ActionConfig.class.getPackage().getName() + ".setup");
                serviceConfig.setTabTitle(ResourceBundle.getBundle(ctx.getResourceBundleName()).getString("module.title"));
                serviceConfig.initPanel("module", ctx, ActionConfig.class.getName(), true);
                serviceConfig.setData();
            }
            ProblemManager problemManager = (ProblemManager)serviceConfig.getTab(ProblemManager.class);
            problemManager.addAfterJbInitTask(() -> problemManager.updateForId(this.problemId));
            serviceConfig.selectTab(ProblemManager.class.getName());
        }

        public void unlinkProblem_B_actionPerformed(ActionEvent actionEvent) {
            this.showProblemPanel(false);
            this.link.setSelectedIndex(0);
            this.problemId = 0;
        }

        public boolean doApply() throws Exception {
            ((RegisterCall)this.data).setContractId(this.callContractID);
            this.save(this.sendEmail.isSelected());
            return true;
        }
    }
}

