/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.server.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import ru.bitel.bgbilling.common.dao.AbstractIdDao;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.ContactType;
import ru.bitel.common.model.Id;

public class ContactTypeDao
extends AbstractIdDao<ContactType> {
    private static ConcurrentHashMap<Integer, ContactType> cache = null;

    public ContactTypeDao(Connection con) {
        super(con, "dispatch_contact_type");
    }

    protected void updateImpl(ContactType contactType) throws SQLException {
        Objects.requireNonNull(contactType);
        boolean update = contactType.getId() > 0;
        String query = (update ? "UPDATE " : "INSERT INTO ") + this.tableName + " SET title=?, pattern=?, description=?, pid=?" + (update ? " WHERE id=?" : "");
        try (PreparedStatement ps = this.con.prepareStatement(query, 1);){
            int index = 1;
            ps.setString(index++, contactType.getTitle());
            ps.setString(index++, contactType.getPattern());
            ps.setString(index++, contactType.getDescription());
            ps.setInt(index++, contactType.getPid());
            this.executeUpdate((Id)contactType, index, ps);
        }
        if (cache != null) {
            cache.put(contactType.getId(), contactType);
        }
    }

    protected ContactType getFromRS(ResultSet rs) throws SQLException {
        ContactType ct = new ContactType();
        ct.setId(rs.getInt(this.tableName + ".id"));
        ct.setTitle(rs.getString(this.tableName + ".title"));
        ct.setPattern(rs.getString(this.tableName + ".pattern"));
        ct.setDescription(rs.getString(this.tableName + ".description"));
        ct.setPid(rs.getInt(this.tableName + ".pid"));
        return ct;
    }

    public ContactType get(int id) throws SQLException {
        return cache == null ? (ContactType)super.get(id) : cache.get(id);
    }

    public List<ContactType> getList() throws SQLException {
        List result = this.list("", "title", new Object[0]);
        if (cache == null) {
            cache = new ConcurrentHashMap();
            for (ContactType ct : result) {
                cache.put(ct.getId(), ct);
            }
        }
        return result;
    }
}

