/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.dispatch.server.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.bean.MaskUtils;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Contact;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.ContactType;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Dispatch;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.DispatchMessage;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.SenderType;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.Subscription;
import ru.bitel.bgbilling.plugins.dispatch.common.bean.condition.DispatchBalanceCondition;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.ContactDao;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.ContactTypeDao;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.DispatchDao;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.DispatchMessageDao;
import ru.bitel.bgbilling.plugins.dispatch.server.dao.SubscriptionDao;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.model.ScheduleTime;

public class Converter
extends BGLogger {
    private static int EMAIL_CONTACT_TYPE_ID = 3;
    private static final int EMAIL_SENDER_TYPE_ID = -1;
    private static String DATABASE_SCHEMA = "";
    private Map<Integer, Integer> userDispatchContactMap = new HashMap<Integer, Integer>();

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            if (args.length != 2) {
                System.err.println("Wrong arguments!");
                return;
            }
            DATABASE_SCHEMA = args[0].length() == 0 ? args[0] : args[0] + ".";
            EMAIL_CONTACT_TYPE_ID = Integer.valueOf(args[1]);
        }
        Setup setup = new Setup("data", "data");
        Converter converter = new Converter();
        Connection con = setup.getDBConnectionFromPool();
        con.setAutoCommit(false);
        if (EMAIL_CONTACT_TYPE_ID == -1) {
            EMAIL_CONTACT_TYPE_ID = converter.createEmailContactType(con);
        }
        converter.moveContacts(con);
        for (Dispatch d : converter.moveDispatches(con)) {
            converter.addSubscriptions(con, d);
        }
        con.commit();
        System.exit(0);
    }

    private void moveContacts(Connection con) throws Exception {
        String selectQuery = "SELECT * FROM " + DATABASE_SCHEMA + "user_dispatch";
        Statement st = con.createStatement();
        ResultSet rs = st.executeQuery(selectQuery);
        String insertQuery = "INSERT INTO dispatch_contact (type_id, contract_id, val) VALUES (?, ?, ?)";
        PreparedStatement ps = con.prepareStatement(insertQuery, 1);
        ps.setInt(1, EMAIL_CONTACT_TYPE_ID);
        while (rs.next()) {
            int contractId = rs.getInt("cid");
            String email = rs.getString("mails");
            ps.setInt(2, contractId);
            ps.setString(3, email);
            ps.executeUpdate();
            ResultSet generatedKeys = ps.getGeneratedKeys();
            if (!generatedKeys.next()) continue;
            int userDispatchId = rs.getInt("id");
            int insertedContactId = generatedKeys.getInt(1);
            this.userDispatchContactMap.put(userDispatchId, insertedContactId);
        }
        ps.close();
        rs.close();
    }

    private List<Dispatch> moveDispatches(Connection con) throws Exception {
        ArrayList<Dispatch> dispatches = new ArrayList<Dispatch>();
        Statement st = con.createStatement();
        String query = "SELECT * FROM " + DATABASE_SCHEMA + "user_dispatch_reference";
        ResultSet rs = st.executeQuery(query);
        while (rs.next()) {
            String title = rs.getString("title");
            String module = rs.getString("module");
            if (!module.equals("contract")) continue;
            dispatches.add(this.addBalanceDispatch(con, title));
        }
        rs.close();
        st.close();
        return dispatches;
    }

    private Dispatch addBalanceDispatch(Connection con, String title) throws Exception {
        SenderType st = new SenderType();
        st.setId(-1);
        ArrayList<DispatchBalanceCondition> conditions = new ArrayList<DispatchBalanceCondition>();
        DispatchBalanceCondition condition = new DispatchBalanceCondition();
        conditions.add(condition);
        Dispatch dispatch = new Dispatch().setActive(true).setPersonal(true).setTitle(title).setSenderType(st).setConditions(conditions).setContactTypeId(EMAIL_CONTACT_TYPE_ID);
        new DispatchDao(con).update(dispatch);
        Date now = new Date();
        DispatchMessage dispatchMessage = new DispatchMessage().setTitle("\u0420\u0430\u0441\u0441\u044b\u043b\u043a\u0430 \u0431\u0430\u043b\u0430\u043d\u0441\u0430").setMessageBody("$${class:ru.bitel.bgbilling.plugins.dispatch.server.bean.message.DispatchBalanceMessage}").setCreateDate(now).setSendDate(now).setDispatchId(dispatch.getId());
        new DispatchMessageDao(con).update(dispatchMessage);
        return dispatch;
    }

    private int createEmailContactType(Connection con) throws Exception {
        ContactType ct = new ContactType();
        ct.setTitle("E-mail");
        ct.setDescription("\u0412\u0432\u0435\u0434\u0438\u0442\u0435 e-mail, \u043d\u0430\u043f\u0440\u0438\u043c\u0435\u0440, example@example.org");
        ct.setPattern("^[A-z0-9._%+-]+@[A-z0-9.-]+\\.[A-z]{2,4}$");
        new ContactTypeDao(con).update(ct);
        return ct.getId();
    }

    private void addSubscriptions(Connection con, Dispatch d) throws Exception {
        Statement st = con.createStatement();
        String selectQuery = "SELECT * FROM " + DATABASE_SCHEMA + "user_dispatch";
        ResultSet rs = st.executeQuery(selectQuery);
        while (rs.next()) {
            int contractId = rs.getInt("cid");
            Contact contact = (Contact)new ContactDao(con).get(this.userDispatchContactMap.get(rs.getInt("id")));
            String params = rs.getString("params");
            Map<String, String> paramsMap = Converter.deserializeParams(params);
            String daysOfWeek = new MaskUtils(1, 7).longToString(this.getDaysOfWeek(paramsMap));
            this.getLogger().debug("Days of week: " + daysOfWeek);
            ScheduleTime scheduleTime = new ScheduleTime();
            scheduleTime.setDayOfWeek((int)Utils.packValues(Collections.singleton(daysOfWeek), (int)1));
            Preferences prefs = new Preferences();
            String balanceLimit = Converter.getUserDispatchParam(paramsMap, "balance_limit", null);
            if (balanceLimit != null) {
                this.getLogger().debug("Balance limit: " + balanceLimit);
                prefs.set("0.to_balance", balanceLimit);
            }
            Subscription s = new Subscription();
            s.setContacts(Collections.singletonList(contact));
            s.setActive(rs.getBoolean("status"));
            s.setContractId(contractId);
            s.setDispatch(d);
            s.setPreferences(prefs);
            s.setRepeatTime(scheduleTime);
            s.setComment("");
            SubscriptionDao subscriptionDao = new SubscriptionDao(con);
            subscriptionDao.update(s);
        }
    }

    private long getDaysOfWeek(Map<String, String> paramsMap) {
        return Utils.parseLong((String)Converter.getUserDispatchParam(paramsMap, "dw", "1-7"), (long)0L);
    }

    private static String getUserDispatchParam(Map<String, String> paramsMap, String name, String defaultValue) {
        String result = null;
        result = paramsMap.get(name);
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    private static Map<String, String> deserializeParams(String params) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        Pattern pt = Pattern.compile("%p%");
        Pattern pt_v = Pattern.compile("%v%");
        String[] pairs = pt.split(params);
        for (int i = 0; i < pairs.length; ++i) {
            String[] pair_value = pt_v.split(pairs[i]);
            if (pair_value == null || pair_value.length != 2) continue;
            paramsMap.put(pair_value[0], pair_value[1]);
        }
        return paramsMap;
    }
}

