/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.client;

import bitel.billing.module.common.BGComboBox;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.hd.client.ContractPackageEditor;
import ru.bitel.bgbilling.modules.hd.client.PackageEditorPanel;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class ContractPackageNsEditor
extends PackageEditorPanel
implements ActionListener {
    private List<NsItem> nsList = new ArrayList<NsItem>();
    private ContractPackageEditor serviceEditor;
    private BGDialogToolBar toolBar = new BGDialogToolBar();
    private CardLayout cardLayout = new CardLayout();
    private BGTextField domain = new BGTextField();
    private JPanel nsPanel = new JPanel(new GridBagLayout());
    private int nsDomain;
    private JPanel primaryPanel = new JPanel(new GridBagLayout());
    private BGComboBox<NsBoxItem> primaryNS = new BGComboBox();
    private BGTextField primaryHost = new BGTextField();
    private BGTextField primaryAddress = new BGTextField();
    private BGTextField domainTTL = new BGTextField();
    private BGTextField adminMail = new BGTextField();
    private BGTextField soaRetry = new BGTextField();
    private BGTextField soaRefresh = new BGTextField();
    private BGTextField soaExpire = new BGTextField();
    private BGTextField soaMimimum = new BGTextField();
    private JList secondaryNSList = new JList();
    private BGComboBox<NsBoxItem> secondaryNS = new BGComboBox();
    private JPanel secondaryPanel = new JPanel(this.cardLayout);
    private BGTextField secondaryHost = new BGTextField();
    private BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();

    public ContractPackageNsEditor(ContractPackageEditor serviceEditor) {
        this.serviceEditor = serviceEditor;
        this.jbInit();
    }

    private void jbInit() {
        JPanel secondaryPanelList = new JPanel(new GridBagLayout());
        JPanel secondaryPanelEditor = new JPanel(new GridBagLayout());
        NsBoxItem nsBoxItem = new NsBoxItem();
        nsBoxItem.id = -1;
        nsBoxItem.host = "\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439";
        nsBoxItem.addr = null;
        this.primaryNS.addItem((Object)nsBoxItem);
        this.primaryPanel.add((Component)new JLabel("PRIMARY:"), new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.primaryPanel.add((Component)new JLabel("\u0422\u0438\u043f:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.primaryPanel.add((Component)this.primaryNS, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.primaryPanel.add((Component)new JLabel("Refresh:"), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.primaryPanel.add((Component)this.soaRefresh, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.primaryPanel.add((Component)new JLabel("\u0425\u043e\u0441\u0442:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.primaryPanel.add((Component)this.primaryHost, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.primaryPanel.add((Component)new JLabel("Retry:"), new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.primaryPanel.add((Component)this.soaRetry, new GridBagConstraints(3, 2, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.primaryPanel.add((Component)new JLabel("E-Mail:"), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.primaryPanel.add((Component)this.adminMail, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.primaryPanel.add((Component)new JLabel("Expire:"), new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.primaryPanel.add((Component)this.soaExpire, new GridBagConstraints(3, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.primaryPanel.add((Component)new JLabel("TTL:"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.primaryPanel.add((Component)this.domainTTL, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.primaryPanel.add((Component)new JLabel("Mimimum:"), new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.primaryPanel.add((Component)this.soaMimimum, new GridBagConstraints(3, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.primaryPanel.add(Box.createVerticalStrut(2), new GridBagConstraints(0, 5, 4, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.toolBar.setDefaultButtons((ActionListener)this);
        this.toolBar.setToolBar(new String[]{"newItem", "editItem", "deleteItem"});
        this.toolBar.setFloatable(false);
        this.toolBar.setOrientation(1);
        nsBoxItem = new NsBoxItem();
        nsBoxItem.id = -1;
        nsBoxItem.host = "\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u0441\u043a\u0438\u0439";
        nsBoxItem.addr = null;
        this.secondaryNS.addItem((Object)nsBoxItem);
        secondaryPanelList.add((Component)new JLabel("SECONDARY:"), new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        secondaryPanelList.add((Component)new JLabel("IP \u0430\u0434\u0440\u0435\u0441 PRIMARY:"), new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        secondaryPanelList.add((Component)this.primaryAddress, new GridBagConstraints(2, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        secondaryPanelList.add((Component)this.toolBar, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        secondaryPanelList.add((Component)this.secondaryNSList, new GridBagConstraints(1, 2, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        secondaryPanelEditor.add((Component)new JLabel("SECONDARY:"), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        secondaryPanelEditor.add((Component)this.secondaryNS, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        secondaryPanelEditor.add((Component)new JLabel("Host/Address:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        secondaryPanelEditor.add((Component)this.secondaryHost, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        secondaryPanelEditor.add((Component)this.okCancel, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        secondaryPanelEditor.add(Box.createVerticalStrut(2), new GridBagConstraints(0, 4, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.secondaryPanel.add((Component)secondaryPanelList, "list");
        this.secondaryPanel.add((Component)secondaryPanelEditor, "editor");
        this.setLayout(new GridLayout(1, 2));
        this.add(this.primaryPanel);
        this.add(this.secondaryPanel);
        this.okCancel.addActionListener(e -> this.cardLayout.show(this.secondaryPanel, "list"));
        this.primaryNS.addItemListener(e -> {
            if (this.primaryNS.getSelectedIndex() == 0) {
                this.primaryHost.setEditable(true);
                this.primaryAddress.setEditable(true);
            } else {
                this.primaryHost.setEditable(false);
                this.primaryAddress.setEditable(false);
            }
        });
    }

    @Override
    public void updateEditor(Element service) {
        this.nsDomain = Utils.parseInt((String)service.getAttribute("ns_domain"));
        if (this.nsDomain == 1) {
            this.domain.setEnabled(false);
        }
        this.nsList.clear();
        this.nsPanel.removeAll();
        this.nsPanel.add((Component)new JLabel("NS \u0421\u0435\u0440\u0432\u0435\u0440"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
        this.nsPanel.add((Component)new JLabel("\u041e\u0431\u044f\u0437\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439"), new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        int pos = 1;
        for (Integer id : Utils.toIntegerList((String)service.getAttribute("ns_server"))) {
            NsItem item = new NsItem();
            item.textField = new BGTextField();
            if (id < 0) {
                item.textField.setEditable(true);
                item.textField.setText("");
                if (id == -1) {
                    JLabel label = new JLabel("*");
                    label.setFont(new Font("Dialog", 1, 20));
                    this.nsPanel.add((Component)label, new GridBagConstraints(1, pos, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0));
                }
            } else {
                item.textField.setEnabled(false);
                item.textField.setText(service.getAttribute("ns_server_" + id));
            }
            this.nsList.add(item);
            this.nsPanel.add((Component)item.textField, new GridBagConstraints(0, pos++, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0));
        }
        this.nsPanel.add(Box.createVerticalStrut(2), new GridBagConstraints(0, pos++, 1, 1, 0.0, 1.0, 10, 3, new Insets(5, 5, 0, 0), 0, 0));
    }

    @Override
    public void update() {
        if (this.nsDomain == 1) {
            this.domain.setText(this.serviceEditor.getDomainEditor().getDomain());
        }
    }

    public String checkNs() {
        return "";
    }

    public String getNsList() {
        StringBuilder result = new StringBuilder();
        for (NsItem item : this.nsList) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(item.textField.getText());
        }
        return result.toString();
    }

    @Override
    public void setData(Element data) {
        this.domain.setText("");
        if (data != null) {
            for (NsItem ns : this.nsList) {
                ns.textField.setText("");
            }
            try {
                Element ns = XMLUtils.selectElement((Node)data, (String)"//ns");
                this.domain.setText(ns.getAttribute("domain"));
                NodeList list = ns.getElementsByTagName("server");
                int size = list.getLength();
                for (int i = 0; i < size; ++i) {
                    Element serverEl = (Element)list.item(i);
                    if (this.nsList.size() <= i) continue;
                    this.nsList.get((int)i).textField.setText(serverEl.getAttribute("name"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void addToRequest(Request req) {
        req.setAttribute("ns_domain", this.domain.getText());
        req.setAttribute("ns_list", this.getNsList());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command != null) {
            if (command.equals("newItem")) {
                this.cardLayout.show(this.secondaryPanel, "editor");
            } else if (command.equals("editItem")) {
                this.cardLayout.show(this.secondaryPanel, "editor");
            } else if (command.equals("deleteItem")) {
                this.deleteItem();
            }
        }
    }

    static class NsBoxItem {
        public int id;
        public String host;
        public String addr;

        NsBoxItem() {
        }

        public String toString() {
            return this.host;
        }
    }

    static class NsItem {
        public int id;
        public BGTextField textField;

        NsItem() {
        }
    }
}

