/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.hd.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.table.BGTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGDialogToolBar;
import ru.bitel.bgbilling.client.common.field.BGTextField;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.modules.hd.client.ContractPackageEditor;
import ru.bitel.bgbilling.modules.hd.client.PackageEditorPanel;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.BGButtonPanelOkCancel;

public class ContractPackageHostEditor
extends PackageEditorPanel
implements ActionListener {
    private ContractPackageEditor serviceEditor;
    private BGDialogToolBar toolBar = new BGDialogToolBar();
    private BGTable table = new BGTable();
    private JLabel domainLabel = new JLabel(".domain");
    private BGComboBox<String> recordType = new BGComboBox();
    private BGTextField recordName = new BGTextField();
    private BGTextField recordValue = new BGTextField();
    private JPanel editor = new JPanel(new GridBagLayout());
    private String[] recordTypeList = new String[]{"A", "NS", "MX", "TXT"};
    private int hostDomain;
    private int hostCol;
    private int row = -1;

    public ContractPackageHostEditor(ContractPackageEditor serviceEditor) {
        this.serviceEditor = serviceEditor;
        this.jbInit();
        this.editor.setVisible(false);
        this.table.setHeader(this.rb_name, this.moduleDoc, "contract_package_host");
    }

    private void jbInit() {
        this.setLayout(new GridBagLayout());
        for (String item : this.recordTypeList) {
            this.recordType.addItem((Object)item);
        }
        this.recordName.setMinimumSize(new Dimension(300, this.recordName.getPreferredSize().height));
        this.recordName.setPreferredSize(new Dimension(300, this.recordName.getPreferredSize().height));
        this.domainLabel.setFont(new Font("Dialog", 1, 16));
        this.toolBar.setDefaultButtons((ActionListener)this);
        this.toolBar.setToolBar(new String[]{"newItem", "editItem", "copyItem", "deleteItem"});
        this.toolBar.setFloatable(false);
        this.toolBar.setOrientation(1);
        this.editor.add((Component)new JLabel("\u0417\u043e\u043d\u0430: "), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.editor.add((Component)this.domainLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.editor.add((Component)new JLabel("\u0417\u0430\u043f\u0438\u0441\u044c: "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.editor.add((Component)this.recordName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.editor.add((Component)new JLabel("\u0422\u0438\u043f: "), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.editor.add((Component)this.recordType, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.editor.add((Component)new JLabel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435: "), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.editor.add((Component)this.recordValue, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 5, 5), 0, 0));
        BGButtonPanelOkCancel okCancel = new BGButtonPanelOkCancel();
        this.editor.add((Component)okCancel, new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.toolBar, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add(new JScrollPane((Component)this.table), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this.editor, new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 10, 2, new Insets(5, 5, 5, 0), 0, 0));
        okCancel.addActionListener(e -> this.stopEdit(e.getActionCommand().equals("ok")));
    }

    @Override
    public void updateEditor(Element service) {
        this.hostDomain = Utils.parseInt((String)service.getAttribute("host_domain"));
        if (this.hostDomain == -1) {
            this.domainLabel.setText(".domain");
        } else {
            this.domainLabel.setText("." + service.getAttribute("host_domain_name"));
        }
        this.hostCol = Utils.parseInt((String)service.getAttribute("host_col"));
        this.recordValue.setEnabled(true);
        String hostAddr = service.getAttribute("host_addr");
        if (Utils.notBlankString((String)hostAddr)) {
            this.recordValue.setText(hostAddr);
            this.recordValue.setEnabled(false);
        }
    }

    @Override
    public void update() {
        if (this.hostDomain == -1) {
            this.domainLabel.setText(this.serviceEditor.getDomainEditor().getDomain());
        }
    }

    public void newItem() {
        if (this.hostCol > 0 && this.hostCol <= this.table.getRowCount()) {
            ClientUtils.showErrorMessageDialog((String)"\u0411\u043e\u043b\u044c\u0448\u0435 \u0441\u043e\u0437\u0434\u0430\u0432\u0430\u0442\u044c \u0445\u043e\u0441\u0442\u044b \u043d\u0435\u043b\u044c\u0437\u044f");
            return;
        }
        this.row = -1;
        this.editor.setVisible(true);
        this.recordName.setText("");
        this.recordType.setSelectedItem((Object)"A");
        this.recordValue.setText("");
    }

    public void editItem() {
        this.row = this.table.getSelectedRow();
        if (this.row < 0) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
            return;
        }
        this.editor.setVisible(true);
        this.recordName.setText((String)this.table.getValueAt(this.row, 0));
        this.recordType.setSelectedItem((Object)((String)this.table.getValueAt(this.row, 1)));
        this.recordValue.setText((String)this.table.getValueAt(this.row, 2));
    }

    public void copyItem() {
        this.row = this.table.getSelectedRow();
        if (this.row < 0) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
            return;
        }
        this.editor.setVisible(true);
        this.recordName.setText((String)this.table.getValueAt(this.row, 0));
        this.recordType.setSelectedItem((Object)((String)this.table.getValueAt(this.row, 1)));
        this.recordValue.setText((String)this.table.getValueAt(this.row, 2));
        this.row = -1;
    }

    public void deleteItem() {
        this.row = this.table.getSelectedRow();
        if (this.row < 0) {
            ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0441\u0442\u0440\u043e\u043a\u0443!");
            return;
        }
        this.table.removeRow(this.row);
        this.row = -1;
    }

    private void stopEdit(boolean save) {
        if (save) {
            String recName = this.recordName.getText();
            String recValue = this.recordValue.getText();
            if (Utils.isBlankString((String)recValue)) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u0430\u0434\u0440\u0435\u0441!");
                return;
            }
            try {
                if (this.row == -1) {
                    this.addRow(recName, (String)this.recordType.getSelectedItem(), recValue);
                } else {
                    this.updateRow(recName, (String)this.recordType.getSelectedItem(), recValue);
                }
                this.editor.setVisible(false);
                this.serviceEditor.getHostingEditor().update();
            }
            catch (Exception exception) {}
        } else {
            this.editor.setVisible(false);
        }
    }

    private void addRow(String recName, String recType, String recValue) throws Exception {
        Document doc = XMLUtils.newDocument();
        Element row = doc.createElement("row");
        row.setAttribute("record", recName);
        row.setAttribute("type", recType);
        row.setAttribute("value", recValue);
        this.table.addRow(row);
    }

    private void updateRow(String recName, String recType, String recValue) {
        this.table.setValueAt((Object)recName, this.row, 0);
        this.table.setValueAt((Object)recType, this.row, 1);
        this.table.setValueAt((Object)recValue, this.row, 2);
    }

    public String getRecordList() {
        StringBuilder result = new StringBuilder();
        Vector<Vector> data = ((DefaultTableModel)this.table.getModel()).getDataVector();
        int size = data.size();
        for (int i = 0; i < size; ++i) {
            if (result.length() != 0) {
                result.append(",");
            }
            Vector row = data.get(i);
            result.append(row.get(0));
            result.append("\t");
            result.append(row.get(1));
            result.append("\t");
            result.append(row.get(2));
        }
        return result.toString();
    }

    @Override
    public void setData(Element data) {
        try {
            Element tableEl = XMLUtils.newDocument().createElement("table");
            XMLUtils.createElement((Element)tableEl, (String)"fake");
            this.table.updateData((Node)tableEl);
            if (data != null) {
                Element hostListEl = XMLUtils.selectElement((Node)data, (String)"//records");
                NodeList list = hostListEl.getElementsByTagName("record");
                int size = list.getLength();
                for (int i = 0; i < size; ++i) {
                    Element hostEl = (Element)list.item(i);
                    this.addRow(hostEl.getAttribute("name"), hostEl.getAttribute("type"), hostEl.getAttribute("value"));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void addToRequest(Request req) {
        req.setAttribute("records", this.getRecordList());
    }
}

