<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:import href="layout.xsl"/>

<xsl:template name="title">
	HelpDesk
	<xsl:choose>
		<xsl:when test="data/@action = 'Topic'"> - Переписка</xsl:when>
		<xsl:when test="data/@action = 'HelpDeskParam'"> - Параметры</xsl:when>
		<xsl:when test="data/@command = 'newtopic'"> - Создание новой темы</xsl:when>
		<xsl:when test="data/@command = 'activetopic'"> - Активные темы</xsl:when>
		<xsl:when test="data/@command = 'archivetopic'"> - Архив</xsl:when>
		<xsl:when test="data/@command = 'packagelist'"> - Пакеты</xsl:when>
	</xsl:choose>
</xsl:template>

<xsl:template match="/data">
<xsl:if test="@action = 'HelpDeskAJAX'">
<link rel="stylesheet" type="text/css" href="css/ru.bitel.bgbilling.plugins.helpdesk.css"/>
<link rel="stylesheet" type="text/css" href="css/ui-lightness/jquery-ui.css"/>
<script language="javascript" type="text/javascript">var contractId = <xsl:value-of select="$CONTRACT_ID"/>; </script>
<script language="javascript" type="text/javascript" src="js/ru.bitel.bgbilling.plugins.helpdesk.js"></script>

	<!-- кнопки -->
	<table class="filter" style="margin-bottom: 20px;">
		<tr>
			<td><input type="button" value="Новая тема" onclick="addHelpDeskTopic()" /></td>
			<td><input type="button" value="Активные" onclick="showTopicTable( 'active' )" /></td>
			<td><input type="button" value="Архив" onclick="showTopicTable( 'archive' )" /></td>
			<td><input type="button" value="Параметры" onclick="showHelpDeskParam()" /></td>
			<td><input type="button" value="Пакеты" onclick="showHelpDeskPackage()" id="helpDeskButtonPackages" style="display: none" /></td>
			<td><span style="font-size: 10pt;" class="colorInfo">[если, что то не работает, попробуйте старую <a style="font-size: 10pt;" href="?action=HelpDeskTable&amp;mid=0&amp;module=ru.bitel.bgbilling.plugins.helpdesk">версию</a>]</span></td>
		</tr>
	</table>

	<div id="topicList" class="report" style="display: none">
	</div>
	
	<div id="topicData" style="display: none">
		<div class="HelpDeskTopicInfo colorInfo">
			<span class="n">ID: </span><span class="v" id="topicId" />
			<span class="n">Статус: </span><span class="v" id="topicStatus" />
			<span class="n">Дата открытия: </span><span class="v" id="topicDate" />
			<span class="n">Оповещение:</span><span class="v" id="topicComm" />
			<span class="n">Менеджер:</span><span class="v" id="topicUser" />
			<span class="n">Стоимость:</span><span class="v" id="topicCost" />
			<span class="n">URL темы:</span><a id="topicURL" />
		</div>
		<div class="HelpDeskTopicTitle colorTitle"><span>Тема:</span><span id="topicTitle"/></div>
		<hr />
		<div id="topicMesssageFilter" style="padding: 5px 3px;">Фильтр сообщений: 
			<a href='#' style='font-weight: bold;' onclick='return helpDeskTopicMessageFilter( this, 5 );'>последние 5</a> | 
			<a href='#' onclick='return helpDeskTopicMessageFilter( this, 10 );'>последние 10</a> | 
			<a href='#' onclick='return helpDeskTopicMessageFilter( this, -1 );'>все</a> | 
			<a href='#' onclick='return helpDeskTopicMessageFilter( this, -2 );'>входящие</a> | 
			<a href='#' onclick='return helpDeskTopicMessageFilter( this, -3 );'>исходящие</a>
			<span style='margin-left: 30px;'>[<a href='#' onclick='return showNextTextAll();'>развернуть все сообщения</a>]</span>
		</div>
		<div id="topicMesssageList" />		
		<table id="topicMessage" class="tableBorder" width="100%" border="0" cellpadding="1" style="margin-bottom: 10px; position: absolute; left: -2500px; right: -2000px; top: 0;">
			<tr>
				<td class="tableBackgroundColorHead tableBorder" style="padding: 3px 10px;">
					<div class="HelpDeskTopicMessage colorInfoDark">
						<span class="new colorNew" id="messageNew"></span>
						<span class="n">Сообщение: </span><span class="v" id="messageN" />
						<span class="n">ID: </span><span class="v" id="messageId" />
						<span class="n">Отправлено:</span><span class="v" id="messageFrom" />
						<span class="n">Прочитано:</span><span class="v" id="messageTo" />
						<span id="messageReply" />
					</div>
				</td>
			</tr>
			<tr><td><div class="HelpDeskTopicMessageFile" id="messageFile" /></td></tr>
			<tr><td align="left"><div class="HelpDeskTopicMessageText colorText" /></td></tr>
		</table>
		<div id="topicReplyButton"><input type="button" value="Ответить" onclick="topicMessageNew( '' )" /> <input type="button" style="margin-left: 2em;"  value="Закрыть тему" onclick="helpDeskTopicClose()" /></div>
		<div id="topicMessageNew" style="display: none; font-size: 10pt;">
			<form action="{$WEBEXECUTER}" method="post" enctype="multipart/form-data" target="messageFrame">
			<input type="hidden" name="action" value="AddMessage" />
			<input type="hidden" name="topicId" value="" />
			<input type="hidden" name="contractId" value="{$CONTRACT_ID}" />
			<input type="hidden" name="ct" value="json" />
			<input type="hidden" name="mid" value="0" />
			<input type="hidden" name="module" value="ru.bitel.bgbilling.plugins.helpdesk" />
			<div style="width: 100%;">Текст сообщения<br/><textarea name="message_body" rows="20" style="width: 100%; font-size: 12pt;"></textarea></div>
			<div id="tdwithfileinput">Прикрепить файл<br/></div>
			<div style="padding: 10px 0px;"> <input type="button" value="Отправить" onclick="sendTopicMessageNew( this.form )" /></div>
			</form>
			<iframe name="messageFrame" width="0" height="0" border="0" style="width: 0; height: 0; border: none;"></iframe>
		</div>
	</div>
	
	<div id="helpDeskParam" class="report" style="display: none"></div>

	<div id="helpDeskPackage" style="display: none">
	<div class="listTitle">Активированные пакеты:</div>
	<div class="report">
	<table>
		<col class="col1" width="50"/>
		<col class="col2" width="150"/>
		<col class="col3" width="100"/>
		<col class="col4" width="180"/>
		<col class="col5" width="80"/>
		<col class="col6"/>
		<thead>
			<tr>
				<td>ID</td>
				<td>Период</td>				
				<td>Стоимость</td>				
				<td>Обращений [использовано]</td>
				<td>Активный</td>
				<td>Активировал</td>
			</tr>
		</thead>
		<tbody/>
	</table>
	</div>
	<div style="margin-top: 10px;">
		<div class="listTitle colorListTitle">Доступные пакеты <span class="memo colorListTitleMemo">(выбранный пакет будет активирован только при наличие на счете суммы большей или равной стоимости пакета)</span>:</div>
		<div id="helpDeskPackageList" />
		<div id="helpDeskPackageListItem" style="display: none;" class="listItem">
			<div class="listItemTitle" id="packageItemTitle" />
			<div class="listItemParam">
				<span class="n">Период [дней]:</span><span class="v" id="packageItemPeriod"/>
				<span class="n">Обращений:</span><span class="v" id="packageItemCount"/>
				<span class="n">Стоимость:</span><span class="v" id="packageItemSumma"/>
			</div>
		</div>
	</div>
	</div>

	<div id="helpDeskAddTopic" style="display: none"></div>
    
    <form id="currentTopicId"><input type="hidden" name="currentTopicId"><xsl:attribute name="value"><xsl:value-of select="@topicId" /></xsl:attribute></input></form>

</xsl:if>

<xsl:if test="@action != 'HelpDeskAJAX'">
<script language="javascript" type="text/javascript">
	<xsl:text disable-output-escaping="yes">
	<![CDATA[
var numfinput = 1;
function filechange()
{
	++numfinput;
	var g=document.getElementById('tdwithfileinput');
	var bre=document.createElement('br');
	g.appendChild(bre);
	var inpt=document.createElement('input');
	inpt.type="file";
	inpt.size=50;
	inpt.name="message_file_"+numfinput;
	inpt.onchange=filechange;
	g.appendChild(inpt);
}

var sendandclose = false;
function sendAndClose(button)
{
	sendandclose = true;
	if ( confirm('Вы уверены, что хотите отправить сообщение и закрыть тему?') )
	{
		button.form.command.value="savemessageandclose";
		button.form.submit();
	}
}
	]]>
	</xsl:text>
</script>

	<style>
<xsl:text disable-output-escaping="yes">
<![CDATA[
div.HelpDeskTopicInfo { font-size: 8pt; color: #808080; }
div.HelpDeskTopicInfo span.n { font-weight: bold; margin-right: 0.3em; }
div.HelpDeskTopicInfo span.v { margin-right: 1em; }

div.HelpDeskTopicTitle { font-size: 14pt; font-weight: bold; color: #4040ff; margin-top: 5px; padding: 5px; }
div.HelpDeskTopicTitle span { font-weight: bold; margin-right: 1em; }

div.HelpDeskTopicMessage { font-size: 8pt; color: #404040; }
div.HelpDeskTopicMessage span.n { font-weight: bold; margin-right: 0.3em; }
div.HelpDeskTopicMessage span.v { margin-right: 1em; }
div.HelpDeskTopicMessage span.new { font-weight: bold; color: blue; padding-right: 5px; }

div.HelpDeskTopicMessageText { font-size: 11pt; color: #101010; }
]]>
</xsl:text>
	</style>
	

	<!-- кнопки -->
	<table class="filter">
		<tr>
			<td>
				<xsl:call-template name="rawLinkButton">
					<xsl:with-param name="url"><xsl:value-of select="$WEBEXECUTER"/>?action=HelpDeskTable&amp;module=ru.bitel.bgbilling.plugins.helpdesk&amp;mid=0&amp;command=newtopic&amp;contractId=<xsl:value-of select="$CONTRACT_ID"/></xsl:with-param>
					<xsl:with-param name="title" select="'Новая тема'"/>
				</xsl:call-template>
			</td>
			<td>
				<xsl:call-template name="rawLinkButton">
					<xsl:with-param name="url"><xsl:value-of select="$WEBEXECUTER"/>?action=HelpDeskTable&amp;module=ru.bitel.bgbilling.plugins.helpdesk&amp;mid=0&amp;command=activetopic&amp;contractId=<xsl:value-of select="$CONTRACT_ID"/></xsl:with-param>
					<xsl:with-param name="title" select="'Активные'"/>
				</xsl:call-template>
			</td>
			<td>
				<xsl:call-template name="rawLinkButton">
					<xsl:with-param name="url"><xsl:value-of select="$WEBEXECUTER"/>?action=HelpDeskTable&amp;module=ru.bitel.bgbilling.plugins.helpdesk&amp;mid=0&amp;command=archivetopic&amp;contractId=<xsl:value-of select="$CONTRACT_ID"/></xsl:with-param>
					<xsl:with-param name="title" select="'Архив'"/>
				</xsl:call-template>
			</td>
			<td>
				<xsl:call-template name="rawLinkButton">
					<xsl:with-param name="url"><xsl:value-of select="$WEBEXECUTER"/>?action=HelpDeskParam&amp;module=ru.bitel.bgbilling.plugins.helpdesk&amp;mid=0&amp;command=showparam&amp;contractId=<xsl:value-of select="$CONTRACT_ID"/></xsl:with-param>
					<xsl:with-param name="title" select="'Параметры'"/>
				</xsl:call-template>
			</td>
			<xsl:if test="//data/packages">
			<td>
				<xsl:call-template name="rawLinkButton">
					<xsl:with-param name="url"><xsl:value-of select="$WEBEXECUTER"/>?action=HelpDeskPackage&amp;module=ru.bitel.bgbilling.plugins.helpdesk&amp;mid=0&amp;command=packagelist&amp;contractId=<xsl:value-of select="$CONTRACT_ID"/></xsl:with-param>
					<xsl:with-param name="title" select="'Пакеты'"/>
				</xsl:call-template>
			</td>
			</xsl:if>
		</tr>
	</table>
	</xsl:if>
	
	<xsl:if test="@action = 'HelpDeskTable' and (@command = 'activetopic' or @command = 'archivetopic')">		
		<form method='post' action='{$WEBEXECUTER}'>
		<xsl:call-template name="action"/>
		<xsl:call-template name="error"	/>
		<input type="hidden" name="command"><xsl:attribute name="value"><xsl:value-of select="/data/@command"/></xsl:attribute></input>
		<input type="hidden" name="contractId" value="{$CONTRACT_ID}" />
		<table class="filter">
			<tr>
				<th>
					ID Темы
				</th>
				<td>
					<input type="text" name="tid" size="5" value="{@tid}"/>
				</td>
				<th style="text-align:center">
					Название
				</th>
				<td>
					<input type="text" name="topic" size="20" value="{@topic}"/>
				</td>
				<th style="text-align:center">
					В периоде с
					<input type="text" name="date1" size="7" value="{@date1}"/>
				</th>
				<th style="text-align:center">
					по
					<input type="text" name="date2" size="7" value="{@date2}"/>
				</th>
			</tr>
		</table>
		<table class="filter">
			<tr>
				<th style="text-align:center">
					Строка поиска в сообщениях
				</th>
				<td>
					<input type="text" name="searchString" size="40" value="{@searchString}"/>
				</td>
				<td>
					<xsl:call-template name="submit">
						<xsl:with-param name="title" select="'Фильтр'"/>
					</xsl:call-template>
				</td>
				<td>
					<xsl:call-template name="rawLinkButton">
						<xsl:with-param name="url"><xsl:value-of select="$WEBEXECUTER"/>?action=HelpDeskTable&amp;module=ru.bitel.bgbilling.plugins.helpdesk&amp;mid=0&amp;command=activetopic&amp;contractId=<xsl:value-of select="$CONTRACT_ID"/></xsl:with-param>
						<xsl:with-param name="title" select="'Очистить'"/>
					</xsl:call-template>
				</td>
			</tr>
		</table>
		</form>
		<hr/>
	</xsl:if>	
	
	
	<xsl:if test="@action = 'HelpDeskTable' and (@command = 'activetopic' or @command = 'archivetopic')">		
		<xsl:call-template name="HelpDeskTable"/>		
	</xsl:if>
	<xsl:if test="@action = 'HelpDeskTable' and @command = 'newtopic'">		
		<xsl:call-template name="HelpDeskAdd"/>		
	</xsl:if>
	<xsl:if test="@action = 'Topic'">		
		<xsl:call-template name="HelpDeskTopic"/>		
	</xsl:if>	
	<xsl:if test="@action = 'HelpDeskPackage'">		
		<xsl:call-template name="HelpDeskPackage"/>		
	</xsl:if>	
	<xsl:if test="@action = 'HelpDeskParam'">		
		<xsl:call-template name="HelpDeskParam"/>		
	</xsl:if>	
</xsl:template>


<xsl:template name="HelpDeskTable">
	<div class="report">
	<table class="table" cellspacing="1" style="border: 0px; width: 100%;">
		<col width="50" align="right"/>
		<col/>
		<col width="100"/>
		<col width="70"/>
		<col width="70"/>
		<col width="70"/>
		<col width="100"/>
		<xsl:if test="//data/nonPackageMode">
			<col width="100"/>
		</xsl:if>
		<xsl:if test="//data/packages">
			<col width="100"/>
		</xsl:if>
		<col width="50"/>
		<thead>
			<tr>
				<td>ID</td>
				<td>Заголовок</td>				
				<td>Оповещение</td>
				<td>Дата создания</td>			
				<td>Состояние</td>
				<td>Дата закрытия</td>
				<td>Статус</td>
				<xsl:if test="//data/nonPackageMode">
					<td>Стоимость</td>
				</xsl:if>
				<xsl:if test="//data/packages">
					<td>Входит в пакет</td>
				</xsl:if>
				<td>Выгрузка</td>
			</tr>
		</thead>
		<tbody>
			<xsl:for-each select="tableTopic/row">
			<tr>
				<td><xsl:value-of select="@id"/></td>
				<td style="text-align: left">
					<a href="{$WEBEXECUTER}?action=Topic&amp;module=ru.bitel.bgbilling.plugins.helpdesk&amp;mid=0&amp;id={@id}&amp;contractId={$CONTRACT_ID}"><xsl:value-of select="@title"/></a>					
					<xsl:if test="@haveNewMsg = 'true'">						
						<a style="color: red;" href="{$WEBEXECUTER}?action=Topic&amp;module=ru.bitel.bgbilling.plugins.helpdesk&amp;mid=0&amp;id={@id}&amp;contractId={$CONTRACT_ID}#new"> [новые]</a>
					</xsl:if>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="@comm = '0'">-</xsl:when>
						<xsl:when test="@comm = '1'">по телефону: <xsl:value-of select="@comm_value" /></xsl:when>
						<xsl:when test="@comm = '2'">по e-mail: <xsl:value-of select="@comm_value" /></xsl:when>
					</xsl:choose>
				</td>
				<td><xsl:value-of select="@date"/></td>
				<td><xsl:value-of select="@status"/></td>
				<td><xsl:value-of select="@dateClose"/></td>
				<td><xsl:value-of select="@type"/></td>
				<xsl:if test="//data/nonPackageMode">
					<td><xsl:value-of select="@cost"/></td>
				</xsl:if>		
				<xsl:if test="//data/packages">
					<td><xsl:value-of select="@inpackage"/></td>
				</xsl:if>	
				<td><a href="{$WEBEXECUTER}?action=DownloadTopic&amp;module=ru.bitel.bgbilling.plugins.helpdesk&amp;mid=0&amp;id={@id}&amp;contractId={$CONTRACT_ID}">сохранить</a></td>
			</tr>
			</xsl:for-each>
		</tbody>
	</table>
	</div>
</xsl:template>


<xsl:template name="HelpDeskPackage">
	<div style="margin-top: 10px;">
		Активированные пакеты:
	</div>
	<div class="report">
	<table style="border: 0px; width: 100%;">
		<col class="col1" width="50" align="right"/>
		<col class="col2" width="150"/>
		<col class="col3" width="100"/>
		<col class="col4" width="180"/>
		<col class="col5" width="80"/>
		<col class="col6"/>
		<thead>
			<tr>
				<td>ID</td>
				<td>Период</td>				
				<td>Стоимость</td>				
				<td>Обращений [использовано]</td>
				<td>Активный</td>
				<td>Активировал</td>
			</tr>
		</thead>
		<tbody>
			<xsl:for-each select="packages/tablePackageContract/row">
			<tr>
				<td align="right"><xsl:value-of select="@id"/></td>
				<td><xsl:value-of select="@period"/></td>
				<td align="right"><xsl:value-of select="@summa"/></td>
				<td align="right"><xsl:value-of select="@count"/></td>
				<td align="center">
					<xsl:choose>
						<xsl:when test="@active = 'true'">да</xsl:when>
						<xsl:otherwise>нет</xsl:otherwise>
					</xsl:choose>
				</td>
				<td>
					<xsl:choose>
						<xsl:when test="@user = 'true'">Администратор</xsl:when>
						<xsl:otherwise>Пользователь</xsl:otherwise>
					</xsl:choose>
				</td>
				<!-- 
				<td>
					<a><xsl:attribute name="href">webex ecuter?action=Topic&amp;module=ru.bitel.bgbilling.plugins.helpdesk&amp;mid=0&amp;id=<xsl:value-of select="@id"/></xsl:attribute><xsl:value-of select="@title"/></a>					
					<xsl:if test="@haveNewMsg = 'true'">						
						<a style="color: red;"><xsl:attribute name="href">webex ecuter?action=Topic&amp;module=ru.bitel.bgbilling.plugins.helpdesk&amp;mid=0&amp;id=<xsl:value-of select="@id"/>#new</xsl:attribute> [новые]</a>
					</xsl:if>					
				</td>
				-->
			</tr>
			</xsl:for-each>
		</tbody>
	</table>
	</div>
	
	<xsl:if test="packages/error">
	<div class="alert alert-danger" role="alert">
		<xsl:choose>
			<xsl:when test="packages/error/@id = 'packageIdNotFound'">Пакет не выбран</xsl:when>
			<xsl:when test="packages/error/@id = 'packageNotFound'">Пакет не существует</xsl:when>
			<xsl:when test="packages/error/@id = 'packageStatusDisabled'">packageStatusDisabled</xsl:when>
			<xsl:when test="packages/error/@id = 'balanceNotValid'">На счете не достаточно средств для активации пакета</xsl:when>
			<xsl:when test="packages/error/@id = 'chargeNotFound'">Расход не существует</xsl:when>
		</xsl:choose>
	</div>
	</xsl:if>
	
	<!-- div class="alert alert-primary"></div    Здесь ничего не происходит -->
	<form action="{$WEBEXECUTER}" method="POST" onSubmit="return confirm('Вы уверены, что хотите активировать выбранный пакет?');">
	<input type="hidden" name="action" value="HelpDeskPackage" />
	<input type="hidden" name="module" value="ru.bitel.bgbilling.plugins.helpdesk" />
	<input type="hidden" name="mid" value="0" />
	<input type="hidden" name="command" value="packageadd" />
	<input type="hidden" name="contractId" value="{$CONTRACT_ID}" />
	<div style="margin-top: 10px;">
		Доступные пакеты:
		<div class="report">
			<table style="border: 0px;">
				<col class="col1" width="50" align="right" />
				<col class="col2" />
				<col class="col3" width="180" />
				<col class="col4" width="100" />
				<col class="col5" />
				<thead>
					<tr>
						<td>V</td>
						<td>Название пакета</td>
						<td>Период [дней]</td>
						<td>Обращений</td>
						<td>Стоимость</td>
					</tr>
				</thead>
				<tbody>
					<xsl:for-each select="packages/tablePackage/row">
						<tr>
							<td align="center">
								<input type="radio" name="packageId">
									<xsl:attribute name="value"><xsl:value-of select="@id" /></xsl:attribute>
								</input>
							</td>
							<td>
								<xsl:value-of select="@title" />
							</td>
							<td nowrap="nowrap">
								<xsl:value-of select="@formatPeriod" />
								[
								<xsl:value-of select="@period" />
								]
							</td>
							<td align="right">
								<xsl:value-of select="@count" />
							</td>
							<td align="right">
								<xsl:value-of select="@summa" />
							</td>
						</tr>
					</xsl:for-each>
				</tbody>
			</table>
			<div style="margin-top: 10px; margin-left: 0px;">
				<input type="submit" class="submit" value="Активировать" />
				(выбранный пакет будет активирован только при наличие на счете суммы большей или
				равной стоимости пакета)
			</div>
		</div>
	</div>
	</form>
</xsl:template>

	<xsl:template name="message">
		<xsl:if test="//data/message">
		<div class="alert alert-primary">
			<xsl:choose>
				<xsl:when test="//data/message/@id = 'save'">
					Сообщение: Данные сохранены.
				</xsl:when>
				<xsl:otherwise>
					Сообщение: id =
					<xsl:value-of select="//data/message/@id" />
				</xsl:otherwise>
			</xsl:choose>
		</div>
		</xsl:if>
	</xsl:template>

	<xsl:template name="HelpDeskAdd">
		<xsl:choose>
			<xsl:when test="//data/error and //data/error/@id = 'activePackageNotFound'">
				<xsl:call-template name="error" />
			</xsl:when>
			<xsl:otherwise>
				<form action="{$WEBEXECUTER}" method="POST" enctype="multipart/form-data">
					<xsl:call-template name="action" />
					<xsl:call-template name="error" />
					<input name="command" value="savetopic" type="hidden" />
					<input type="hidden" name="contractId" value="{$CONTRACT_ID}" />
					<table style="width: 100%; font-size: 10pt;">
						<tr>
							<td>
								Тема
								<br />
								<input type="text" style="width: 100%;" name="topic_title" size="50">
									<xsl:attribute name="value">
										<xsl:value-of select="currentvalues/@topic_title" />
									</xsl:attribute>
								</input>
							</td>
						</tr>
						<tr>
							<td>
								Текст сообщения, описание проблемы
								<br />
								<textarea name="message_body" cols="100" rows="20">
									<xsl:value-of select="currentvalues/@message_body" />
								</textarea>
							</td>
						</tr>
						<tr>
							<td>
								Режим оповещения об ответах:
								<br />
								<table>
									<tr>
										<td>
											<input type="radio" name="topic.comm.mode" value="0">
												<xsl:if test="currentvalues/@topic.comm.mode = '0'">
													<xsl:attribute name="checked">checked</xsl:attribute>
												</xsl:if>
											</input>
										</td>
										<td>не оповещать</td>
										<td></td>
									</tr>
									<xsl:if test="currentvalues/@topic.comm.phone.enable = 'true'">
										<tr>
											<td>
												<input type="radio" name="topic.comm.mode" value="1">
													<xsl:if test="currentvalues/@topic.comm.mode = '1'">
														<xsl:attribute name="checked">checked</xsl:attribute>
													</xsl:if>
												</input>
											</td>
											<td>по телефону</td>
											<td>
												<input type="text" size="30" name="topic.comm.phone.value">
													<xsl:attribute name="value"><xsl:value-of
														select="currentvalues/@topic.comm.phone.value" /></xsl:attribute>
												</input>
											</td>
										</tr>
									</xsl:if>
									<xsl:if test="currentvalues/@topic.comm.email.enable = 'true'">
										<tr>
											<td>
												<input type="radio" name="topic.comm.mode" value="2">
													<xsl:if test="currentvalues/@topic.comm.mode = '2'">
														<xsl:attribute name="checked">checked</xsl:attribute>
													</xsl:if>
												</input>
											</td>
											<td>по email</td>
											<td>
												<input type="text" size="30" name="topic.comm.email.value">
													<xsl:attribute name="value"><xsl:value-of
														select="currentvalues/@topic.comm.email.value" /></xsl:attribute>
												</input>
											</td>
										</tr>
									</xsl:if>
								</table>
							</td>
						</tr>
						<tr>
							<td id="tdwithfileinput">
								Прикрепить файл<br/>
								<input type="file" size="50" name="message_file_1" onchange="filechange();" />
							</td>
						</tr>
						<tr>
							<td>
								<input type="submit" value="Отправить" />
							</td>
						</tr>
					</table>
				</form>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="HelpDeskTopic">
		<div class="HelpDeskTopicInfo">
			<span class="n">ID:</span>
			<span class="v">#<xsl:value-of select="topic/@id" />;</span>
			<span class="n">Статус:</span>
			<span class="v">
				<xsl:choose>
					<xsl:when test="topic/@closed = 'false'">Активна</xsl:when>
					<xsl:when test="topic/@closed = 'true'">Закрыта</xsl:when>
				</xsl:choose>;
			</span>
			<span class="n">Дата открытия: </span>
			<span class="v">
				<xsl:value-of select="topic/@date" />;
			</span>
			<span class="n">Оповещение:</span>
			<span class="v">
				<xsl:choose>
					<xsl:when test="topic/@comm = '0'">нет</xsl:when>
					<xsl:when test="topic/@comm = '1'">по телефону: <xsl:value-of select="topic/@comm_value" /></xsl:when>
					<xsl:when test="topic/@comm = '2'">по e-mail: <xsl:value-of select="topic/@comm_value" /></xsl:when>
				</xsl:choose>;
			</span>
			<span class="n">Менеджер:</span>
			<span class="v">
				<xsl:value-of select="topic/@user" />
			</span>
		</div>
		<div class="HelpDeskTopicTitle">
			<span>Тема:</span>
			<xsl:value-of select="topic/@title" />
		</div>

		<hr />

		<xsl:for-each select="topic/message">
			<table width="100%" border="0" cellpadding="1" style="border: 1px solid #8080ff; margin-bottom: 10px;">
				<tr>
					<td style="padding: 3px 10px; border: 1px solid #8080ff; background-color: #a0d0ff;">
						<div class="HelpDeskTopicMessage">
							<xsl:if test="@isNewMessage = 'true'">
								<a name="new"><span class="new">НОВОЕ!!!</span></a>
							</xsl:if>
							<span class="n">Сообщение ID:</span>
							<span class="v">#<xsl:value-of select="@id" />;</span>
							<span class="n">Отправлено:</span>
							<span class="v"><xsl:value-of select="@userFrom" />	в <xsl:value-of select="@dateFrom" />;</span>
							<span class="n">Прочитано:</span>
							<span class="v"><xsl:value-of select="@userTo" /> в <xsl:value-of select="@dateTo" /></span>
						</div>
					</td>
				</tr>
				<xsl:if test="file">
				<tr>
					<td>
							<div style="font-size: 9pt;">
							<xsl:for-each select="file">
								<img src="img/attach.png" alt="прикреплено"/>
								<a href="{$WEBEXECUTER}?action=FileDownload&#38;mid=0&#38;module=ru.bitel.bgbilling.plugins.helpdesk&#38;id={@id}&amp;contractId={$CONTRACT_ID}" style="text-decoration: underline;">
									<xsl:value-of select="@title" />
								</a>
								(<xsl:value-of select="@size" /> байт);
								<a href="{$WEBEXECUTER}?action=FileDelete&#38;mid=0&#38;module=ru.bitel.bgbilling.plugins.helpdesk&#38;id={@id}&#38;topicId={../../@id}&amp;contractId={$CONTRACT_ID}">Удалить</a>
							</xsl:for-each>
							</div>
					</td>
				</tr>
				</xsl:if>
				<tr>
					<td align="left"><xsl:if test="@userFrom != 'Клиент'"><xsl:attribute name="style">padding-left: 50px;</xsl:attribute></xsl:if>
						<div class="HelpDeskTopicMessageText" style="padding: 5px 10px;">
							<xsl:call-template name="n2br">
								<xsl:with-param name="text">
									<xsl:value-of select="@body" />
								</xsl:with-param>
							</xsl:call-template>
						</div>
					</td>
				</tr>
			</table>
		</xsl:for-each>

		<xsl:if test="topic/@closed = 'false'">
			<form action="{$WEBEXECUTER}" method="POST" enctype="multipart/form-data">
				<xsl:call-template name="action" />
				<xsl:call-template name="error" />
				<input name="command" value="savemessage" type="hidden" />
				<input name="id" type="hidden">
					<xsl:attribute name="value"><xsl:value-of select="topic/@id" /></xsl:attribute>
				</input>
				<input type="hidden" name="contractId" value="{$CONTRACT_ID}" />
				<table style="width: 100%; font-size: 10pt;">
					<tr>
						<td>
							Текст сообщения<br/>
							<textarea name="message_body" cols="120" rows="20"></textarea>
						</td>
					</tr>
					<tr>
						<td id="tdwithfileinput">
							Прикрепить файл<br/>
							<input type="file" name="message_file_1" size="50" onchange="filechange();" />
						</td>
					</tr>
					<tr>
						<td style="padding: 10px 0px;">
							<input type="submit" value="Отправить" />
							<ht/>
							<input type="button" value="Отправить и закрыть" onClick="sendAndClose(this);"/>
						</td>
					</tr>
				</table>
			</form>
		</xsl:if>
	</xsl:template>


	<xsl:template name="HelpDeskParam">
		<div style="margin-top: 10px;">
			Выберите режим оповещения об ответах и значения по умолчанию:
		</div>
		<form action="{$WEBEXECUTER}" method="POST" enctype="multipart/form-data">
				<xsl:call-template name="action" />
				<xsl:call-template name="error" />
				<xsl:call-template name="message" />
				<input type="hidden" name="contractId" value="{$CONTRACT_ID}" />
				<table style="font-size: 10pt;">
					<tr>
						<td>
							<input type="radio" name="default.comm.mode" value="0">
								<xsl:if test="currentvalues/@default.comm.mode = '0'">
									<xsl:attribute name="checked">checked</xsl:attribute>
								</xsl:if>
							</input>
						</td>
						<td>не оповещать</td>
						<td></td>
					</tr>
					<xsl:if test="currentvalues/@default.comm.phone.enable = 'true'">
						<tr>
							<td>
								<input type="radio" name="default.comm.mode" value="1">
									<xsl:if test="currentvalues/@default.comm.mode = '1'">
										<xsl:attribute name="checked">checked</xsl:attribute>
									</xsl:if>
								</input>
							</td>
							<td>по телефону</td>
							<td>
								<input type="text" size="30" name="default.comm.phone.value">
									<xsl:attribute name="value"><xsl:value-of
										select="currentvalues/@default.comm.phone.value" /></xsl:attribute>
								</input>
							</td>
						</tr>
					</xsl:if>
					<xsl:if test="currentvalues/@default.comm.email.enable = 'true'">
						<tr>
							<td>
								<input type="radio" name="default.comm.mode" value="2">
									<xsl:if test="currentvalues/@default.comm.mode = '2'">
										<xsl:attribute name="checked">checked</xsl:attribute>
									</xsl:if>
								</input>
							</td>
							<td>по email</td>
							<td>
								<input type="text" size="30" name="default.comm.email.value">
									<xsl:attribute name="value"><xsl:value-of
										select="currentvalues/@default.comm.email.value" /></xsl:attribute>
								</input>
							</td>
						</tr>
					</xsl:if>
					<tr>
						<td colspan="3" align="left">
							<br />
							<input type="submit" value="Сохранить" />
						</td>
					</tr>
				</table>
		</form>
	</xsl:template>


	<!-- TODO здесь вот конкретная путаница может быть, ибо перекрывается
	стандартный шаблон "error" и неясно в странице по контексту, какой используется
	до и после его объявления, совсем неочевидная логика. Переименовать этот и
	использовать в тех местах на странице, в которых надо, в остальных - стандартный -->
	<xsl:template name="error">
		<xsl:if test="//data/error">
		<div class="alert alert-danger" role="alert">
			<xsl:choose>
				<xsl:when test="//data/error/@id = 'subjectNotEmpty'">
					Ошибка: Заголовок темы должен быть непустым.
				</xsl:when>
				<xsl:when test="//data/error/@id = 'bodyNotEmpty'">
					Ошибка: Cообщение должно быть непустым.
				</xsl:when>
				<xsl:when test="//data/error/@id = 'topicNotFound'">
					Ошибка: Тема не найдена 
				</xsl:when>
				<xsl:when test="//data/error/@id = 'badOwner'">
					Ошибка: Это тема создана не вами.
				</xsl:when>
				<xsl:when test="//data/error/@id = 'topicClosed'">
					Ошибка: Тема закрыта. Вы не можете писать сообщения в нее.
				</xsl:when>
				<xsl:when test="//data/error/@id = 'noStatusNoClose'">
					К сожалению, Вы не можете закрыть тему, статус которой не установлен менеджером.
				</xsl:when>
				<xsl:otherwise>
					Ошибка: id =
					<xsl:value-of select="//data/error/@id" />
				</xsl:otherwise>
			</xsl:choose>
		</div>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>
