/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.inet.server.runtime;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.inet.access.Access;
import ru.bitel.bgbilling.apps.inet.access.InetConnectionManager;
import ru.bitel.bgbilling.apps.inet.access.InetConnectionRuntime;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionCallRuntime;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.network.dhcp.DhcpPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusListenerWorker;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.modules.inet.common.bean.InetConnection;
import ru.bitel.bgbilling.modules.inet.common.bean.InetServ;
import ru.bitel.bgbilling.modules.inet.server.radius.InetRadiusProcessor;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetApplication;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntimeMap;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.util.CopyOnWriteArrayMap;

public abstract class InetConnectionKeyMap2<D, E> {
    private static final Logger logger = LogManager.getLogger();
    private final ConcurrentMap<String, KeyPattern> patternMap = new ConcurrentHashMap<String, KeyPattern>();
    private ConcurrentMap<Object, E> connectionMap = new ConcurrentHashMap<Object, E>();
    private AddressMap addressMap = new AddressMap(this);
    private volatile Set<Integer> keyDeviceTypeIds;
    protected final InetApplication application;
    protected final boolean newSearch;
    private static final Pattern macrosPattern = Pattern.compile("\\$\\w+");

    private KeyPattern getPattern(String pattern) {
        KeyPattern result = (KeyPattern)this.patternMap.get(pattern);
        if (result != null) {
            return result;
        }
        result = new KeyPattern(pattern);
        this.patternMap.putIfAbsent(pattern, result);
        return result;
    }

    protected E put(Object key, byte[] address, E entry) {
        if (address != null) {
            this.addressMap.add(new IpAddress(address), entry);
        }
        return this.connectionMap.put(key, entry);
    }

    protected E put(Key key, byte[] address, E entry) {
        if (key.ipAddress != null) {
            this.addressMap.add(key.ipAddress, entry);
        } else if (address != null) {
            this.addressMap.add(new IpAddress(address), entry);
        }
        return this.connectionMap.put(key, entry);
    }

    protected void remove(Object key, byte[] address, E entry) {
        this.connectionMap.remove(key, entry);
        if (address != null) {
            this.addressMap.remove(new IpAddress(address), entry);
        }
    }

    protected void remove(Key key, byte[] address, E entry) {
        this.connectionMap.remove(key, entry);
        if (key.ipAddress != null) {
            this.addressMap.remove(key.ipAddress, entry);
        } else if (address != null) {
            this.addressMap.remove(new IpAddress(address), entry);
        }
    }

    private Key getKey(D device, int servSearchMode, int deviceId, int agentDeviceId, InetServ inetServ, InetServ parentInetServ, String mac, byte[] address) {
        if (parentInetServ == null) {
            InetServRuntime inetServRuntime = this.application.getInetServRuntimeMap().get(inetServ.getId());
            InetServRuntime parentInetServRuntime = inetServRuntime.getRootInetServRuntime(this.application);
            parentInetServ = parentInetServRuntime.getInetServ();
        }
        switch (servSearchMode) {
            case 1: 
            case 3: 
            case 12: {
                int interfaceId = parentInetServ.getInterfaceId();
                if (interfaceId != -1) {
                    return this.getKey(device, deviceId, agentDeviceId, interfaceId, mac, address);
                }
                logger.info("interfaceId not set");
                return null;
            }
            case 2: 
            case 4: 
            case 11: {
                int vlanId = parentInetServ.getVlan();
                if (vlanId != -1) {
                    return this.getKey(device, deviceId, agentDeviceId, vlanId, mac, address);
                }
                logger.info("vlanId not set");
                return null;
            }
        }
        return this.getKey(device, deviceId, agentDeviceId, 0, mac, address);
    }

    protected Key getKey(D device, int deviceId, int agentDeviceId, int circuitId, String mac, byte[] address) {
        String dhcpKeyPattern = this.getPattern(device);
        KeyPattern pattern = this.getPattern(dhcpKeyPattern);
        return pattern.newKey(deviceId, agentDeviceId, circuitId, mac, address);
    }

    public InetConnectionKeyMap2(InetApplication application, final boolean newSearch) throws BGException {
        this.application = application;
        this.newSearch = newSearch;
        EventProcessor.getInstance().addListener((EventListener)new EventListener<InetRadiusProcessor.AuthAcceptEvent>(){

            public void notify(InetRadiusProcessor.AuthAcceptEvent e, EventListenerContext ctx) throws BGException {
                int deviceId = e.getDeviceId();
                Object device = InetConnectionKeyMap2.this.getDevice(deviceId);
                if (InetConnectionKeyMap2.this.keyDeviceTypeIds != null && InetConnectionKeyMap2.this.keyDeviceTypeIds.contains(InetConnectionKeyMap2.this.getDeviceTypeId(device))) {
                    return;
                }
                RadiusPacket request = e.getRequest();
                RadiusPacket response = e.getResponse();
                byte[] address = response.getByteAttribute(-1, 8, null);
                if (address == null) {
                    address = request.getByteAttribute(2352, 132, null);
                }
                String userName = request.getStringAttribute(-1, 1, null);
                String callingStationId = request.getStringAttribute(-1, 31, null);
                int servSearchMode = InetConnectionKeyMap2.this.getServSearchMode(device);
                if (newSearch || device != null && servSearchMode != 0) {
                    Key key = InetConnectionKeyMap2.this.getKey(device, servSearchMode, deviceId, e.getAgentDeviceId(), e.getInetServ(), null, callingStationId, address);
                    if (key != null) {
                        logger.info("Put auth accept " + String.valueOf(key));
                        InetConnectionKeyMap2.this.put(key, null, InetConnectionKeyMap2.this.newEntry(e.getIpResourceId(), address, e.getInetServ().getId(), 0L));
                    }
                } else if (Utils.notBlankString((String)userName) && Utils.notBlankString((String)callingStationId) && address != null) {
                    String key = InetConnectionKeyMap2.this.getKeyOld(deviceId, userName, callingStationId);
                    if (key != null) {
                        logger.info("Put auth accept " + key);
                        InetConnectionKeyMap2.this.put(key, null, InetConnectionKeyMap2.this.newEntry(e.getIpResourceId(), address, e.getInetServ().getId(), 0L));
                    }
                } else {
                    logger.info("Skip userName: " + userName);
                }
            }
        }, InetRadiusProcessor.AuthAcceptEvent.class);
        if (application instanceof Access) {
            EventProcessor.getInstance().addListener((EventListener)new EventListener<InetConnectionManager.ConnectionAddEvent>(){

                public void notify(InetConnectionManager.ConnectionAddEvent e, EventListenerContext ctx) throws BGException {
                    if (e.getInetConnection().getParentConnectionId() > 0L) {
                        logger.debug("Skip service connection");
                    }
                    InetConnectionKeyMap2.this.connectionAdd(e.getInetConnection());
                }
            }, InetConnectionManager.ConnectionAddEvent.class);
            EventProcessor.getInstance().addListener((EventListener)new EventListener<InetConnectionManager.ConnectionUpdateEvent>(){

                public void notify(InetConnectionManager.ConnectionUpdateEvent e, EventListenerContext ctx) throws BGException {
                    if (e.getInetConnection().getParentConnectionId() > 0L) {
                        logger.debug("Skip service connection");
                    }
                    InetConnectionKeyMap2.this.connectionUpdate(e.getInetConnection());
                }
            }, InetConnectionManager.ConnectionUpdateEvent.class);
            EventProcessor.getInstance().addListener((EventListener)new EventListener<InetConnectionManager.ConnectionRemoveEvent>(){

                public void notify(InetConnectionManager.ConnectionRemoveEvent e, EventListenerContext ctx) throws BGException {
                    if (e.getInetConnection().getParentConnectionId() > 0L) {
                        logger.debug("Skip service connection");
                    }
                    InetConnectionKeyMap2.this.connectionRemove(e.getInetConnection());
                }
            }, InetConnectionManager.ConnectionRemoveEvent.class);
        } else {
            EventProcessor.getInstance().addListener((EventListener)new EventListener<Accounting.ConnectionAddEvent>(){

                public void notify(Accounting.ConnectionAddEvent e, EventListenerContext ctx) throws BGException {
                    if (e.getConnection().getParentConnectionId() > 0L) {
                        logger.debug("Skip service connection");
                    }
                    InetConnectionKeyMap2.this.connectionAdd(e.getConnection());
                }
            }, Accounting.ConnectionAddEvent.class);
            EventProcessor.getInstance().addListener((EventListener)new EventListener<Accounting.ConnectionUpdateEvent>(){

                public void notify(Accounting.ConnectionUpdateEvent e, EventListenerContext ctx) throws BGException {
                    if (e.getConnection().getParentConnectionId() > 0L) {
                        logger.debug("Skip service connection");
                    }
                    InetConnectionKeyMap2.this.connectionUpdate(e.getConnection());
                }
            }, Accounting.ConnectionUpdateEvent.class);
            EventProcessor.getInstance().addListener((EventListener)new EventListener<Accounting.ConnectionRemoveEvent>(){

                public void notify(Accounting.ConnectionRemoveEvent e, EventListenerContext ctx) throws BGException {
                    if (e.getConnection().getParentConnectionId() > 0L) {
                        logger.debug("Skip service connection");
                    }
                    InetConnectionKeyMap2.this.connectionRemove(e.getConnection());
                }
            }, Accounting.ConnectionRemoveEvent.class);
        }
    }

    private void connectionAdd(InetConnection con) {
        int deviceId = con.getDeviceId();
        D device = this.getDevice(deviceId);
        if (this.keyDeviceTypeIds != null && this.keyDeviceTypeIds.contains(this.getDeviceTypeId(device))) {
            return;
        }
        int servSearchMode = this.getServSearchMode(device);
        if (this.newSearch || device != null && servSearchMode != 0) {
            Key key;
            InetServRuntime servRuntime = this.application.getInetServRuntimeMap().get(con.getServId());
            if (servRuntime != null && (key = this.getKey(device, servSearchMode, deviceId, con.getAgentDeviceId(), servRuntime.getInetServ(), servRuntime.getRootInetServRuntime(this.application).getInetServ(), con.getCallingStationId(), con.getInetAddressBytes())) != null) {
                if (con.getInetAddressBytes() != null) {
                    logger.info("Put connection add " + String.valueOf(key));
                    this.put(key, con.getInetAddressBytes(), this.newEntry(con.getIpResourceId(), con.getInetAddressBytes(), con.getServId(), con.getId()));
                } else {
                    logger.info("Ip is null " + String.valueOf(key));
                }
            }
        } else {
            String key = this.getKeyOld(con);
            if (key != null) {
                if (con.getInetAddressBytes() != null) {
                    logger.info("Put connection add " + key);
                    this.put(key, con.getInetAddressBytes(), this.newEntry(con.getIpResourceId(), con.getInetAddressBytes(), con.getServId(), con.getId()));
                } else {
                    logger.info("Ip is null " + key);
                }
            }
        }
    }

    private void connectionUpdate(InetConnection con) {
        int deviceId = con.getDeviceId();
        D device = this.getDevice(deviceId);
        if (this.keyDeviceTypeIds != null && this.keyDeviceTypeIds.contains(this.getDeviceTypeId(device))) {
            return;
        }
        int servSearchMode = this.getServSearchMode(device);
        if (this.newSearch || device != null && servSearchMode != 0) {
            InetServRuntime servRuntime = this.application.getInetServRuntimeMap().get(con.getServId());
            if (servRuntime == null) {
                return;
            }
            Key key = this.getKey(device, servSearchMode, deviceId, con.getAgentDeviceId(), servRuntime.getInetServ(), servRuntime.getRootInetServRuntime(this.application).getInetServ(), con.getCallingStationId(), con.getInetAddressBytes());
            if (key == null) {
                return;
            }
            if (con.getInetAddressBytes() != null) {
                logger.info("Put connection update " + String.valueOf(key));
                this.put(key, con.getInetAddressBytes(), this.newEntry(con.getIpResourceId(), con.getInetAddressBytes(), con.getServId(), con.getId()));
            } else {
                logger.info("Ip is null " + String.valueOf(key));
            }
        } else {
            String key = this.getKeyOld(con);
            if (key != null) {
                if (con.getInetAddressBytes() != null) {
                    logger.info("Put connection update " + key);
                    this.put(key, con.getInetAddressBytes(), this.newEntry(con.getIpResourceId(), con.getInetAddressBytes(), con.getServId(), con.getId()));
                } else {
                    logger.info("Ip is null " + key);
                }
            }
        }
    }

    private void connectionRemove(InetConnection con) {
        int deviceId = con.getDeviceId();
        D device = this.getDevice(deviceId);
        if (this.keyDeviceTypeIds != null && this.keyDeviceTypeIds.contains(this.getDeviceTypeId(device))) {
            return;
        }
        int servSearchMode = this.getServSearchMode(device);
        if (this.newSearch || device != null && servSearchMode != 0) {
            InetServRuntime servRuntime = this.application.getInetServRuntimeMap().get(con.getServId());
            if (servRuntime == null) {
                return;
            }
            Key key = this.getKey(device, servSearchMode, deviceId, con.getAgentDeviceId(), servRuntime.getInetServ(), servRuntime.getRootInetServRuntime(this.application).getInetServ(), con.getCallingStationId(), con.getInetAddressBytes());
            if (key == null) {
                return;
            }
            logger.info("Remove connection remove " + String.valueOf(key));
            Object entry = this.connectionMap.get(key);
            if (entry != null && this.getConnectionId(entry) == con.getId()) {
                this.remove(key, con.getInetAddressBytes(), entry);
            }
        } else {
            String key = this.getKeyOld(con);
            if (key != null) {
                logger.info("Remove connection remove " + key);
                Object entry = this.connectionMap.get(key);
                if (entry != null && this.getConnectionId(entry) == con.getId()) {
                    this.remove(key, con.getInetAddressBytes(), entry);
                }
            }
        }
    }

    public void load(Set<Integer> keyDeviceTypeIds) {
        logger.info("Restore connections on InetConnectionKeyMap");
        this.keyDeviceTypeIds = keyDeviceTypeIds;
        InetServRuntimeMap inetServRuntimeMap = this.application.getInetServRuntimeMap();
        StringBuffer sb = new StringBuffer();
        if (this.application instanceof Access) {
            for (Map.Entry<Integer, ConcurrentMap<Long, InetConnectionRuntime>> me : ((Access)this.application).connectionManager.deviceConnectionEntrySet()) {
                Integer deviceId = me.getKey();
                ConcurrentMap<Long, InetConnectionRuntime> map = me.getValue();
                D device = this.getDevice(deviceId);
                if (keyDeviceTypeIds != null && keyDeviceTypeIds.contains(this.getDeviceTypeId(device))) continue;
                for (InetConnectionRuntime connectionRuntime : map.values()) {
                    this.put(inetServRuntimeMap, device, deviceId, connectionRuntime.connection, sb);
                }
            }
        } else {
            for (Map.Entry<Long, InetConnectionCallRuntime> me : ((Accounting)this.application).connectionMapCall.getSessionMap().entrySet()) {
                InetConnectionCallRuntime connectionCallRuntime = me.getValue();
                InetConnection connection = connectionCallRuntime.connection;
                Integer deviceId = connection.getDeviceId();
                D device = this.getDevice(deviceId);
                if (keyDeviceTypeIds != null && keyDeviceTypeIds.contains(this.getDeviceTypeId(device))) continue;
                this.put(inetServRuntimeMap, device, deviceId, connection, sb);
            }
        }
    }

    private void put(InetServRuntimeMap inetServRuntimeMap, D device, int deviceId, InetConnection connection, StringBuffer sb) {
        Object key;
        Integer inetServId = connection.getServId();
        InetServRuntime inetServRuntime = inetServRuntimeMap.get(inetServId);
        int servSearchMode = this.getServSearchMode(device);
        if (this.newSearch || device != null && servSearchMode != 0) {
            sb.setLength(0);
            key = this.getKey(device, servSearchMode, deviceId, connection.getAgentDeviceId(), inetServRuntime.getInetServ(), inetServRuntime.getRootInetServRuntime(this.application).getInetServ(), connection.getCallingStationId(), connection.getInetAddressBytes());
        } else {
            key = this.getKeyOld(connection);
        }
        if (key != null) {
            logger.info("Restored connection add " + String.valueOf(key));
            this.put(key, connection.getInetAddressBytes(), this.newEntry(connection.getIpResourceId(), connection.getInetAddressBytes(), connection.getServId(), connection.getId()));
        }
    }

    private String getKeyOld(InetConnection con) {
        int deviceId = con.getDeviceId();
        String userName = Utils.maskBlank((String)con.getUsername(), (String)"").toUpperCase();
        String callingStationId = con.getCallingStationId();
        return this.getKeyOld(deviceId, userName, callingStationId);
    }

    private String getKeyOld(int deviceId, String userName, String callingStationId) {
        String[] remote_circuit = userName.toUpperCase().replaceAll("[#_\\-\\|]", ":").split(":");
        if (remote_circuit.length != 2) {
            logger.error("Incorrect userName: " + userName);
            return null;
        }
        String mac = Utils.maskBlank((String)callingStationId, (String)"").toUpperCase().replaceAll("\\.", "");
        return this.getKeyOld(deviceId, remote_circuit[0], remote_circuit[1], mac);
    }

    protected String getKeyOld(int deviceId, String remoteId, String circuitId, String mac) {
        D device = this.getDevice(deviceId);
        String pattern = this.getPattern(device);
        StringBuffer sb = new StringBuffer(48);
        Matcher m = macrosPattern.matcher(pattern);
        while (m.find()) {
            String param = m.group();
            if ("$deviceId".equals(param)) {
                m.appendReplacement(sb, String.valueOf(deviceId));
                continue;
            }
            if ("$remoteId".equals(param)) {
                m.appendReplacement(sb, remoteId);
                continue;
            }
            if ("$circuitId".equals(param)) {
                m.appendReplacement(sb, circuitId);
                continue;
            }
            if ("$mac".equals(param)) {
                m.appendReplacement(sb, mac);
                continue;
            }
            logger.error("Unknown parameter in pattern: " + pattern);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    protected abstract E newEntry(int var1, byte[] var2, int var3, long var4);

    protected abstract E[] newArray(int var1);

    protected abstract E[] newArray(E var1);

    protected abstract int getServSearchMode(D var1);

    protected abstract long getConnectionId(E var1);

    protected abstract D getDevice(int var1);

    protected abstract String getPattern(D var1);

    protected abstract int getDeviceTypeId(D var1);

    private Key getKey(D device, int servSearchMode, int deviceId, int agentDeviceId, InetDeviceRuntime deviceRuntime, DhcpPacket request, String mac, byte[] address) {
        switch (servSearchMode) {
            case 1: {
                int interfaceId = deviceRuntime.getOption82InterfaceId(request);
                return this.getKey(device, deviceId, agentDeviceId, interfaceId, mac, address);
            }
            case 2: 
            case 4: 
            case 11: {
                int vlanId = deviceRuntime.getOption82VlanId(request);
                return this.getKey(device, deviceId, agentDeviceId, vlanId, mac, address);
            }
        }
        return null;
    }

    public E get(InetDeviceRuntime deviceRuntime, D device, DhcpPacket request) {
        Object key;
        int servSearchMode = this.getServSearchMode(device);
        if (servSearchMode == 0) {
            String circuitId = Utils.bytesToHexString((byte[])request.getSubOption((byte)1).value);
            String remoteId = Utils.bytesToHexString((byte[])request.getSubOption((byte)2).value);
            String macString = Utils.bytesToHexString((byte[])request.chaddr);
            int agentDeviceId = deviceRuntime.inetDeviceId;
            key = this.getKeyOld(deviceRuntime.inetDeviceId, remoteId, circuitId, macString);
        } else {
            int agentDeviceId;
            InetDeviceRuntime agentDeviceRuntime = null;
            Object agentRemoteId = deviceRuntime.getOption82AgentRemoteId(request);
            if (agentRemoteId != null && !"".equals(agentRemoteId)) {
                agentDeviceRuntime = this.application.deviceMap.getByIdentifier(deviceRuntime, agentRemoteId);
            }
            if (agentDeviceRuntime != null) {
                agentDeviceId = agentDeviceRuntime.inetDeviceId;
            } else {
                agentDeviceId = deviceRuntime.inetDeviceId;
                agentDeviceRuntime = deviceRuntime;
            }
            String macString = Utils.bytesToString((byte[])request.chaddr, (boolean)true, null);
            key = this.getKey(device, servSearchMode, (int)deviceRuntime.inetDeviceId, agentDeviceId, agentDeviceRuntime, request, macString, null);
        }
        return (E)this.connectionMap.get(key);
    }

    private Key getKey(D device, int servSearchMode, int deviceId, int agentDeviceId, InetDeviceRuntime deviceRuntime, RadiusPacket request, String mac, byte[] address) {
        switch (servSearchMode) {
            case 1: 
            case 3: 
            case 12: {
                int interfaceId = deviceRuntime.getOption82InterfaceId(request);
                return this.getKey(device, deviceId, agentDeviceId, interfaceId, mac, address);
            }
            case 2: 
            case 4: 
            case 11: {
                int vlanId = deviceRuntime.getOption82VlanId(request);
                return this.getKey(device, deviceId, agentDeviceId, vlanId, mac, address);
            }
        }
        return null;
    }

    public E get(Object key) {
        return (E)this.connectionMap.get(key);
    }

    public E[] get(IpAddress address) {
        return this.addressMap.get(address);
    }

    public E get(RadiusListenerWorker<?> req, InetDeviceRuntime deviceRuntime, D device, InetDeviceRuntime agentDeviceRuntime, RadiusPacket request, String macString) {
        int agentDeviceId;
        int servSearchMode = this.getServSearchMode(device);
        if (agentDeviceRuntime != null) {
            agentDeviceId = agentDeviceRuntime.inetDeviceId;
        } else {
            agentDeviceId = deviceRuntime.inetDeviceId;
            agentDeviceRuntime = deviceRuntime;
        }
        Key key = this.getKey(device, servSearchMode, (int)deviceRuntime.inetDeviceId, agentDeviceId, agentDeviceRuntime, request, macString, null);
        return (E)this.connectionMap.get(key);
    }

    static class KeyPattern {
        final boolean deviceId;
        final boolean agentDeviceId;
        final boolean circuitId;
        final boolean mac;
        final boolean ipAddress;

        KeyPattern(String pattern) {
            boolean deviceId = false;
            boolean agentDeviceId = false;
            boolean circuitId = false;
            boolean mac = false;
            boolean ipAddress = false;
            Matcher m = macrosPattern.matcher(pattern);
            while (m.find()) {
                String param = m.group();
                if ("$deviceId".equals(param)) {
                    deviceId = true;
                    continue;
                }
                if ("$remoteId".equals(param)) {
                    agentDeviceId = true;
                    continue;
                }
                if ("$circuitId".equals(param)) {
                    circuitId = true;
                    continue;
                }
                if ("$mac".equals(param)) {
                    mac = true;
                    continue;
                }
                if (!"$ip".equals(param)) continue;
                ipAddress = true;
            }
            this.deviceId = deviceId;
            this.agentDeviceId = agentDeviceId;
            this.circuitId = circuitId;
            this.mac = mac;
            this.ipAddress = ipAddress;
        }

        public Key newKey(int deviceId, int agentDeviceId, int circuitId, String mac, byte[] address) {
            return new Key(this.deviceId ? deviceId : 0, this.agentDeviceId ? agentDeviceId : 0, this.circuitId ? circuitId : 0, this.mac ? mac : null, this.ipAddress ? new IpAddress(address) : null);
        }
    }

    final class AddressMap
    extends CopyOnWriteArrayMap<IpAddress, E> {
        public AddressMap(InetConnectionKeyMap2 this$0) {
            super(64);
        }

        protected E[] newArray(int size) {
            return this.newArray((Object)size);
        }

        protected E[] newArray(E r) {
            return this.newArray(r);
        }

        public E[] get(IpAddress key) {
            return (Object[])this.arrayMap.get(key);
        }
    }

    static class Key {
        public final int deviceId;
        public final int agentDeviceId;
        public final int circuitId;
        public final String mac;
        public final IpAddress ipAddress;

        public Key(int deviceId, int agentDeviceId, int circuitId, String mac, IpAddress ipAddress) {
            this.deviceId = deviceId;
            this.agentDeviceId = agentDeviceId;
            this.circuitId = circuitId;
            this.mac = mac;
            this.ipAddress = ipAddress;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.agentDeviceId;
            result = 31 * result + this.circuitId;
            result = 31 * result + this.deviceId;
            result = 31 * result + (this.ipAddress == null ? 0 : this.ipAddress.hashCode());
            result = 31 * result + (this.mac == null ? 0 : this.mac.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Key)) {
                return false;
            }
            Key other = (Key)obj;
            if (this.agentDeviceId != other.agentDeviceId || this.circuitId != other.circuitId || this.deviceId != other.deviceId) {
                return false;
            }
            if (this.ipAddress == null ? other.ipAddress != null : !this.ipAddress.equals((Object)other.ipAddress)) {
                return false;
            }
            return !(this.mac == null ? other.mac != null : !this.mac.equals(other.mac));
        }
    }
}

