/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.detail;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import ru.bitel.bgbilling.apps.inet.accounting.detail.InetFlowSelector;
import ru.bitel.bgbilling.kernel.network.flow.Data;
import ru.bitel.bgbilling.kernel.network.flow.FlowSelector;
import ru.bitel.bgbilling.modules.inet.common.event.accounting.InetDetailCreateEvent;

public class InetMonthFlowSelector
implements FlowSelector {
    private final List<InetFlowSelector> flowSelectorList;
    private long currentHour = -1L;
    private List<InetFlowSelector> currentHourSelectorList = new ArrayList<InetFlowSelector>();
    private InetFlowSelector[] currentHourSelectors;

    public InetMonthFlowSelector(List<InetDetailCreateEvent.SessionInfo> sessionList, long connectionfinishTimeoutMillis) {
        ArrayList<InetFlowSelector> flowSelectorList = new ArrayList<InetFlowSelector>();
        for (InetDetailCreateEvent.SessionInfo task : sessionList) {
            flowSelectorList.add(new InetFlowSelector(task.getTimeFrom().getTime(), (task.getTimeTo().getTime() + connectionfinishTimeoutMillis) / 1000L * 1000L + 999L, task.getIfaces(), task.getAddressFrom().address, task.getAddressTo().address, task.getPrefix().address, task.getPrefixLength(), task.getRouteNetList(), 0));
        }
        Collections.sort(flowSelectorList, new Comparator<InetFlowSelector>(this){

            @Override
            public int compare(InetFlowSelector o2, InetFlowSelector o1) {
                return o1.timeFrom > o2.timeFrom ? 1 : (o1.timeFrom == o2.timeFrom ? 0 : -1);
            }
        });
        this.flowSelectorList = flowSelectorList;
    }

    public FlowSelector.Result test(long hour, Data flow) {
        if (this.currentHour != hour) {
            this.currentHour = hour;
            long hourEnd = hour + 86400000L;
            this.currentHourSelectorList.clear();
            for (InetFlowSelector selector : this.flowSelectorList) {
                if (selector.timeFrom >= hourEnd || selector.timeTo < hour) continue;
                this.currentHourSelectorList.add(selector);
            }
            this.currentHourSelectors = this.currentHourSelectorList.toArray(new InetFlowSelector[this.currentHourSelectorList.size()]);
        }
        InetFlowSelector[] selectors = this.currentHourSelectors;
        int size = selectors.length;
        for (int i = 0; i < size; ++i) {
            FlowSelector.Result result = selectors[i].test(hour, flow);
            if (result == RESULT_ERROR) continue;
            return result;
        }
        return RESULT_ERROR;
    }
}

