/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.client.common;

import javax.swing.SwingWorker;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;

public abstract class BGSwingWorker<T, V>
extends SwingWorker<T, V> {
    private final ClientContext context;

    public BGSwingWorker(ClientContext context) {
        this.context = context;
    }

    public ClientContext getContext() {
        return this.context;
    }

    @Override
    protected final T doInBackground() throws Exception {
        ClientContext.push(this.context);
        try {
            T t = this.doInBackgroundImpl();
            return t;
        }
        finally {
            ClientContext.pop();
        }
    }

    @Override
    protected final void done() {
        ClientContext.push(this.context);
        try {
            this.doneImpl();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
        finally {
            ClientContext.pop();
        }
    }

    protected abstract T doInBackgroundImpl() throws Exception;

    protected void doneImpl() throws Exception {
    }
}

