/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.order.product.server.service;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import jakarta.annotation.Resource;
import jakarta.jws.WebService;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff.ContractTariffDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.tariff.PersonalTariffManager;
import ru.bitel.bgbilling.kernel.contract.label.server.bean.ContractLabelManager;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.modules.tv.server.runtime.TvTarifficationManager;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.RangeUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.GuiTitlable;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.Tied;
import ru.bitel.common.util.Ranger;
import ru.bitel.oss.systems.inventory.product.common.bean.Product;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductOffering;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductOfferingActivationMode;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductPeriod;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpec;
import ru.bitel.oss.systems.inventory.product.common.bean.ProductSpecActivationMode;
import ru.bitel.oss.systems.inventory.product.common.service.ProductService;
import ru.bitel.oss.systems.order.product.common.event.ProductDeactivatedEvent;
import ru.bitel.oss.systems.order.product.common.event.ProductOfferingListEvent;
import ru.bitel.oss.systems.order.product.common.event.ProductOrderEvent;
import ru.bitel.oss.systems.order.product.common.service.ProductOrderService;

@WebService(endpointInterface="ru.bitel.oss.systems.order.product.common.service.ProductOrderService")
public class ProductOrderServiceImpl
extends AbstractService
implements ProductOrderService {
    @Resource
    private ProductService productService;
    private ContractManager contractManager;
    private ContractLabelManager contractLabelManager;
    private Tied.Utils<Product, ProductSpec> tiedUtils = null;
    private Tied.TieResolver<Product, ProductSpec> tiedResolver = null;

    private ContractManager getContractManager() {
        if (this.contractManager == null) {
            this.contractManager = new ContractManager(this.getConnection());
        }
        return this.contractManager;
    }

    private ContractLabelManager getContractLabelManager() {
        if (this.contractLabelManager == null) {
            this.contractLabelManager = new ContractLabelManager(this.getConnection());
        }
        return this.contractLabelManager;
    }

    public Tied.TieResolver<Product, ProductSpec> getTiedResolver() throws Exception {
        if (this.tiedResolver != null) {
            return this.tiedResolver;
        }
        final Map map = Id.newMap((List)this.productService.productSpecList(null, null, null, null, null));
        this.tiedResolver = new Tied.TieResolver<Product, ProductSpec>(){

            public ProductSpec resolve(Product t) {
                return (ProductSpec)map.get(this.resolveId(t));
            }

            public int resolveId(Product t) {
                return t.getProductSpecId();
            }

            public ProductSpec resolve(Integer id) {
                return (ProductSpec)map.get(id);
            }
        };
        return this.tiedResolver;
    }

    public Tied.Utils<Product, ProductSpec> getTieUtils() throws Exception {
        if (this.tiedUtils != null) {
            return this.tiedUtils;
        }
        this.tiedUtils = new Tied.Utils(this.getTiedResolver(), (Ranger)new Ranger<Product, Date>(this){

            public Date getMaxValue(Product r) {
                return r.getTimeTo();
            }

            public Date getMinValue(Product r) {
                return r.getTimeFrom();
            }
        });
        return this.tiedUtils;
    }

    protected void processTieException(Tied.TieUnresolvedException ex) throws BGMessageException {
        List<String> values;
        String key;
        StringBuilder sb = new StringBuilder();
        if (ex.getDependsUnresolved().size() > 0) {
            for (Map.Entry e : ex.getDependsUnresolved().entrySet()) {
                key = e.getKey() instanceof GuiTitlable ? ((GuiTitlable)e.getKey()).getGuiTitle() : ((Tied)e.getKey()).toString();
                values = ((Set)e.getValue()).stream().map(a -> a instanceof GuiTitlable ? ((GuiTitlable)a).getGuiTitle() : a.toString()).toList();
                sb.append(MessageFormat.format("\u0414\u043b\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043d\u0430 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \"{0}\" \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u043d\u0430 {2,choice,1#\u043f\u0440\u043e\u0434\u0443\u043a\u0442|1<\u043f\u0440\u043e\u0434\u0443\u043a\u0442\u044b:} \"{1}\".", key, Utils.toString(values, (String)"\", \""), values.size())).append("\n");
            }
        }
        if (ex.getIncompatibleUnresolved().size() > 0) {
            for (Map.Entry e : ex.getIncompatibleUnresolved().entrySet()) {
                key = e.getKey() instanceof GuiTitlable ? ((GuiTitlable)e.getKey()).getGuiTitle() : ((Tied)e.getKey()).toString();
                values = ((Set)e.getValue()).stream().map(a -> a instanceof GuiTitlable ? ((GuiTitlable)a).getGuiTitle() : a.toString()).toList();
                sb.append(MessageFormat.format("\u041f\u0440\u043e\u0434\u0443\u043a\u0442 \"{0}\" \u043d\u0435\u0441\u043e\u0432\u043c\u0435\u0441\u0442\u0438\u043c \u0441 {2,choice,1#\u043f\u0440\u043e\u0434\u0443\u043a\u0442\u043e\u043c|1<\u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430\u043c\u0438:} \"{1}\".", key, Utils.toString(values, (String)"\", \""), values.size())).append("\n");
            }
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        throw new BGMessageException(sb.toString());
    }

    public List<ProductOffering> productTariffOfferingList(Integer moduleId, int tariffId, Date time, boolean availableOnly) throws Exception {
        if (moduleId == null && this.moduleId > 0) {
            moduleId = this.moduleId;
        }
        if (time == null) {
            time = new Date();
        }
        List fullProductSpecList = this.productService.productSpecList(moduleId, time, time, null, null);
        if (moduleId != null && moduleId > 0) {
            fullProductSpecList.addAll(this.productService.productSpecList(Integer.valueOf(0), time, time, null, null));
        }
        HashSet<Integer> tariffIds = new HashSet<Integer>();
        tariffIds.add(tariffId);
        List<ProductOffering> productOfferingList = new ArrayList<ProductOffering>();
        for (ProductSpec productSpec : fullProductSpecList) {
            ArrayList<ProductOfferingActivationMode> productOfferingActivationModeList = new ArrayList<ProductOfferingActivationMode>();
            ProductOffering productOffering = ProductOffering.builder().setProductSpec(productSpec).setActivationModeList(productOfferingActivationModeList).build();
            productOfferingList.add(productOffering);
            if (productSpec.getTariffIds().size() > 0 && CollectionUtils.intersection((Iterable)productSpec.getTariffIds(), tariffIds).size() == 0 || productSpec.getActivationModeList() == null || productSpec.getActivationModeList().size() == 0) continue;
            for (ProductSpecActivationMode activationMode : productSpec.getActivationModeList()) {
                if (!TimeUtils.dateInRange((Date)time, (Date)activationMode.getDateFrom(), (Date)activationMode.getDateTo())) continue;
                productOfferingActivationModeList.add(new ProductOfferingActivationMode(activationMode, BigDecimal.ZERO));
            }
            productOffering.setEnable(true);
        }
        try {
            List<Object> result;
            new TvTarifficationManager(this.context.getSetup(), this.getConnectionSet(), moduleId.intValue()).tarifficateOfferings(this.getConnection(), tariffId, productOfferingList, time);
            ProductOfferingListEvent availableListEvent = EventProcessor.getInstance().request(new ProductOfferingListEvent(moduleId, 0, 0, this.userId, time, null, tariffIds, null, availableOnly, productOfferingList));
            productOfferingList = availableListEvent.getProductOfferingList();
            if (availableOnly) {
                result = new ArrayList();
                for (ProductOffering productOffering : productOfferingList) {
                    if (!productOffering.isEnable()) continue;
                    result.add(productOffering);
                }
            } else {
                result = productOfferingList;
            }
            return result;
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public ProductOffering productOfferingGet(Integer moduleId, int contractId, int accountId, int productSpecId, int activationModeId, Date time, boolean availableOnly, boolean customer) throws BGException {
        List<ProductOffering> productOfferingList = this.productOfferingList(moduleId, contractId, accountId, time, availableOnly, customer, null, productSpecId, activationModeId);
        return productOfferingList.size() > 0 ? productOfferingList.get(0) : null;
    }

    public List<ProductOffering> productOfferingList(Integer moduleId, int contractId, int accountId, int productSpecId, Date time, boolean availableOnly, boolean customer) throws BGException {
        return this.productOfferingList(moduleId, contractId, accountId, time, availableOnly, customer, null, productSpecId, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ProductOffering> productOfferingList(Integer moduleId, int contractId, int accountId, Date time, boolean availableOnly, boolean customer, List<Product> activeProductList, int productSpecId, int activationModeId) throws BGException {
        try {
            List<ProductOffering> result;
            if (moduleId == null && this.moduleId > 0) {
                moduleId = this.moduleId;
            }
            if (contractId <= 0) {
                throw new BGIllegalArgumentException();
            }
            if (time == null) {
                time = new Date();
            }
            if (activeProductList == null) {
                activeProductList = this.activeProductList(contractId, accountId, time);
            }
            List fullProductSpecList = this.productService.productSpecList(moduleId, time, time, null, null);
            if (moduleId != null && moduleId > 0) {
                fullProductSpecList.addAll(this.productService.productSpecList(Integer.valueOf(0), time, time, null, null));
            }
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace("fullProductSpecList.size() = {}", (Object)fullProductSpecList.size());
                fullProductSpecList.forEach(a -> this.getLogger().trace("\t" + String.valueOf(a)));
            }
            HashSet<Integer> tariffIds = new HashSet<Integer>();
            new ContractTariffDao(this.getConnection()).list(contractId, TimeUtils.convertDateToLocalDate((Date)time)).forEach(a -> tariffIds.add(a.getTariffPlanId()));
            tariffIds.addAll(new PersonalTariffManager(this.getConnection()).getParentTreeTariffIds(contractId, time));
            Contract contract = new ContractManager(this.getConnection()).getContractById(contractId);
            List<ProductOffering> productOfferingList = new ArrayList<ProductOffering>();
            List<Integer> labelsOnContract = this.getContractLabelManager().getContractLabelIds(contractId);
            this.getLogger().trace(String.format("ProductOfferingList. cid=%s, productSpecId=%s, tariffIds=%s, fullProductSpecList size=%s, isCustomer=%s", contractId, productSpecId, tariffIds.size(), fullProductSpecList.size(), customer));
            for (ProductSpec productSpec : fullProductSpecList) {
                if (this.getLogger().isTraceEnabled()) {
                    this.getLogger().trace("productSpecId={}; productSpec.getId()={}", (Object)productSpecId, (Object)productSpec.getId());
                }
                if (productSpecId > 0 && productSpec.getId() != productSpecId) continue;
                ProductOffering productOffering = ProductOffering.builder().setProductSpec(productSpec).setActivationModeList(new ArrayList()).build();
                productOfferingList.add(productOffering);
                if (productSpec.getTariffIds().size() > 0 && CollectionUtils.intersection((Iterable)productSpec.getTariffIds(), tariffIds).size() == 0) {
                    if (!this.getLogger().isTraceEnabled()) continue;
                    this.getLogger().trace("SKIP: \"\u041d\u0435 \u043f\u0435\u0440\u0435\u0441\u0435\u043a\u0430\u0435\u0442\u0441\u044f \u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u043e \u0442\u0430\u0440\u0438\u0444\u043e\u0432 \u043d\u0430 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0435 \u0441 \u043c\u043d\u043e\u0436\u0435\u0441\u0442\u0432\u043e\u043c \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u044b\u0445 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u043e\u043c \u0442\u0430\u0440\u0438\u0444\u043e\u0432");
                    continue;
                }
                if (Utils.notEmptyCollection(labelsOnContract) && Utils.notEmptyCollection((Collection)productSpec.getContractLabels())) {
                    boolean allowProductForContract;
                    boolean bl = allowProductForContract = productSpec.getContractLabels().stream().filter(labelId -> labelsOnContract.stream().anyMatch(labelId::equals)).findAny().orElse(-1) > 0;
                    if (!allowProductForContract) {
                        if (!this.getLogger().isTraceEnabled()) continue;
                        this.getLogger().trace("SKIP: \u041d\u0435 \u043f\u0440\u043e\u0448\u0435\u043b \u0444\u0438\u043b\u044c\u0442\u0440\u0430\u0446\u0438\u044e \u043f\u043e \u043c\u0435\u0442\u043a\u0430\u043c");
                        continue;
                    }
                }
                if (customer) {
                    if (productSpec.isHideForCustomer()) {
                        this.getLogger().trace(String.format("\u0421\u043a\u0440\u044b\u0442\u043e \u0434\u043b\u044f WEB. productSpecId=%s", productSpec.getId()));
                        if (!this.getLogger().isTraceEnabled()) continue;
                        this.getLogger().trace("SKIP: \u043f\u0440\u043e\u043f\u0443\u0441\u043a\u0430\u0435\u043c, \u0435\u0441\u043b\u0438 \u0441\u0442\u043e\u0438\u0442 \u0433\u0430\u043b\u043a\u0430 \"\u0441\u043a\u0440\u044b\u0432\u0430\u0442\u044c \u0432 web\"");
                        continue;
                    }
                    if (productSpec.getHideForContractGroupsMode() == 0) {
                        boolean hideThisProduct;
                        boolean bl = hideThisProduct = productSpec.getHideForContractLabels().stream().filter(labelId -> labelsOnContract.stream().anyMatch(labelId::equals)).findAny().orElse(-1) > 0;
                        if (hideThisProduct) {
                            if (!this.getLogger().isTraceEnabled()) continue;
                            this.getLogger().trace("SKIP: \u041d\u0435 \u043f\u0440\u043e\u0448\u0451\u043b \u0444\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u043c\u0435\u0442\u043a\u0430\u043c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430. \u0420\u0435\u0436\u0438\u043c \u0418\u041b\u0418. labelsOnContract={}", labelsOnContract);
                            continue;
                        }
                    } else if (!labelsOnContract.containsAll(productSpec.getHideForContractLabels())) {
                        if (!this.getLogger().isTraceEnabled()) continue;
                        this.getLogger().trace("SKIP: \u041d\u0435 \u043f\u0440\u043e\u0448\u0451\u043b \u0444\u0438\u043b\u044c\u0442\u0440 \u043f\u043e \u043c\u0435\u0442\u043a\u0430\u043c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430. \u0420\u0435\u0436\u0438\u043c \u0418. labelsOnContract={}", labelsOnContract);
                        continue;
                    }
                }
                if (productSpec.getActivationModeList() == null || productSpec.getActivationModeList().size() == 0) {
                    if (!this.getLogger().isTraceEnabled()) continue;
                    this.getLogger().trace("SKIP: \u041d\u0435 \u0437\u0430\u0434\u0430\u043d \u0440\u0435\u0436\u0438\u043c \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0434\u043b\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430");
                    continue;
                }
                for (Object activationMode : productSpec.getActivationModeList()) {
                    if (activationModeId > 0 && activationMode.getId() != activationModeId) {
                        if (!this.getLogger().isTraceEnabled()) continue;
                        this.getLogger().trace("\u041d\u0435 \u043f\u0440\u043e\u0448\u0435\u043b \u0443\u0441\u043b\u043e\u0432\u0438\u0435 activationModeId > 0 && activationMode.getId() != activationModeId. activationModeId=" + activationModeId + ", activationMode=" + activationMode.getId());
                        continue;
                    }
                    if (!TimeUtils.dateInRange((Date)time, (Date)activationMode.getDateFrom(), (Date)activationMode.getDateTo())) continue;
                    productOffering.getActivationModeList().add(new ProductOfferingActivationMode((ProductSpecActivationMode)activationMode, BigDecimal.ZERO));
                }
                productOffering.setEnable(true);
            }
            ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(this.getConnection(), (Integer)contractId);
            contractRuntime.lock();
            try {
                new TvTarifficationManager(this.context.getSetup(), this.getConnectionSet(), moduleId.intValue()).tarifficateOfferings(contractId, accountId, productOfferingList, time);
            }
            finally {
                contractRuntime.unlock();
            }
            ProductOfferingListEvent productOfferingListEvent = new ProductOfferingListEvent(moduleId, contractId, accountId, this.userId, time, contract, tariffIds, activeProductList, availableOnly, productOfferingList);
            ProductOfferingListEvent availableListEvent = EventProcessor.getInstance().request(productOfferingListEvent);
            productOfferingList = availableListEvent.getProductOfferingList();
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace("availableOnly = {}; productOfferingList.size() = {}", (Object)availableOnly, (Object)productOfferingList.size());
            }
            if (availableOnly) {
                this.getLogger().trace("availableOnly=true");
                result = new ArrayList();
                for (ProductOffering productOffering : productOfferingList) {
                    if (!productOffering.isEnable()) continue;
                    result.add(productOffering);
                }
            } else {
                result = productOfferingList;
            }
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace("Result productOfferingList size={}", (Object)productOfferingList.size());
            }
            ArrayList<ProductOffering> sortResult = new ArrayList<ProductOffering>();
            for (ProductOffering offering : result) {
                int id = offering.getProductSpec().getId();
                if (!result.stream().noneMatch(a -> offering.getProductSpec().getParentId() == id)) continue;
                sortResult.add(offering);
                this.addChildren(offering.getProductSpec().getId(), sortResult, result);
            }
            return sortResult;
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private void addChildren(int parentId, List<ProductOffering> sortResult, List<ProductOffering> result) {
        ArrayList<ProductOffering> adds = new ArrayList<ProductOffering>();
        for (ProductOffering offering : result) {
            if (offering.getProductSpec().getParentId() != parentId) continue;
            adds.add(offering);
        }
        Collections.sort(adds, new Comparator<ProductOffering>(this){

            @Override
            public int compare(ProductOffering o1, ProductOffering o2) {
                return o1.getProductSpec().getSort() - o2.getProductSpec().getSort();
            }
        });
        sortResult.addAll(adds);
    }

    private static boolean containsProductSpec(List<ProductOffering> productOfferingList, ProductSpec productSpec) {
        int size = productOfferingList.size();
        for (int i = 0; i < size; ++i) {
            if (!productSpec.equals((Object)productOfferingList.get(i).getProductSpec())) continue;
            return true;
        }
        return false;
    }

    public List<Product> activeProductList(int contractId, int accountId, Date time) throws Exception {
        return this.productService.productList(-1, contractId, accountId, true, null, null, time, null, false, false);
    }

    @Deprecated
    public int productActivate(Product product, boolean customer, boolean sync) throws Exception {
        return this.productActivate(product, null, customer, sync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int productActivate(Product product, Date time, boolean customer, boolean sync) throws Exception {
        boolean timeFromSet;
        if (product == null || product.getContractId() <= 0 || product.getProductSpecId() <= 0 || product.getActivationModeId() <= 0) {
            throw new BGIllegalArgumentException();
        }
        ProductSpec productSpec = this.productService.productSpecGet(product.getProductSpecId());
        if (productSpec == null) {
            throw new BGMessageException("\u041f\u0440\u043e\u0434\u0443\u043a\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d.");
        }
        int contractId = product.getContractId();
        int accountId = product.getAccountId();
        boolean timeSet = time != null;
        boolean bl = timeFromSet = product.getTimeFrom() != null && time == null;
        if (timeFromSet) {
            time = product.getTimeFrom();
        }
        time = new Date(TimeUtils.rountToSeconds((long)(time == null ? System.currentTimeMillis() : time.getTime())));
        ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(this.getConnectionSet(), (Integer)contractId);
        contractRuntime.lock();
        try {
            List<Product> activeProductList = this.activeProductList(contractId, accountId, time);
            List<ProductOffering> productOffering = this.productOfferingList(productSpec.getModuleId(), contractId, accountId, time, true, customer, activeProductList, productSpec.getId(), product.getActivationModeId());
            if (!ProductOrderServiceImpl.containsProductSpec(productOffering, productSpec)) {
                throw new BGMessageException("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u043d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430.");
            }
            int productActivationModeId = product.getActivationModeId();
            ProductSpecActivationMode activationMode = productSpec.getActivationModeList().stream().filter(a -> a.getId() == productActivationModeId).findFirst().orElse(null);
            if (activationMode == null) {
                throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0440\u0435\u0436\u0438\u043c \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0441 ID " + product.getActivationModeId() + ".");
            }
            if (!TimeUtils.dateInRange((Date)time, (Date)activationMode.getDateFrom(), (Date)activationMode.getDateTo())) {
                throw new BGMessageException("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u0441 \u0434\u0430\u043d\u043d\u044b\u043c \u0440\u0435\u0436\u0438\u043c\u043e\u043c \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u0430!");
            }
            ContractManager cm = this.getContractManager();
            Contract contract = cm.getContractById(contractId);
            if (contract == null) {
                throw new BGMessageException("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u0441 ID " + contractId + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
            }
            product.setActivationTime(time);
            product.setDeviceState(sync ? (short)-1 : 1);
            product.setUserId(this.userId);
            product.setTimeFrom(time);
            this.adjustProductPeriod(product, activationMode, timeFromSet);
            Date _productTimeTo = product.getTimeTo();
            try {
                product.setTimeTo(new Date(product.getTimeFrom().getTime() + 1000L));
                this.getTieUtils().checkAdd(activeProductList, (Object)product, 14);
            }
            catch (Tied.TieUnresolvedException ex) {
                if (customer || !timeSet && !timeFromSet || ex.getDependsUnresolved() != null && ex.getDependsUnresolved().size() > 0) {
                    this.processTieException(ex);
                }
            }
            finally {
                product.setTimeTo(_productTimeTo);
            }
            int id = this.productService.productUpdate(product);
            product.setId(id);
            ProductOrderEvent activateOrderEvent = EventProcessor.getInstance().request(new ProductOrderEvent(1, contractId, this.userId, customer, productSpec, activationMode, null, product, sync, true));
            if (!activateOrderEvent.isProcess()) {
                throw new BGMessageException(activateOrderEvent.getMessage());
            }
            product = activateOrderEvent.getNewProduct();
            int n = product.getId();
            return n;
        }
        finally {
            contractRuntime.unlock();
        }
    }

    public void adjustProductPeriod(Product product, ProductSpecActivationMode activationMode, boolean timeFromSet) {
        int[] modeValue = ProductSpecActivationMode.mode((int)activationMode.getPeriodMode());
        int modeField = modeValue[0];
        int modeBegin = modeValue[1];
        int modeEnd = modeValue[2];
        int calendarField = switch (modeField) {
            case 1 -> 12;
            case 2 -> 11;
            case 3 -> 5;
            case 4 -> 3;
            case 5 -> 2;
            default -> 2;
        };
        Calendar calendar = TimeUtils.convertDateToCalendar((Date)product.getTimeFrom());
        if (!timeFromSet) {
            if (modeBegin == 2 || modeBegin == 3) {
                TimeUtils.floor((Calendar)calendar, (int)calendarField);
                if (modeBegin == 3) {
                    calendar.add(calendarField, 1);
                }
            } else if (modeBegin == 4) {
                TimeUtils.clear_MIN_MIL_SEC((Calendar)calendar);
                calendar.add(11, 1);
            }
            product.setTimeFrom(TimeUtils.convertCalendarToDate((Calendar)calendar));
        }
        if (product.getTimeTo() == null) {
            if (activationMode.getPeriodAmount() == 0) {
                product.setTimeTo(null);
            } else {
                if (modeEnd == 2) {
                    TimeUtils.floor((Calendar)calendar, (int)calendarField);
                }
                calendar.add(calendarField, activationMode.getPeriodAmount());
                calendar.add(14, -1);
                product.setTimeTo(TimeUtils.convertCalendarToDate((Calendar)calendar));
            }
        } else {
            calendar.setTime(product.getTimeTo());
            calendar.set(14, 999);
            product.setTimeTo(TimeUtils.convertCalendarToDate((Calendar)calendar));
        }
    }

    @Deprecated
    public void productDeactivate(int contractId, int productId, Date time, boolean customer, boolean sync) throws Exception {
        this.productDeactivate(contractId, productId, time, customer, sync, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void productDeactivate(int contractId, int productId, Date time, boolean customer, boolean sync, boolean now) throws Exception {
        ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(this.getConnectionSet(), (Integer)contractId);
        contractRuntime.lock();
        try {
            Product product = this.productService.productGet(contractId, productId);
            if (product == null) {
                throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0441 ID " + productId + ".");
            }
            if (customer) {
                now = false;
            }
            Product oldProduct = product.clone();
            ProductSpec productSpec = this.productService.productSpecGet(product.getProductSpecId());
            if (productSpec == null) {
                throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0441\u043f\u0435\u0446\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u0441 ID " + product.getProductSpecId() + ".");
            }
            ProductSpecActivationMode activationMode = null;
            for (ProductSpecActivationMode mode : productSpec.getActivationModeList()) {
                if (mode.getId() != product.getActivationModeId()) continue;
                activationMode = mode;
                break;
            }
            if (activationMode == null) {
                throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0440\u0435\u0436\u0438\u043c \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0441 ID " + product.getActivationModeId() + ".");
            }
            GregorianCalendar calendar = new GregorianCalendar();
            try {
                if (time == null) {
                    time = new Date();
                }
                calendar.setTime(time);
                calendar.set(14, 0);
                time = calendar.getTime();
                List<Product> activeProductList = this.activeProductList(contractId, product.getAccountId(), time);
                if (product.getTimeTo() != null && (customer || !product.getTimeTo().after(time))) {
                    throw new BGMessageException("\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0443\u0436\u0435 \u0434\u0435\u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u043f\u0440\u043e\u0434\u0443\u043a\u0442.");
                }
                if (product.getTimeFrom().compareTo(time) > 0) {
                    close = time;
                    product.setTimeTo(close);
                    this.getTieUtils().checkRemove(activeProductList, (Object)product, 14);
                } else {
                    close = time;
                    calendar.setTime(close);
                    calendar.set(14, 0);
                    int deactivationMode = now ? 0 : activationMode.getDeactivationMode();
                    switch (deactivationMode) {
                        case 10: {
                            List productPeriodList = this.productService.productPeriodList(contractId, productId);
                            if (productPeriodList.size() <= 0) break;
                            ProductPeriod lastPeriod = (ProductPeriod)productPeriodList.get(productPeriodList.size() - 1);
                            if (lastPeriod.getTimeTo() == null) {
                                throw new BGException("lastProductPeriod.getTimeTo() == null");
                            }
                            if (calendar.getTime().compareTo(lastPeriod.getTimeTo()) >= 0) break;
                            calendar.setTime(lastPeriod.getTimeTo());
                            calendar.set(14, 0);
                            break;
                        }
                        case 0: {
                            break;
                        }
                        case 2: {
                            TimeUtils.clear_MIN_MIL_SEC((Calendar)calendar);
                            ((Calendar)calendar).add(11, 1);
                            break;
                        }
                        case 3: {
                            TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendar);
                            ((Calendar)calendar).add(5, 1);
                            break;
                        }
                        case 4: {
                            TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendar);
                            calendar.set(7, calendar.getFirstDayOfWeek());
                            ((Calendar)calendar).add(3, 1);
                            break;
                        }
                        case 5: {
                            TimeUtils.clear_HOUR_MIN_MIL_SEC((Calendar)calendar);
                            calendar.set(5, 1);
                            ((Calendar)calendar).add(2, 1);
                            break;
                        }
                        default: {
                            throw new BGIllegalArgumentException();
                        }
                    }
                    close = TimeUtils.convertCalendarToDate((Calendar)calendar);
                    product.setTimeTo(close);
                    ArrayList<ProductSpec> depends = new ArrayList<ProductSpec>();
                    for (Product a : activeProductList) {
                        ProductSpec productSpec1 = (ProductSpec)this.getTiedResolver().resolve((Object)a);
                        if (productSpec1.getDepends() == null || !productSpec1.getDepends().contains(product.getProductSpecId()) || !RangeUtils.intersects((Comparable)a.getTimeFrom(), (Comparable)a.getTimeTo(), (Comparable)product.getTimeFrom(), (Comparable)product.getTimeTo()) || a.getTimeTo() != null) continue;
                        depends.add(productSpec1);
                    }
                    if (depends.size() > 0) {
                        throw new BGMessageException(MessageFormat.format("\u0414\u043b\u044f \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0438 \u043d\u0430 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \"{0}\" \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430 \u043f\u043e\u0434\u043f\u0438\u0441\u043a\u0430 \u043d\u0430 {2,choice,1#\u043f\u0440\u043e\u0434\u0443\u043a\u0442|1<\u043f\u0440\u043e\u0434\u0443\u043a\u0442\u044b:} \"{1}\".", productSpec, Utils.toString(depends, (String)"\", \""), depends.size()));
                    }
                }
            }
            catch (Tied.TieUnresolvedException ex) {
                this.processTieException(ex);
            }
            product.setDeactivationTime(time);
            ProductOrderEvent deactivateOrderEvent = EventProcessor.getInstance().request(new ProductOrderEvent(2, contractId, this.userId, customer, productSpec, activationMode, oldProduct, product, sync, true));
            if (!deactivateOrderEvent.isProcess()) {
                throw new BGMessageException(deactivateOrderEvent.getMessage());
            }
            product = deactivateOrderEvent.getNewProduct();
            this.productService.productUpdate(product);
            EventProcessor.getInstance().publish(new ProductDeactivatedEvent(product.getId(), product.getProductSpecId(), product.getAccountId(), product.getContractId(), this.userId, this.moduleId));
        }
        finally {
            contractRuntime.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void productReactivate(int contractId, int productId, boolean sync) throws Exception {
        if (contractId <= 0 || productId <= 0) {
            throw new BGIllegalArgumentException();
        }
        ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(this.getConnectionSet(), (Integer)contractId);
        contractRuntime.lock();
        try {
            Product product = this.productService.productGet(contractId, productId);
            if (product == null || product.getContractId() != contractId) {
                throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0441 ID=" + productId + ".");
            }
            ProductSpec productSpec = this.productService.productSpecGet(product.getProductSpecId());
            if (productSpec == null) {
                throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0441\u043f\u0435\u0446\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u0441 ID=" + product.getProductSpecId() + ".");
            }
            ProductSpecActivationMode activationMode = null;
            for (ProductSpecActivationMode productSpecActivationMode : productSpec.getActivationModeList()) {
                if (productSpecActivationMode.getId() != product.getActivationModeId()) continue;
                activationMode = productSpecActivationMode;
                break;
            }
            if (activationMode == null) {
                throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0440\u0435\u0436\u0438\u043c \u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u0438 \u0441 ID=" + product.getActivationModeId() + ".");
            }
            if (activationMode.getReactivationMode() != 1 || product.getTimeTo() == null || !product.getTimeTo().after(new Date())) {
                throw new BGMessageException("\u0420\u0435\u0430\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u0430!");
            }
            Product oldProduct = product.clone();
            product.setDeactivationTime(null);
            product.setTimeTo(null);
            ProductOrderEvent reactivateOrderEvent = EventProcessor.getInstance().request(new ProductOrderEvent(4, contractId, this.userId, true, productSpec, activationMode, oldProduct, product, sync, true));
            if (!reactivateOrderEvent.isProcess()) {
                throw new BGMessageException(reactivateOrderEvent.getMessage());
            }
            product = reactivateOrderEvent.getNewProduct();
            this.productService.productUpdate(product);
        }
        finally {
            contractRuntime.unlock();
        }
    }

    public void isAllowProductActivate(int moduleId, int contractId) throws BGException, BGMessageException {
        boolean allow;
        Contract contract = this.getContractManager().getContractById(contractId);
        Setup setup = Setup.getSetup();
        String kernelContractStatusActiveCodes = setup.get("contract.status.active.codes");
        String tvContractStatusActiveCodes = setup.getModuleSetup(moduleId).get("contract.status.active.codes");
        boolean bl = allow = contract != null;
        if (allow) {
            if (tvContractStatusActiveCodes != null) {
                allow = Utils.toIntegerSet((String)tvContractStatusActiveCodes).contains(contract.getStatus());
            } else if (kernelContractStatusActiveCodes != null) {
                allow = Utils.toIntegerSet((String)kernelContractStatusActiveCodes).contains(contract.getStatus());
            } else {
                throw new BGMessageException("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u0430. \u0412 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043c\u043e\u0434\u0443\u043b\u044f \u0438\u043b\u0438 \u044f\u0434\u0440\u0430 \u043d\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043d\u044b \u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0435 \u0441\u0442\u0430\u0442\u0443\u0441\u044b.");
            }
        }
        if (allow) {
            return;
        }
        throw new BGMessageException("\u0410\u043a\u0442\u0438\u0432\u0430\u0446\u0438\u044f \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u0430. \u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u0432 \"\u043d\u0435 \u0430\u043a\u0442\u0438\u0432\u043d\u043e\u043c\" \u0441\u0442\u0430\u0442\u0443\u0441\u0435");
    }

    public List<ProductOffering> productAvailableList(int moduleId, int contractId, Date date) throws BGException, BGMessageException {
        if (date == null) {
            date = new Date();
        }
        return null;
    }
}

