/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.base.server.logger.BGLogger;
import ru.bitel.common.Utils;

public class MacrosFormat
extends BGLogger {
    private static String MACROS = "\\$([\\w\u0430-\u044f\u0410-\u042f\\-]+)";
    private static String ARGS_PROTO = "[\\w^\\w\u0430-\u044f\u0410-\u042f ,\\$'\"-:;.#|><=+\\&@%\u2116!\\[\\]\\{\\}\\?&&[^\\(\\)]]*?";
    private static String ARGS = "\\((" + ARGS_PROTO + ")\\)";
    private static Pattern pattern = Pattern.compile("(\\{(" + MACROS + ARGS + ")" + ARGS_PROTO + "\\})|((" + MACROS + ARGS + "))|(?:(\\{(" + MACROS + ")\\b()" + ARGS_PROTO + "\\}))|(?:(" + MACROS + ")\\b())");
    private static Pattern pattern2 = Pattern.compile("(?:\\A|,)?+\\s*(?:(\\{\\$([\\w\\-]+)(?:\\((.+?)\\))?.*?\\})|(\\$([\\w\\-]+)(?:\\((.+?)\\))?)|(.+?))\\s*(?:\\z|,)");
    private String matcherPattern;
    private Matcher matcher;
    private MessageFormat messageFormat;

    public String format(String pattern, Object ... globalArgs) {
        try {
            return this.format(new StringBuffer(pattern.length() + 10), pattern, globalArgs).toString();
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
    }

    private static final MessageFormat newMessageFormat() {
        return new MessageFormat(""){

            @Override
            public void applyPattern(String pattern) {
                super.applyPattern(pattern);
                Format[] formats = this.getFormats();
                int size = formats.length;
                for (int i = 0; i < size; ++i) {
                    if (!(formats[i] instanceof DecimalFormat)) continue;
                    DecimalFormatSymbols dfs = new DecimalFormatSymbols(this.getLocale());
                    dfs.setDecimalSeparator('.');
                    ((DecimalFormat)formats[i]).setDecimalFormatSymbols(dfs);
                }
            }
        };
    }

    public void setPattern(String pattern) {
        this.matcherPattern = pattern;
        this.matcher = MacrosFormat.pattern.matcher(pattern);
        this.messageFormat = MacrosFormat.newMessageFormat();
    }

    public StringBuffer format(StringBuffer appendable, Object ... globalArgs) throws BGException {
        this.matcher.reset();
        return this.formatImpl(this.matcherPattern, this.matcher, this.messageFormat, appendable, globalArgs);
    }

    public StringBuffer format(StringBuffer appendable, String pattern, Object ... globalArgs) throws BGException {
        Matcher m = MacrosFormat.pattern.matcher(pattern);
        MessageFormat messageFormat = MacrosFormat.newMessageFormat();
        return this.formatImpl(pattern, m, messageFormat, appendable, globalArgs);
    }

    private StringBuffer formatImpl(String pattern, Matcher m, MessageFormat messageFormat, StringBuffer appendable, Object ... globalArgs) throws BGException {
        StringBuffer sb = appendable.length() == 0 ? appendable : new StringBuffer(pattern.length() + 10);
        ArrayList<Object> variables1 = new ArrayList<Object>(6);
        ArrayList variables2 = new ArrayList(6);
        for (int i = 0; i < 100; ++i) {
            boolean found = false;
            while (m.find()) {
                Object result;
                found = true;
                boolean format = false;
                int pos = 2;
                pos = 3;
                String macros = m.group(3);
                if (macros != null) {
                    format = true;
                } else {
                    pos = 7;
                    macros = m.group(7);
                    if (macros != null) {
                        format = false;
                    } else {
                        pos = 11;
                        macros = m.group(11);
                        if (macros != null) {
                            int index = m.end(11);
                            if (index < pattern.length() - 1 && pattern.charAt(index) == '(') continue;
                            format = true;
                        } else {
                            pos = 14;
                            macros = m.group(14);
                            if (macros != null) {
                                int index = m.end(14);
                                if (index < pattern.length() - 1 && pattern.charAt(index) == '(') continue;
                                format = false;
                            }
                        }
                    }
                }
                if (macros.equals("dollar")) {
                    m.appendReplacement(sb, Matcher.quoteReplacement("$"));
                    continue;
                }
                if (macros.startsWith("macros-")) {
                    result = variables1.get(Utils.parseInt(macros.substring(7)));
                    m.appendReplacement(sb, Matcher.quoteReplacement(this.format(messageFormat, null, result)));
                    continue;
                }
                result = this.invoke(macros, m.group(pos + 1), messageFormat, globalArgs, variables1);
                if (format) {
                    m.appendReplacement(sb, Matcher.quoteReplacement(this.format(messageFormat, m.group(pos - 2).replaceAll(Pattern.quote(m.group(pos - 1)), "0"), result)));
                    continue;
                }
                m.appendReplacement(sb, Matcher.quoteReplacement("$macros-" + variables2.size() + "()"));
                variables2.add(result);
            }
            m.appendTail(sb);
            if (!found) {
                int k = sb.indexOf("$$()");
                while (k >= 0) {
                    sb.replace(k, k + 4, "$");
                    k = sb.indexOf("$$()");
                }
                if (sb != appendable) {
                    appendable.append(sb);
                }
                return appendable;
            }
            variables1.clear();
            ArrayList<Object> temp = variables1;
            variables1 = variables2;
            variables2 = temp;
            pattern = sb.toString();
            m = MacrosFormat.pattern.matcher(pattern);
            sb.setLength(0);
        }
        int k = sb.indexOf("$$()");
        while (k >= 0) {
            sb.replace(k, k + 4, "$");
            k = sb.indexOf("$$()");
        }
        if (sb != appendable) {
            appendable.append(sb);
        }
        return appendable;
    }

    protected String format(MessageFormat messageFormat, String pattern, Object o) {
        if (pattern == null) {
            return String.valueOf(o);
        }
        if (o instanceof Calendar) {
            o = ((Calendar)o).getTime();
        }
        messageFormat.applyPattern(pattern);
        return messageFormat.format(new Object[]{o});
    }

    private Object invoke(String method, String args, MessageFormat messageFormat, Object[] globalArgs, List<Object> variables) throws BGException {
        if (args == null) {
            args = "";
        }
        ArrayList<Object> arguments = new ArrayList<Object>();
        Matcher m = pattern2.matcher(args);
        while (m.find()) {
            boolean format = false;
            boolean macros = false;
            int pos = 1;
            pos = 2;
            String data = m.group(2);
            if (data != null) {
                format = true;
                macros = true;
            } else {
                pos = 5;
                data = m.group(5);
                if (data != null) {
                    format = false;
                    macros = true;
                } else {
                    pos = 7;
                    data = m.group(7);
                    if (data != null) {
                        format = false;
                        macros = false;
                    }
                }
            }
            if (macros) {
                Object result = data.startsWith("macros-") ? variables.get(Utils.parseInt(data.substring(7))) : this.invoke(data, m.group(pos + 1), messageFormat, globalArgs, null);
                if (format) {
                    arguments.add(this.format(messageFormat, m.group(pos - 1).replaceAll("\\$" + macros, "0"), result));
                    continue;
                }
                arguments.add(result);
                continue;
            }
            arguments.add(data);
        }
        return this.invoke(method, arguments.toArray(new Object[arguments.size()]), globalArgs);
    }

    protected Object invoke(String macros, Object[] args) throws BGException {
        return null;
    }

    protected Object invoke(String macros, Object[] args, Object[] globalArgs) throws BGException {
        return this.invoke(macros, args);
    }

    protected String getString(Object[] args, int i, String def) {
        if (args.length <= i) {
            return def;
        }
        Object o = args[i];
        if (o == null) {
            return def;
        }
        return o.toString();
    }

    protected int getInt(Object[] args, int i, int def) {
        if (args.length <= i) {
            return def;
        }
        Object o = args[i];
        if (o == null) {
            return def;
        }
        if (o instanceof String) {
            return Utils.parseInt((String)o, def);
        }
        if (o instanceof Number) {
            return (Integer)o;
        }
        return def;
    }

    protected double getDouble(Object[] args, int i, double def) {
        if (args.length >= i) {
            return def;
        }
        Object o = args[i];
        if (o == null) {
            return def;
        }
        if (o instanceof String) {
            return Utils.parseDouble((String)o, def);
        }
        if (o instanceof Number) {
            return ((Integer)o).doubleValue();
        }
        return def;
    }

    public static void main(String[] args) {
        Pattern p = Pattern.compile(MACROS + "\\b(?:(?:$)|(?:[^\\(]))");
        Matcher m = p.matcher("$asd() asd");
        boolean find = m.find();
        System.out.println(find);
        if (find) {
            System.out.println(m.group());
        }
        MacrosFormat f = new MacrosFormat(){

            @Override
            protected Object invoke(String macros, Object[] args, Object[] globalArgs) {
                System.out.println(macros + " : " + String.valueOf(Arrays.asList(args)));
                return "asd";
            }
        };
        try {
            System.err.println(f.format(new StringBuffer(), "asd$$()1234", new Object[0]));
            System.err.println(f.format(new StringBuffer(), "set speed=$param( $option(5), speed, 100 ); echo IZMENENIE TARIFA \u041d\u0410 \u041d\u041e\u0412\u042b\u0419;", new Object[0]));
            System.err.println(f.format(new StringBuffer(), "$forEach( asd; asd; $aaa $bbb(ccc); $ddd($eee) )", new Object[0]));
            System.err.println(f.format(new StringBuffer(), "set speed=$param( $option, speed, 100 )", new Object[0]));
            System.err.println(f.format(new StringBuffer(), "{$asd(1, 2, $aaa)} $asds(4, _______)", new Object[0]));
            f = new MacrosFormat(){

                @Override
                protected Object invoke(String macros, Object[] args) {
                    System.out.println(macros);
                    System.out.println(Arrays.asList(args));
                    return "1254132.05";
                }
            };
            System.err.println(f.format(new StringBuffer(), "kkk $PARAM(3,____________), $PARAM(4) \"$PARAM(4,____________)\"", new Object[0]));
            System.err.println("kkk 1254132.05, 1254132.05 \"1254132.05\"");
            f = new MacrosFormat(){

                @Override
                protected Object invoke(String macros, Object[] args) {
                    System.out.println(macros);
                    System.out.println(Arrays.asList(args));
                    return 2;
                }
            };
            System.err.println(f.format(new StringBuffer(), "{$asd( $qwe(zxc) ), choice, 1#asd|2#bbb}", new Object[0]));
            System.out.println();
            System.out.println();
            System.out.println();
            System.err.println(f.format(new StringBuffer(), "interface Fa 0/$iface; swi access vlan $vlan; speed $param( $option , $optiona, 100 ); exit", new Object[0]));
            System.err.println(f.format(new StringBuffer(), "interface Fa 0/$iface(); swi access vlan $vlan; speed $param( $option , $optiona, 100 ); exit", new Object[0]));
            System.err.println(f.format(new StringBuffer(), "interface Fa 0/$iface($iface()); swi access vlan $vlan; speed $param( $option , $optiona, 100 ); exit", new Object[0]));
            System.err.println("interface Fa 0/2; swi access vlan 2; speed 2; exit");
            System.err.println(f.format(new StringBuffer(), "$PARAM(19, ) $PARAM(22, )", new Object[0]));
            System.err.println(f.format(new StringBuffer(), "\u0412\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u043d\u043e\u0447\u043d\u043e\u0439 \u0442\u0440\u0430\u0444\u0438\u043a \u0437\u0430 $month{$month,date,yyyy \u0433.}", new Object[0]));
            System.err.println(f.format(new StringBuffer(), "$setEndSequence(])", new Object[0]));
            System.err.println(f.format(new StringBuffer(), "$setEndSequence(#)", new Object[0]));
            System.err.println(f.format(new StringBuffer(), "\\$setEndSequence", new Object[0]));
        }
        catch (Exception ex) {
            BGLogger.error(ex);
        }
    }
}

