/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.module.services;

import bitel.billing.module.common.ActionPerformer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ru.bitel.bgbilling.client.common.BGControlPanelListSelect;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.model.BGUListItem;
import ru.bitel.common.Utils;

public class ServiceEditorListPanel
extends JPanel
implements ActionPerformer {
    private BGControlPanelListSelect serviceList = new BGControlPanelListSelect(5);
    private JCheckBox showOnlyUsing = new JCheckBox("\u0422\u043e\u043b\u044c\u043a\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0435", true);
    private transient List<ActionListener> actionListeners;

    public ServiceEditorListPanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ClientUtils.showErrorMessageDialog(ex);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.setBorder(new BGTitleBorder(" \u0423\u0441\u043b\u0443\u0433\u0438 "));
        this.add((Component)this.showOnlyUsing, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.showOnlyUsing.addActionListener(e -> {
            List<String> selectedItems = this.getSelectedIdList();
            this.fireActionPerformed(e);
            this.selectByIds(Utils.toString(selectedItems));
        });
        this.add((Component)new JScrollPane(this.serviceList), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    public boolean isShowOnlyUsing() {
        return this.showOnlyUsing.getModel().isSelected();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.serviceList.setEnabled(enabled);
    }

    public void buildList(Node treeNode, String selectedNodeId) {
        NodeList list = ((Element)treeNode).getElementsByTagName("service");
        DefaultListModel<BGUListItem> model = this.serviceList.getListModel();
        model.clear();
        for (int i = 0; i < list.getLength(); ++i) {
            Element itemEl = (Element)list.item(i);
            model.addElement(new BGUListItem(itemEl.getAttribute("id"), itemEl.getAttribute("title")));
        }
        this.setEnabled(true);
    }

    public List<String> getSelectedIdList() {
        return Utils.toList(this.serviceList.getListValues());
    }

    public void freeAllSelection() {
        this.serviceList.setListItemSelected(false);
    }

    public void selectByIds(String sids) {
        this.serviceList.setListValues(sids);
    }

    public synchronized void removeActionListener(ActionListener l) {
        if (this.actionListeners != null && this.actionListeners.contains(l)) {
            ArrayList<ActionListener> v = new ArrayList<ActionListener>();
            v.addAll(this.actionListeners);
            v.remove(l);
            this.actionListeners = v;
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        ArrayList<ActionListener> v = new ArrayList<ActionListener>();
        if (this.actionListeners != null) {
            v.addAll(this.actionListeners);
        }
        if (!v.contains(l)) {
            v.add(l);
            this.actionListeners = v;
        }
    }

    @Override
    public void fireActionPerformed(ActionEvent e) {
        if (this.actionListeners != null) {
            for (ActionListener actionListener : this.actionListeners) {
                actionListener.actionPerformed(e);
            }
        }
    }
}

