/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.address.server.service;

import jakarta.annotation.PostConstruct;
import jakarta.jws.WebService;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.module.common.bean.BGInstalledModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.inpoint.GetIndexPoint;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.directories.address.common.bean.AddressEntityData;
import ru.bitel.oss.kernel.directories.address.common.bean.AddressEntityParam;
import ru.bitel.oss.kernel.directories.address.common.bean.AddressEntityType;
import ru.bitel.oss.kernel.directories.address.common.bean.AddressPrefixSuffix;
import ru.bitel.oss.kernel.directories.address.common.bean.Area;
import ru.bitel.oss.kernel.directories.address.common.bean.City;
import ru.bitel.oss.kernel.directories.address.common.bean.Country;
import ru.bitel.oss.kernel.directories.address.common.bean.House;
import ru.bitel.oss.kernel.directories.address.common.bean.HouseCoordinates;
import ru.bitel.oss.kernel.directories.address.common.bean.HouseData;
import ru.bitel.oss.kernel.directories.address.common.bean.Quarter;
import ru.bitel.oss.kernel.directories.address.common.bean.Street;
import ru.bitel.oss.kernel.directories.address.common.event.AreaModifiedEvent;
import ru.bitel.oss.kernel.directories.address.common.event.CityModifiedEvent;
import ru.bitel.oss.kernel.directories.address.common.event.CountryModifiedEvent;
import ru.bitel.oss.kernel.directories.address.common.event.HouseModifiedEvent;
import ru.bitel.oss.kernel.directories.address.common.event.QuarterModifiedEvent;
import ru.bitel.oss.kernel.directories.address.common.event.StreetModifiedEvent;
import ru.bitel.oss.kernel.directories.address.common.service.AddressService;
import ru.bitel.oss.kernel.directories.address.server.bean.AddressUtils;
import ru.bitel.oss.kernel.directories.address.server.bean.AreaDao;
import ru.bitel.oss.kernel.directories.address.server.bean.CityDao;
import ru.bitel.oss.kernel.directories.address.server.bean.CountryDao;
import ru.bitel.oss.kernel.directories.address.server.bean.HouseCoordinatesDao;
import ru.bitel.oss.kernel.directories.address.server.bean.HouseDao;
import ru.bitel.oss.kernel.directories.address.server.bean.ParameterDao;
import ru.bitel.oss.kernel.directories.address.server.bean.QuarterDao;
import ru.bitel.oss.kernel.directories.address.server.bean.StreetDao;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrAddress;
import ru.bitel.oss.kernel.entity.common.bean.enums.EntityType;

@WebService(endpointInterface="ru.bitel.oss.kernel.directories.address.common.service.AddressService")
public class AddressServiceImpl
extends AbstractService
implements AddressService {
    private Directory<Country> countryDirectory;
    private Directory<City> cityDirectory;
    private Directory<Area> areaDirectory;
    private Directory<Street> streetDirectory;
    private Directory<Quarter> quarterDirectory;
    private AreaDao areaDao;
    private CountryDao countryDao;
    private CityDao cityDao;
    private StreetDao streetDao;
    private QuarterDao quarterDao;
    private HouseDao houseDao;
    private ParameterDao parameterDao;

    @PostConstruct
    protected void init() throws BGException {
        this.countryDirectory = this.context.getDirectory(Country.class, 0);
        this.cityDirectory = this.context.getDirectory(City.class, 0);
        this.areaDirectory = this.context.getDirectory(Area.class, 0);
        this.streetDirectory = this.context.getDirectory(Street.class, 0);
        this.quarterDirectory = this.context.getDirectory(Quarter.class, 0);
        this.countryDao = new CountryDao(this.getConnection());
        this.cityDao = new CityDao(this.getConnection());
        this.areaDao = new AreaDao(this.getConnection());
        this.streetDao = new StreetDao(this.getConnection());
        this.quarterDao = new QuarterDao(this.getConnection());
        this.houseDao = new HouseDao(this.getConnection());
        this.parameterDao = new ParameterDao(this.getConnection());
    }

    public Country countryGet(int id) throws BGException {
        return this.countryDirectory.get(id);
    }

    public SearchResult<Country> searchCountryList(String title, String searchMode, Page page) throws Exception {
        SearchResult searchResult = new SearchResult(page);
        if (searchMode == null && page == null) {
            if (Utils.isBlankString((String)title)) {
                searchResult.setList(this.countryDirectory.list());
            } else {
                searchResult.setList(this.countryDao.list(title));
            }
        } else {
            this.countryDao.searchCountryList((SearchResult<Country>)searchResult, this.getMask(title, searchMode));
        }
        return searchResult;
    }

    public int countryUpdate(Country country) throws BGException {
        try {
            this.countryDirectory.update(country);
            return country.getId();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void countryDelete(int id) throws BGException {
        try {
            this.countryDirectory.delete(id);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public City cityGet(int id) throws BGException {
        return this.cityDirectory.get(id);
    }

    public SearchResult<City> searchCityList(int countryId, String title, String searchMode, Page page) throws Exception {
        SearchResult searchResult = new SearchResult(page);
        if (searchMode == null && page == null) {
            if (countryId <= 0 && Utils.isBlankString((String)title)) {
                searchResult.setList(this.cityDirectory.list());
            } else {
                searchResult.setList(this.cityDao.list(countryId, title));
            }
        } else {
            this.cityDao.searchCityList((SearchResult<City>)searchResult, countryId, this.getMask(title, searchMode));
        }
        return searchResult;
    }

    public int cityUpdate(City city) throws BGException {
        try {
            this.cityDirectory.update(city);
            return city.getId();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void cityDelete(int id) throws BGException {
        try {
            this.cityDirectory.delete(id);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<City> cityList(int countryId) throws Exception {
        List<City> cities = this.cityDirectory.list();
        return countryId > 0 ? cities.stream().filter(a -> a.getCountryId() == countryId).toList() : cities;
    }

    public Area areaGet(int id) throws BGException {
        return this.areaDirectory.get(id);
    }

    public SearchResult<Area> searchAreaList(int cityId, String title, String searchMode, Page page) throws Exception {
        SearchResult searchResult = new SearchResult(page);
        if (searchMode == null && page == null) {
            if (cityId <= 0 && Utils.isBlankString((String)title)) {
                searchResult.setList(this.areaDirectory.list());
            } else {
                searchResult.setList(this.areaDao.list(cityId, title));
            }
        } else {
            this.areaDao.searchAreaList((SearchResult<Area>)searchResult, cityId, this.getMask(title, searchMode));
        }
        return searchResult;
    }

    public int areaUpdate(Area area) throws BGException {
        try {
            this.areaDirectory.update(area);
            return area.getId();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void areaDelete(int id) throws Exception {
        this.areaDirectory.delete(id);
    }

    public List<Area> areaList(int cityId) throws Exception {
        List<Area> areas = this.areaDirectory.list();
        return cityId > 0 ? areas.stream().filter(a -> a.getCity().getId() == cityId).toList() : areas;
    }

    public Street streetGet(int id) throws BGException {
        return this.streetDirectory.get(id);
    }

    public SearchResult<Street> searchStreetList(int cityId, String title, String searchMode, Page page) throws Exception {
        SearchResult searchResult = new SearchResult(page);
        if (searchMode == null && page == null) {
            if (cityId <= 0 && Utils.isBlankString((String)title)) {
                searchResult.setList(this.streetDirectory.list());
            } else {
                searchResult.setList(this.streetDao.list(cityId, title));
            }
        } else {
            this.streetDao.searchStreetList((SearchResult<Street>)searchResult, cityId, this.getMask(title, searchMode));
        }
        return searchResult;
    }

    public List<Street> streetSearch(int cityId, String title, String cityTitle, Page page) throws Exception {
        if (cityId <= 0 && Utils.isBlankString((String)title) && Utils.isBlankString((String)cityTitle) && page == null) {
            return this.streetDirectory.list();
        }
        return this.streetDao.search(cityId, title, cityTitle, page);
    }

    public int streetUpdate(Street b) throws BGException {
        try {
            this.streetDirectory.update(b);
            return b.getId();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void streetDelete(int id) throws BGException {
        try {
            this.streetDirectory.delete(id);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<Street> streetList(int cityId) throws Exception {
        List<Street> streets = this.streetDirectory.list();
        return cityId > 0 ? streets.stream().filter(a -> a.getCity().getId() == cityId).toList() : streets;
    }

    public Quarter quarterGet(int id) throws BGException {
        return this.quarterDirectory.get(id);
    }

    public SearchResult<Quarter> searchQuarterList(int cityId, String title, String searchMode, Page page) throws Exception {
        SearchResult searchResult = new SearchResult(page);
        if (searchMode == null && page == null) {
            if (cityId <= 0 && Utils.isBlankString((String)title)) {
                searchResult.setList(this.quarterDirectory.list());
            } else {
                searchResult.setList(this.quarterDao.list(cityId, title));
            }
        } else {
            this.quarterDao.searchQuarterList((SearchResult<Quarter>)searchResult, cityId, this.getMask(title, searchMode));
        }
        return searchResult;
    }

    public int quarterUpdate(Quarter b) throws BGException {
        try {
            this.quarterDirectory.update(b);
            return b.getId();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void quarterDelete(int id) throws BGException {
        try {
            this.quarterDirectory.delete(id);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<Quarter> quarterList(int cityId) throws Exception {
        List<Quarter> quarters = this.quarterDirectory.list();
        return cityId > 0 ? quarters.stream().filter(a -> a.getCity().getId() == cityId).toList() : quarters;
    }

    public String postIndexGet(int streetId, String houseAndFrac, int house, String frac) throws BGException {
        Collection<GetIndexPoint> points;
        if (streetId == -1) {
            return null;
        }
        String index = this.streetDao.getPostIndex(streetId);
        if (!Utils.isEmptyString((String)index)) {
            return index;
        }
        if (houseAndFrac != null && house <= 0) {
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < houseAndFrac.length(); ++i) {
                int ch = houseAndFrac.charAt(i);
                if (!Character.isDigit((char)ch)) {
                    frac = houseAndFrac.substring(i);
                    break;
                }
                str.append((char)ch);
            }
            house = Utils.parseInt((String)str.toString(), (int)-1);
        }
        if (house < 1) {
            return null;
        }
        String boxIndexRange = this.parameterDao.getAddressParam("address_street", streetId, "boxIndexRange");
        if (!Utils.isEmptyString((String)boxIndexRange)) {
            for (String tokens : boxIndexRange.split(";")) {
                String[] indexData = tokens.split(":");
                if (indexData.length != 2 && !indexData[0].matches("^\\d{6}$")) continue;
                for (String houseToken : indexData[1].split(",")) {
                    int rangeStop;
                    if ("*".equals(houseToken) || houseToken.equals(String.valueOf(house).concat(frac != null ? frac : ""))) {
                        return indexData[0];
                    }
                    if (!houseToken.matches("^\\d+\\-(\\d+)?$")) continue;
                    String[] range = houseToken.split("-");
                    int rangeStart = Utils.parseInt((String)range[0], (int)-1);
                    int n = rangeStop = range.length > 1 ? Utils.parseInt((String)range[1], (int)-1) : -1;
                    if (rangeStart != -1 && (rangeStart <= 0 || rangeStart > house) || rangeStop != -1 && (rangeStop <= 0 || house > rangeStop)) continue;
                    return indexData[0];
                }
            }
        }
        if ((points = BGPluginManagerServer.getManager().getInvokeables(GetIndexPoint.class, true)).size() > 1) {
            throw new BGMessageException("\u0411\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u0433\u0438\u043d\u0430 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u043e \u043a \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0443 \u0432\u044b\u0434\u0430\u0447\u0438 \u0438\u043d\u0434\u0435\u043a\u0441\u0430 \u0434\u043e\u043c\u0430");
        }
        GetIndexPoint finder = null;
        if (points.size() == 1) {
            finder = points.iterator().next();
        }
        if (finder != null && !Utils.isEmptyString((String)(index = finder.getIndex(this.getConnection(), streetId, house, frac)))) {
            return index;
        }
        return null;
    }

    public House houseGet(int id) throws BGException {
        return this.houseDao.get(id);
    }

    public HouseData houseDataGet(int id) throws BGException {
        HouseData houseData = new HouseData(this.houseDao.get(id));
        Setup setup = Setup.getSetup();
        String paramString = "address." + AddressEntityType.HOUSE.getType();
        List paramList = Utils.toList((String)setup.get(paramString, null));
        Map<String, String> paramMap = this.parameterDao.getAddressParams(AddressEntityType.HOUSE.getTableName(), id);
        ArrayList<KeyValue> configParams = new ArrayList<KeyValue>();
        for (String str : paramList) {
            if ("floorRange".equals(str)) {
                houseData.setFloorRange(paramMap.getOrDefault(str, ""));
                continue;
            }
            if ("entranceRange".equals(str)) {
                houseData.setEntranceRange(paramMap.getOrDefault(str, ""));
                continue;
            }
            configParams.add(new KeyValue(setup.get(paramString + "." + str + ".title", ""), paramMap.getOrDefault(str, "")));
        }
        houseData.setParams(configParams);
        return houseData;
    }

    public List<House> houseList(int cityId, int areaId, int streetId, int quarterId, int house, String frac, Page page) throws BGException {
        return this.houseDao.list(cityId, areaId, streetId, quarterId, house, frac, page);
    }

    public int houseUpdate(House house) throws BGException {
        try {
            this.houseDao.update(house);
            return house.getId();
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void houseDelete(int id) throws BGException {
        try {
            this.houseDao.delete(id);
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public List<KeyValue> addressFormat(EntityAttrAddress attrAddress, EntityType entityType) throws BGException {
        ArrayList<KeyValue> result = new ArrayList<KeyValue>();
        Setup setup = this.context.getSetup();
        AddressUtils addressUtils = new AddressUtils(this.context);
        House house = this.houseGet(attrAddress.getHouseId());
        attrAddress.setFormatKey("0");
        result.add(new KeyValue("0", addressUtils.getAddress((ParameterMap)setup, house, attrAddress)));
        String sortOrder = setup.get("addrs.format.list", null);
        if (sortOrder != null) {
            String[] sortOrderValues = sortOrder.trim().split(";");
            String cp = "cp" + attrAddress.getEntitySpecAttrId();
            String op = "op" + attrAddress.getEntitySpecAttrId();
            for (String item : sortOrderValues) {
                if (item.startsWith("cp") && (entityType == EntityType.OBJECT_PARAMETER || !item.equals(cp)) || item.startsWith("op") && (entityType == EntityType.CONTRACT_PARAMETER || !item.equals(op))) continue;
                attrAddress.setFormatKey(item);
                String title = house != null ? addressUtils.getAddress((ParameterMap)setup, house, attrAddress) : "";
                result.add(new KeyValue(item, title));
            }
        }
        return result;
    }

    private String getMask(String searchText, String searchMode) {
        StringBuilder mask = new StringBuilder();
        if (searchText != null && !searchText.isEmpty()) {
            if (searchMode == null || "subs".equals(searchMode) || "end".equals(searchMode)) {
                mask.append('%');
            }
            mask.append(searchText);
            if (searchMode == null || "subs".equals(searchMode) || "start".equals(searchMode)) {
                mask.append('%');
            }
        }
        return mask.toString();
    }

    public String houseIndexGet(int streetId, String houseAndFrac, int house, String frac) throws BGException, BGMessageException {
        if (streetId == -1) {
            return "";
        }
        String index = this.streetDao.getPostIndex(streetId);
        if (!Utils.isEmptyString((String)index)) {
            return index;
        }
        Collection<GetIndexPoint> points = BGPluginManagerServer.getManager().getInvokeables(GetIndexPoint.class, true);
        if (points.size() > 1) {
            throw new BGMessageException("\u0411\u043e\u043b\u0435\u0435 \u043e\u0434\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u0433\u0438\u043d\u0430 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u043e \u043a \u0438\u043d\u0442\u0435\u0440\u0444\u0435\u0439\u0441\u0443 \u0432\u044b\u0434\u0430\u0447\u0438 \u0438\u043d\u0434\u0435\u043a\u0441\u0430 \u0434\u043e\u043c\u0430");
        }
        GetIndexPoint finder = null;
        if (points.size() == 1) {
            finder = points.iterator().next();
        }
        if (finder != null) {
            int houseNumber = -1;
            String houseFrac = null;
            if (houseAndFrac != null) {
                StringBuilder str = new StringBuilder();
                for (int i = 0; i < houseAndFrac.length(); ++i) {
                    char ch = houseAndFrac.charAt(i);
                    if (!Character.isDigit(ch)) {
                        houseFrac = houseAndFrac.substring(i);
                        break;
                    }
                    str.append(ch);
                }
                houseNumber = Utils.parseInt((String)str.toString(), (int)0);
            }
            house = house > 0 ? house : houseNumber;
            frac = frac != null ? frac : houseFrac;
            index = finder.getIndex(this.getConnection(), streetId, house, frac);
            if (!Utils.isEmptyString((String)index)) {
                return index;
            }
        }
        return "";
    }

    public void extraParamsUpdate(AddressEntityType addressEntityType, int recordId, List<KeyValue> params) throws BGException, BGMessageException {
        if (addressEntityType == null || recordId < 1 || params == null) {
            throw new BGIllegalArgumentException();
        }
        String tableId = addressEntityType.getTableName();
        params.forEach(a -> {
            try {
                this.parameterDao.updateAddressParams(tableId, recordId, a.getKey(), a.getValue());
            }
            catch (Exception ex) {
                this.logError(ex);
            }
        });
    }

    public AddressEntityData addressEntityDataGet(AddressEntityType addressEntityType, int recordId) throws Exception {
        Objects.requireNonNull(addressEntityType);
        AddressEntityData addressEntityData = new AddressEntityData();
        addressEntityData.setAddressEntityType(addressEntityType);
        addressEntityData.setRecordId(recordId);
        Id title = null;
        switch (addressEntityType) {
            case COUNTRY: {
                title = this.countryDao.get(recordId);
                break;
            }
            case CITY: {
                title = this.cityDao.get(recordId);
                break;
            }
            case STREET: {
                title = this.streetDao.get(recordId);
                break;
            }
            case AREA: {
                title = this.areaDao.get(recordId);
                break;
            }
            case QUARTER: {
                title = this.quarterDao.get(recordId);
                break;
            }
            case HOUSE: {
                House house = this.houseDao.get(recordId);
                if (house == null) break;
                title = new IdTitle(0, house.getHouseFrac());
                addressEntityData.addEntityParameter("postIndex", house.getPostIndex());
                addressEntityData.addEntityParameter("areaId", String.valueOf(house.getArea().getId()));
                addressEntityData.addEntityParameter("quarterId", String.valueOf(house.getQuarter().getId()));
                addressEntityData.addEntityParameter("amount", String.valueOf(house.getAmount()));
                addressEntityData.addEntityParameter("comment", house.getComment());
                HouseCoordinates coordinates = this.getCoordinatesByHouse(recordId);
                if (coordinates == null) break;
                addressEntityData.addEntityParameter("latitude", String.valueOf(coordinates.getLatitude()));
                addressEntityData.addEntityParameter("longitude", String.valueOf(coordinates.getLongitude()));
            }
        }
        if (title instanceof IdTitle) {
            IdTitle idTitle = (IdTitle)title;
            addressEntityData.setTitle(idTitle.getTitle() != null ? idTitle.getTitle() : "");
        }
        if (title instanceof AddressPrefixSuffix) {
            AddressPrefixSuffix prefixSuffix = (AddressPrefixSuffix)title;
            addressEntityData.setTitlePrefix(prefixSuffix.getTitlePrefix() != null ? prefixSuffix.getTitlePrefix() : "");
            addressEntityData.setTitleSuffix(prefixSuffix.getTitleSuffix() != null ? prefixSuffix.getTitleSuffix() : "");
        }
        this.loadAddressEntityParams(addressEntityData);
        return addressEntityData;
    }

    private void loadAddressEntityParams(AddressEntityData addressEntityData) {
        Setup setup = Setup.getSetup();
        AddressEntityType entityType = addressEntityData.getAddressEntityType();
        String paramString = "address." + entityType.getType();
        List paramList = Utils.toList((String)setup.get(paramString, null));
        Map<String, String> paramMap = this.parameterDao.getAddressParams(entityType.getTableName(), addressEntityData.getRecordId());
        List configParams = addressEntityData.getConfigParams();
        for (String str : paramList) {
            AddressEntityParam param = new AddressEntityParam();
            param.setId(str);
            param.setTitle(setup.get(paramString + "." + str + ".title", null));
            param.setType(setup.get(paramString + "." + str + ".type", null));
            param.setValue(paramMap.getOrDefault(str, ""));
            configParams.add(param);
        }
    }

    public void addressEntityDataUpdate(AddressEntityData addressEntityData) throws BGException, BGMessageException {
        Objects.requireNonNull(addressEntityData);
        try {
            Setup setup = Setup.getSetup();
            switch (addressEntityData.getAddressEntityType()) {
                case COUNTRY: {
                    Country oldCountry = null;
                    Country newCountry = null;
                    if (addressEntityData.getRecordId() > 0) {
                        oldCountry = (Country)this.countryDao.get(addressEntityData.getRecordId());
                        newCountry = Country.from((Country)oldCountry);
                    } else {
                        newCountry = new Country();
                    }
                    newCountry.setTitle(addressEntityData.getTitle());
                    this.countryDao.update(newCountry);
                    addressEntityData.setRecordId(newCountry.getId());
                    this.updateAddressParams(addressEntityData, this.parameterDao);
                    EventProcessor.getInstance().publish((Event)new CountryModifiedEvent(0, this.userId, oldCountry, newCountry));
                    break;
                }
                case CITY: {
                    City oldCity = null;
                    City newCity = null;
                    if (addressEntityData.getRecordId() > 0) {
                        oldCity = (City)this.cityDao.get(addressEntityData.getRecordId());
                        newCity = City.from((City)oldCity);
                    } else {
                        newCity = City.builder().setCountryId(addressEntityData.getParentId()).build();
                    }
                    newCity.setPositionIndex(1);
                    newCity.setTitlePrefix(Utils.maskNull((String)addressEntityData.getTitlePrefix(), (String)""));
                    newCity.setTitle(addressEntityData.getTitle());
                    newCity.setTitleSuffix(Utils.maskNull((String)addressEntityData.getTitleSuffix(), (String)""));
                    this.cityDao.update(newCity);
                    addressEntityData.setRecordId(newCity.getId());
                    this.updateAddressParams(addressEntityData, this.parameterDao);
                    EventProcessor.getInstance().publish((Event)new CityModifiedEvent(0, this.userId, oldCity, newCity));
                    ru.bitel.oss.kernel.entity.server.utils.AddressUtils.onUpdateAddressCity(setup, newCity.getId());
                    break;
                }
                case STREET: {
                    Street oldStreet = null;
                    Street newStreet = null;
                    if (addressEntityData.getRecordId() > 0) {
                        oldStreet = (Street)this.streetDao.get(addressEntityData.getRecordId());
                        newStreet = Street.from((Street)oldStreet);
                    } else {
                        newStreet = Street.builder().setCityId(addressEntityData.getParentId()).build();
                    }
                    newStreet.setTitlePrefix(Utils.maskNull((String)addressEntityData.getTitlePrefix(), (String)""));
                    newStreet.setTitle(addressEntityData.getTitle());
                    newStreet.setTitleSuffix(Utils.maskNull((String)addressEntityData.getTitleSuffix(), (String)""));
                    this.streetDao.update(newStreet);
                    addressEntityData.setRecordId(newStreet.getId());
                    this.updateAddressParams(addressEntityData, this.parameterDao);
                    EventProcessor.getInstance().publish((Event)new StreetModifiedEvent(0, this.userId, oldStreet, newStreet));
                    ru.bitel.oss.kernel.entity.server.utils.AddressUtils.onUpdateAddressStreet(setup, newStreet.getId());
                    break;
                }
                case AREA: {
                    Area oldArea = null;
                    Area newArea = null;
                    if (addressEntityData.getRecordId() > 0) {
                        oldArea = (Area)this.areaDao.get(addressEntityData.getRecordId());
                        newArea = Area.from((Area)oldArea);
                    } else {
                        newArea = Area.builder().setCityId(addressEntityData.getParentId()).build();
                    }
                    newArea.setTitlePrefix(addressEntityData.getTitlePrefix());
                    newArea.setTitle(addressEntityData.getTitle());
                    newArea.setTitleSuffix(addressEntityData.getTitleSuffix());
                    this.areaDao.update(newArea);
                    addressEntityData.setRecordId(newArea.getId());
                    this.updateAddressParams(addressEntityData, this.parameterDao);
                    EventProcessor.getInstance().publish((Event)new AreaModifiedEvent(0, this.userId, oldArea, newArea));
                    ru.bitel.oss.kernel.entity.server.utils.AddressUtils.onUpdateAddressArea(setup, newArea.getId());
                    break;
                }
                case QUARTER: {
                    Quarter oldQuarter = null;
                    Quarter newQuarter = null;
                    if (addressEntityData.getRecordId() > 0) {
                        oldQuarter = (Quarter)this.quarterDao.get(addressEntityData.getRecordId());
                        newQuarter = Quarter.from((Quarter)oldQuarter);
                    } else {
                        newQuarter = Quarter.builder().setCityId(addressEntityData.getParentId()).build();
                    }
                    newQuarter.setTitlePrefix(addressEntityData.getTitlePrefix());
                    newQuarter.setTitle(addressEntityData.getTitle());
                    newQuarter.setTitleSuffix(addressEntityData.getTitleSuffix());
                    this.quarterDao.update(newQuarter);
                    addressEntityData.setRecordId(newQuarter.getId());
                    this.updateAddressParams(addressEntityData, this.parameterDao);
                    EventProcessor.getInstance().publish((Event)new QuarterModifiedEvent(0, this.userId, oldQuarter, newQuarter));
                    ru.bitel.oss.kernel.entity.server.utils.AddressUtils.onUpdateAddressQuarter(setup, newQuarter.getId());
                    break;
                }
                case HOUSE: {
                    House oldHouse = null;
                    House newHouse = null;
                    if (addressEntityData.getRecordId() > 0) {
                        oldHouse = this.houseDao.get(addressEntityData.getRecordId());
                        newHouse = House.from((House)oldHouse);
                    } else {
                        newHouse = House.builder().setStreet(IdTitle.IdTitleBuilder.get().setId(addressEntityData.getParentId()).build()).build();
                    }
                    int areaId = Utils.parseInt((String)addressEntityData.getEntityParameter("areaId"), (int)0);
                    int quarterId = Utils.parseInt((String)addressEntityData.getEntityParameter("quarterId"), (int)0);
                    newHouse.setHouseAndFrac(addressEntityData.getTitle());
                    newHouse.setPostIndex(addressEntityData.getEntityParameter("postIndex"));
                    newHouse.setAmount(Utils.parseInt((String)addressEntityData.getEntityParameter("amount"), (int)0));
                    newHouse.setArea(IdTitle.IdTitleBuilder.get().setId(areaId).build());
                    newHouse.setQuarter(IdTitle.IdTitleBuilder.get().setId(quarterId).build());
                    newHouse.setComment(addressEntityData.getEntityParameter("comment"));
                    newHouse.setCityId(Utils.parseInt((String)addressEntityData.getEntityParameter("cityId")));
                    this.houseDao.update(newHouse);
                    addressEntityData.setRecordId(newHouse.getId());
                    double latitude = Utils.parseDouble((String)addressEntityData.getEntityParameter("latitude"), (double)0.0);
                    double longitude = Utils.parseDouble((String)addressEntityData.getEntityParameter("longitude"), (double)0.0);
                    if (latitude > 0.0 && longitude > 0.0) {
                        this.saveCoordinates(new HouseCoordinates(addressEntityData.getRecordId(), latitude, longitude));
                    }
                    this.updateAddressParams(addressEntityData, this.parameterDao);
                    EventProcessor.getInstance().publish((Event)new HouseModifiedEvent(0, this.userId, oldHouse, newHouse));
                    break;
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    private void updateAddressParams(AddressEntityData addressEntityData, ParameterDao parameterDao) throws BGException {
        for (AddressEntityParam param : addressEntityData.getConfigParams()) {
            parameterDao.updateAddressParams(addressEntityData.getAddressEntityType().getTableName(), addressEntityData.getRecordId(), param.getId(), param.getValue());
        }
    }

    public void addressEntityDataDelete(AddressEntityType addressEntityType, int recordId) throws BGException, BGMessageException {
        try {
            switch (addressEntityType) {
                case COUNTRY: {
                    if (this.cityDao.countryCityCount(recordId) > 0) {
                        throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0435\u0441\u0442\u044c \u0433\u043e\u0440\u043e\u0434\u0430, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0449\u0438\u0435 \u044d\u0442\u043e\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440. \u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u0441\u043d\u0430\u0447\u0430\u043b\u0430 \u0438\u0445.");
                    }
                    this.parameterDao.deleteExctraAddressParams(addressEntityType.getTableName(), Arrays.asList(recordId), null);
                    this.countryDao.delete(recordId);
                    break;
                }
                case CITY: {
                    if (this.areaDao.cityAreaCount(recordId) > 0) {
                        throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0435\u0441\u0442\u044c \u0440\u0430\u0439\u043e\u043d\u044b, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0449\u0438\u0435 \u044d\u0442\u043e\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440. \u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u0441\u043d\u0430\u0447\u0430\u043b\u0430 \u0438\u0445.");
                    }
                    if (this.quarterDao.cityQuarterCount(recordId) > 0) {
                        throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0435\u0441\u0442\u044c \u043a\u0432\u0430\u0440\u0442\u0430\u043b\u044b, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0449\u0438\u0435 \u044d\u0442\u043e\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440. \u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u0441\u043d\u0430\u0447\u0430\u043b\u0430 \u0438\u0445.");
                    }
                    if (this.streetDao.cityStreetCount(recordId) > 0) {
                        throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0435\u0441\u0442\u044c \u0443\u043b\u0438\u0446\u044b, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0449\u0438\u0435 \u044d\u0442\u043e\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440. \u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u0441\u043d\u0430\u0447\u0430\u043b\u0430 \u0438\u0445.");
                    }
                    this.parameterDao.deleteExctraAddressParams(addressEntityType.getTableName(), Arrays.asList(recordId), null);
                    this.cityDao.delete(recordId);
                    break;
                }
                case STREET: {
                    if (this.houseDao.streetHouseCount(recordId) > 0) {
                        throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0435\u0441\u0442\u044c \u0434\u043e\u043c\u0430, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0449\u0438\u0435 \u044d\u0442\u043e\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440. \u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u0441\u043d\u0430\u0447\u0430\u043b\u0430 \u0438\u0445.");
                    }
                    this.parameterDao.deleteExctraAddressParams(addressEntityType.getTableName(), Arrays.asList(recordId), null);
                    this.streetDao.delete(recordId);
                    break;
                }
                case AREA: {
                    if (this.houseDao.areaHouseCount(recordId) > 0) {
                        throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0435\u0441\u0442\u044c \u0434\u043e\u043c\u0430, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0449\u0438\u0435 \u044d\u0442\u043e\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440. \u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u0441\u043d\u0430\u0447\u0430\u043b\u0430 \u0438\u0445.");
                    }
                    this.parameterDao.deleteExctraAddressParams(addressEntityType.getTableName(), Arrays.asList(recordId), null);
                    this.areaDao.delete(recordId);
                    break;
                }
                case QUARTER: {
                    if (this.houseDao.quarterHouseCount(recordId) > 0) {
                        throw new BGMessageException("\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u0435\u0441\u0442\u044c \u0434\u043e\u043c\u0430, \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u044e\u0449\u0438\u0435 \u044d\u0442\u043e\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440. \u0423\u0434\u0430\u043b\u0438\u0442\u0435 \u0441\u043d\u0430\u0447\u0430\u043b\u0430 \u0438\u0445.");
                    }
                    this.parameterDao.deleteExctraAddressParams(addressEntityType.getTableName(), Arrays.asList(recordId), null);
                    this.quarterDao.delete(recordId);
                    break;
                }
                case HOUSE: {
                    break;
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
    }

    public void addressImport(int mode, int id, String data) throws BGException, BGMessageException {
        if (id < 1) {
            return;
        }
        Optional addressEntityType = AddressEntityType.getAddressEntityTypeByCode((int)mode);
        if (addressEntityType.isEmpty()) {
            return;
        }
        String table = addressEntityType.map(a -> a.getTableName()).orElse(null);
        Connection con = this.getConnection();
        switch ((AddressEntityType)addressEntityType.get()) {
            case COUNTRY: {
                break;
            }
            case CITY: {
                ru.bitel.oss.kernel.entity.server.utils.AddressUtils.importData(con, table, "country_id", id, data);
                break;
            }
            case STREET: 
            case AREA: 
            case QUARTER: {
                ru.bitel.oss.kernel.entity.server.utils.AddressUtils.importData(con, table, "cityid", id, data);
                break;
            }
            case HOUSE: {
                ru.bitel.oss.kernel.entity.server.utils.AddressUtils.importHouseData(con, "address_house", id, data);
            }
        }
    }

    public List<IdTitle> addressEntityItems(AddressEntityType addressEntityType, int parentId) throws BGException, BGMessageException {
        Objects.requireNonNull(addressEntityType);
        return switch (addressEntityType) {
            case AddressEntityType.COUNTRY -> this.countryDao.list().stream().map(IdTitle::toIdTitle).toList();
            case AddressEntityType.CITY -> this.cityDao.list(parentId).stream().map(IdTitle::toIdTitle).toList();
            case AddressEntityType.STREET -> this.streetDao.list(parentId).stream().map(IdTitle::toIdTitle).toList();
            case AddressEntityType.AREA -> this.areaDao.list(parentId).stream().map(IdTitle::toIdTitle).toList();
            case AddressEntityType.QUARTER -> this.quarterDao.list(parentId).stream().map(IdTitle::toIdTitle).toList();
            default -> new ArrayList<IdTitle>();
        };
    }

    public boolean checkGarPluginInstalled() throws BGException, BGMessageException {
        return ModuleCache.getInstance().getInstalledModule("ru.bitel.bgbilling.plugins.gar") != null;
    }

    public void saveCoordinates(HouseCoordinates houseCoordinates) throws Exception {
        if (houseCoordinates.getHouseId() <= 0) {
            throw new BGException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d id \u0434\u043e\u043c\u0430 \u0434\u043b\u044f \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442");
        }
        if (houseCoordinates.getLatitude() <= 0.0 || houseCoordinates.getLongitude() <= 0.0) {
            throw new BGException("\u041d\u0435 \u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d\u044b \u0438\u043b\u0438 \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u043a\u043e\u043e\u0440\u0434\u0438\u043d\u0430\u0442\u044b \u0434\u043b\u044f houseId=" + houseCoordinates.getHouseId());
        }
        new HouseCoordinatesDao(this.getConnection()).save(houseCoordinates);
    }

    public HouseCoordinates getCoordinatesByHouse(int houseId) throws Exception {
        return new HouseCoordinatesDao(this.getConnection()).getCoordinatesByHouseId(houseId);
    }

    public HouseCoordinates searchCoordinatesByHouseId(int houseId) throws Exception {
        HouseCoordinates coordinates = this.getCoordinatesByHouse(houseId);
        if (coordinates != null) {
            return coordinates;
        }
        BGInstalledModule garPlugin = ModuleCache.getInstance().getInstalledModule("ru.bitel.bgbilling.plugins.gar");
        if (garPlugin == null) {
            throw new BGException("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043f\u043b\u0430\u0433\u0438\u043d \u0413\u0410\u0420");
        }
        try {
            Object garServiceImpl = this.context.getService(Class.forName("ru.bitel.bgbilling.plugins.gar.common.service.GarService"), garPlugin.getId());
            String result = (String)garServiceImpl.getClass().getMethod("getCoordinatesByAddress", Integer.TYPE).invoke(garServiceImpl, houseId);
            JSONObject json = new JSONObject(result);
            coordinates = new HouseCoordinates(houseId, json.optDouble("latitude"), json.optDouble("longitude"));
            this.saveCoordinates(coordinates);
            return coordinates;
        }
        catch (InvocationTargetException ite) {
            throw new BGException(ite.getTargetException().getMessage());
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new BGException((Throwable)e);
        }
    }
}

