/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.balance.server.service;

import jakarta.jws.WebService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentInfo;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentType;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentTypeItem;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.PaymentService;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentInfoDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentTypeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.ContractBalanceChangedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentDeletedEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.event.PaymentEvent;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.IdTitle;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.balance.common.service.PaymentService")
public class PaymentServiceImpl
extends AbstractService
implements PaymentService {
    private PaymentDao paymentDao = null;
    private PaymentTypeDao paymentTypeDao = null;
    private PaymentInfoDao paymentInfoDao = null;

    private PaymentDao getPaymentDao() {
        if (this.paymentDao == null) {
            this.paymentDao = new PaymentDao(this.getConnection());
        }
        return this.paymentDao;
    }

    private PaymentTypeDao getPaymentTypeDao() {
        if (this.paymentTypeDao == null) {
            this.paymentTypeDao = new PaymentTypeDao(this.getConnection());
        }
        return this.paymentTypeDao;
    }

    private PaymentInfoDao getPaymentInfoDao() {
        if (this.paymentInfoDao == null) {
            this.paymentInfoDao = new PaymentInfoDao(this.getConnection());
        }
        return this.paymentInfoDao;
    }

    @Override
    public Payment paymentGet(int paymentId) throws Exception {
        return (Payment)this.getPaymentDao().get(paymentId);
    }

    @Override
    public SearchResult<Payment> paymentList(int contractId, Period period, int members) throws Exception {
        return this.getPaymentDao().getPaymentList(contractId, period, members);
    }

    @Override
    public int paymentDelete(int contractId, int paymentId) throws Exception {
        int result = 0;
        try (BalanceUtils bu = new BalanceUtils(this.getConnection());){
            PaymentDao paymentDao = this.getPaymentDao();
            Payment payment = (Payment)paymentDao.get(paymentId);
            if (payment != null) {
                Calendar closedDate = null;
                closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionDeleteContractPayment", (int)this.moduleId, (int)this.userId);
                if (closedDate != null) {
                    ClosedDateChecker.checkDatesForDelete((Calendar)closedDate, (Date)payment.getDate());
                }
                result = paymentDao.delete(paymentId);
                this.getConnection().commit();
                bu.updateBalance(payment.getDate(), payment.getContractId());
                this.context.publishAfterCommit(new PaymentDeletedEvent(this.userId, payment));
                this.context.publishAfterCommit(new ContractBalanceChangedEvent(payment.getContractId(), 3, payment.getSum().negate()));
            }
        }
        return result;
    }

    @Override
    public List<Integer> paymentUpdate(Payment payment, String distribution) throws Exception {
        ArrayList<Integer> list = new ArrayList<Integer>();
        payment.setUserId(this.userId);
        if (payment.getId() < -1 || payment.getDate() == null || payment.getContractId() <= 0 || payment.getTypeId() <= 0) {
            throw new BGIllegalArgumentException();
        }
        if (this.getSetup().getInt("allow.future.payment", 0) == 0 && TimeUtils.dateBefore(new Date(), payment.getDate())) {
            throw new BGMessageException("\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u044b \u043f\u0440\u0438\u0445\u043e\u0434\u044b \u0441 \u0434\u0430\u0442\u043e\u0439 \u043f\u043e\u0437\u0434\u043d\u0435\u0435 \u0442\u0435\u043a\u0443\u0449\u0435\u0439");
        }
        Contract contract = null;
        Date oldDate = null;
        Payment oldPayment = null;
        PaymentDao paymentDao = this.getPaymentDao();
        if (payment.getId() > 0 && (oldPayment = (Payment)paymentDao.get(payment.getId())) != null) {
            if (payment.getContractId() != oldPayment.getContractId()) {
                throw new BGMessageException("\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e!");
            }
            oldDate = oldPayment.getDate();
        }
        ArrayList<DistributeData> paymentDistribution = new ArrayList<DistributeData>();
        try (ContractDao contractDao = new ContractDao(this.getConnection(), 0);){
            boolean allowClosedPayment;
            contract = (Contract)contractDao.get(payment.getContractId());
            if (contract == null) {
                throw new BGMessageException(String.format("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u043f\u043e ID=%s \u0434\u043b\u044f \u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u043f\u043b\u0430\u0442\u0435\u0436\u0430!", payment.getContractId()));
            }
            boolean bl = allowClosedPayment = this.getSetup().getInt("allow.closed.payment", 0) == 1;
            if (payment.getId() <= 0 && Utils.notBlankString(distribution)) {
                for (String pair : Utils.toList(distribution)) {
                    String[] tokens = pair.split("\\:");
                    if (tokens.length != 2) continue;
                    int contractId = Utils.parseInt(tokens[0]);
                    DistributeData data = new DistributeData();
                    data.summa = Utils.parseBigDecimal(tokens[1], BigDecimal.ZERO);
                    if (BigDecimal.ZERO.compareTo(data.summa) == 0) continue;
                    paymentDistribution.add(data);
                    data.contract = (Contract)contractDao.get(contractId);
                    if (data.contract == null) {
                        throw new BGMessageException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0434\u043e\u0433\u043e\u0432\u043e\u0440 \u0441 \u043a\u043e\u0434\u043e\u043c " + contractId);
                    }
                    if (allowClosedPayment || TimeUtils.dateInRange(payment.getDate(), data.contract.getDateFrom(), data.contract.getDateTo())) continue;
                    throw new BGMessageException("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 " + data.contract.getTitle() + " \u043d\u0435\u0430\u043a\u0442\u0438\u0432\u0435\u043d \u0432 \u043c\u043e\u043c\u0435\u043d\u0442 \u043f\u043b\u0430\u0442\u0435\u0436\u0430!");
                }
            } else if (!allowClosedPayment && !TimeUtils.dateInRange(payment.getDate(), contract.getDateFrom(), contract.getDateTo())) {
                throw new BGMessageException("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 " + contract.getTitle() + " \u043d\u0435\u0430\u043a\u0442\u0438\u0432\u0435\u043d \u0432 \u043c\u043e\u043c\u0435\u043d\u0442 \u043f\u043b\u0430\u0442\u0435\u0436\u0430!");
            }
        }
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionUpdateContractPayment", (int)this.moduleId, (int)this.userId);
        if (closedDate != null) {
            ClosedDateChecker.checkDatesForUpdate((Calendar)closedDate, (Date)oldDate, (Date)payment.getDate());
        }
        try (BalanceUtils bu = new BalanceUtils(this.getConnection());){
            if (payment.getId() <= 0 && paymentDistribution.size() > 0) {
                for (DistributeData data : paymentDistribution) {
                    Payment paymentD = payment.clone();
                    paymentD.setId(-1);
                    paymentD.setContractId(data.contract.getId());
                    paymentD.setSum(data.summa);
                    if (paymentD.getTransactionId() != null) {
                        paymentD.setTransactionId(null);
                    }
                    paymentDao.update(paymentD);
                    list.add(paymentD.getId());
                    this.getConnection().commit();
                    bu.updateBalance(paymentD.getDate(), data.contract);
                    this.context.publishAfterCommit(new PaymentEvent(this.userId, paymentD, false));
                    this.context.publishAfterCommit(new ContractBalanceChangedEvent(data.contract.getId(), 3, paymentD.getSum()));
                }
            } else {
                boolean editMode = payment.getId() >= 0;
                payment.setUserId(this.userId);
                paymentDao.update(payment);
                list.add(payment.getId());
                this.getConnection().commit();
                bu.updateBalance(payment.getDate(), contract);
                if (oldDate != null && TimeUtils.monthsDelta(oldDate, payment.getDate()) != 0) {
                    bu.updateBalance(oldDate, contract);
                }
                BigDecimal balanceChange = payment.getSum();
                if (oldPayment != null) {
                    balanceChange = balanceChange.subtract(oldPayment.getSum());
                }
                this.context.publishAfterCommit(new PaymentEvent(this.userId, payment, editMode));
                this.context.publishAfterCommit(new ContractBalanceChangedEvent(contract.getId(), 3, balanceChange));
            }
        }
        return list;
    }

    @Override
    public PaymentType paymentTypeGet(int paymentTypeId) throws Exception {
        return this.context.getDirectory(PaymentType.class, 0).get(paymentTypeId);
    }

    @Override
    public List<PaymentType> paymentTypeList(Integer editable, Integer type) throws Exception {
        if (editable == null && type == null) {
            return this.context.getDirectory(PaymentType.class, 0).list();
        }
        return this.getPaymentTypeDao().list(editable, type);
    }

    @Override
    public PaymentTypeItem paymentTypeTree(int editable, boolean showEmptyRoot) throws Exception {
        return this.getPaymentTypeDao().getTree(editable, showEmptyRoot);
    }

    @Override
    public int paymentTypeUpdate(PaymentType paymentType) throws Exception {
        this.context.getDirectory(PaymentType.class, 0).update(paymentType);
        return paymentType.getId();
    }

    @Override
    public int paymentTypeDelete(int paymentTypeId) throws Exception {
        return this.context.getDirectory(PaymentType.class, 0).delete(paymentTypeId);
    }

    @Override
    public void paymentTypeMove(int paymentTypeId, List<Integer> idList) throws Exception {
        this.getPaymentTypeDao().move(paymentTypeId, idList);
    }

    @Override
    public PaymentInfo paymentInfoByPaymentId(int paymentId) throws Exception {
        return this.getPaymentInfoDao().getInfoByPaymentId(paymentId);
    }

    @Override
    public List<PaymentInfo> paymentInfoByPaymentIds(List<Integer> paymentIds) throws Exception {
        return this.getPaymentInfoDao().getInfoByPaymentIds(paymentIds);
    }

    @Override
    public void updatePaymentInfo(PaymentInfo paymentInfo) throws Exception {
        this.getPaymentInfoDao().update(paymentInfo);
    }

    @Override
    public void deletePaymentInfo(int paymentInfoId) throws Exception {
        this.getPaymentTypeDao().delete(paymentInfoId);
    }

    @Override
    public List<IdTitle> paymentTypeTitles() throws BGException {
        return this.getPaymentTypeDao().list().stream().map(IdTitle::toIdTitle).toList();
    }

    private static class DistributeData {
        public BigDecimal summa;
        public Contract contract;

        private DistributeData() {
        }
    }
}

